/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.PhysicalRDD;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.ColumnsRequired$;
import org.apache.spark.sql.sources.DataSourceTest;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.FiltersPushed$;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$class;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils$class;
import org.apache.spark.sql.test.SQLTestUtils$testImplicits$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSQLContext$class;
import org.apache.spark.sql.test.TestSQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0001\u001b\t\tb)\u001b7uKJ,GmU2b]N+\u0018\u000e^3\u000b\u0005\r!\u0011aB:pkJ\u001cWm\u001d\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019\u0011\u0002\u0004\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tqA)\u0019;b'>,(oY3UKN$\bCA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0011!Xm\u001d;\n\u0005]!\"\u0001E*iCJ,GmU)M\u0007>tG/\u001a=u!\tIb$D\u0001\u001b\u0015\tYB$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000f\u0005\u0003!\u0019\u0017\r^1msN$\u0018BA\u0010\u001b\u0005=\u0001&/\u001a3jG\u0006$X\rS3ma\u0016\u0014\b\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\bF\u0001$!\ty\u0001\u0001\u0003\u0005\u0006\u0001!\u0015\r\u0011\"\u0015&+\u00051\u0003\u0003B\u0014+YMj\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\n\rVt7\r^5p]F\u0002\"!\f\u0019\u000f\u0005\u001dr\u0013BA\u0018)\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011G\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=B\u0003C\u0001\u001b6\u001b\u0005!\u0011B\u0001\u001c\u0005\u0005%!\u0015\r^1Ge\u0006lW\r\u0003\u00059\u0001!\u0005\t\u0015)\u0003'\u0003\u0011\u0019\u0018\u000f\u001c\u0011\t\u000bi\u0002A\u0011I\u001e\u0002\u0013\t,gm\u001c:f\u00032dG#\u0001\u001f\u0011\u0005\u001dj\u0014B\u0001 )\u0005\u0011)f.\u001b;\t\u000b\u0001\u0003A\u0011A!\u0002\u0019Q,7\u000f\u001e)vg\"$un\u001e8\u0015\tq\u0012E)\u0013\u0005\u0006\u0007~\u0002\r\u0001L\u0001\ngFd7\u000b\u001e:j]\u001eDQ!R A\u0002\u0019\u000bQ\"\u001a=qK\u000e$X\rZ\"pk:$\bCA\u0014H\u0013\tA\u0005FA\u0002J]RDQAS A\u0002-\u000b1C]3rk&\u0014X\rZ\"pYVlgNT1nKN\u00042!\f'-\u0013\ti%GA\u0002TKRDQ\u0001\u0011\u0001\u0005\u0002=#R\u0001\u0010)R%NCQa\u0011(A\u00021BQ!\u0012(A\u0002\u0019CQA\u0013(A\u0002-CQ\u0001\u0016(A\u0002U\u000b\u0001$\u001a=qK\u000e$X\rZ+oQ\u0006tG\r\\3e\r&dG/\u001a:t!\riCJ\u0016\t\u0003\u001f]K!\u0001\u0017\u0002\u0003\r\u0019KG\u000e^3s\u0001")
public class FilteredScanSuite
extends DataSourceTest
implements SharedSQLContext,
PredicateHelper {
    private Function1<String, DataFrame> sql;
    private TestSQLContext org$apache$spark$sql$test$SharedSQLContext$$_ctx;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private final DataFrame emptyTestData;
    private final DataFrame testData;
    private final DataFrame testData2;
    private final DataFrame testData3;
    private final DataFrame negativeData;
    private final DataFrame largeAndSmallInts;
    private final DataFrame decimalData;
    private final DataFrame binaryData;
    private final DataFrame upperCaseData;
    private final DataFrame lowerCaseData;
    private final RDD<SQLTestData.ArrayData> arrayData;
    private final RDD<SQLTestData.MapData> mapData;
    private final RDD<SQLTestData.StringData> repeatedData;
    private final RDD<SQLTestData.StringData> nullableRepeatedData;
    private final DataFrame nullInts;
    private final DataFrame allNulls;
    private final DataFrame nullStrings;
    private final DataFrame tableName;
    private final RDD<String> unparsedStrings;
    private final RDD<SQLTestData.IntField> withEmptyParts;
    private final DataFrame person;
    private final DataFrame salary;
    private final DataFrame complexData;
    private final DataFrame courseSales;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile int bitmap$0;
    private volatile SQLTestUtils$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;

    private Function1 sql$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FilteredScanSuite $outer;

                    public final DataFrame apply(String sqlText) {
                        return this.$outer.caseInsensitiveContext().sql(sqlText);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                };
                this.bitmap$0 |= 1;
            }
            return this.sql;
        }
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitConjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitDisjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.class.replaceAlias((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.class.canEvaluate((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    @Override
    public TestSQLContext org$apache$spark$sql$test$SharedSQLContext$$_ctx() {
        return this.org$apache$spark$sql$test$SharedSQLContext$$_ctx;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$_ctx_$eq(TestSQLContext x$1) {
        this.org$apache$spark$sql$test$SharedSQLContext$$_ctx = x$1;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SQLTestUtils$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSQLContext$class.sqlContext(this);
    }

    @Override
    public void afterAll() {
        SharedSQLContext$class.afterAll(this);
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestUtils$testImplicits$ testImplicits$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if (this.testImplicits$module != null) return this.testImplicits$module;
            this.testImplicits$module = new SQLTestUtils$testImplicits$(this);
            return this.testImplicits$module;
        }
    }

    @Override
    public SQLTestUtils$testImplicits$ testImplicits() {
        return this.testImplicits$module == null ? this.testImplicits$lzycompute() : this.testImplicits$module;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtils$class.sparkContext(this);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils$class.setupTestData(this);
    }

    @Override
    public Configuration hadoopConfiguration() {
        return SQLTestUtils$class.hadoopConfiguration(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withSQLConf(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtils$class.withTempPath(this, f);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils$class.withTempDir(this, f);
    }

    @Override
    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withTempTable(this, tableNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtils$class.withTable(this, tableNames, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtils$class.withTempDatabase(this, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtils$class.activateDatabase(this, db, f);
    }

    @Override
    public DataFrame logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtils$class.logicalPlanToSparkQuery(this, plan);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if (this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module != null) return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module = new SQLTestData$internalImplicits$(this);
            return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
        }
    }

    @Override
    public final SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        return this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module == null ? this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute() : this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$module;
    }

    private DataFrame emptyTestData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData$class.emptyTestData(this);
                this.bitmap$0 |= 2;
            }
            return this.emptyTestData;
        }
    }

    @Override
    public DataFrame emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private DataFrame testData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData$class.testData(this);
                this.bitmap$0 |= 4;
            }
            return this.testData;
        }
    }

    @Override
    public DataFrame testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private DataFrame testData2$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData$class.testData2(this);
                this.bitmap$0 |= 8;
            }
            return this.testData2;
        }
    }

    @Override
    public DataFrame testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private DataFrame testData3$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData$class.testData3(this);
                this.bitmap$0 |= 0x10;
            }
            return this.testData3;
        }
    }

    @Override
    public DataFrame testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private DataFrame negativeData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData$class.negativeData(this);
                this.bitmap$0 |= 0x20;
            }
            return this.negativeData;
        }
    }

    @Override
    public DataFrame negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private DataFrame largeAndSmallInts$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData$class.largeAndSmallInts(this);
                this.bitmap$0 |= 0x40;
            }
            return this.largeAndSmallInts;
        }
    }

    @Override
    public DataFrame largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private DataFrame decimalData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData$class.decimalData(this);
                this.bitmap$0 |= 0x80;
            }
            return this.decimalData;
        }
    }

    @Override
    public DataFrame decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private DataFrame binaryData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData$class.binaryData(this);
                this.bitmap$0 |= 0x100;
            }
            return this.binaryData;
        }
    }

    @Override
    public DataFrame binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private DataFrame upperCaseData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData$class.upperCaseData(this);
                this.bitmap$0 |= 0x200;
            }
            return this.upperCaseData;
        }
    }

    @Override
    public DataFrame upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private DataFrame lowerCaseData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData$class.lowerCaseData(this);
                this.bitmap$0 |= 0x400;
            }
            return this.lowerCaseData;
        }
    }

    @Override
    public DataFrame lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private RDD arrayData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.arrayData = SQLTestData$class.arrayData(this);
                this.bitmap$0 |= 0x800;
            }
            return this.arrayData;
        }
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x800) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD mapData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.mapData = SQLTestData$class.mapData(this);
                this.bitmap$0 |= 0x1000;
            }
            return this.mapData;
        }
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD repeatedData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.repeatedData = SQLTestData$class.repeatedData(this);
                this.bitmap$0 |= 0x2000;
            }
            return this.repeatedData;
        }
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD nullableRepeatedData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.nullableRepeatedData = SQLTestData$class.nullableRepeatedData(this);
                this.bitmap$0 |= 0x4000;
            }
            return this.nullableRepeatedData;
        }
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private DataFrame nullInts$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.nullInts = SQLTestData$class.nullInts(this);
                this.bitmap$0 |= 0x8000;
            }
            return this.nullInts;
        }
    }

    @Override
    public DataFrame nullInts() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private DataFrame allNulls$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.allNulls = SQLTestData$class.allNulls(this);
                this.bitmap$0 |= 0x10000;
            }
            return this.allNulls;
        }
    }

    @Override
    public DataFrame allNulls() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private DataFrame nullStrings$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullStrings = SQLTestData$class.nullStrings(this);
                this.bitmap$0 |= 0x20000;
            }
            return this.nullStrings;
        }
    }

    @Override
    public DataFrame nullStrings() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private DataFrame tableName$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.tableName = SQLTestData$class.tableName(this);
                this.bitmap$0 |= 0x40000;
            }
            return this.tableName;
        }
    }

    @Override
    public DataFrame tableName() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD unparsedStrings$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.unparsedStrings = SQLTestData$class.unparsedStrings(this);
                this.bitmap$0 |= 0x80000;
            }
            return this.unparsedStrings;
        }
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD withEmptyParts$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.withEmptyParts = SQLTestData$class.withEmptyParts(this);
                this.bitmap$0 |= 0x100000;
            }
            return this.withEmptyParts;
        }
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private DataFrame person$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.person = SQLTestData$class.person(this);
                this.bitmap$0 |= 0x200000;
            }
            return this.person;
        }
    }

    @Override
    public DataFrame person() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.person$lzycompute() : this.person;
    }

    private DataFrame salary$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.salary = SQLTestData$class.salary(this);
                this.bitmap$0 |= 0x400000;
            }
            return this.salary;
        }
    }

    @Override
    public DataFrame salary() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private DataFrame complexData$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.complexData = SQLTestData$class.complexData(this);
                this.bitmap$0 |= 0x800000;
            }
            return this.complexData;
        }
    }

    @Override
    public DataFrame complexData() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private DataFrame courseSales$lzycompute() {
        FilteredScanSuite filteredScanSuite = this;
        synchronized (filteredScanSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.courseSales = SQLTestData$class.courseSales(this);
                this.bitmap$0 |= 0x1000000;
            }
            return this.courseSales;
        }
    }

    @Override
    public DataFrame courseSales() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    @Override
    public void loadTestData() {
        SQLTestData$class.loadTestData(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public Function1<String, DataFrame> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public void beforeAll() {
        SharedSQLContext$class.beforeAll(this);
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE TEMPORARY TABLE oneToTenFiltered\n        |USING org.apache.spark.sql.sources.FilteredScanSource\n        |OPTIONS (\n        |  from '1',\n        |  to '10'\n        |)\n      ")).stripMargin());
    }

    public void testPushDown(String sqlString, int expectedCount, Set<String> requiredColumnNames) {
        this.testPushDown(sqlString, expectedCount, requiredColumnNames, (Set<Filter>)Predef$.MODULE$.Set().empty());
    }

    public void testPushDown(String sqlString, int expectedCount, Set<String> requiredColumnNames, Set<Filter> expectedUnhandledFilters) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PushDown Returns ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedCount), sqlString})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, sqlString, expectedCount, requiredColumnNames, expectedUnhandledFilters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FilteredScanSuite $outer;
            private final String sqlString$1;
            private final int expectedCount$1;
            private final Set requiredColumnNames$1;
            private final Set expectedUnhandledFilters$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryExecution queryExecution = ((DataFrame)this.$outer.sql().apply((Object)this.sqlString$1)).queryExecution();
                Seq seq = queryExecution.executedPlan().collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof PhysicalRDD) {
                            PhysicalRDD physicalRDD = (PhysicalRDD)A1;
                            object = physicalRDD;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x1) {
                        SparkPlan sparkPlan = x1;
                        boolean bl = sparkPlan instanceof PhysicalRDD;
                        return bl;
                    }
                });
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                    PhysicalRDD p;
                    PhysicalRDD physicalRDD;
                    PhysicalRDD rawPlan = physicalRDD = (p = (PhysicalRDD)((SeqLike)some.get()).apply(0));
                    long rawCount = rawPlan.execute().count();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(ColumnsRequired$.MODULE$.set());
                    Set $org_scalatest_assert_macro_right = this.requiredColumnNames$1;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    DataFrame table = this.$outer.caseInsensitiveContext().table("oneToTenFiltered");
                    BaseRelation relation = (BaseRelation)table.queryExecution().logical().collectFirst((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x2;
                            if (A1 instanceof LogicalRelation) {
                                LogicalRelation logicalRelation = (LogicalRelation)A1;
                                BaseRelation r = logicalRelation.relation();
                                object = r;
                            } else {
                                object = function1.apply(x2);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(LogicalPlan x2) {
                            LogicalPlan logicalPlan = x2;
                            boolean bl = logicalPlan instanceof LogicalRelation;
                            return bl;
                        }
                    }).get();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Predef$.MODULE$.refArrayOps((Object[])relation.unhandledFilters((Filter[])FiltersPushed$.MODULE$.list().toArray(ClassTag$.MODULE$.apply(Filter.class)))).toSet());
                    Set $org_scalatest_assert_macro_right2 = this.expectedUnhandledFilters$1;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    if (rawCount != (long)this.expectedCount$1) {
                        throw this.$outer.fail(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong # of results for pushed filter. Got ", ", Expected ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)rawCount), BoxesRunTime.boxToInteger((int)this.expectedCount$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Filters pushed: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FiltersPushed$.MODULE$.list().mkString(",")}))).append((Object)queryExecution).toString());
                    }
                    return;
                }
                throw this.$outer.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"More than one PhysicalRDD found\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryExecution})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sqlString$1 = sqlString$1;
                this.expectedCount$1 = expectedCount$1;
                this.requiredColumnNames$1 = requiredColumnNames$1;
                this.expectedUnhandledFilters$1 = expectedUnhandledFilters$1;
            }
        });
    }

    public FilteredScanSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        SQLTestData$class.$init$(this);
        SQLTestUtils$class.$init$(this);
        SharedSQLContext$class.$init$(this);
        PredicateHelper.class.$init$((PredicateHelper)this);
        this.sqlTest("SELECT * FROM oneToTenFiltered", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)(i * 2)), new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToCharacter((char)((char)(i - 1 + 97)))).toString())).$times(5)).append((Object)new StringOps(Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToCharacter((char)((char)(i - 1 + 97)))).toString().toUpperCase())).$times(5)).toString()}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT a, b FROM oneToTenFiltered", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT b, a FROM oneToTenFiltered", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i * 2)), BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT a FROM oneToTenFiltered", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT b FROM oneToTenFiltered", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT a * 2 FROM oneToTenFiltered", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT A AS b FROM oneToTenFiltered", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT x.b, y.a FROM oneToTenFiltered x JOIN oneToTenFiltered y ON x.a = y.b", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(i * 4)), BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT x.a, y.b FROM oneToTenFiltered x JOIN oneToTenFiltered y ON x.a = y.b", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 10).by(2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT a, b FROM oneToTenFiltered WHERE a = 1", (Seq<Row>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.sqlTest("SELECT a, b FROM oneToTenFiltered WHERE a IN (1,3,5)", (Seq<Row>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.sqlTest("SELECT a, b FROM oneToTenFiltered WHERE A = 1", (Seq<Row>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.sqlTest("SELECT a, b FROM oneToTenFiltered WHERE b = 2", (Seq<Row>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.sqlTest("SELECT a, b FROM oneToTenFiltered WHERE a IS NULL", (Seq<Row>)((Seq)Seq$.MODULE$.empty()));
        this.sqlTest("SELECT a, b FROM oneToTenFiltered WHERE a IS NOT NULL", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT a, b FROM oneToTenFiltered WHERE a < 5 AND a > 1", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT a, b FROM oneToTenFiltered WHERE a < 3 OR a > 8", (Seq<Row>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 9, 10}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.sqlTest("SELECT a, b FROM oneToTenFiltered WHERE NOT (a < 6)", (Seq<Row>)((scala.collection.immutable.Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(int i) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)(i * 2))}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
        this.sqlTest("SELECT a, b, c FROM oneToTenFiltered WHERE c like 'c%'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)6), new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("c")).$times(5)).append((Object)new StringOps(Predef$.MODULE$.augmentString("C")).$times(5)).toString()}))}))));
        this.sqlTest("SELECT a, b, c FROM oneToTenFiltered WHERE c like '%D'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)8), new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("d")).$times(5)).append((Object)new StringOps(Predef$.MODULE$.augmentString("D")).$times(5)).toString()}))}))));
        this.sqlTest("SELECT a, b, c FROM oneToTenFiltered WHERE c like '%eE%'", (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), BoxesRunTime.boxToInteger((int)10), new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("e")).$times(5)).append((Object)new StringOps(Predef$.MODULE$.augmentString("E")).$times(5)).toString()}))}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE A = 1", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT a FROM oneToTenFiltered WHERE A = 1", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))));
        this.testPushDown("SELECT b FROM oneToTenFiltered WHERE A = 1", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))));
        this.testPushDown("SELECT a, b FROM oneToTenFiltered WHERE A = 1", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE a = 1", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE 1 = a", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE a > 1", 9, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE a >= 2", 9, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE 1 < a", 9, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE 2 <= a", 9, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE 1 > a", 0, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE 2 >= a", 2, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE a < 1", 0, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE a <= 2", 2, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE a > 1 AND a < 10", 8, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE a IN (1,3,5)", 3, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE a = 20", 0, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE b = 1", 10, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))), (Set<Filter>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{new EqualTo("b", (Object)BoxesRunTime.boxToInteger((int)1))}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE a < 5 AND a > 1", 3, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE a < 3 OR a > 8", 4, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT * FROM oneToTenFiltered WHERE NOT (a < 6)", 5, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT a, b, c FROM oneToTenFiltered WHERE c like 'c%'", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT a, b, c FROM oneToTenFiltered WHERE c like 'C%'", 0, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT a, b, c FROM oneToTenFiltered WHERE c like '%D'", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT a, b, c FROM oneToTenFiltered WHERE c like '%d'", 0, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT a, b, c FROM oneToTenFiltered WHERE c like '%eE%'", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT a, b, c FROM oneToTenFiltered WHERE c like '%Ee%'", 0, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown("SELECT c FROM oneToTenFiltered WHERE c = 'aaaaaAAAAA'", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))));
        this.testPushDown("SELECT c FROM oneToTenFiltered WHERE c IN ('aaaaaAAAAA', 'foo')", 1, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))));
        this.testPushDown("SELECT c FROM oneToTenFiltered WHERE A + b > 9", 10, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}))));
        this.testPushDown(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString("SELECT a\n      |  FROM oneToTenFiltered\n      | WHERE a + b > 9\n      |   AND b < 16\n      |   AND c IN ('bbbbbBBBBB', 'cccccCCCCC', 'dddddDDDDD', 'foo')\n    ")).stripMargin().split("\n")).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$15) {
                return x$15.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(" "), 3, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}))), (Set<Filter>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{new LessThan("b", (Object)BoxesRunTime.boxToInteger((int)16))}))));
    }
}

