/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.package$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLConf$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.execution.datasources.parquet.CatalystReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.CatalystSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.CatalystSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetTest;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Assertions;
import org.scalatest.FunSuiteLike;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;

public abstract class ParquetTest$class {
    public static void withParquetFile(ParquetTest $this, Seq data, Function1 f, ClassTag evidence$1, TypeTags.TypeTag evidence$2) {
        $this.withTempPath((Function1<File, BoxedUnit>)new Serializable($this, data, f, evidence$2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetTest $outer;
            private final Seq data$1;
            private final Function1 f$1;
            private final TypeTags.TypeTag evidence$2$1;

            public final void apply(File file) {
                this.$outer.sqlContext().createDataFrame(this.data$1, this.evidence$2$1).write().parquet(file.getCanonicalPath());
                this.f$1.apply((Object)file.getCanonicalPath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.data$1 = data$1;
                this.f$1 = f$1;
                this.evidence$2$1 = evidence$2$1;
            }
        });
    }

    public static void withParquetDataFrame(ParquetTest $this, Seq data, Function1 f, ClassTag evidence$3, TypeTags.TypeTag evidence$4) {
        $this.withParquetFile(data, (Function1<String, BoxedUnit>)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetTest $outer;
            private final Function1 f$2;

            public final void apply(String path) {
                this.f$2.apply((Object)this.$outer.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$2 = f$2;
            }
        }, evidence$3, evidence$4);
    }

    public static void withParquetTable(ParquetTest $this, Seq data, String tableName, Function0 f, ClassTag evidence$5, TypeTags.TypeTag evidence$6) {
        $this.withParquetDataFrame(data, (Function1<DataFrame, BoxedUnit>)new Serializable($this, tableName, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetTest $outer;
            private final String tableName$1;
            private final Function0 f$3;

            public final void apply(DataFrame df2) {
                this.$outer.sqlContext().registerDataFrameAsTable(df2, this.tableName$1);
                this.$outer.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tableName$1}), (Function0<BoxedUnit>)this.f$3);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tableName$1 = tableName$1;
                this.f$3 = f$3;
            }
        }, evidence$5, evidence$6);
    }

    public static void makeParquetFile(ParquetTest $this, Seq data, File path, ClassTag evidence$7, TypeTags.TypeTag evidence$8) {
        $this.sqlContext().createDataFrame(data, evidence$8).write().mode(SaveMode.Overwrite).parquet(path.getCanonicalPath());
    }

    public static void makeParquetFile(ParquetTest $this, DataFrame df2, File path, ClassTag evidence$9, TypeTags.TypeTag evidence$10) {
        df2.write().mode(SaveMode.Overwrite).parquet(path.getCanonicalPath());
    }

    public static File makePartitionDir(ParquetTest $this, File basePath, String defaultPartitionName, Seq partitionCols) {
        Seq partNames = (Seq)partitionCols.map((Function1)new Serializable($this, defaultPartitionName){
            public static final long serialVersionUID = 0L;
            private final String defaultPartitionName$1;

            /*
             * Unable to fully structure code
             */
            public final String apply(Tuple2<String, Object> x0$1) {
                block2: {
                    var2_2 = x0$1;
                    if (var2_2 == null) break block2;
                    k = (String)var2_2._1();
                    v = var2_2._2();
                    if (v == null) ** GOTO lbl-1000
                    v0 = v;
                    var7_5 = "";
                    if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) lbl-1000:
                    // 2 sources

                    {
                        v1 = this.defaultPartitionName$1;
                    } else {
                        v1 = v.toString();
                    }
                    valueString = v1;
                    var5_7 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, valueString}));
                    return var5_7;
                }
                throw new MatchError(var2_2);
            }
            {
                this.defaultPartitionName$1 = defaultPartitionName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        File partDir = (File)partNames.foldLeft((Object)basePath, (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final File apply(File parent, String child) {
                return new File(parent, child);
            }
        });
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(partDir.mkdirs(), "partDir.mkdirs()");
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't create directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partDir})));
        return partDir;
    }

    public static void writeMetadata(ParquetTest $this, StructType schema, Path path, Configuration configuration) {
        MessageType parquetSchema = new CatalystSchemaConverter(CatalystSchemaConverter$.MODULE$.$lessinit$greater$default$1(), CatalystSchemaConverter$.MODULE$.$lessinit$greater$default$2(), CatalystSchemaConverter$.MODULE$.$lessinit$greater$default$3()).convert(schema);
        java.util.Map extraMetadata = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)CatalystReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)schema.json())}))).asJava();
        String createdBy = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Apache Spark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_VERSION()}));
        FileMetaData fileMetadata = new FileMetaData(parquetSchema, extraMetadata, createdBy);
        ParquetMetadata parquetMetadata = new ParquetMetadata(fileMetadata, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava());
        Footer footer = new Footer(path, parquetMetadata);
        ParquetFileWriter.writeMetadataFile((Configuration)configuration, (Path)path, (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Footer[]{footer}))).asJava()));
    }

    public static void writeMetadata(ParquetTest $this, MessageType parquetSchema, Path path, Configuration configuration, scala.collection.immutable.Map extraMetadata) {
        java.util.Map extraMetadataAsJava = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)extraMetadata).asJava();
        String createdBy = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Apache Spark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.SPARK_VERSION()}));
        FileMetaData fileMetadata = new FileMetaData(parquetSchema, extraMetadataAsJava, createdBy);
        ParquetMetadata parquetMetadata = new ParquetMetadata(fileMetadata, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava());
        Footer footer = new Footer(path, parquetMetadata);
        ParquetFileWriter.writeMetadataFile((Configuration)configuration, (Path)path, (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Footer[]{footer}))).asJava()));
    }

    public static scala.collection.immutable.Map writeMetadata$default$4(ParquetTest $this) {
        return Predef$.MODULE$.Map().empty();
    }

    public static Seq readAllFootersWithoutSummaryFiles(ParquetTest $this, Path path, Configuration configuration) {
        FileSystem fs = path.getFileSystem(configuration);
        return ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(ParquetFileReader.readAllFootersInParallel((Configuration)configuration, (FileStatus)fs.getFileStatus(path))).asScala()).toSeq();
    }

    public static ParquetMetadata readFooter(ParquetTest $this, Path path, Configuration configuration) {
        return ParquetFileReader.readFooter((Configuration)configuration, (Path)new Path(path, "_metadata"), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
    }

    public static void testStandardAndLegacyModes(ParquetTest $this, String testName, Function0 f) {
        ((FunSuiteLike)$this).test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Standard mode - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetTest $outer;
            private final Function0 f$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()), (Object)"false")}), (Function0<BoxedUnit>)this.f$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$4 = f$4;
            }
        });
        ((FunSuiteLike)$this).test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Legacy mode - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable($this, f){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetTest $outer;
            private final Function0 f$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()), (Object)"true")}), (Function0<BoxedUnit>)this.f$4);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$4 = f$4;
            }
        });
    }

    public static DataFrame readResourceParquetFile(ParquetTest $this, String name) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(name);
        return $this.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{url.toString()}));
    }

    public static void $init$(ParquetTest $this) {
    }
}

