/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.NoopColumnStats;
import org.apache.spark.sql.execution.columnar.compression.BooleanBitSet$;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.Decoder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001%2A!\u0001\u0002\u0001#\t\u0011\"i\\8mK\u0006t')\u001b;TKR\u001cV/\u001b;f\u0015\t\u0019A!A\u0006d_6\u0004(/Z:tS>t'BA\u0003\u0007\u0003!\u0019w\u000e\\;n]\u0006\u0014(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0015%\u0011QC\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005\u0011\u0001\"\u0002\u000f\u0001\t\u0003i\u0012\u0001C:lK2,Go\u001c8\u0015\u0005y!\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSRDQ!J\u000eA\u0002\u0019\nQaY8v]R\u0004\"aH\u0014\n\u0005!\u0002#aA%oi\u0002")
public class BooleanBitSetSuite
extends SparkFunSuite {
    public void skeleton(int count) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply((ColumnStats)new NoopColumnStats(), BOOLEAN$.MODULE$, (CompressionScheme)BooleanBitSet$.MODULE$);
        Seq rows = (Seq)Seq$.MODULE$.fill(count, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final InternalRow apply() {
                return ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)BOOLEAN$.MODULE$, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
            }
        });
        Seq values = (Seq)rows.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InternalRow x$1) {
                return x$1.getBoolean(0);
            }
        }, Seq$.MODULE$.canBuildFrom());
        rows.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final TestCompressibleColumnBuilder builder$1;

            public final void apply(InternalRow x$2) {
                this.builder$1.appendFrom(x$2, 0);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        int extra = count % BooleanBitSet$.MODULE$.BITS_PER_LONG() == 0 ? 0 : 1;
        int compressedSize = 8 + (count / BooleanBitSet$.MODULE$.BITS_PER_LONG() + extra) * 8;
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)BooleanBitSet$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()));
        this.assertResult(BoxesRunTime.boxToInteger((int)count), "Wrong element count", BoxesRunTime.boxToInteger((int)buffer.getInt()));
        long temp1 = 0L;
        LongRef word = new LongRef(temp1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)new Serializable(this, values, buffer, word){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;
            private final Seq values$1;
            private final ByteBuffer buffer$1;
            private final LongRef word$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int bit = i % BooleanBitSet$.MODULE$.BITS_PER_LONG();
                this.word$1.elem = bit == 0 ? this.buffer$1.getLong() : this.word$1.elem;
                this.$outer.assertResult(this.values$1.apply(i), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong value in compressed buffer, index=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), BoxesRunTime.boxToBoolean(((this.word$1.elem & 1L << bit) != 0L ? 1 : 0) != 0));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.values$1 = values$1;
                this.buffer$1 = buffer$1;
                this.word$1 = word$1;
            }
        });
        buffer.rewind().position(headerSize + 4);
        Decoder decoder = BooleanBitSet$.MODULE$.decoder(buffer, (NativeColumnType)BOOLEAN$.MODULE$);
        GenericMutableRow mutableRow = new GenericMutableRow(1);
        if (values.nonEmpty()) {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext");
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            values.foreach((Function1)new Serializable(this, decoder, mutableRow){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BooleanBitSetSuite $outer;
                private final Decoder decoder$1;
                private final GenericMutableRow mutableRow$1;

                public final void apply(boolean x$3) {
                    Boolean bl = BoxesRunTime.boxToBoolean((boolean)x$3);
                    this.decoder$1.next((MutableRow)this.mutableRow$1, 0);
                    this.$outer.assertResult(bl, "Wrong decoded value", BoxesRunTime.boxToBoolean((boolean)this.mutableRow$1.getBoolean(0)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.decoder$1 = decoder$1;
                    this.mutableRow$1 = mutableRow$1;
                }
            });
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext"));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public BooleanBitSetSuite() {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(0);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": less than 1 word"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() - 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": exactly 1 word"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": multiple whole words"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": multiple words and 1 more bit"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BooleanBitSet$.MODULE$})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BooleanBitSetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.skeleton(BooleanBitSet$.MODULE$.BITS_PER_LONG() * 2 + 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

