/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.execution.columnar.ARRAY;
import org.apache.spark.sql.execution.columnar.BINARY$;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.LARGE_DECIMAL;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.MAP;
import org.apache.spark.sql.execution.columnar.NullableColumnBuilderSuite$;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.STRUCT;
import org.apache.spark.sql.execution.columnar.TestNullableColumnBuilder;
import org.apache.spark.sql.execution.columnar.TestNullableColumnBuilder$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001\u001f\tQb*\u001e7mC\ndWmQ8mk6t')^5mI\u0016\u00148+^5uK*\u00111\u0001B\u0001\tG>dW/\u001c8be*\u0011QAB\u0001\nKb,7-\u001e;j_:T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!)!\u0004\u0001C\u00017\u0005IB/Z:u\u001dVdG.\u00192mK\u000e{G.^7o\u0005VLG\u000eZ3s+\ta\"\u0006\u0006\u0002\u001eGA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t!QK\\5u\u0011\u0015!\u0013\u00041\u0001&\u0003)\u0019w\u000e\\;n]RK\b/\u001a\t\u00041\u0019B\u0013BA\u0014\u0003\u0005)\u0019u\u000e\\;n]RK\b/\u001a\t\u0003S)b\u0001\u0001B\u0003,3\t\u0007AFA\u0004Km6$\u0016\u0010]3\u0012\u00055\u0002\u0004C\u0001\u0010/\u0013\tysDA\u0004O_RD\u0017N\\4\u0011\u0005y\t\u0014B\u0001\u001a \u0005\r\te.\u001f")
public class NullableColumnBuilderSuite
extends SparkFunSuite {
    public <JvmType> void testNullableColumnBuilder(ColumnType<JvmType> columnType) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        DataType dataType = columnType.dataType();
        UnsafeProjection proj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{dataType}));
        Function1 converter = CatalystTypeConverters$.MODULE$.createToScalaConverter(dataType);
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column builder: empty column"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NullableColumnBuilderSuite $outer;
            private final ColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TestNullableColumnBuilder<JvmType> columnBuilder = TestNullableColumnBuilder$.MODULE$.apply(this.columnType$1, TestNullableColumnBuilder$.MODULE$.apply$default$2());
                ByteBuffer buffer = columnBuilder.build();
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)0), "Wrong null count", BoxesRunTime.boxToInteger((int)buffer.getInt()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(buffer.hasRemaining(), "buffer.hasRemaining()"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$1 = columnType$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column builder: buffer size auto growth"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType, proj){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NullableColumnBuilderSuite $outer;
            private final ColumnType columnType$1;
            public final UnsafeProjection proj$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TestNullableColumnBuilder<JvmType> columnBuilder = TestNullableColumnBuilder$.MODULE$.apply(this.columnType$1, TestNullableColumnBuilder$.MODULE$.apply$default$2());
                InternalRow randomRow = ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)this.columnType$1, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)new Serializable(this, columnBuilder, randomRow){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testNullableColumnBuilder$2 $outer;
                    private final TestNullableColumnBuilder columnBuilder$1;
                    private final InternalRow randomRow$1;

                    public final void apply(int x$3) {
                        this.apply$mcVI$sp(x$3);
                    }

                    public void apply$mcVI$sp(int x$3) {
                        this.columnBuilder$1.appendFrom((InternalRow)this.$outer.proj$1.apply(this.randomRow$1), 0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.columnBuilder$1 = columnBuilder$1;
                        this.randomRow$1 = randomRow$1;
                    }
                });
                ByteBuffer buffer = columnBuilder.build();
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)0), "Wrong null count", BoxesRunTime.boxToInteger((int)buffer.getInt()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$1 = columnType$1;
                this.proj$1 = proj$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column builder: null values"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType, dataType, proj, converter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NullableColumnBuilderSuite $outer;
            public final ColumnType columnType$1;
            public final DataType dataType$1;
            public final UnsafeProjection proj$1;
            public final Function1 converter$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TestNullableColumnBuilder<JvmType> columnBuilder = TestNullableColumnBuilder$.MODULE$.apply(this.columnType$1, TestNullableColumnBuilder$.MODULE$.apply$default$2());
                InternalRow randomRow = ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)this.columnType$1, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
                GenericMutableRow nullRow = ColumnarTestUtils$.MODULE$.makeNullRow(1);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)new Serializable(this, columnBuilder, randomRow, nullRow){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testNullableColumnBuilder$3 $outer;
                    private final TestNullableColumnBuilder columnBuilder$2;
                    private final InternalRow randomRow$2;
                    private final GenericMutableRow nullRow$1;

                    public final void apply(int x$4) {
                        this.apply$mcVI$sp(x$4);
                    }

                    public void apply$mcVI$sp(int x$4) {
                        this.columnBuilder$2.appendFrom((InternalRow)this.$outer.proj$1.apply(this.randomRow$2), 0);
                        this.columnBuilder$2.appendFrom((InternalRow)this.$outer.proj$1.apply((InternalRow)this.nullRow$1), 0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.columnBuilder$2 = columnBuilder$2;
                        this.randomRow$2 = randomRow$2;
                        this.nullRow$1 = nullRow$1;
                    }
                });
                ByteBuffer buffer = columnBuilder.build();
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)4), "Wrong null count", BoxesRunTime.boxToInteger((int)buffer.getInt()));
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 7).by(2).foreach$mVc$sp((Function1)new Serializable(this, buffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testNullableColumnBuilder$3 $outer;
                    private final ByteBuffer buffer$1;

                    public final void apply(int x$5) {
                        this.apply$mcVI$sp(x$5);
                    }

                    public void apply$mcVI$sp(int x$5) {
                        this.$outer.org$apache$spark$sql$execution$columnar$NullableColumnBuilderSuite$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)x$5), "Wrong null position", BoxesRunTime.boxToInteger((int)this.buffer$1.getInt()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.buffer$1 = buffer$1;
                    }
                });
                GenericMutableRow actual = new GenericMutableRow(new Object[1]);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)new Serializable(this, randomRow, buffer, actual){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testNullableColumnBuilder$3 $outer;
                    private final InternalRow randomRow$2;
                    private final ByteBuffer buffer$1;
                    private final GenericMutableRow actual$1;

                    public final void apply(int x$6) {
                        this.apply$mcVI$sp(x$6);
                    }

                    public void apply$mcVI$sp(int x$6) {
                        this.$outer.columnType$1.extract(this.buffer$1, (MutableRow)this.actual$1, 0);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$execution$columnar$NullableColumnBuilderSuite$$anonfun$$$outer().convertToEqualizer(this.$outer.converter$1.apply(this.actual$1.get(0, this.$outer.dataType$1)));
                        Object $org_scalatest_assert_macro_right = this.$outer.converter$1.apply(this.randomRow$2.get(0, this.$outer.dataType$1));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$execution$columnar$NullableColumnBuilderSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Extracted value didn't equal to the original one");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.randomRow$2 = randomRow$2;
                        this.buffer$1 = buffer$1;
                        this.actual$1 = actual$1;
                    }
                });
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(buffer.hasRemaining(), "buffer.hasRemaining()"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ NullableColumnBuilderSuite org$apache$spark$sql$execution$columnar$NullableColumnBuilderSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$1 = columnType$1;
                this.dataType$1 = dataType$1;
                this.proj$1 = proj$1;
                this.converter$1 = converter$1;
            }
        });
    }

    public NullableColumnBuilderSuite() {
        ColumnType[] columnTypeArray = new ColumnType[14];
        columnTypeArray[0] = BOOLEAN$.MODULE$;
        columnTypeArray[1] = BYTE$.MODULE$;
        columnTypeArray[2] = SHORT$.MODULE$;
        columnTypeArray[3] = INT$.MODULE$;
        columnTypeArray[4] = LONG$.MODULE$;
        columnTypeArray[5] = FLOAT$.MODULE$;
        columnTypeArray[6] = DOUBLE$.MODULE$;
        columnTypeArray[7] = STRING$.MODULE$;
        columnTypeArray[8] = BINARY$.MODULE$;
        columnTypeArray[9] = new COMPACT_DECIMAL(15, 10);
        columnTypeArray[10] = new LARGE_DECIMAL(20, 10);
        StructField structField = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        columnTypeArray[11] = new STRUCT(StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)));
        columnTypeArray[12] = new ARRAY(ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        columnTypeArray[13] = new MAP(MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])columnTypeArray))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NullableColumnBuilderSuite $outer;

            public final void apply(ColumnType<? super UnsafeMapData> x$2) {
                this.$outer.testNullableColumnBuilder(x$2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

