/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.columnar.ARRAY;
import org.apache.spark.sql.execution.columnar.BINARY$;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnType$;
import org.apache.spark.sql.execution.columnar.ColumnTypeSuite$;
import org.apache.spark.sql.execution.columnar.ColumnTypeSuite$$anonfun$testColumnType$1$;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.LARGE_DECIMAL;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.MAP;
import org.apache.spark.sql.execution.columnar.NULL$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.STRUCT;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001f\ty1i\u001c7v[:$\u0016\u0010]3Tk&$XM\u0003\u0002\u0004\t\u0005A1m\u001c7v[:\f'O\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A!\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011\u0011#F\u0005\u0003-!\u0011q\u0001T8hO&tw\rC\u0003\u0019\u0001\u0011\u0005\u0011$\u0001\u0004=S:LGO\u0010\u000b\u00025A\u00111\u0004A\u0007\u0002\u0005!9Q\u0004\u0001b\u0001\n\u0013q\u0012a\u0005#F\r\u0006+F\nV0C+\u001a3UIU0T\u0013j+U#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\u0007%sG\u000f\u0003\u0004'\u0001\u0001\u0006IaH\u0001\u0015\t\u00163\u0015)\u0016'U?\n+fIR#S?NK%,\u0012\u0011\t\u000f!\u0002!\u0019!C\u0005S\u0005AQ*\u0011)`)f\u0003V)F\u0001+!\tY2&\u0003\u0002-\u0005\t\u0019Q*\u0011)\t\r9\u0002\u0001\u0015!\u0003+\u0003%i\u0015\tU0U3B+\u0005\u0005C\u00041\u0001\t\u0007I\u0011B\u0019\u0002\u0015\u0005\u0013&+Q-`)f\u0003V)F\u00013!\tY2'\u0003\u00025\u0005\t)\u0011I\u0015*B3\"1a\u0007\u0001Q\u0001\nI\n1\"\u0011*S\u0003f{F+\u0017)FA!9\u0001\b\u0001b\u0001\n\u0013I\u0014aC*U%V\u001bEk\u0018+Z!\u0016+\u0012A\u000f\t\u00037mJ!\u0001\u0010\u0002\u0003\rM#&+V\"U\u0011\u0019q\u0004\u0001)A\u0005u\u0005a1\u000b\u0016*V\u0007R{F+\u0017)FA!)\u0001\t\u0001C\u0001\u0003\u0006!B/Z:u\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016,\"AQ'\u0015\u0005\r3\u0005C\u0001\u0011E\u0013\t)\u0015E\u0001\u0003V]&$\b\"B$@\u0001\u0004A\u0015AC2pYVlg\u000eV=qKB\u00191$S&\n\u0005)\u0013!\u0001\u0005(bi&4XmQ8mk6tG+\u001f9f!\taU\n\u0004\u0001\u0005\u000b9{$\u0019A(\u0003\u0003Q\u000b\"\u0001U*\u0011\u0005\u0001\n\u0016B\u0001*\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001V,\u000e\u0003US!A\u0016\u0004\u0002\u000bQL\b/Z:\n\u0005a+&AC!u_6L7\rV=qK\")!\f\u0001C\u00017\u0006qA/Z:u\u0007>dW/\u001c8UsB,WC\u0001/c)\t\u0019U\fC\u0003H3\u0002\u0007a\fE\u0002\u001c?\u0006L!\u0001\u0019\u0002\u0003\u0015\r{G.^7o)f\u0004X\r\u0005\u0002ME\u0012)1-\u0017b\u0001I\n9!J^7UsB,\u0017C\u0001)f!\t\u0001c-\u0003\u0002hC\t\u0019\u0011I\\=\t\u000b%\u0004A\u0011\u00026\u0002\u0015\u0011,X\u000e\u001d\"vM\u001a,'\u000f\u0006\u0002fW\")A\u000e\u001ba\u0001[\u0006!!-\u001e4g!\tq7/D\u0001p\u0015\t\u0001\u0018/A\u0002oS>T\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\nQ!)\u001f;f\u0005V4g-\u001a:")
public class ColumnTypeSuite
extends SparkFunSuite {
    private final int DEFAULT_BUFFER_SIZE;
    private final MAP org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$MAP_TYPE = new MAP(MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));
    private final ARRAY org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$ARRAY_TYPE = new ARRAY(ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
    private final STRUCT org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$STRUCT_TYPE;

    private int DEFAULT_BUFFER_SIZE() {
        return this.DEFAULT_BUFFER_SIZE;
    }

    public MAP org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$MAP_TYPE() {
        return this.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$MAP_TYPE;
    }

    public ARRAY org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$ARRAY_TYPE() {
        return this.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$ARRAY_TYPE;
    }

    public STRUCT org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$STRUCT_TYPE() {
        return this.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$STRUCT_TYPE;
    }

    public <T extends AtomicType> void testNativeColumnType(NativeColumnType<T> columnType) {
        this.testColumnType((ColumnType)columnType);
    }

    public <JvmType> void testColumnType(ColumnType<JvmType> columnType) {
        ByteBuffer buffer = ByteBuffer.allocate(this.DEFAULT_BUFFER_SIZE()).order(ByteOrder.nativeOrder());
        UnsafeProjection proj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{columnType.dataType()}));
        Function1 converter = CatalystTypeConverters$.MODULE$.createToScalaConverter(columnType.dataType());
        IndexedSeq seq = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this, columnType, proj){
            public static final long serialVersionUID = 0L;
            private final ColumnType columnType$1;
            private final UnsafeProjection proj$1;

            public final UnsafeRow apply(int x$2) {
                return this.proj$1.apply(ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)this.columnType$1, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]))).copy();
            }
            {
                this.columnType$1 = columnType$1;
                this.proj$1 = proj$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " append/extract"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnType})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType, buffer, converter, seq){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;
            public final ColumnType columnType$1;
            public final ByteBuffer buffer$1;
            public final Function1 converter$1;
            private final IndexedSeq seq$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.buffer$1.rewind();
                this.seq$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnType$1 $outer;

                    public final void apply(UnsafeRow x$3) {
                        this.$outer.columnType$1.append((InternalRow)x$3, 0, this.$outer.buffer$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.buffer$1.rewind();
                this.seq$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnType$1 $outer;

                    public final void apply(UnsafeRow row) {
                        this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, row){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$testColumnType$1$$anonfun$apply$mcV$sp$5 $outer;
                            private final UnsafeRow row$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"buffer = ").append((Object)this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$anonfun$$$outer().buffer$1).append((Object)", expected = ").append((Object)this.row$1).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.row$1 = row$1;
                            }
                        });
                        Object expected2 = this.$outer.converter$1.apply(row.get(0, this.$outer.columnType$1.dataType()));
                        Object extracted = this.$outer.converter$1.apply(this.$outer.columnType$1.extract(this.$outer.buffer$1));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$$outer().convertToEqualizer(expected2);
                        Object $org_scalatest_assert_macro_right = extracted;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extracted value didn't equal to the original one. ", " != ", ", buffer ="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected2, extracted}))).append(this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$$outer().org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$dumpBuffer((ByteBuffer)this.$outer.buffer$1.duplicate().rewind())).toString());
                    }

                    public /* synthetic */ $anonfun$testColumnType$1 org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ColumnTypeSuite org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$1 = columnType$1;
                this.buffer$1 = buffer$1;
                this.converter$1 = converter$1;
                this.seq$1 = seq$1;
            }
        });
    }

    public Object org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$dumpBuffer(ByteBuffer buff) {
        StringBuilder sb = new StringBuilder();
        while (buff.hasRemaining()) {
            byte b = buff.get();
            sb.append(Integer.toHexString(b & 0xFF)).append(' ');
        }
        if (sb.nonEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public ColumnTypeSuite() {
        this.DEFAULT_BUFFER_SIZE = 512;
        StructField structField = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$STRUCT_TYPE = new STRUCT(StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)));
        this.test("defaultSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map checks = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)NULL$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BOOLEAN$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BYTE$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)SHORT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)INT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)LONG$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)FLOAT$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)DOUBLE$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new COMPACT_DECIMAL(15, 10)), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new LARGE_DECIMAL(20, 10)), (Object)BoxesRunTime.boxToInteger((int)12)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)STRING$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BINARY$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$STRUCT_TYPE()), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$ARRAY_TYPE()), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$MAP_TYPE()), (Object)BoxesRunTime.boxToInteger((int)32))}));
                checks.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(Tuple2<ColumnType<? super UnsafeMapData>, Object> x0$1) {
                        Tuple2<ColumnType<? super UnsafeMapData>, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            ColumnType columnType = (ColumnType)tuple2._1();
                            int expectedSize = tuple2._2$mcI$sp();
                            this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$$outer().assertResult(BoxesRunTime.boxToInteger((int)expectedSize), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong defaultSize for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnType})), BoxesRunTime.boxToInteger((int)columnType.defaultSize()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ColumnTypeSuite org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("actualSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.checkActualSize$1((ColumnType)NULL$.MODULE$, null, 0);
                this.checkActualSize$1((ColumnType)BOOLEAN$.MODULE$, BoxesRunTime.boxToBoolean((boolean)true), 1);
                this.checkActualSize$1((ColumnType)BYTE$.MODULE$, BoxesRunTime.boxToByte((byte)127), 1);
                this.checkActualSize$1((ColumnType)SHORT$.MODULE$, BoxesRunTime.boxToShort((short)Short.MAX_VALUE), 2);
                this.checkActualSize$1((ColumnType)INT$.MODULE$, BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), 4);
                this.checkActualSize$1((ColumnType)LONG$.MODULE$, BoxesRunTime.boxToLong((long)Long.MAX_VALUE), 8);
                this.checkActualSize$1((ColumnType)FLOAT$.MODULE$, BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), 4);
                this.checkActualSize$1((ColumnType)DOUBLE$.MODULE$, BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), 8);
                this.checkActualSize$1((ColumnType)STRING$.MODULE$, "hello", 4 + "hello".getBytes("utf-8").length);
                this.checkActualSize$1((ColumnType)BINARY$.MODULE$, Array$.MODULE$.fill(4, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte apply() {
                        return this.apply$mcB$sp();
                    }

                    public byte apply$mcB$sp() {
                        return (byte)0;
                    }
                }, ClassTag$.MODULE$.Byte()), 8);
                this.checkActualSize$1((ColumnType)new COMPACT_DECIMAL(15, 10), Decimal$.MODULE$.apply(0L, 15, 10), 8);
                this.checkActualSize$1((ColumnType)new LARGE_DECIMAL(20, 10), Decimal$.MODULE$.apply(0L, 20, 10), 5);
                this.checkActualSize$1((ColumnType)this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$ARRAY_TYPE(), Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}), ClassTag$.MODULE$.Any()), 16);
                this.checkActualSize$1((ColumnType)this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$MAP_TYPE(), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a")})), 29);
                this.checkActualSize$1((ColumnType)this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$STRUCT_TYPE(), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hello"})), 28);
            }

            private final void checkActualSize$1(ColumnType columnType, Object value, int expected2) {
                Integer n = BoxesRunTime.boxToInteger((int)expected2);
                String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong actualSize for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnType}));
                GenericMutableRow row = new GenericMutableRow(1);
                row.update(0, CatalystTypeConverters$.MODULE$.convertToCatalyst(value));
                UnsafeProjection proj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{columnType.dataType()}));
                this.$outer.assertResult(n, string, BoxesRunTime.boxToInteger((int)columnType.actualSize((InternalRow)proj.apply((InternalRow)row), 0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.testNativeColumnType((NativeColumnType)BOOLEAN$.MODULE$);
        this.testNativeColumnType((NativeColumnType)BYTE$.MODULE$);
        this.testNativeColumnType((NativeColumnType)SHORT$.MODULE$);
        this.testNativeColumnType((NativeColumnType)INT$.MODULE$);
        this.testNativeColumnType((NativeColumnType)LONG$.MODULE$);
        this.testNativeColumnType((NativeColumnType)FLOAT$.MODULE$);
        this.testNativeColumnType((NativeColumnType)DOUBLE$.MODULE$);
        this.testNativeColumnType((NativeColumnType)new COMPACT_DECIMAL(15, 10));
        this.testNativeColumnType((NativeColumnType)STRING$.MODULE$);
        this.testColumnType((ColumnType)NULL$.MODULE$);
        this.testColumnType((ColumnType)BINARY$.MODULE$);
        this.testColumnType((ColumnType)new LARGE_DECIMAL(20, 10));
        this.testColumnType((ColumnType)this.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$STRUCT_TYPE());
        this.testColumnType((ColumnType)this.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$ARRAY_TYPE());
        this.testColumnType((ColumnType)this.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$MAP_TYPE());
        this.test("column type for decimal types with different precision", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnTypeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 18).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.$outer.org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$$outer().assertResult(new COMPACT_DECIMAL(i, 0), ColumnType$.MODULE$.apply((DataType)new DecimalType(i, 0)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.assertResult(new LARGE_DECIMAL(19, 0), ColumnType$.MODULE$.apply((DataType)new DecimalType(19, 0)));
            }

            public /* synthetic */ ColumnTypeSuite org$apache$spark$sql$execution$columnar$ColumnTypeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

