/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.BooleanColumnStats;
import org.apache.spark.sql.execution.columnar.ByteColumnStats;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnStatsSuite$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.DecimalColumnStats;
import org.apache.spark.sql.execution.columnar.DoubleColumnStats;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.FloatColumnStats;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.ShortColumnStats;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Array$;
import scala.Double$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001f\t\u00012i\u001c7v[:\u001cF/\u0019;t'VLG/\u001a\u0006\u0003\u0007\u0011\t\u0001bY8mk6t\u0017M\u001d\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00065\u0001!\taG\u0001\nGJ,\u0017\r^3S_^$\"\u0001\b\u0013\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013aC3yaJ,7o]5p]NT!!\t\u0004\u0002\u0011\r\fG/\u00197zgRL!a\t\u0010\u0003%\u001d+g.\u001a:jG&sG/\u001a:oC2\u0014vn\u001e\u0005\u0006Ke\u0001\rAJ\u0001\u0007m\u0006dW/Z:\u0011\u0007\u001dRC&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005)a$/\u001a9fCR,GM\u0010\t\u0003O5J!A\f\u0015\u0003\u0007\u0005s\u0017\u0010C\u00031\u0001\u0011\u0005\u0011'A\buKN$8i\u001c7v[:\u001cF/\u0019;t+\r\u0011\u0004+\u0011\u000b\u0005gYR\u0015\f\u0005\u0002(i%\u0011Q\u0007\u000b\u0002\u0005+:LG\u000fC\u00038_\u0001\u0007\u0001(\u0001\td_2,XN\\*uCR\u001c8\t\\1tgB\u0019\u0011\bP \u000f\u0005\u001dR\u0014BA\u001e)\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0006\u00072\f7o\u001d\u0006\u0003w!\u0002\"\u0001Q!\r\u0001\u0011)!i\fb\u0001\u0007\n\tQ+\u0005\u0002E\u000fB\u0011q%R\u0005\u0003\r\"\u0012qAT8uQ&tw\r\u0005\u0002\u0019\u0011&\u0011\u0011J\u0001\u0002\f\u0007>dW/\u001c8Ti\u0006$8\u000fC\u0003L_\u0001\u0007A*\u0001\u0006d_2,XN\u001c+za\u0016\u00042\u0001G'P\u0013\tq%A\u0001\tOCRLg/Z\"pYVlg\u000eV=qKB\u0011\u0001\t\u0015\u0003\u0006#>\u0012\rA\u0015\u0002\u0002)F\u0011Ai\u0015\t\u0003)^k\u0011!\u0016\u0006\u0003-\u001a\tQ\u0001^=qKNL!\u0001W+\u0003\u0015\u0005#x.\\5d)f\u0004X\rC\u0003[_\u0001\u0007A$A\tj]&$\u0018.\u00197Ti\u0006$\u0018n\u001d;jGNDQ\u0001\u0018\u0001\u0005\u0002u\u000ba\u0003^3ti\u0012+7-[7bY\u000e{G.^7o'R\fGo]\u000b\u0004=\u0002\fGCA\u001a`\u0011\u0015Q6\f1\u0001\u001d\t\u0015\t6L1\u0001S\t\u0015\u00115L1\u0001D\u0001")
public class ColumnStatsSuite
extends SparkFunSuite {
    public GenericInternalRow createRow(Seq<Object> values) {
        return new GenericInternalRow((Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    public <T extends AtomicType, U extends ColumnStats> void testColumnStats(Class<U> columnStatsClass, NativeColumnType<T> columnType, GenericInternalRow initialStatistics) {
        String columnStatsName = columnStatsClass.getSimpleName();
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnStatsName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStatsClass, initialStatistics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnStatsSuite $outer;
            private final Class columnStatsClass$1;
            private final GenericInternalRow initialStatistics$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ColumnStats columnStats = (ColumnStats)this.columnStatsClass$1.newInstance();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics().values()).zip((GenIterable)Predef$.MODULE$.genericWrapArray((Object)this.initialStatistics$1.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnStats$1 $outer;

                    public final void apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object actual = tuple2._1();
                            Object expected2 = tuple2._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$execution$columnar$ColumnStatsSuite$$anonfun$$$outer().convertToEqualizer(actual);
                            Object $org_scalatest_assert_macro_right = expected2;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$sql$execution$columnar$ColumnStatsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ColumnStatsSuite org$apache$spark$sql$execution$columnar$ColumnStatsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStatsClass$1 = columnStatsClass$1;
                this.initialStatistics$1 = initialStatistics$1;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": non-empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnStatsName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStatsClass, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnStatsSuite $outer;
            private final Class columnStatsClass$1;
            public final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ColumnStats columnStats = (ColumnStats)this.columnStatsClass$1.newInstance();
                Seq rows = (Seq)((TraversableLike)Seq$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnStats$2 $outer;

                    public final InternalRow apply() {
                        return ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)this.$outer.columnType$1, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GenericMutableRow apply() {
                        return ColumnarTestUtils$.MODULE$.makeNullRow(1);
                    }
                }), Seq$.MODULE$.canBuildFrom());
                rows.foreach((Function1)new Serializable(this, columnStats){
                    public static final long serialVersionUID = 0L;
                    private final ColumnStats columnStats$1;

                    public final void apply(InternalRow x$1) {
                        this.columnStats$1.gatherStats(x$1, 0);
                    }
                    {
                        this.columnStats$1 = columnStats$1;
                    }
                });
                Seq values = (Seq)((TraversableLike)rows.take(10)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnStats$2 $outer;

                    public final Object apply(InternalRow x$2) {
                        return x$2.get(0, (DataType)this.$outer.columnType$1.dataType());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Ordering ordering = this.columnType$1.dataType().ordering();
                GenericInternalRow stats = columnStats.collectedStatistics();
                this.$outer.assertResult(values.min(ordering), "Wrong lower bound", stats.values()[0]);
                this.$outer.assertResult(values.max(ordering), "Wrong upper bound", stats.values()[1]);
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats.values()[2]);
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats.values()[3]);
                this.$outer.assertResult(stats.values()[4], "Wrong size in bytes", ((TraversableOnce)rows.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testColumnStats$2 $outer;

                    public final int apply(InternalRow row) {
                        return row.isNullAt(0) ? 4 : this.$outer.columnType$1.actualSize(row, 0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnStatsClass$1 = columnStatsClass$1;
                this.columnType$1 = columnType$1;
            }
        });
    }

    public <T extends AtomicType, U extends ColumnStats> void testDecimalColumnStats(GenericInternalRow initialStatistics) {
        String columnStatsName = DecimalColumnStats.class.getSimpleName();
        COMPACT_DECIMAL columnType = new COMPACT_DECIMAL(15, 10);
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnStatsName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, initialStatistics){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnStatsSuite $outer;
            private final GenericInternalRow initialStatistics$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecimalColumnStats columnStats = new DecimalColumnStats(15, 10);
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics().values()).zip((GenIterable)Predef$.MODULE$.genericWrapArray((Object)this.initialStatistics$2.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDecimalColumnStats$1 $outer;

                    public final void apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object actual = tuple2._1();
                            Object expected2 = tuple2._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$execution$columnar$ColumnStatsSuite$$anonfun$$$outer().convertToEqualizer(actual);
                            Object $org_scalatest_assert_macro_right = expected2;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$sql$execution$columnar$ColumnStatsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ColumnStatsSuite org$apache$spark$sql$execution$columnar$ColumnStatsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.initialStatistics$2 = initialStatistics$2;
            }
        });
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": non-empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columnStatsName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ColumnStatsSuite $outer;
            public final COMPACT_DECIMAL columnType$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecimalColumnStats columnStats = new DecimalColumnStats(15, 10);
                Seq rows = (Seq)((TraversableLike)Seq$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDecimalColumnStats$2 $outer;

                    public final InternalRow apply() {
                        return ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)this.$outer.columnType$2, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })).$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(10, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GenericMutableRow apply() {
                        return ColumnarTestUtils$.MODULE$.makeNullRow(1);
                    }
                }), Seq$.MODULE$.canBuildFrom());
                rows.foreach((Function1)new Serializable(this, columnStats){
                    public static final long serialVersionUID = 0L;
                    private final DecimalColumnStats columnStats$2;

                    public final void apply(InternalRow x$3) {
                        this.columnStats$2.gatherStats(x$3, 0);
                    }
                    {
                        this.columnStats$2 = columnStats$2;
                    }
                });
                Seq values = (Seq)((TraversableLike)rows.take(10)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDecimalColumnStats$2 $outer;

                    public final Object apply(InternalRow x$4) {
                        return x$4.get(0, (DataType)this.$outer.columnType$2.dataType());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Decimal.DecimalIsFractional$ ordering = ((DecimalType)this.columnType$2.dataType()).ordering();
                GenericInternalRow stats = columnStats.collectedStatistics();
                this.$outer.assertResult(values.min((Ordering)ordering), "Wrong lower bound", stats.values()[0]);
                this.$outer.assertResult(values.max((Ordering)ordering), "Wrong upper bound", stats.values()[1]);
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats.values()[2]);
                this.$outer.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats.values()[3]);
                this.$outer.assertResult(stats.values()[4], "Wrong size in bytes", ((TraversableOnce)rows.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testDecimalColumnStats$2 $outer;

                    public final int apply(InternalRow row) {
                        return row.isNullAt(0) ? 4 : this.$outer.columnType$2.actualSize(row, 0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.columnType$2 = columnType$2;
            }
        });
    }

    public ColumnStatsSuite() {
        this.testColumnStats((Class)BooleanColumnStats.class, (NativeColumnType)BOOLEAN$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)ByteColumnStats.class, (NativeColumnType)BYTE$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)127), BoxesRunTime.boxToByte((byte)-128), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)ShortColumnStats.class, (NativeColumnType)SHORT$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)Short.MAX_VALUE), BoxesRunTime.boxToShort((short)Short.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)IntColumnStats.class, (NativeColumnType)INT$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)LongColumnStats.class, (NativeColumnType)LONG$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)FloatColumnStats.class, (NativeColumnType)FLOAT$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), BoxesRunTime.boxToFloat((float)Float$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)0)})));
        this.testColumnStats((Class)DoubleColumnStats.class, (NativeColumnType)DOUBLE$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)0)})));
        Object[] objectArray = new Object[3];
        objectArray[0] = null;
        objectArray[1] = null;
        objectArray[2] = BoxesRunTime.boxToInteger((int)0);
        this.testColumnStats((Class)StringColumnStats.class, (NativeColumnType)STRING$.MODULE$, this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = null;
        objectArray2[1] = null;
        objectArray2[2] = BoxesRunTime.boxToInteger((int)0);
        this.testDecimalColumnStats(this.createRow((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)objectArray2)));
    }
}

