/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLConf$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ScalaUDF;
import org.apache.spark.sql.catalyst.expressions.UserDefinedGenerator;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.plans.PlanTest;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.AppendColumns;
import org.apache.spark.sql.catalyst.plans.logical.CoGroup;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MapGroups;
import org.apache.spark.sql.catalyst.plans.logical.MapPartitions;
import org.apache.spark.sql.catalyst.trees.TreeNode$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.LogicalRDD;
import org.apache.spark.sql.execution.Queryable;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005uf!B\u0001\u0003\u0003\u0003Y!!C)vKJLH+Z:u\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005)\u0001\u000f\\1og*\u0011\u0011CA\u0001\tG\u0006$\u0018\r\\=ti&\u00111C\u0004\u0002\t!2\fg\u000eV3ti\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00065\u00011\tbG\u0001\u000bgFd7i\u001c8uKb$X#\u0001\u000f\u0011\u0005ai\u0012B\u0001\u0010\u0003\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010\u001e\u0005\u0006A\u0001!\t!I\u0001\u000fG\",7m[#ySN$XM\\2f)\u0011\u0011\u0003&\f\u001a\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006S}\u0001\rAK\u0001\u0003I\u001a\u0004\"\u0001G\u0016\n\u00051\u0012!!\u0003#bi\u00064%/Y7f\u0011\u0015qs\u00041\u00010\u0003\u0019)\u00070[:ugB\u00111\u0005M\u0005\u0003c\u0011\u0012qAQ8pY\u0016\fg\u000eC\u00034?\u0001\u0007A'\u0001\u0005lKf<xN\u001d3t!\r\u0019SgN\u0005\u0003m\u0011\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?!\tA4H\u0004\u0002$s%\u0011!\bJ\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;I!)q\b\u0001C\t\u0001\u0006Y1\r[3dW\u0006s7o^3s+\t\t\u0015\nF\u0002#\u0005JCQa\u0011 A\u0002\u0011\u000b!\u0001Z:\u0011\u0007a)u)\u0003\u0002G\u0005\t9A)\u0019;bg\u0016$\bC\u0001%J\u0019\u0001!QA\u0013 C\u0002-\u0013\u0011\u0001V\t\u0003\u0019>\u0003\"aI'\n\u00059##a\u0002(pi\"Lgn\u001a\t\u0003GAK!!\u0015\u0013\u0003\u0007\u0005s\u0017\u0010C\u0003T}\u0001\u0007A+\u0001\bfqB,7\r^3e\u0003:\u001cx/\u001a:\u0011\u0007\r*t\tC\u0003W\u0001\u0011Eq+A\u0007dQ\u0016\u001c7\u000eR3d_\u0012LgnZ\u000b\u00031~#2AI-a\u0011\u0019\u0019U\u000b\"a\u00015B\u00191eW/\n\u0005q##\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007a)e\f\u0005\u0002I?\u0012)!*\u0016b\u0001\u0017\")1+\u0016a\u0001CB\u00191%\u000e0\t\u000b}\u0002A\u0011C2\u0015\u0007\t\"g\r\u0003\u0004*E\u0012\u0005\r!\u001a\t\u0004GmS\u0003\"B*c\u0001\u00049\u0007c\u00015qg:\u0011\u0011N\u001c\b\u0003U6l\u0011a\u001b\u0006\u0003Y*\ta\u0001\u0010:p_Rt\u0014\"A\u0013\n\u0005=$\u0013a\u00029bG.\fw-Z\u0005\u0003cJ\u00141aU3r\u0015\tyG\u0005\u0005\u0002\u0019i&\u0011QO\u0001\u0002\u0004%><\b\"B \u0001\t#9Hc\u0001\u0012ys\"1\u0011F\u001eCA\u0002\u0015DQa\u0015<A\u0002MDQa\u0010\u0001\u0005\u0012m$2A\t?~\u0011\u0019I#\u0010\"a\u0001K\")1K\u001fa\u0001U!1q\u0010\u0001C\t\u0003\u0003\tac\u00195fG.\fum\u001a:fO\u0006$Xm],ji\"$v\u000e\u001c\u000b\bE\u0005\r\u0011qAA\u0005\u0011\u0019\t)A a\u0001U\u0005IA-\u0019;b\rJ\fW.\u001a\u0005\u0006'z\u0004\ra\u001a\u0005\b\u0003\u0017q\b\u0019AA\u0007\u0003\u0019\t'm\u001d+pYB\u00191%a\u0004\n\u0007\u0005EAE\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u007f\u0002!\t\"!\u0006\u0015\u000f\t\n9\"!\u0007\u0002\u001c!9\u0011QAA\n\u0001\u0004Q\u0003BB*\u0002\u0014\u0001\u00071\u000f\u0003\u0005\u0002\f\u0005M\u0001\u0019AA\u0007\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\tA\"Y:tKJ$8)Y2iK\u0012$RAIA\u0012\u0003gA\u0001\"!\n\u0002\u001e\u0001\u0007\u0011qE\u0001\u0006cV,'/\u001f\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u0002\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BA\u0019\u0003W\u0011\u0011\"U;fef\f'\r\\3\t\u0015\u0005U\u0012Q\u0004I\u0001\u0002\u0004\t9$A\bok6\u001c\u0015m\u00195fIR\u000b'\r\\3t!\r\u0019\u0013\u0011H\u0005\u0004\u0003w!#aA%oi\"9\u0011q\b\u0001\u0005\n\u0005\u0005\u0013aD2iK\u000e\\'j]8o\r>\u0014X.\u0019;\u0015\u0007\t\n\u0019\u0005\u0003\u0004*\u0003{\u0001\rA\u000b\u0005\n\u0003\u000f\u0002\u0011\u0013!C\u0001\u0003\u0013\na#Y:tKJ$8)Y2iK\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0017RC!a\u000e\u0002N-\u0012\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003%)hn\u00195fG.,GMC\u0002\u0002Z\u0011\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti&a\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cWmB\u0004\u0002b\tA\t!a\u0019\u0002\u0013E+XM]=UKN$\bc\u0001\r\u0002f\u00191\u0011A\u0001E\u0001\u0003O\u001ab!!\u001a\u0002j\u0005=\u0004cA\u0012\u0002l%\u0019\u0011Q\u000e\u0013\u0003\r\u0005s\u0017PU3g!\r\u0019\u0013\u0011O\u0005\u0004\u0003g\"#\u0001D*fe&\fG.\u001b>bE2,\u0007bB\u000b\u0002f\u0011\u0005\u0011q\u000f\u000b\u0003\u0003GBqaPA3\t\u0003\tY\b\u0006\u0004\u0002~\u0005\r\u0015Q\u0011\t\u0005G\u0005}t'C\u0002\u0002\u0002\u0012\u0012aa\u00149uS>t\u0007BB\u0015\u0002z\u0001\u0007!\u0006\u0003\u0004T\u0003s\u0002\ra\u001a\u0005\b\u007f\u0006\u0015D\u0011CAE)\u001d\u0011\u00131RAH\u0003#Cq!!$\u0002\b\u0002\u00071/\u0001\u0007bGR,\u0018\r\\!og^,'\u000f\u0003\u0004T\u0003\u000f\u0003\ra\u001d\u0005\t\u0003\u0017\t9\t1\u0001\u0002\u000e!9q(!\u001a\u0005\u0002\u0005UE#B\u001c\u0002\u0018\u0006e\u0005BB\u0015\u0002\u0014\u0002\u0007!\u0006C\u0004T\u0003'\u0003\r!a'\u0011\u000b\u0005u\u0015qU:\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000bA!\u001e;jY*\u0011\u0011QU\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0006}%\u0001\u0002'jgRD!\"!,\u0002f\u0005\u0005I\u0011BAX\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0006\u0003BAZ\u0003sk!!!.\u000b\t\u0005]\u00161U\u0001\u0005Y\u0006tw-\u0003\u0003\u0002<\u0006U&AB(cU\u0016\u001cG\u000f")
public abstract class QueryTest
extends PlanTest {
    public abstract SQLContext sqlContext();

    public void checkExistence(DataFrame df2, boolean exists, Seq<String> keywords) {
        String outputs = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df2.collect()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Row x$1) {
                return x$1.mkString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString();
        keywords.foreach((Function1)new Serializable(this, df2, exists, outputs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryTest $outer;
            private final DataFrame df$1;
            private final boolean exists$1;
            private final String outputs$1;

            public final void apply(String key) {
                if (this.exists$1) {
                    String $org_scalatest_assert_macro_left = this.outputs$1;
                    String $org_scalatest_assert_macro_right = key;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed for ", " (", " doesn't exist in result)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.df$1, key})));
                } else {
                    String $org_scalatest_assert_macro_left = this.outputs$1;
                    String $org_scalatest_assert_macro_right = key;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed for ", " (", " existed in the result)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.df$1, key})));
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.df$1 = df$1;
                this.exists$1 = exists$1;
                this.outputs$1 = outputs$1;
            }
        });
    }

    public <T> void checkAnswer(Dataset<T> ds, Seq<T> expectedAnswer) {
        this.checkAnswer((Function0<DataFrame>)new Serializable(this, ds){
            public static final long serialVersionUID = 0L;
            private final Dataset ds$1;

            public final DataFrame apply() {
                return this.ds$1.toDF();
            }
            {
                this.ds$1 = ds$1;
            }
        }, (Seq<Row>)Predef$.MODULE$.refArrayOps((Object[])this.sqlContext().createDataset(expectedAnswer, (Encoder)ds.unresolvedTEncoder()).toDF().collect()).toSeq());
        this.checkDecoding((Function0<Dataset<T>>)new Serializable(this, ds){
            public static final long serialVersionUID = 0L;
            private final Dataset ds$1;

            public final Dataset<T> apply() {
                return this.ds$1;
            }
            {
                this.ds$1 = ds$1;
            }
        }, expectedAnswer);
    }

    public <T> void checkDecoding(Function0<Dataset<T>> ds, Seq<T> expectedAnswer) {
        Set decoded;
        block6: {
            block5: {
                block4: {
                    try {
                        decoded = Predef$.MODULE$.genericArrayOps(((Dataset)ds.apply()).collect()).toSet();
                    }
                    catch (Exception exception) {
                        throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |Exception collecting dataset as objects\n             |", "\n             |", "\n             |", "\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Dataset)ds.apply()).resolvedTEncoder(), ((Dataset)ds.apply()).resolvedTEncoder().fromRowExpression().treeString(), ((Dataset)ds.apply()).queryExecution()})))).stripMargin(), exception);
                    }
                    boolean isArray = BoxesRunTime.unboxToBoolean((Object)decoded.headOption().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(T x$2) {
                            return x$2.getClass().isArray();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return false;
                        }
                    }));
                    if (!isArray) break block4;
                    Set set = this.expectedAsSeq$1(expectedAnswer);
                    Set set2 = this.decodedAsSeq$1(decoded);
                    if (!(set == null ? set2 != null : !set.equals(set2))) break block5;
                }
                if (!this.normalEquality$1(expectedAnswer, decoded)) break block6;
            }
            return;
        }
        Seq expected2 = (Seq)((SeqLike)expectedAnswer.toSet().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object a) {
                return a.toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
        Seq actual = (Seq)((SeqLike)decoded.toSet().toSeq().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object a) {
                return a.toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
        String string = "expected";
        String string2 = "spark";
        String comparision = package$.MODULE$.sideBySide((Seq)expected2.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom()), (Seq)actual.$plus$colon((Object)string2, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decoded objects do not match expected objects:\n            |", "\n            |", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{comparision, ((Dataset)ds.apply()).resolvedTEncoder().fromRowExpression().treeString()})))).stripMargin());
    }

    public void checkAnswer(Function0<DataFrame> df2, Seq<Row> expectedAnswer) {
        Option<String> option;
        try {
            DataFrame analyzedDF = (DataFrame)df2.apply();
            this.checkJsonFormat(analyzedDF);
            option = QueryTest$.MODULE$.checkAnswer(analyzedDF, expectedAnswer);
        }
        catch (AnalysisException analysisException) {
            boolean currentValue = this.sqlContext().conf().dataFrameEagerAnalysis();
            this.sqlContext().setConf(SQLConf$.MODULE$.DATAFRAME_EAGER_ANALYSIS(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            LogicalPlan partiallyAnalzyedPlan = ((DataFrame)df2.apply()).queryExecution().analyzed();
            this.sqlContext().setConf(SQLConf$.MODULE$.DATAFRAME_EAGER_ANALYSIS(), (Object)BoxesRunTime.boxToBoolean((boolean)currentValue));
            throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |Failed to analyze query: ", "\n             |", "\n             |\n             |", "\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analysisException, partiallyAnalzyedPlan, package$.MODULE$.stackTraceToString((Throwable)analysisException)})))).stripMargin());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String errorMessage = (String)some.x();
            throw this.fail(errorMessage);
        }
        None$ none$ = None$.MODULE$;
        Option<String> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError(option);
    }

    public void checkAnswer(Function0<DataFrame> df2, Row expectedAnswer) {
        this.checkAnswer(df2, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{expectedAnswer}))));
    }

    public void checkAnswer(Function0<DataFrame> df2, DataFrame expectedAnswer) {
        this.checkAnswer(df2, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expectedAnswer.collect()));
    }

    public void checkAggregatesWithTol(DataFrame dataFrame, Seq<Row> expectedAnswer, double absTol) {
        Row[] actualAnswer = dataFrame.collect();
        Predef$.MODULE$.require(actualAnswer.length == expectedAnswer.length(), (Function0)new Serializable(this, expectedAnswer, actualAnswer){
            public static final long serialVersionUID = 0L;
            private final Seq expectedAnswer$1;
            private final Row[] actualAnswer$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"actual num rows ", " != expected num of rows ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.actualAnswer$1.length), BoxesRunTime.boxToInteger((int)this.expectedAnswer$1.length())}));
            }
            {
                this.expectedAnswer$1 = expectedAnswer$1;
                this.actualAnswer$1 = actualAnswer$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])actualAnswer).zip(expectedAnswer, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, absTol){
            public static final long serialVersionUID = 0L;
            private final double absTol$1;

            public final void apply(Tuple2<Row, Row> x0$1) {
                Tuple2<Row, Row> tuple2 = x0$1;
                if (tuple2 != null) {
                    Row actualRow = (Row)tuple2._1();
                    Row expectedRow = (Row)tuple2._2();
                    QueryTest$.MODULE$.checkAggregatesWithTol(actualRow, expectedRow, this.absTol$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.absTol$1 = absTol$1;
            }
        });
    }

    public void checkAggregatesWithTol(DataFrame dataFrame, Row expectedAnswer, double absTol) {
        this.checkAggregatesWithTol(dataFrame, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{expectedAnswer}))), absTol);
    }

    public void assertCached(Queryable query, int numCachedTables) {
        Seq cachedData;
        LogicalPlan planWithCaching = query.queryExecution().withCachedData();
        Seq $org_scalatest_assert_macro_left = cachedData = planWithCaching.collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InMemoryRelation) {
                    InMemoryRelation inMemoryRelation = (InMemoryRelation)A1;
                    object = inMemoryRelation;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof InMemoryRelation;
                return bl;
            }
        });
        int $org_scalatest_assert_macro_right = numCachedTables;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (long)$org_scalatest_assert_macro_left.size(), (long)$org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected query to contain ", ", but it actually had ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numCachedTables), BoxesRunTime.boxToInteger((int)cachedData.size())}))).append((Object)planWithCaching).toString());
    }

    public int assertCached$default$2() {
        return 1;
    }

    private void checkJsonFormat(DataFrame df2) {
        NonLocalReturnControl nonLocalReturnControl2;
        block9: {
            Object object = new Object();
            try {
                LogicalPlan jsonBackPlan;
                String jsonString;
                LogicalPlan logicalPlan = df2.queryExecution().analyzed();
                ((QueryPlan)logicalPlan.transform((PartialFunction)new Serializable(this, object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey1$1;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        A1 A1 = x2;
                        if (A1 instanceof MapPartitions) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        if (A1 instanceof MapGroups) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        if (A1 instanceof AppendColumns) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        if (A1 instanceof CoGroup) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        if (A1 instanceof LogicalRelation) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        Object object = function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan = x2;
                        boolean bl = logicalPlan instanceof MapPartitions ? true : (logicalPlan instanceof MapGroups ? true : (logicalPlan instanceof AppendColumns ? true : (logicalPlan instanceof CoGroup ? true : logicalPlan instanceof LogicalRelation)));
                        return bl;
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                })).transformAllExpressions((PartialFunction)new Serializable(this, object){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey1$1;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        A1 A1 = x3;
                        if (A1 instanceof ImperativeAggregate) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                        Object object = function1.apply(x3);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Expression x3) {
                        Expression expression = x3;
                        boolean bl = expression instanceof ImperativeAggregate;
                        return bl;
                    }
                    {
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                if (((Object)((Object)this)).getClass().getName().startsWith("org.apache.spark.sql.hive")) {
                    return;
                }
                try {
                    jsonString = logicalPlan.toJSON();
                }
                catch (Throwable throwable) {
                    throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |Failed to parse logical plan to JSON:\n             |", "\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalPlan.treeString()})))).stripMargin(), throwable);
                }
                LogicalPlan normalized1 = (LogicalPlan)logicalPlan.transformAllExpressions((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x4;
                        if (A1 instanceof ScalaUDF) {
                            ScalaUDF scalaUDF = (ScalaUDF)A1;
                            object = scalaUDF.copy(null, scalaUDF.copy$default$2(), scalaUDF.copy$default$3(), scalaUDF.copy$default$4());
                        } else if (A1 instanceof UserDefinedGenerator) {
                            UserDefinedGenerator userDefinedGenerator = (UserDefinedGenerator)A1;
                            Object x$12 = null;
                            Seq x$13 = userDefinedGenerator.copy$default$1();
                            Seq x$14 = userDefinedGenerator.copy$default$3();
                            object = userDefinedGenerator.copy(x$13, null, x$14);
                        } else {
                            object = function1.apply(x4);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Expression x4) {
                        Expression expression = x4;
                        boolean bl = expression instanceof ScalaUDF ? true : expression instanceof UserDefinedGenerator;
                        return bl;
                    }
                });
                ObjectRef logicalRDDs = new ObjectRef((Object)logicalPlan.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x5;
                        if (A1 instanceof LogicalRDD) {
                            LogicalRDD logicalRDD = (LogicalRDD)A1;
                            object = logicalRDD;
                        } else {
                            object = function1.apply(x5);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x5) {
                        LogicalPlan logicalPlan = x5;
                        boolean bl = logicalPlan instanceof LogicalRDD;
                        return bl;
                    }
                }));
                ObjectRef localRelations = new ObjectRef((Object)logicalPlan.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x6;
                        if (A1 instanceof LocalRelation) {
                            LocalRelation localRelation = (LocalRelation)A1;
                            object = localRelation;
                        } else {
                            object = function1.apply(x6);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x6) {
                        LogicalPlan logicalPlan = x6;
                        boolean bl = logicalPlan instanceof LocalRelation;
                        return bl;
                    }
                }));
                ObjectRef inMemoryRelations = new ObjectRef((Object)logicalPlan.collect((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x7;
                        if (A1 instanceof InMemoryRelation) {
                            InMemoryRelation inMemoryRelation = (InMemoryRelation)A1;
                            object = inMemoryRelation;
                        } else {
                            object = function1.apply(x7);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x7) {
                        LogicalPlan logicalPlan = x7;
                        boolean bl = logicalPlan instanceof InMemoryRelation;
                        return bl;
                    }
                }));
                try {
                    jsonBackPlan = (LogicalPlan)TreeNode$.MODULE$.fromJSON(jsonString, this.sqlContext().sparkContext());
                }
                catch (Throwable throwable) {
                    throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |Failed to rebuild the logical plan from JSON:\n             |", "\n             |\n             |", "\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalPlan.treeString(), logicalPlan.prettyJson()})))).stripMargin(), throwable);
                }
                LogicalPlan normalized2 = (LogicalPlan)jsonBackPlan.transformDown((PartialFunction)new Serializable(this, logicalRDDs, localRelations, inMemoryRelations){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ QueryTest $outer;
                    private final ObjectRef logicalRDDs$1;
                    private final ObjectRef localRelations$1;
                    private final ObjectRef inMemoryRelations$1;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x8;
                        if (A1 instanceof LogicalRDD) {
                            LogicalRDD logicalRDD = (LogicalRDD)A1;
                            LogicalRDD origin = (LogicalRDD)((Seq)this.logicalRDDs$1.elem).head();
                            this.logicalRDDs$1.elem = (Seq)((Seq)this.logicalRDDs$1.elem).drop(1);
                            object = new LogicalRDD(logicalRDD.output(), origin.rdd(), this.$outer.sqlContext());
                        } else if (A1 instanceof LocalRelation) {
                            LocalRelation localRelation = (LocalRelation)A1;
                            LocalRelation origin = (LocalRelation)((Seq)this.localRelations$1.elem).head();
                            this.localRelations$1.elem = (Seq)((Seq)this.localRelations$1.elem).drop(1);
                            Seq x$15 = origin.data();
                            Seq x$16 = localRelation.copy$default$1();
                            object = localRelation.copy(x$16, x$15);
                        } else if (A1 instanceof InMemoryRelation) {
                            InMemoryRelation inMemoryRelation = (InMemoryRelation)A1;
                            InMemoryRelation origin = (InMemoryRelation)((Seq)this.inMemoryRelations$1.elem).head();
                            this.inMemoryRelations$1.elem = (Seq)((Seq)this.inMemoryRelations$1.elem).drop(1);
                            object = new InMemoryRelation(inMemoryRelation.output(), inMemoryRelation.useCompression(), inMemoryRelation.batchSize(), inMemoryRelation.storageLevel(), origin.child(), inMemoryRelation.tableName(), origin.cachedColumnBuffers(), inMemoryRelation._statistics(), origin._batchStats());
                        } else {
                            object = function1.apply(x8);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x8) {
                        LogicalPlan logicalPlan = x8;
                        boolean bl = logicalPlan instanceof LogicalRDD ? true : (logicalPlan instanceof LocalRelation ? true : logicalPlan instanceof InMemoryRelation);
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.logicalRDDs$1 = logicalRDDs$1;
                        this.localRelations$1 = localRelations$1;
                        this.inMemoryRelations$1 = inMemoryRelations$1;
                    }
                });
                Seq $org_scalatest_assert_macro_left = (Seq)logicalRDDs.elem;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Seq $org_scalatest_assert_macro_left2 = (Seq)localRelations.elem;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Seq $org_scalatest_assert_macro_left3 = (Seq)inMemoryRelations.elem;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                LogicalPlan logicalPlan2 = normalized1;
                LogicalPlan logicalPlan3 = normalized2;
                if (logicalPlan2 == null ? logicalPlan3 != null : !logicalPlan2.equals(logicalPlan3)) {
                    throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |== FAIL: the logical plan parsed from json does not match the original one ===\n           |", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.sideBySide(logicalPlan.treeString(), normalized2.treeString()).mkString("\n")})))).stripMargin());
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block9;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    private final boolean normalEquality$1(Seq expectedAnswer$2, Set decoded$1) {
        Set set = decoded$1;
        Set set2 = expectedAnswer$2.toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    private final Set expectedAsSeq$1(Seq expectedAnswer$2) {
        return ((TraversableOnce)expectedAnswer$2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(T x$3) {
                return Predef$.MODULE$.genericArrayOps(x$3).toSeq();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
    }

    private final Set decodedAsSeq$1(Set decoded$1) {
        return (Set)decoded$1.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(T x$4) {
                return Predef$.MODULE$.genericArrayOps(x$4).toSeq();
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public QueryTest() {
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
        Locale.setDefault(Locale.US);
    }
}

