/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010.consumer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager$;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.consumer.FetchedData;
import org.apache.spark.sql.kafka010.consumer.FetchedDataPool;
import org.apache.spark.sql.kafka010.consumer.FetchedRecord;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumer;
import org.apache.spark.sql.kafka010.consumer.InternalKafkaConsumerPool;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer$;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011McA\u0002>|\u0001u\fy\u0001\u0003\u0006\u0002*\u0001\u0011\t\u0011)A\u0005\u0003[A!\"!\u0010\u0001\u0005\u0003\u0005\u000b\u0011BA \u0011)\t\t\b\u0001B\u0001B\u0003%\u00111\u000f\u0005\u000b\u0003w\u0002!\u0011!Q\u0001\n\u0005u\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\n\u0003#\u0003\u0001\u0019!C\u0005\u0003'C\u0011\"a'\u0001\u0001\u0004%I!!(\t\u0011\u0005%\u0006\u0001)Q\u0005\u0003+C\u0011\"a+\u0001\u0001\u0004%I!a%\t\u0013\u00055\u0006\u00011A\u0005\n\u0005=\u0006\u0002CAZ\u0001\u0001\u0006K!!&\t\u0013\u0005U\u0006A1A\u0005\n\u0005]\u0006\u0002CA`\u0001\u0001\u0006I!!/\t\u0015\u0005\u0005\u0007\u00011A\u0005\u0002m\f\u0019\r\u0003\u0006\u0002R\u0002\u0001\r\u0011\"\u0001|\u0003'D\u0001\"a6\u0001A\u0003&\u0011Q\u0019\u0005\n\u0003C\u0004\u0001\u0019!C\u0005\u0003GD\u0011\"!<\u0001\u0001\u0004%I!a<\t\u0011\u0005M\b\u0001)Q\u0005\u0003KD\u0011\"a>\u0001\u0005\u0004%I!!?\t\u0011\u0005m\b\u0001)A\u0005\u0003\u001fB\u0011\"!@\u0001\u0005\u0004%I!a@\t\u0011\rU\u0003\u0001)A\u0005\u0005\u0003A\u0011ba\u0016\u0001\u0005\u0004%Ia!\u0017\t\u0011\r\u0005\u0004\u0001)A\u0005\u00077B\u0011ba\u0019\u0001\u0001\u0004%I!a%\t\u0013\r\u0015\u0004\u00011A\u0005\n\r\u001d\u0004\u0002CB6\u0001\u0001\u0006K!!&\t\u0013\r5\u0004\u00011A\u0005\n\u0005M\u0005\"CB8\u0001\u0001\u0007I\u0011BB9\u0011!\u0019)\b\u0001Q!\n\u0005U\u0005\"CB<\u0001\u0001\u0007I\u0011BAJ\u0011%\u0019I\b\u0001a\u0001\n\u0013\u0019Y\b\u0003\u0005\u0004\u0000\u0001\u0001\u000b\u0015BAK\u0011%\u0019\t\t\u0001a\u0001\n\u0013\t\u0019\nC\u0005\u0004\u0004\u0002\u0001\r\u0011\"\u0003\u0004\u0006\"A1\u0011\u0012\u0001!B\u0013\t)\nC\u0005\u0004\f\u0002\u0001\r\u0011\"\u0003\u0002\u0014\"I1Q\u0012\u0001A\u0002\u0013%1q\u0012\u0005\t\u0007'\u0003\u0001\u0015)\u0003\u0002\u0016\"91Q\u0013\u0001\u0005\u0002\r]\u0005bBBa\u0001\u0011\u000511\u0019\u0005\b\u0007\u000f\u0004A\u0011ABe\u0011\u001d\u0019Y\r\u0001C\u0001\u0007\u0013Dqa!4\u0001\t\u0003\u0019y\rC\u0004\u0004R\u0002!Iaa4\t\u000f\rM\u0007\u0001\"\u0003\u0004P\"91Q\u001b\u0001\u0005\n\r]\u0007bBBp\u0001\u0011%1\u0011\u001d\u0005\b\u0007c\u0004A\u0011BBz\u0011!\u0019i\u0010\u0001C\u0001{\u000e}\bb\u0002C\u0001\u0001\u0011%1q\u001a\u0005\b\t\u0007\u0001A\u0011\u0002C\u0003\u0011\u001d!I\u0001\u0001C\u0005\t\u0017Aq\u0001b\u0005\u0001\t\u0013!)\u0002C\u0005\u0005$\u0001\t\n\u0011\"\u0003\u0004R!9AQ\u0005\u0001\u0005\n\u0011\u001d\u0002b\u0002C#\u0001\u0011%AqI\u0004\t\u0005\u000bY\b\u0012A?\u0003\b\u00199!p\u001fE\u0001{\n%\u0001bBABy\u0011\u0005!1\u0002\u0005\n\u0005\u001ba$\u0019!C\u0001\u0003'C\u0001Ba\u0004=A\u0003%\u0011Q\u0013\u0004\u0007\u0005#a\u0004Ia\u0005\t\u0015\t\u0005\u0002I!f\u0001\n\u0003\t\u0019\n\u0003\u0006\u0003$\u0001\u0013\t\u0012)A\u0005\u0003+C!B!\nA\u0005+\u0007I\u0011AAJ\u0011)\u00119\u0003\u0011B\tB\u0003%\u0011Q\u0013\u0005\b\u0003\u0007\u0003E\u0011\u0001B\u0015\u0011%\u0011\u0019\u0004QA\u0001\n\u0003\u0011)\u0004C\u0005\u0003<\u0001\u000b\n\u0011\"\u0001\u0003>!I!1\u000b!\u0012\u0002\u0013\u0005!Q\b\u0005\n\u0005+\u0002\u0015\u0011!C!\u0005/B\u0011B!\u0018A\u0003\u0003%\tAa\u0018\t\u0013\t\u001d\u0004)!A\u0005\u0002\t%\u0004\"\u0003B:\u0001\u0006\u0005I\u0011\tB;\u0011%\u0011\u0019\tQA\u0001\n\u0003\u0011)\tC\u0005\u0003\n\u0002\u000b\t\u0011\"\u0011\u0003\f\"I!Q\u0012!\u0002\u0002\u0013\u0005#q\u0012\u0005\n\u0005#\u0003\u0015\u0011!C!\u0005';\u0011Ba&=\u0003\u0003E\tA!'\u0007\u0013\tEA(!A\t\u0002\tm\u0005bBAB%\u0012\u0005!\u0011\u0016\u0005\n\u0005\u001b\u0013\u0016\u0011!C#\u0005\u001fC\u0011Ba+S\u0003\u0003%\tI!,\t\u0013\tM&+!A\u0005\u0002\nU\u0006\"\u0003Bb%\u0006\u0005I\u0011\u0002Bc\r\u0019\u00119\r\u0010!\u0003J\"Q\u0011q\u001f-\u0003\u0016\u0004%\t!!?\t\u0015\u0005m\bL!E!\u0002\u0013\ty\u0005\u0003\u0006\u0002*a\u0013)\u001a!C\u0001\u0005\u0017D!B!4Y\u0005#\u0005\u000b\u0011BA\u0017\u0011\u001d\t\u0019\t\u0017C\u0001\u0005\u001fDq!a!Y\t\u0003\u00119\u000eC\u0005\u00034a\u000b\t\u0011\"\u0001\u0003^\"I!1\b-\u0012\u0002\u0013\u0005!1\u001d\u0005\n\u0005'B\u0016\u0013!C\u0001\u0005OD\u0011B!\u0016Y\u0003\u0003%\tEa\u0016\t\u0013\tu\u0003,!A\u0005\u0002\t}\u0003\"\u0003B41\u0006\u0005I\u0011\u0001Bv\u0011%\u0011\u0019\bWA\u0001\n\u0003\u0012)\bC\u0005\u0003\u0004b\u000b\t\u0011\"\u0001\u0003p\"I!\u0011\u0012-\u0002\u0002\u0013\u0005#1\u0012\u0005\n\u0005\u001bC\u0016\u0011!C!\u0005\u001fC\u0011B!%Y\u0003\u0003%\tEa=\b\u0013\t]H(!A\t\u0002\teh!\u0003Bdy\u0005\u0005\t\u0012\u0001B~\u0011\u001d\t\u0019i\u001bC\u0001\u0005\u007fD\u0011B!$l\u0003\u0003%)Ea$\t\u0013\t-6.!A\u0005\u0002\u000e\u0005\u0001\"\u0003BZW\u0006\u0005I\u0011QB\u0004\u0011%\u0011\u0019m[A\u0001\n\u0013\u0011)\rC\u0005\u0004\u0010q\u0012\r\u0011\"\u0003\u0004\u0012!A11\u0004\u001f!\u0002\u0013\u0019\u0019\u0002C\u0005\u0002rq\u0012\r\u0011\"\u0003\u0004\u001e!A1q\u0004\u001f!\u0002\u0013\t\u0019\bC\u0005\u0002|q\u0012\r\u0011\"\u0003\u0004\"!A11\u0005\u001f!\u0002\u0013\ti\bC\u0004\u0004&q\"\taa\n\t\u000f\r5B\b\"\u0003\u00040!I1q\n\u001f\u0012\u0002\u0013%1\u0011\u000b\u0002\u0012\u0017\u000647.\u0019#bi\u0006\u001cuN\\:v[\u0016\u0014(B\u0001?~\u0003!\u0019wN\\:v[\u0016\u0014(B\u0001@\u0000\u0003!Y\u0017MZ6baE\u0002$\u0002BA\u0001\u0003\u0007\t1a]9m\u0015\u0011\t)!a\u0002\u0002\u000bM\u0004\u0018M]6\u000b\t\u0005%\u00111B\u0001\u0007CB\f7\r[3\u000b\u0005\u00055\u0011aA8sON)\u0001!!\u0005\u0002\u001eA!\u00111CA\r\u001b\t\t)B\u0003\u0002\u0002\u0018\u0005)1oY1mC&!\u00111DA\u000b\u0005\u0019\te.\u001f*fMB!\u0011qDA\u0013\u001b\t\t\tC\u0003\u0003\u0002$\u0005\r\u0011\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005\u001d\u0012\u0011\u0005\u0002\b\u0019><w-\u001b8h\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\u0001\u0001\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\r\r|W.\\8o\u0015\u0011\t9$a\u0002\u0002\u000b-\fgm[1\n\t\u0005m\u0012\u0011\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003-Y\u0017MZ6b!\u0006\u0014\u0018-\\:\u0011\u0011\u0005\u0005\u00131JA(\u0003Kj!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0005kRLGN\u0003\u0002\u0002J\u0005!!.\u0019<b\u0013\u0011\ti%a\u0011\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002R\u0005}c\u0002BA*\u00037\u0002B!!\u0016\u0002\u00165\u0011\u0011q\u000b\u0006\u0005\u00033\nY#\u0001\u0004=e>|GOP\u0005\u0005\u0003;\n)\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\n\u0019G\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003;\n)\u0002\u0005\u0003\u0002h\u00055TBAA5\u0015\u0011\tY'a\u0012\u0002\t1\fgnZ\u0005\u0005\u0003_\nIG\u0001\u0004PE*,7\r^\u0001\rG>t7/^7feB{w\u000e\u001c\t\u0005\u0003k\n9(D\u0001|\u0013\r\tIh\u001f\u0002\u001a\u0013:$XM\u001d8bY.\u000bgm[1D_:\u001cX/\\3s!>|G.A\bgKR\u001c\u0007.\u001a3ECR\f\u0007k\\8m!\u0011\t)(a \n\u0007\u0005\u00055PA\bGKR\u001c\u0007.\u001a3ECR\f\u0007k\\8m\u0003\u0019a\u0014N\\5u}QQ\u0011qQAE\u0003\u0017\u000bi)a$\u0011\u0007\u0005U\u0004\u0001C\u0004\u0002*\u0015\u0001\r!!\f\t\u000f\u0005uR\u00011\u0001\u0002@!9\u0011\u0011O\u0003A\u0002\u0005M\u0004bBA>\u000b\u0001\u0007\u0011QP\u0001\u0011_\u001a47/\u001a;PkR|eMU1oO\u0016,\"!!&\u0011\t\u0005M\u0011qS\u0005\u0005\u00033\u000b)B\u0001\u0003M_:<\u0017\u0001F8gMN,GoT;u\u001f\u001a\u0014\u0016M\\4f?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0006\u0015\u0006\u0003BA\n\u0003CKA!a)\u0002\u0016\t!QK\\5u\u0011%\t9kBA\u0001\u0002\u0004\t)*A\u0002yIE\n\u0011c\u001c4gg\u0016$x*\u001e;PMJ\u000bgnZ3!\u0003!!\u0017\r^1M_N\u001c\u0018\u0001\u00043bi\u0006dun]:`I\u0015\fH\u0003BAP\u0003cC\u0011\"a*\u000b\u0003\u0003\u0005\r!!&\u0002\u0013\u0011\fG/\u0019'pgN\u0004\u0013AF5t)>\\WM\u001c)s_ZLG-\u001a:F]\u0006\u0014G.\u001a3\u0016\u0005\u0005e\u0006\u0003BA\n\u0003wKA!!0\u0002\u0016\t9!i\\8mK\u0006t\u0017aF5t)>\\WM\u001c)s_ZLG-\u001a:F]\u0006\u0014G.\u001a3!\u0003%y6m\u001c8tk6,'/\u0006\u0002\u0002FB1\u00111CAd\u0003\u0017LA!!3\u0002\u0016\t1q\n\u001d;j_:\u0004B!!\u001e\u0002N&\u0019\u0011qZ>\u0003+%sG/\u001a:oC2\\\u0015MZ6b\u0007>t7/^7fe\u0006iqlY8ogVlWM]0%KF$B!a(\u0002V\"I\u0011qU\b\u0002\u0002\u0003\u0007\u0011QY\u0001\u000b?\u000e|gn];nKJ\u0004\u0003f\u0001\t\u0002\\B!\u00111CAo\u0013\u0011\ty.!\u0006\u0003\u0011Y|G.\u0019;jY\u0016\fAb\u00184fi\u000eDW\r\u001a#bi\u0006,\"!!:\u0011\r\u0005M\u0011qYAt!\u0011\t)(!;\n\u0007\u0005-8PA\u0006GKR\u001c\u0007.\u001a3ECR\f\u0017\u0001E0gKR\u001c\u0007.\u001a3ECR\fw\fJ3r)\u0011\ty*!=\t\u0013\u0005\u001d&#!AA\u0002\u0005\u0015\u0018!D0gKR\u001c\u0007.\u001a3ECR\f\u0007\u0005K\u0002\u0014\u00037\fqa\u001a:pkBLE-\u0006\u0002\u0002P\u0005AqM]8va&#\u0007%\u0001\u0005dC\u000eDWmS3z+\t\u0011\t\u0001E\u0002\u0003\u0004as1!!\u001e<\u0003EY\u0015MZ6b\t\u0006$\u0018mQ8ogVlWM\u001d\t\u0004\u0003kb4#\u0002\u001f\u0002\u0012\u0005uAC\u0001B\u0004\u00039)fj\u0013(P/:{vJ\u0012$T\u000bR\u000bq\"\u0016(L\u001d>;fjX(G\rN+E\u000b\t\u0002\u0015\u0003Z\f\u0017\u000e\\1cY\u0016|eMZ:fiJ\u000bgnZ3\u0014\u000f\u0001\u000b\tB!\u0006\u0003\u001cA!\u00111\u0003B\f\u0013\u0011\u0011I\"!\u0006\u0003\u000fA\u0013x\u000eZ;diB!\u00111\u0003B\u000f\u0013\u0011\u0011y\"!\u0006\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0011\u0015\f'\u000f\\5fgR\f\u0011\"Z1sY&,7\u000f\u001e\u0011\u0002\r1\fG/Z:u\u0003\u001da\u0017\r^3ti\u0002\"bAa\u000b\u00030\tE\u0002c\u0001B\u0017\u00016\tA\bC\u0004\u0003\"\u0015\u0003\r!!&\t\u000f\t\u0015R\t1\u0001\u0002\u0016\u0006!1m\u001c9z)\u0019\u0011YCa\u000e\u0003:!I!\u0011\u0005$\u0011\u0002\u0003\u0007\u0011Q\u0013\u0005\n\u0005K1\u0005\u0013!a\u0001\u0003+\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003@)\"\u0011Q\u0013B!W\t\u0011\u0019\u0005\u0005\u0003\u0003F\t=SB\u0001B$\u0015\u0011\u0011IEa\u0013\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002B'\u0003+\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tFa\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011I\u0006\u0005\u0003\u0002h\tm\u0013\u0002BA1\u0003S\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u0019\u0011\t\u0005M!1M\u0005\u0005\u0005K\n)BA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003l\tE\u0004\u0003BA\n\u0005[JAAa\u001c\u0002\u0016\t\u0019\u0011I\\=\t\u0013\u0005\u001d6*!AA\u0002\t\u0005\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t]\u0004C\u0002B=\u0005\u007f\u0012Y'\u0004\u0002\u0003|)!!QPA\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0003\u0013YH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA]\u0005\u000fC\u0011\"a*N\u0003\u0003\u0005\rAa\u001b\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u0019\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u0017\u0002\r\u0015\fX/\u00197t)\u0011\tIL!&\t\u0013\u0005\u001d\u0006+!AA\u0002\t-\u0014\u0001F!wC&d\u0017M\u00197f\u001f\u001a47/\u001a;SC:<W\rE\u0002\u0003.I\u001bRA\u0015BO\u00057\u0001\"Ba(\u0003&\u0006U\u0015Q\u0013B\u0016\u001b\t\u0011\tK\u0003\u0003\u0003$\u0006U\u0011a\u0002:v]RLW.Z\u0005\u0005\u0005O\u0013\tKA\tBEN$(/Y2u\rVt7\r^5p]J\"\"A!'\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t-\"q\u0016BY\u0011\u001d\u0011\t#\u0016a\u0001\u0003+CqA!\nV\u0001\u0004\t)*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t]&q\u0018\t\u0007\u0003'\t9M!/\u0011\u0011\u0005M!1XAK\u0003+KAA!0\u0002\u0016\t1A+\u001e9mKJB\u0011B!1W\u0003\u0003\u0005\rAa\u000b\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAA3\u0005!\u0019\u0015m\u00195f\u0017\u0016L8c\u0002-\u0002\u0012\tU!1D\u000b\u0003\u0003[\tq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\t\u000b\u0007\u0005#\u0014\u0019N!6\u0011\u0007\t5\u0002\fC\u0004\u0002xv\u0003\r!a\u0014\t\u000f\u0005%R\f1\u0001\u0002.Q1!\u0011\u001bBm\u00057Dq!!\u000b_\u0001\u0004\ti\u0003C\u0004\u0002>y\u0003\r!a\u0010\u0015\r\tE'q\u001cBq\u0011%\t9p\u0018I\u0001\u0002\u0004\ty\u0005C\u0005\u0002*}\u0003\n\u00111\u0001\u0002.U\u0011!Q\u001d\u0016\u0005\u0003\u001f\u0012\t%\u0006\u0002\u0003j*\"\u0011Q\u0006B!)\u0011\u0011YG!<\t\u0013\u0005\u001dF-!AA\u0002\t\u0005D\u0003BA]\u0005cD\u0011\"a*g\u0003\u0003\u0005\rAa\u001b\u0015\t\u0005e&Q\u001f\u0005\n\u0003OK\u0017\u0011!a\u0001\u0005W\n\u0001bQ1dQ\u0016\\U-\u001f\t\u0004\u0005[Y7#B6\u0003~\nm\u0001C\u0003BP\u0005K\u000by%!\f\u0003RR\u0011!\u0011 \u000b\u0007\u0005#\u001c\u0019a!\u0002\t\u000f\u0005]h\u000e1\u0001\u0002P!9\u0011\u0011\u00068A\u0002\u00055B\u0003BB\u0005\u0007\u001b\u0001b!a\u0005\u0002H\u000e-\u0001\u0003CA\n\u0005w\u000by%!\f\t\u0013\t\u0005w.!AA\u0002\tE\u0017!C:qCJ\\7i\u001c8g+\t\u0019\u0019\u0002\u0005\u0003\u0004\u0016\r]QBAA\u0002\u0013\u0011\u0019I\"a\u0001\u0003\u0013M\u0003\u0018M]6D_:4\u0017AC:qCJ\\7i\u001c8gAU\u0011\u00111O\u0001\u000eG>t7/^7feB{w\u000e\u001c\u0011\u0016\u0005\u0005u\u0014\u0001\u00054fi\u000eDW\r\u001a#bi\u0006\u0004vn\u001c7!\u0003\u001d\t7-];je\u0016$b!a\"\u0004*\r-\u0002bBA\u0015o\u0002\u0007\u0011Q\u0006\u0005\b\u0003{9\b\u0019AA \u0003=\u0011X\r]8si\u0012\u000bG/\u0019'pgN\u0004D\u0003CAP\u0007c\u0019)d!\u000f\t\u000f\rM\u0002\u00101\u0001\u0002:\u0006qa-Y5m\u001f:$\u0015\r^1M_N\u001c\bbBB\u001cq\u0002\u0007\u0011qJ\u0001\rM&t\u0017\r\\'fgN\fw-\u001a\u0005\n\u0007wA\b\u0013!a\u0001\u0007{\tQaY1vg\u0016\u0004Baa\u0010\u0004J9!1\u0011IB#\u001d\u0011\t)fa\u0011\n\u0005\u0005]\u0011\u0002BB$\u0003+\tq\u0001]1dW\u0006<W-\u0003\u0003\u0004L\r5#!\u0003+ie><\u0018M\u00197f\u0015\u0011\u00199%!\u0006\u00023I,\u0007o\u001c:u\t\u0006$\u0018\rT8tgB\"C-\u001a4bk2$HeM\u000b\u0003\u0007'RCa!\u0010\u0003B\u0005I1-Y2iK.+\u0017\u0010I\u0001\u000eM\u0016$8\r[3e%\u0016\u001cwN\u001d3\u0016\u0005\rm\u0003\u0003BA;\u0007;J1aa\u0018|\u000551U\r^2iK\u0012\u0014VmY8sI\u0006qa-\u001a;dQ\u0016$'+Z2pe\u0012\u0004\u0013A\u0005;pi\u0006dG+[7f%\u0016\fGMT1o_N\fa\u0003^8uC2$\u0016.\\3SK\u0006$g*\u00198pg~#S-\u001d\u000b\u0005\u0003?\u001bI\u0007C\u0005\u0002(n\t\t\u00111\u0001\u0002\u0016\u0006\u0019Bo\u001c;bYRKW.\u001a*fC\u0012t\u0015M\\8tA\u0005Aa.^7Q_2d7/\u0001\u0007ok6\u0004v\u000e\u001c7t?\u0012*\u0017\u000f\u0006\u0003\u0002 \u000eM\u0004\"CAT=\u0005\u0005\t\u0019AAK\u0003%qW/\u001c)pY2\u001c\b%\u0001\tok6\u0014VmY8sIN\u0004v\u000e\u001c7fI\u0006!b.^7SK\u000e|'\u000fZ:Q_2dW\rZ0%KF$B!a(\u0004~!I\u0011qU\u0011\u0002\u0002\u0003\u0007\u0011QS\u0001\u0012]Vl'+Z2pe\u0012\u001c\bk\u001c7mK\u0012\u0004\u0013\u0001\u0005;pi\u0006d'+Z2pe\u0012\u001c(+Z1e\u0003Q!x\u000e^1m%\u0016\u001cwN\u001d3t%\u0016\fGm\u0018\u0013fcR!\u0011qTBD\u0011%\t9\u000bJA\u0001\u0002\u0004\t)*A\tu_R\fGNU3d_J$7OU3bI\u0002\n!c\u001d;beR$\u0016.\\3ti\u0006l\u0007OT1o_\u000612\u000f^1siRKW.Z:uC6\u0004h*\u00198p?\u0012*\u0017\u000f\u0006\u0003\u0002 \u000eE\u0005\"CATO\u0005\u0005\t\u0019AAK\u0003M\u0019H/\u0019:u)&lWm\u001d;b[Bt\u0015M\\8!\u0003\r9W\r\u001e\u000b\u000b\u00073\u001b\u0019la.\u0004<\u000e}\u0006\u0003CBN\u0007G\u001b9ka*\u000e\u0005\ru%b\u0001?\u0004 *!1\u0011UA\u001b\u0003\u001d\u0019G.[3oiNLAa!*\u0004\u001e\nq1i\u001c8tk6,'OU3d_J$\u0007CBA\n\u0007S\u001bi+\u0003\u0003\u0004,\u0006U!!B!se\u0006L\b\u0003BA\n\u0007_KAa!-\u0002\u0016\t!!)\u001f;f\u0011\u001d\u0019),\u000ba\u0001\u0003+\u000baa\u001c4gg\u0016$\bbBB]S\u0001\u0007\u0011QS\u0001\fk:$\u0018\u000e\\(gMN,G\u000fC\u0004\u0004>&\u0002\r!!&\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t\u0011\u001d\u0019\u0019$\u000ba\u0001\u0003s\u000bqcZ3u\u0003Z\f\u0017\u000e\\1cY\u0016|eMZ:fiJ\u000bgnZ3\u0015\u0005\r\u0015\u0007c\u0001B\u0002\u0001\u00061r-\u001a;Ok6|eMZ:fi>+Ho\u00144SC:<W\r\u0006\u0002\u0002\u0016\u0006qq-\u001a;Ok6$\u0015\r^1M_N\u001c\u0018a\u0002:fY\u0016\f7/\u001a\u000b\u0003\u0003?\u000bqB]3mK\u0006\u001cXmQ8ogVlWM]\u0001\u0013e\u0016dW-Y:f\r\u0016$8\r[3e\t\u0006$\u0018-A\u0011hKR,\u0015M\u001d7jKN$\u0018I^1jY\u0006\u0014G.Z(gMN,GOQ3uo\u0016,g\u000e\u0006\u0005\u0002\u0016\u000ee71\\Bo\u0011\u0019a\b\u00071\u0001\u0002L\"91Q\u0017\u0019A\u0002\u0005U\u0005bBB]a\u0001\u0007\u0011QS\u0001\fM\u0016$8\r\u001b*fG>\u0014H\r\u0006\b\u0004\\\r\r8Q]Bu\u0007W\u001cioa<\t\rq\f\u0004\u0019AAf\u0011\u001d\u00199/\ra\u0001\u0003O\f1BZ3uG\",G\rR1uC\"91QW\u0019A\u0002\u0005U\u0005bBB]c\u0001\u0007\u0011Q\u0013\u0005\b\u0007{\u000b\u0004\u0019AAK\u0011\u001d\u0019\u0019$\ra\u0001\u0003s\u000b\u0011BZ3uG\"$\u0015\r^1\u0015\u0015\u0005}5Q_B|\u0007s\u001cY\u0010\u0003\u0004}e\u0001\u0007\u00111\u001a\u0005\b\u0007O\u0014\u0004\u0019AAt\u0011\u001d\u0019)L\ra\u0001\u0003+Cqa!03\u0001\u0004\t)*A\u000bhKR|%OU3ue&,g/Z\"p]N,X.\u001a:\u0015\u0005\u0005-\u0017\u0001\u0005:fiJLWM^3D_:\u001cX/\\3s\u0003a9W\r^(s%\u0016$(/[3wK\u001a+Go\u00195fI\u0012\u000bG/\u0019\u000b\u0005\u0003O$9\u0001C\u0004\u00046V\u0002\r!!&\u0002#\u0005$G-\u001b;j_:\fG.T3tg\u0006<W\r\u0006\u0005\u0002P\u00115Aq\u0002C\t\u0011\u001d\tIC\u000ea\u0001\u0003[Aq!a>7\u0001\u0004\ty\u0005C\u0004\u00044Y\u0002\r!!/\u0002\u001dI,\u0007o\u001c:u\t\u0006$\u0018\rT8tgRa\u0011q\u0014C\f\t3!Y\u0002\"\b\u0005\"!9\u0011\u0011F\u001cA\u0002\u00055\u0002bBA|o\u0001\u0007\u0011q\n\u0005\b\u0007g9\u0004\u0019AA]\u0011\u001d!yb\u000ea\u0001\u0003\u001f\nq!\\3tg\u0006<W\rC\u0005\u0004<]\u0002\n\u00111\u0001\u0004>\u0005A\"/\u001a9peR$\u0015\r^1M_N\u001cH\u0005Z3gCVdG\u000fJ\u001b\u00029I,h.\u00168j]R,'O];qi&\u0014G._%g!>\u001c8/\u001b2mKV!A\u0011\u0006C\u0018)\u0011!Y\u0003b\u000f\u0011\t\u00115Bq\u0006\u0007\u0001\t\u001d!\t$\u000fb\u0001\tg\u0011\u0011\u0001V\t\u0005\tk\u0011Y\u0007\u0005\u0003\u0002\u0014\u0011]\u0012\u0002\u0002C\u001d\u0003+\u0011qAT8uQ&tw\r\u0003\u0005\u0005>e\"\t\u0019\u0001C \u0003\u0011\u0011w\u000eZ=\u0011\r\u0005MA\u0011\tC\u0016\u0013\u0011!\u0019%!\u0006\u0003\u0011q\u0012\u0017P\\1nKz\n\u0011\u0002^5nK:\u000bgn\\:\u0016\t\u0011%CQ\n\u000b\u0005\t\u0017\"y\u0005\u0005\u0003\u0005.\u00115Ca\u0002C\u0019u\t\u0007A1\u0007\u0005\t\t{QD\u00111\u0001\u0005RA1\u00111\u0003C!\t\u0017\u0002")
public class KafkaDataConsumer
implements Logging {
    private final TopicPartition topicPartition;
    private final Map<String, Object> kafkaParams;
    private final InternalKafkaConsumerPool consumerPool;
    private final FetchedDataPool fetchedDataPool;
    private long offsetOutOfRange;
    private long dataLoss;
    private final boolean isTokenProviderEnabled;
    private volatile Option<InternalKafkaConsumer> _consumer;
    private volatile Option<FetchedData> _fetchedData;
    private final String groupId;
    private final CacheKey cacheKey;
    private final FetchedRecord fetchedRecord;
    private long totalTimeReadNanos;
    private long numPolls;
    private long numRecordsPolled;
    private long totalRecordsRead;
    private long startTimestampNano;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KafkaDataConsumer acquire(TopicPartition topicPartition, Map<String, Object> map) {
        return KafkaDataConsumer$.MODULE$.acquire(topicPartition, map);
    }

    public static long UNKNOWN_OFFSET() {
        return KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long offsetOutOfRange() {
        return this.offsetOutOfRange;
    }

    private void offsetOutOfRange_$eq(long x$1) {
        this.offsetOutOfRange = x$1;
    }

    private long dataLoss() {
        return this.dataLoss;
    }

    private void dataLoss_$eq(long x$1) {
        this.dataLoss = x$1;
    }

    private boolean isTokenProviderEnabled() {
        return this.isTokenProviderEnabled;
    }

    public Option<InternalKafkaConsumer> _consumer() {
        return this._consumer;
    }

    public void _consumer_$eq(Option<InternalKafkaConsumer> x$1) {
        this._consumer = x$1;
    }

    private Option<FetchedData> _fetchedData() {
        return this._fetchedData;
    }

    private void _fetchedData_$eq(Option<FetchedData> x$1) {
        this._fetchedData = x$1;
    }

    private String groupId() {
        return this.groupId;
    }

    private CacheKey cacheKey() {
        return this.cacheKey;
    }

    private FetchedRecord fetchedRecord() {
        return this.fetchedRecord;
    }

    private long totalTimeReadNanos() {
        return this.totalTimeReadNanos;
    }

    private void totalTimeReadNanos_$eq(long x$1) {
        this.totalTimeReadNanos = x$1;
    }

    private long numPolls() {
        return this.numPolls;
    }

    private void numPolls_$eq(long x$1) {
        this.numPolls = x$1;
    }

    private long numRecordsPolled() {
        return this.numRecordsPolled;
    }

    private void numRecordsPolled_$eq(long x$1) {
        this.numRecordsPolled = x$1;
    }

    private long totalRecordsRead() {
        return this.totalRecordsRead;
    }

    private void totalRecordsRead_$eq(long x$1) {
        this.totalRecordsRead = x$1;
    }

    private long startTimestampNano() {
        return this.startTimestampNano;
    }

    private void startTimestampNano_$eq(long x$1) {
        this.startTimestampNano = x$1;
    }

    public ConsumerRecord<byte[], byte[]> get(long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        return (ConsumerRecord)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(offset < untilOffset, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("offset must always be less than untilOffset [offset: ").append(offset).append(", untilOffset: ").append(untilOffset).append("]").toString());
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            FetchedData fetchedData = this.getOrRetrieveFetchedData(offset);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Get ").append(this.groupId()).append(" ").append($this.topicPartition).append(" nextOffset ").append(fetchedData.nextOffsetInFetchedData()).append(" ").append("requested ").append(offset).toString());
            LongRef toFetchOffset = LongRef.create((long)offset);
            FetchedRecord fetchedRecord = null;
            boolean isFetchComplete = false;
            while (toFetchOffset.elem != KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET() && !isFetchComplete) {
                try {
                    fetchedRecord = this.fetchRecord(consumer, fetchedData, toFetchOffset.elem, untilOffset, pollTimeoutMs, failOnDataLoss);
                    if (fetchedRecord.record() != null) {
                        isFetchComplete = true;
                        continue;
                    }
                    toFetchOffset.elem = fetchedRecord.nextOffsetToFetch();
                    if (toFetchOffset.elem >= untilOffset) {
                        fetchedData.reset();
                        toFetchOffset.elem = KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
                        continue;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Skipped offsets [").append(offset).append(", ").append(toFetchOffset$1.elem).append("]").toString());
                }
                catch (OffsetOutOfRangeException e) {
                    this.releaseConsumer();
                    fetchedData.reset();
                    this.reportDataLoss($this.topicPartition, this.groupId(), failOnDataLoss, new StringBuilder(20).append("Cannot fetch offset ").append(toFetchOffset.elem).toString(), e);
                    long oldToFetchOffsetd = toFetchOffset.elem;
                    toFetchOffset.elem = this.getEarliestAvailableOffsetBetween(consumer, toFetchOffset.elem, untilOffset);
                    if (toFetchOffset.elem == KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET()) {
                        this.offsetOutOfRange_$eq(this.offsetOutOfRange() + (untilOffset - oldToFetchOffsetd));
                        continue;
                    }
                    this.offsetOutOfRange_$eq(this.offsetOutOfRange() + (toFetchOffset.elem - oldToFetchOffsetd));
                }
            }
            if (isFetchComplete) {
                this.totalRecordsRead_$eq(this.totalRecordsRead() + 1L);
                return fetchedRecord.record();
            }
            fetchedData.reset();
            return null;
        });
    }

    public AvailableOffsetRange getAvailableOffsetRange() {
        return (AvailableOffsetRange)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            InternalKafkaConsumer consumer = this.getOrRetrieveConsumer();
            return (AvailableOffsetRange)this.timeNanos((Function0 & Serializable & scala.Serializable)() -> consumer.getAvailableOffsetRange());
        });
    }

    public long getNumOffsetOutOfRange() {
        return this.offsetOutOfRange();
    }

    public long getNumDataLoss() {
        return this.dataLoss();
    }

    public void release() {
        String kafkaMeta = (String)this._consumer().map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(24).append("topicPartition=").append(c.topicPartition()).append(" groupId=").append(c.groupId()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        long walTime = System.nanoTime() - this.startTimestampNano();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("From Kafka ").append(kafkaMeta).append(" read ").append(this.totalRecordsRead()).append(" records through ").append(this.numPolls()).append(" polls (polled ").append(" out ").append(this.numRecordsPolled()).append(" records), taking ").append(this.totalTimeReadNanos()).append(" nanos, during time span of ").append(walTime).append(" nanos.").toString());
        this.releaseConsumer();
        this.releaseFetchedData();
    }

    private void releaseConsumer() {
        if (this._consumer().isDefined()) {
            this.consumerPool.returnObject((InternalKafkaConsumer)this._consumer().get());
            this._consumer_$eq((Option<InternalKafkaConsumer>)None$.MODULE$);
            return;
        }
    }

    private void releaseFetchedData() {
        if (this._fetchedData().isDefined()) {
            this.fetchedDataPool.release(this.cacheKey(), (FetchedData)this._fetchedData().get());
            this._fetchedData_$eq((Option<FetchedData>)None$.MODULE$);
            return;
        }
    }

    private long getEarliestAvailableOffsetBetween(InternalKafkaConsumer consumer, long offset, long untilOffset) {
        AvailableOffsetRange range = (AvailableOffsetRange)this.timeNanos((Function0 & Serializable & scala.Serializable)() -> consumer.getAvailableOffsetRange());
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Some data may be lost. Recovering from the earliest offset: ").append(range.earliest()).toString());
        TopicPartition topicPartition = consumer.topicPartition();
        String groupId = consumer.groupId();
        if (offset >= range.latest() || range.earliest() >= untilOffset) {
            String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(untilOffset).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString())).stripMargin();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
            return KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET();
        }
        if (offset >= range.earliest()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Found a disappeared offset ").append(offset).append(". Some data may be lost ").append(this.additionalMessage(topicPartition, groupId, false)).toString());
            return offset;
        }
        String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         |The current available offset range is ").append(range).append(".\n         | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(range.earliest()).append(") will be\n         | skipped ").append(this.additionalMessage(topicPartition, groupId, false)).append("\n        ").toString())).stripMargin();
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
        return range.earliest();
    }

    private FetchedRecord fetchRecord(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        if (offset != fetchedData.nextOffsetInFetchedData()) {
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        } else if (!fetchedData.hasNext()) {
            if (offset < fetchedData.offsetAfterPoll()) {
                long nextOffsetToFetch = fetchedData.offsetAfterPoll();
                fetchedData.reset();
                return this.fetchedRecord().withRecord(null, nextOffsetToFetch);
            }
            this.fetchData(consumer, fetchedData, offset, pollTimeoutMs);
        }
        if (!fetchedData.hasNext()) {
            Predef$.MODULE$.assert(offset <= fetchedData.offsetAfterPoll(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("seek to ").append(offset).append(" and poll but the offset was reset to ").append(fetchedData.offsetAfterPoll()).toString());
            return this.fetchedRecord().withRecord(null, fetchedData.offsetAfterPoll());
        }
        ConsumerRecord<byte[], byte[]> record = fetchedData.next();
        if (record.offset() > offset) {
            Tuple2<Object, Object> tuple2 = fetchedData.availableOffsetRange();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long earliestOffset = tuple2._1$mcJ$sp();
            long earliestOffset2 = earliestOffset;
            if (earliestOffset2 <= offset) {
                fetchedData.previous();
                return this.fetchedRecord().withRecord(null, record.offset());
            }
            if (failOnDataLoss) {
                this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), true, new StringBuilder(28).append("Cannot fetch records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
                throw new IllegalStateException("reportDataLoss didn't throw an exception when 'failOnDataLoss' is true");
            }
            if (record.offset() >= untilOffset) {
                this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(untilOffset).append(")").toString(), this.reportDataLoss$default$5());
                return this.fetchedRecord().withRecord(null, untilOffset);
            }
            this.reportDataLoss(consumer.topicPartition(), consumer.groupId(), false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$5());
            return this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
        }
        if (record.offset() < offset) {
            throw new IllegalStateException(new StringBuilder(51).append("Tried to fetch ").append(offset).append(" but the returned record offset was ").append(record.offset()).toString());
        }
        return this.fetchedRecord().withRecord(record, fetchedData.nextOffsetInFetchedData());
    }

    private void fetchData(InternalKafkaConsumer consumer, FetchedData fetchedData, long offset, long pollTimeoutMs) {
        Tuple3 tuple3 = (Tuple3)this.timeNanos((Function0 & Serializable & scala.Serializable)() -> consumer.fetch(offset, pollTimeoutMs));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        List records = (List)tuple3._1();
        long offsetAfterPoll = BoxesRunTime.unboxToLong((Object)tuple3._2());
        AvailableOffsetRange range = (AvailableOffsetRange)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)records, (Object)BoxesRunTime.boxToLong((long)offsetAfterPoll), (Object)range);
        List records2 = (List)tuple32._1();
        long offsetAfterPoll2 = BoxesRunTime.unboxToLong((Object)tuple32._2());
        AvailableOffsetRange range2 = (AvailableOffsetRange)tuple32._3();
        this.numPolls_$eq(this.numPolls() + 1L);
        this.numRecordsPolled_$eq(this.numRecordsPolled() + (long)records2.size());
        fetchedData.withNewPoll(records2.listIterator(), offsetAfterPoll2, range2);
    }

    public InternalKafkaConsumer getOrRetrieveConsumer() {
        block1: {
            if (!this._consumer().isDefined()) {
                this.retrieveConsumer();
            }
            Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Consumer must be defined");
            if (!this.isTokenProviderEnabled() || !KafkaTokenUtil$.MODULE$.needTokenUpdate(((InternalKafkaConsumer)this._consumer().get()).kafkaParamsWithSecurity(), ((InternalKafkaConsumer)this._consumer().get()).clusterConfig())) break block1;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cached consumer uses an old delegation token, invalidating.");
            this.releaseConsumer();
            this.consumerPool.invalidateKey(this.cacheKey());
            this.fetchedDataPool.invalidate(this.cacheKey());
            this.retrieveConsumer();
        }
        return (InternalKafkaConsumer)this._consumer().get();
    }

    private void retrieveConsumer() {
        this._consumer_$eq((Option<InternalKafkaConsumer>)((Option)this.timeNanos((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)$this.consumerPool.borrowObject(this.cacheKey(), $this.kafkaParams)))));
        this.startTimestampNano_$eq(System.nanoTime());
        this.totalTimeReadNanos_$eq(0L);
        this.numPolls_$eq(0L);
        this.numRecordsPolled_$eq(0L);
        this.totalRecordsRead_$eq(0L);
        Predef$.MODULE$.require(this._consumer().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "borrowing consumer from pool must always succeed.");
    }

    private FetchedData getOrRetrieveFetchedData(long offset) {
        Option<FetchedData> option = this._fetchedData();
        if (None$.MODULE$.equals(option)) {
            this._fetchedData_$eq((Option<FetchedData>)Option$.MODULE$.apply((Object)this.fetchedDataPool.acquire(this.cacheKey(), offset)));
            Predef$.MODULE$.require(this._fetchedData().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "acquiring fetched data from cache must always succeed.");
            return (FetchedData)this._fetchedData().get();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            FetchedData fetchedData = (FetchedData)some.value();
            return fetchedData;
        }
        throw new MatchError(option);
    }

    private String additionalMessage(TopicPartition topicPartition, String groupId, boolean failOnDataLoss) {
        if (failOnDataLoss) {
            return new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE()).toString();
        }
        return new StringBuilder(31).append("(GroupId: ").append(groupId).append(", TopicPartition: ").append(topicPartition).append("). ").append(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE()).toString();
    }

    private void reportDataLoss(TopicPartition topicPartition, String groupId, boolean failOnDataLoss, String message, Throwable cause) {
        String finalMessage = new StringBuilder(1).append(message).append(" ").append(this.additionalMessage(topicPartition, groupId, failOnDataLoss)).toString();
        this.dataLoss_$eq(this.dataLoss() + 1L);
        KafkaDataConsumer$.MODULE$.org$apache$spark$sql$kafka010$consumer$KafkaDataConsumer$$reportDataLoss0(failOnDataLoss, finalMessage, cause);
    }

    private Throwable reportDataLoss$default$5() {
        return null;
    }

    private <T> T runUninterruptiblyIfPossible(Function0<T> body) {
        Thread thread = Thread.currentThread();
        if (thread instanceof UninterruptibleThread) {
            UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
            return (T)uninterruptibleThread.runUninterruptibly(body);
        }
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "KafkaDataConsumer is not running in UninterruptibleThread. It may hang when KafkaDataConsumer's methods are interrupted because of KAFKA-1894");
        return (T)body.apply();
    }

    private <T> T timeNanos(Function0<T> body) {
        long startTime = System.nanoTime();
        Object result = body.apply();
        this.totalTimeReadNanos_$eq(this.totalTimeReadNanos() + (System.nanoTime() - startTime));
        return (T)result;
    }

    public KafkaDataConsumer(TopicPartition topicPartition, Map<String, Object> kafkaParams, InternalKafkaConsumerPool consumerPool, FetchedDataPool fetchedDataPool) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        this.consumerPool = consumerPool;
        this.fetchedDataPool = fetchedDataPool;
        Logging.$init$((Logging)this);
        this.offsetOutOfRange = 0L;
        this.dataLoss = 0L;
        this.isTokenProviderEnabled = HadoopDelegationTokenManager$.MODULE$.isServiceEnabled(SparkEnv$.MODULE$.get().conf(), "kafka");
        this._consumer = None$.MODULE$;
        this._fetchedData = None$.MODULE$;
        this.groupId = (String)kafkaParams.get("group.id");
        this.cacheKey = new CacheKey(this.groupId(), topicPartition);
        this.fetchedRecord = new FetchedRecord(null, KafkaDataConsumer$.MODULE$.UNKNOWN_OFFSET());
        this.totalTimeReadNanos = 0L;
        this.numPolls = 0L;
        this.numRecordsPolled = 0L;
        this.totalRecordsRead = 0L;
        this.startTimestampNano = System.nanoTime();
    }

    public static class AvailableOffsetRange
    implements Product,
    scala.Serializable {
        private final long earliest;
        private final long latest;

        public long earliest() {
            return this.earliest;
        }

        public long latest() {
            return this.latest;
        }

        public AvailableOffsetRange copy(long earliest, long latest) {
            return new AvailableOffsetRange(earliest, latest);
        }

        public long copy$default$1() {
            return this.earliest();
        }

        public long copy$default$2() {
            return this.latest();
        }

        public String productPrefix() {
            return "AvailableOffsetRange";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.earliest());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.latest());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AvailableOffsetRange;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.earliest()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.latest()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AvailableOffsetRange)) return false;
            boolean bl = true;
            if (!bl) return false;
            AvailableOffsetRange availableOffsetRange = (AvailableOffsetRange)x$1;
            if (this.earliest() != availableOffsetRange.earliest()) return false;
            if (this.latest() != availableOffsetRange.latest()) return false;
            if (!availableOffsetRange.canEqual(this)) return false;
            return true;
        }

        public AvailableOffsetRange(long earliest, long latest) {
            this.earliest = earliest;
            this.latest = latest;
            Product.$init$((Product)this);
        }
    }

    public static class CacheKey
    implements Product,
    scala.Serializable {
        private final String groupId;
        private final TopicPartition topicPartition;

        public String groupId() {
            return this.groupId;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public CacheKey copy(String groupId, TopicPartition topicPartition) {
            return new CacheKey(groupId, topicPartition);
        }

        public String copy$default$1() {
            return this.groupId();
        }

        public TopicPartition copy$default$2() {
            return this.topicPartition();
        }

        public String productPrefix() {
            return "CacheKey";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.groupId();
                }
                case 1: {
                    return this.topicPartition();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CacheKey;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            CacheKey cacheKey = (CacheKey)x$1;
            String string = this.groupId();
            String string2 = cacheKey.groupId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            TopicPartition topicPartition = this.topicPartition();
            TopicPartition topicPartition2 = cacheKey.topicPartition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            if (!cacheKey.canEqual(this)) return false;
            return true;
        }

        public CacheKey(String groupId, TopicPartition topicPartition) {
            this.groupId = groupId;
            this.topicPartition = topicPartition;
            Product.$init$((Product)this);
        }

        public CacheKey(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
            this((String)kafkaParams.get("group.id"), topicPartition);
        }
    }
}

