/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.GlobalTimestampRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaSourceOffset;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$StrategyOnNoMatchStartingOffset$;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.kafka010.SpecificTimestampRangeLimit;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015g!B\u0015+\u0001)\"\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011)\u0003!Q1A\u0005B-C\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\tM\u0002\u0011\t\u0011)A\u0005O\"Aa\u000e\u0001B\u0001B\u0003%A\u000bC\u0003p\u0001\u0011\u0005\u0001\u000f\u0003\u0005w\u0001\t\u0007I\u0011\u0001\u0016x\u0011\u0019Y\b\u0001)A\u0005q\"AA\u0010\u0001b\u0001\n\u0003QS\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002@\t\u0013\u0005\u0015\u0001\u00011A\u0005\u0012\u0005\u001d\u0001\"CA\u000f\u0001\u0001\u0007I\u0011CA\u0010\u0011!\tY\u0003\u0001Q!\n\u0005%\u0001bBA\b\u0001\u0011E\u0011q\u0001\u0005\u000b\u0003k\u0001\u0001R1A\u0005\u0002\u0005]\u0002BCA#\u0001!\u0015\r\u0011\"\u0003\u0002H!9\u0011q\n\u0001\u0005\n\u0005E\u0003\"CA;\u0001\t\u0007I\u0011BA<\u0011!\ty\b\u0001Q\u0001\n\u0005e\u0004\"CAA\u0001\t\u0007I\u0011BAB\u0011!\tY\t\u0001Q\u0001\n\u0005\u0015\u0005bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\ty\n\u0001C!\u0003CCq!a)\u0001\t\u0003\n)\u000bC\u0004\u0002:\u0002!\t%a/\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\"9!1\u0002\u0001\u0005B\t5\u0001b\u0002B\f\u0001\u0011%!\u0011\u0004\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u0011\u001d\u0011y\u0005\u0001C!\u0005#BqAa\u0015\u0001\t\u0003\u0012)\u0006C\u0004\u0003P\u0001!\tEa\u001b\t\u000f\t\u0005\u0005\u0001\"\u0011\u0003\u0004\"9!Q\u0013\u0001\u0005\n\t]\u0005b\u0002BP\u0001\u0011\u0005#\u0011\u0015\u0005\b\u0005[\u0003A\u0011\u0002BX\u0011\u001d\u0011)\f\u0001C\u0005\u0005oCqA!1\u0001\t\u0013\t\t\u000bC\u0004\u0003D\u0002!I!!)\u0003--\u000bgm[1PM\u001a\u001cX\r\u001e*fC\u0012,'/\u00113nS:T!a\u000b\u0017\u0002\u0011-\fgm[11cAR!!\f\u0018\u0002\u0007M\fHN\u0003\u00020a\u0005)1\u000f]1sW*\u0011\u0011GM\u0001\u0007CB\f7\r[3\u000b\u0003M\n1a\u001c:h'\u0011\u0001QgO \u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g!\taT(D\u0001+\u0013\tq$FA\tLC\u001a\\\u0017m\u00144gg\u0016$(+Z1eKJ\u0004\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0018\u0002\u0011%tG/\u001a:oC2L!\u0001R!\u0003\u000f1{wmZ5oO\u0006\u00012m\u001c8tk6,'o\u0015;sCR,w-_\u0002\u0001!\ta\u0004*\u0003\u0002JU\t\u00012i\u001c8tk6,'o\u0015;sCR,w-_\u0001\u0012IJLg/\u001a:LC\u001a\\\u0017\rU1sC6\u001cX#\u0001'\u0011\t5\u0013FkX\u0007\u0002\u001d*\u0011q\nU\u0001\u0005kRLGNC\u0001R\u0003\u0011Q\u0017M^1\n\u0005Ms%aA'baB\u0011Q\u000b\u0018\b\u0003-j\u0003\"aV\u001c\u000e\u0003aS!!\u0017$\u0002\rq\u0012xn\u001c;?\u0013\tYv'\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013aa\u0015;sS:<'BA.8!\t\u00017-D\u0001b\u0015\t\u0011\u0007+\u0001\u0003mC:<\u0017B\u00013b\u0005\u0019y%M[3di\u0006\u0011BM]5wKJ\\\u0015MZ6b!\u0006\u0014\u0018-\\:!\u00035\u0011X-\u00193fe>\u0003H/[8ogB\u0019\u0001\u000e\u001c+\u000e\u0003%T!a\u00146\u000b\u0005-d\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u00055L'AE\"bg\u0016Len]3og&$\u0018N^3NCB\f1\u0003\u001a:jm\u0016\u0014xI]8va&#\u0007K]3gSb\fa\u0001P5oSRtD#B9sgR,\bC\u0001\u001f\u0001\u0011\u0015)e\u00011\u0001H\u0011\u0015Qe\u00011\u0001M\u0011\u00151g\u00011\u0001h\u0011\u0015qg\u00011\u0001U\u0003Yi\u0017\r_(gMN,GOR3uG\"\fE\u000f^3naR\u001cX#\u0001=\u0011\u0005YJ\u0018B\u0001>8\u0005\rIe\u000e^\u0001\u0018[\u0006DxJ\u001a4tKR4U\r^2i\u0003R$X-\u001c9ug\u0002\nAd\u001c4gg\u0016$h)\u001a;dQ\u0006#H/Z7qi&sG/\u001a:wC2l5/F\u0001\u007f!\t1t0C\u0002\u0002\u0002]\u0012A\u0001T8oO\u0006irN\u001a4tKR4U\r^2i\u0003R$X-\u001c9u\u0013:$XM\u001d<bY6\u001b\b%\u0001\u0004`C\u0012l\u0017N\\\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u001a5\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0003bI6LgN\u0003\u0003\u0002\u0014\u0005U\u0011aB2mS\u0016tGo\u001d\u0006\u0004\u0003/\u0001\u0014!B6bM.\f\u0017\u0002BA\u000e\u0003\u001b\u0011Q!\u00113nS:\f!bX1e[&tw\fJ3r)\u0011\t\t#a\n\u0011\u0007Y\n\u0019#C\u0002\u0002&]\u0012A!\u00168ji\"I\u0011\u0011\u0006\u0007\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\u0004q\u0012\n\u0014aB0bI6Lg\u000e\t\u0015\u0004\u001b\u0005=\u0002c\u0001\u001c\u00022%\u0019\u00111G\u001c\u0003\u0011Y|G.\u0019;jY\u0016\fa\"[:pY\u0006$\u0018n\u001c8MKZ,G.\u0006\u0002\u0002:A!\u00111HA!\u001b\t\tiD\u0003\u0003\u0002@\u0005U\u0011AB2p[6|g.\u0003\u0003\u0002D\u0005u\"AD%t_2\fG/[8o\u0019\u00164X\r\\\u0001\u0013Y&\u001cHo\u00144gg\u0016$8o\u00149uS>t7/\u0006\u0002\u0002JA!\u00111BA&\u0013\u0011\ti%!\u0004\u0003%1K7\u000f^(gMN,Go](qi&|gn]\u0001\fY&\u001cHo\u00144gg\u0016$8\u000f\u0006\u0004\u0002T\u0005\u001d\u0014\u0011\u000e\t\b\u0003+\ny&!\u0019\u007f\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013!C5n[V$\u0018M\u00197f\u0015\r\tifN\u0001\u000bG>dG.Z2uS>t\u0017bA*\u0002XA!\u00111HA2\u0013\u0011\t)'!\u0010\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011qB\tA\u0002\u0005%\u0001bBA6#\u0001\u0007\u0011QN\u0001\u0012Y&\u001cHo\u00144gg\u0016$8\u000fU1sC6\u001c\bCB'S\u0003C\ny\u0007\u0005\u0003\u0002\f\u0005E\u0014\u0002BA:\u0003\u001b\u0011!b\u00144gg\u0016$8\u000b]3d\u00035i\u0017N\u001c)beRLG/[8ogV\u0011\u0011\u0011\u0010\t\u0005m\u0005m\u00040C\u0002\u0002~]\u0012aa\u00149uS>t\u0017AD7j]B\u000b'\u000f^5uS>t7\u000fI\u0001\u0010e\u0006tw-Z\"bY\u000e,H.\u0019;peV\u0011\u0011Q\u0011\t\u0004y\u0005\u001d\u0015bAAEU\tQ2*\u00194lC>3gm]3u%\u0006tw-Z\"bY\u000e,H.\u0019;pe\u0006\u0001\"/\u00198hK\u000e\u000bGnY;mCR|'\u000fI\u0001\u001dg\"|W\u000f\u001c3ESZ4\u00180\u00169MCJ<W\rU1si&$\u0018n\u001c8t)\u0011\t\t*a&\u0011\u0007Y\n\u0019*C\u0002\u0002\u0016^\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\u001aZ\u0001\r\u0001_\u0001\u0013]VlGk\u001c9jGB\u000b'\u000f^5uS>t7/\u0001\u0005u_N#(/\u001b8h)\u0005!\u0016!B2m_N,GCAA\u0011\u0003U1W\r^2i!\u0006\u0014H/\u001b;j_:|eMZ:fiN$b!a*\u0002,\u0006U\u0006CB+\u0002*\u0006\u0005d0\u0003\u0002T=\"9\u0011QV\rA\u0002\u0005=\u0016\u0001E8gMN,GOU1oO\u0016d\u0015.\\5u!\ra\u0014\u0011W\u0005\u0004\u0003gS#!F&bM.\fwJ\u001a4tKR\u0014\u0016M\\4f\u0019&l\u0017\u000e\u001e\u0005\b\u0003oK\u0002\u0019AAI\u0003EI7o\u0015;beRLgnZ(gMN,Go]\u0001\u0015M\u0016$8\r[*qK\u000eLg-[2PM\u001a\u001cX\r^:\u0015\r\u0005u\u00161YAd!\ra\u0014qX\u0005\u0004\u0003\u0003T#!E&bM.\f7k\\;sG\u0016|eMZ:fi\"9\u0011Q\u0019\u000eA\u0002\u0005\u001d\u0016\u0001\u00059beRLG/[8o\u001f\u001a47/\u001a;t\u0011\u001d\tIM\u0007a\u0001\u0003\u0017\faB]3q_J$H)\u0019;b\u0019>\u001c8\u000f\u0005\u00047\u0003\u001b$\u0016\u0011E\u0005\u0004\u0003\u001f<$!\u0003$v]\u000e$\u0018n\u001c82\u0003\t2W\r^2i'B,7-\u001b4jGRKW.Z:uC6\u0004()Y:fI>3gm]3ugRA\u0011QXAk\u00033\fY\u000eC\u0004\u0002Xn\u0001\r!a*\u0002'A\f'\u000f^5uS>tG+[7fgR\fW\u000e]:\t\u000f\u0005]6\u00041\u0001\u0002\u0012\"9\u0011Q\\\u000eA\u0002\u0005}\u0017aH:ue\u0006$XmZ=P]:{W*\u0019;dQN#\u0018M\u001d;j]\u001e|eMZ:fiB!\u0011\u0011\u001dB\u0002\u001d\u0011\t\u0019/!@\u000f\t\u0005\u0015\u0018\u0011 \b\u0005\u0003O\f9P\u0004\u0003\u0002j\u0006Uh\u0002BAv\u0003gtA!!<\u0002r:\u0019q+a<\n\u0003MJ!!\r\u001a\n\u0005=\u0002\u0014BA\u0017/\u0013\tYC&C\u0002\u0002|*\n1cS1gW\u0006\u001cv.\u001e:dKB\u0013xN^5eKJLA!a@\u0003\u0002\u0005y2\u000b\u001e:bi\u0016<\u0017p\u00148O_6\u000bGo\u00195Ti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;\u000b\u0007\u0005m(&\u0003\u0003\u0003\u0006\t\u001d!!\u0002,bYV,\u0017b\u0001B\u0005o\tYQI\\;nKJ\fG/[8o\u0003\u00012W\r^2i\u000f2|'-\u00197US6,7\u000f^1na\n\u000b7/\u001a3PM\u001a\u001cX\r^:\u0015\u0011\u0005u&q\u0002B\n\u0005+AaA!\u0005\u001d\u0001\u0004q\u0018!\u0003;j[\u0016\u001cH/Y7q\u0011\u001d\t9\f\ba\u0001\u0003#Cq!!8\u001d\u0001\u0004\ty.\u0001\u000bsK\u0006$G+[7fgR\fW\u000e](gMN,Go\u001d\u000b\u000b\u0003O\u0013YBa\f\u00032\tM\u0002b\u0002B\u000f;\u0001\u0007!qD\u0001\u000eiB$vn\u00144gg\u0016$X*\u00199\u0011\u000fU\u000bI+!\u0019\u0003\"A!!1\u0005B\u0015\u001d\u0011\tYA!\n\n\t\t\u001d\u0012QB\u0001\u0012\u0019&\u001cHo\u00144gg\u0016$8OU3tk2$\u0018\u0002\u0002B\u0016\u0005[\u0011Q\u0003T5ti>3gm]3ugJ+7/\u001e7u\u0013:4wN\u0003\u0003\u0003(\u00055\u0001bBA\\;\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003;l\u0002\u0019AAp\u0011\u001d\u0011)$\ba\u0001\u0005o\tA\u0003]1si&$\u0018n\u001c8US6,7\u000f^1na\u001as\u0007C\u0002\u001c\u0002N\u0006\u0005d0A\u000bgKR\u001c\u0007n\u00159fG&4\u0017nY(gMN,Go\u001d\u0019\u0015\r\u0005u&Q\bB%\u0011\u001d\u0011yD\ba\u0001\u0005\u0003\n\u0001E\u001a8BgN,'\u000f\u001e)be\u0006lW\r^3sg^KG\u000f\u001b)beRLG/[8ogB9a'!4\u0003D\u0005\u0005\u0002#B'\u0003F\u0005\u0005\u0014b\u0001B$\u001d\n\u00191+\u001a;\t\u000f\t-c\u00041\u0001\u0003N\u0005QbM\u001c*fiJLWM^3QCJ$\u0018\u000e^5p]>3gm]3ugB9a'!4\u0003D\u0005\u001d\u0016\u0001\u00064fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$8\u000f\u0006\u0002\u0002(\u0006\u0011b-\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;t)\u0011\u00119F!\u001a\u0011\t\te#q\f\b\u0004y\tm\u0013b\u0001B/U\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B1\u0005G\u0012!\u0003U1si&$\u0018n\u001c8PM\u001a\u001cX\r^'ba*\u0019!Q\f\u0016\t\u000f\t\u001d\u0004\u00051\u0001\u0003j\u0005a1N\\8x]>3gm]3ugB)a'a\u001f\u0003XQ!\u0011q\u0015B7\u0011\u001d\u0011y'\ta\u0001\u0005c\nQB\\3x!\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B:\u0005w\n\tG\u0004\u0003\u0003v\tedbA,\u0003x%\t\u0001(C\u0002\u0003^]JAA! \u0003\u0000\t\u00191+Z9\u000b\u0007\tus'\u0001\u0013hKR|eMZ:fiJ\u000bgnZ3t\rJ|W.\u00168sKN|GN^3e\u001f\u001a47/\u001a;t)\u0019\u0011)I!$\u0003\u0012B1!1\u000fB>\u0005\u000f\u00032\u0001\u0010BE\u0013\r\u0011YI\u000b\u0002\u0011\u0017\u000647.Y(gMN,GOU1oO\u0016DqAa$#\u0001\u0004\ty+A\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;t\u0011\u001d\u0011\u0019J\ta\u0001\u0003_\u000bQ\"\u001a8eS:<wJ\u001a4tKR\u001c\u0018!F4fiN{'\u000f^3e\u000bb,7-\u001e;pe2K7\u000f^\u000b\u0003\u00053\u0003BA\u000eBN)&\u0019!QT\u001c\u0003\u000b\u0005\u0013(/Y=\u0002E\u001d,Go\u00144gg\u0016$(+\u00198hKN4%o\\7SKN|GN^3e\u001f\u001a47/\u001a;t)!\u0011)Ia)\u0003(\n-\u0006b\u0002BSI\u0001\u0007!qK\u0001\u0015MJ|W\u000eU1si&$\u0018n\u001c8PM\u001a\u001cX\r^:\t\u000f\t%F\u00051\u0001\u0003X\u0005)RO\u001c;jYB\u000b'\u000f^5uS>twJ\u001a4tKR\u001c\bbBAeI\u0001\u0007\u00111Z\u0001\u001aa\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:,G\rV8BI6Lg\u000e\u0006\u0003\u0002(\nE\u0006b\u0002BZK\u0001\u0007!QJ\u0001\u0005E>$\u00170A\u0006xSRD'+\u001a;sS\u0016\u001cH\u0003BAT\u0005sC\u0001Ba-'\t\u0003\u0007!1\u0018\t\u0006m\tu\u0016qU\u0005\u0004\u0005\u007f;$\u0001\u0003\u001fcs:\fW.\u001a \u0002\u0013M$x\u000e]!e[&t\u0017A\u0003:fg\u0016$\u0018\tZ7j]\u0002")
public class KafkaOffsetReaderAdmin
implements KafkaOffsetReader,
Logging {
    private IsolationLevel isolationLevel;
    private ListOffsetsOptions listOffsetsOptions;
    private final ConsumerStrategy consumerStrategy;
    private final java.util.Map<String, Object> driverKafkaParams;
    private final int maxOffsetFetchAttempts;
    private final long offsetFetchAttemptIntervalMs;
    private volatile Admin _admin;
    private final Option<Object> minPartitions;
    private final KafkaOffsetRangeCalculator rangeCalculator;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public java.util.Map<String, Object> driverKafkaParams() {
        return this.driverKafkaParams;
    }

    @Override
    public int maxOffsetFetchAttempts() {
        return this.maxOffsetFetchAttempts;
    }

    @Override
    public long offsetFetchAttemptIntervalMs() {
        return this.offsetFetchAttemptIntervalMs;
    }

    public Admin _admin() {
        return this._admin;
    }

    public void _admin_$eq(Admin x$1) {
        this._admin = x$1;
    }

    public synchronized Admin admin() {
        block0: {
            if (this._admin() != null) break block0;
            this._admin_$eq(this.consumerStrategy.createAdmin(this.driverKafkaParams()));
        }
        return this._admin();
    }

    private IsolationLevel isolationLevel$lzycompute() {
        KafkaOffsetReaderAdmin kafkaOffsetReaderAdmin = this;
        synchronized (kafkaOffsetReaderAdmin) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                IsolationLevel isolationLevel;
                Some some;
                Object s;
                Option option = Option$.MODULE$.apply(this.driverKafkaParams().get("isolation.level"));
                if (option instanceof Some && (s = (some = (Some)option).value()) instanceof String) {
                    String string = (String)s;
                    isolationLevel = IsolationLevel.valueOf((String)string.toUpperCase(Locale.ROOT));
                } else if (None$.MODULE$.equals(option)) {
                    isolationLevel = IsolationLevel.valueOf((String)ConsumerConfig.DEFAULT_ISOLATION_LEVEL.toUpperCase(Locale.ROOT));
                } else {
                    throw new IllegalArgumentException(new StringBuilder(62).append("isolation.level").append(" ").append("must be either not defined or with type String").toString());
                }
                this.isolationLevel = isolationLevel;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.isolationLevel;
    }

    public IsolationLevel isolationLevel() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.isolationLevel$lzycompute();
        }
        return this.isolationLevel;
    }

    private ListOffsetsOptions listOffsetsOptions$lzycompute() {
        KafkaOffsetReaderAdmin kafkaOffsetReaderAdmin = this;
        synchronized (kafkaOffsetReaderAdmin) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.listOffsetsOptions = new ListOffsetsOptions(this.isolationLevel());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.listOffsetsOptions;
    }

    private ListOffsetsOptions listOffsetsOptions() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.listOffsetsOptions$lzycompute();
        }
        return this.listOffsetsOptions;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> listOffsets(Admin admin, java.util.Map<TopicPartition, OffsetSpec> listOffsetsParams) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)admin.listOffsets(listOffsetsParams, this.listOffsetsOptions()).all().get()).asScala()).map((Function1 & Serializable & scala.Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result._1()), (Object)BoxesRunTime.boxToLong((long)((ListOffsetsResult.ListOffsetsResultInfo)result._2()).offset())), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Option<Object> minPartitions() {
        return this.minPartitions;
    }

    private KafkaOffsetRangeCalculator rangeCalculator() {
        return this.rangeCalculator;
    }

    private boolean shouldDivvyUpLargePartitions(int numTopicPartitions) {
        return BoxesRunTime.unboxToBoolean((Object)this.minPartitions().map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 > numTopicPartitions).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    public String toString() {
        return this.consumerStrategy.toString();
    }

    @Override
    public void close() {
        this.stopAdmin();
    }

    @Override
    public scala.collection.immutable.Map<TopicPartition, Object> fetchPartitionOffsets(KafkaOffsetRangeLimit offsetRangeLimit, boolean isStartingOffsets) {
        scala.collection.immutable.Set<TopicPartition> partitions = this.consumerStrategy.assignedTopicPartitions(this.admin());
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = offsetRangeLimit;
        if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            return ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TopicPartition topicPartition = x0$1;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST()));
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            return ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TopicPartition topicPartition = x0$2;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST()));
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
            SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets = specificOffsetRangeLimit.partitionOffsets();
            return this.validateTopicPartitions$1(partitions, partitionOffsets);
        }
        if (kafkaOffsetRangeLimit instanceof SpecificTimestampRangeLimit) {
            SpecificTimestampRangeLimit specificTimestampRangeLimit = (SpecificTimestampRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> partitionTimestamps = specificTimestampRangeLimit.topicTimestamps();
            Enumeration.Value strategyOnNoMatchingStartingOffset = specificTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
            return this.fetchSpecificTimestampBasedOffsets(partitionTimestamps, isStartingOffsets, strategyOnNoMatchingStartingOffset).partitionToOffsets();
        }
        if (kafkaOffsetRangeLimit instanceof GlobalTimestampRangeLimit) {
            GlobalTimestampRangeLimit globalTimestampRangeLimit = (GlobalTimestampRangeLimit)kafkaOffsetRangeLimit;
            long timestamp = globalTimestampRangeLimit.timestamp();
            Enumeration.Value strategyOnNoMatchingStartingOffset = globalTimestampRangeLimit.strategyOnNoMatchingStartingOffset();
            return this.fetchGlobalTimestampBasedOffsets(timestamp, isStartingOffsets, strategyOnNoMatchingStartingOffset).partitionToOffsets();
        }
        throw new MatchError((Object)kafkaOffsetRangeLimit);
    }

    @Override
    public KafkaSourceOffset fetchSpecificOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets, Function1<String, BoxedUnit> reportDataLoss) {
        Function1 & Serializable & scala.Serializable fnAssertParametersWithPartitions = (Function1 & Serializable & scala.Serializable)partitions -> {
            KafkaOffsetReaderAdmin.$anonfun$fetchSpecificOffsets$1(this, partitionOffsets, partitions);
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable & scala.Serializable fnRetrievePartitionOffsets = (Function1 & Serializable & scala.Serializable)x$3 -> partitionOffsets;
        return this.fetchSpecificOffsets0((Function1<Set<TopicPartition>, BoxedUnit>)fnAssertParametersWithPartitions, (Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)fnRetrievePartitionOffsets);
    }

    @Override
    public KafkaSourceOffset fetchSpecificTimestampBasedOffsets(scala.collection.immutable.Map<TopicPartition, Object> partitionTimestamps, boolean isStartingOffsets, Enumeration.Value strategyOnNoMatchStartingOffset) {
        Function1 & Serializable & scala.Serializable fnAssertParametersWithPartitions = (Function1 & Serializable & scala.Serializable)partitions -> {
            KafkaOffsetReaderAdmin.$anonfun$fetchSpecificTimestampBasedOffsets$1(this, partitionTimestamps, partitions);
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable & scala.Serializable fnRetrievePartitionOffsets = (Function1 & Serializable & scala.Serializable)x$4 -> {
            java.util.Map listOffsetsParams = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionTimestamps.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long timestamp = tuple2._2$mcJ$sp();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)OffsetSpec.forTimestamp((long)timestamp));
                }
                throw new MatchError((Object)tuple2);
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).asJava();
            return this.readTimestampOffsets((scala.collection.immutable.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.admin().listOffsets(listOffsetsParams, this.listOffsetsOptions()).all().get()).asScala()).toMap(Predef$.MODULE$.$conforms()), isStartingOffsets, strategyOnNoMatchStartingOffset, (Function1<TopicPartition, Object>)partitionTimestamps);
        };
        return this.fetchSpecificOffsets0((Function1<Set<TopicPartition>, BoxedUnit>)fnAssertParametersWithPartitions, (Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)fnRetrievePartitionOffsets);
    }

    @Override
    public KafkaSourceOffset fetchGlobalTimestampBasedOffsets(long timestamp, boolean isStartingOffsets, Enumeration.Value strategyOnNoMatchStartingOffset) {
        Function1 & Serializable & scala.Serializable fnAssertParametersWithPartitions = (Function1 & Serializable & scala.Serializable)partitions -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(timestamp$1).toString());
            return BoxedUnit.UNIT;
        };
        Function1 & Serializable & scala.Serializable fnRetrievePartitionOffsets = (Function1 & Serializable & scala.Serializable)tps -> {
            java.util.Map listOffsetsParams = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(tps).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)OffsetSpec.forTimestamp((long)timestamp)), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            return this.readTimestampOffsets((scala.collection.immutable.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.admin().listOffsets(listOffsetsParams, this.listOffsetsOptions()).all().get()).asScala()).toMap(Predef$.MODULE$.$conforms()), isStartingOffsets, strategyOnNoMatchStartingOffset, (Function1<TopicPartition, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)timestamp));
        };
        return this.fetchSpecificOffsets0((Function1<Set<TopicPartition>, BoxedUnit>)fnAssertParametersWithPartitions, (Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)fnRetrievePartitionOffsets);
    }

    private scala.collection.immutable.Map<TopicPartition, Object> readTimestampOffsets(scala.collection.immutable.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> tpToOffsetMap, boolean isStartingOffsets, Enumeration.Value strategyOnNoMatchStartingOffset, Function1<TopicPartition, Object> partitionTimestampFn) {
        return ((scala.collection.immutable.Map)tpToOffsetMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            long l;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            TopicPartition tp = (TopicPartition)tuple2._1();
            ListOffsetsResult.ListOffsetsResultInfo offsetSpec = (ListOffsetsResult.ListOffsetsResultInfo)tuple2._2();
            if (offsetSpec.offset() == -1L) {
                if (isStartingOffsets) {
                    Enumeration.Value value = strategyOnNoMatchStartingOffset;
                    Enumeration.Value value2 = KafkaSourceProvider$StrategyOnNoMatchStartingOffset$.MODULE$.ERROR();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        throw new IllegalArgumentException(new StringBuilder(66).append("No offset ").append("matched from request of topic-partition ").append(tp).append(" and timestamp ").append(partitionTimestampFn.apply((Object)tp)).append(".").toString());
                    }
                    Enumeration.Value value4 = KafkaSourceProvider$StrategyOnNoMatchStartingOffset$.MODULE$.LATEST();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) throw new MatchError((Object)value);
                    l = KafkaOffsetRangeLimit$.MODULE$.LATEST();
                } else {
                    l = KafkaOffsetRangeLimit$.MODULE$.LATEST();
                }
            } else {
                l = offsetSpec.offset();
            }
            long offset = l;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)offset));
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private KafkaSourceOffset fetchSpecificOffsets0(Function1<Set<TopicPartition>, BoxedUnit> fnAssertParametersWithPartitions, Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>> fnRetrievePartitionOffsets) {
        scala.collection.immutable.Map<TopicPartition, Object> fetched = this.partitionsAssignedToAdmin((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            fnAssertParametersWithPartitions.apply(partitions);
            scala.collection.immutable.Map partitionOffsets = (scala.collection.immutable.Map)fnRetrievePartitionOffsets.apply(partitions);
            scala.collection.immutable.Map listOffsetsParams = (scala.collection.immutable.Map)((TraversableLike)partitionOffsets.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetReaderAdmin.$anonfun$fetchSpecificOffsets0$2(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    long off;
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long l = off = tuple2._2$mcJ$sp();
                    if (KafkaOffsetRangeLimit$.MODULE$.LATEST() == l) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)OffsetSpec.latest());
                    }
                    if (KafkaOffsetRangeLimit$.MODULE$.EARLIEST() == l) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)OffsetSpec.earliest());
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToLong((long)l));
                }
                throw new MatchError((Object)tuple2);
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            scala.collection.immutable.Map<TopicPartition, Object> resolvedPartitionOffsets = this.listOffsets(this.admin(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)listOffsetsParams).asJava());
            return (scala.collection.immutable.Map)partitionOffsets.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    long off;
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long l = off = tuple2._2$mcJ$sp();
                    if (KafkaOffsetRangeLimit$.MODULE$.LATEST() == l) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), resolvedPartitionOffsets.apply((Object)tp));
                    }
                    if (KafkaOffsetRangeLimit$.MODULE$.EARLIEST() == l) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), resolvedPartitionOffsets.apply((Object)tp));
                    }
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)off));
                }
                throw new MatchError((Object)tuple2);
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        });
        return new KafkaSourceOffset(fetched);
    }

    @Override
    public scala.collection.immutable.Map<TopicPartition, Object> fetchEarliestOffsets() {
        return this.partitionsAssignedToAdmin((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            java.util.Map listOffsetsParams = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p), (Object)OffsetSpec.earliest()), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets = this.listOffsets(this.admin(), listOffsetsParams);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Got earliest offsets for partitions: ").append(partitionOffsets).toString());
            return partitionOffsets;
        });
    }

    @Override
    public scala.collection.immutable.Map<TopicPartition, Object> fetchLatestOffsets(Option<scala.collection.immutable.Map<TopicPartition, Object>> knownOffsets) {
        return this.partitionsAssignedToAdmin((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            java.util.Map listOffsetsParams = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), (Object)OffsetSpec.latest()), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            if (knownOffsets.isEmpty()) {
                scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets = this.listOffsets(this.admin(), listOffsetsParams);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Got latest offsets for partitions: ").append(partitionOffsets).toString());
                return partitionOffsets;
            }
            ObjectRef partitionOffsets = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
            ObjectRef incorrectOffsets = ObjectRef.create((Object)Nil$.MODULE$);
            int attempt = 0;
            do {
                partitionOffsets.elem = this.listOffsets(this.admin(), listOffsetsParams);
                ++attempt;
                incorrectOffsets.elem = KafkaOffsetReaderAdmin.findIncorrectOffsets$1(partitionOffsets, knownOffsets);
                if (!((Seq)incorrectOffsets.elem).nonEmpty()) continue;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Found incorrect offsets in some partitions ").append("(partition, previous offset, fetched offset): ").append((Seq)incorrectOffsets$2.elem).toString());
                if (attempt >= this.maxOffsetFetchAttempts()) continue;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Retrying to fetch latest offsets because of incorrect offsets");
                Thread.sleep(this.offsetFetchAttemptIntervalMs());
            } while (((Seq)incorrectOffsets.elem).nonEmpty() && attempt < this.maxOffsetFetchAttempts());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Got latest offsets for partitions: ").append((scala.collection.immutable.Map)partitionOffsets$5.elem).toString());
            return (scala.collection.immutable.Map)partitionOffsets.elem;
        });
    }

    @Override
    public scala.collection.immutable.Map<TopicPartition, Object> fetchEarliestOffsets(Seq<TopicPartition> newPartitions) {
        if (newPartitions.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return this.partitionsAssignedToAdmin((Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>>)(Function1 & Serializable & scala.Serializable)partitions -> {
            java.util.Map listOffsetsParams = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)newPartitions.filter((Function1 & Serializable & scala.Serializable)newPartition -> BoxesRunTime.boxToBoolean((boolean)partitions.contains(newPartition)))).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)OffsetSpec.earliest()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets = this.listOffsets(this.admin(), listOffsetsParams);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Got earliest offsets for new partitions: ").append(partitionOffsets).toString());
            return partitionOffsets;
        });
    }

    @Override
    public Seq<KafkaOffsetRange> getOffsetRangesFromUnresolvedOffsets(KafkaOffsetRangeLimit startingOffsets, KafkaOffsetRangeLimit endingOffsets) {
        scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets = this.fetchPartitionOffsets(startingOffsets, true);
        scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets = this.fetchPartitionOffsets(endingOffsets, false);
        scala.collection.immutable.Set set = fromPartitionOffsets.keySet();
        scala.collection.immutable.Set set2 = untilPartitionOffsets.keySet();
        if (set == null ? set2 != null : !set.equals(set2)) {
            Ordering topicOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)t -> t.topic(), (Ordering)Ordering.String$.MODULE$);
            String fromTopics = ((TraversableOnce)fromPartitionOffsets.keySet().toList().sorted(topicOrdering)).mkString(",");
            String untilTopics = ((TraversableOnce)untilPartitionOffsets.keySet().toList().sorted(topicOrdering)).mkString(",");
            throw new IllegalStateException(new StringBuilder(84).append("different topic partitions ").append("for starting offsets topics[").append(fromTopics).append("] and ").append("ending offsets topics[").append(untilTopics).append("]").toString());
        }
        Seq offsetRangesBase = ((SetLike)untilPartitionOffsets.keySet().map((Function1 & Serializable & scala.Serializable)tp -> {
            long fromOffset = BoxesRunTime.unboxToLong((Object)fromPartitionOffsets.getOrElse(tp, (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(27).append(tp).append(" doesn't have a from offset").toString());
            }));
            long untilOffset = BoxesRunTime.unboxToLong((Object)untilPartitionOffsets.apply(tp));
            return new KafkaOffsetRange((TopicPartition)tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
        }, Set$.MODULE$.canBuildFrom())).toSeq();
        if (this.shouldDivvyUpLargePartitions(offsetRangesBase.size())) {
            scala.collection.immutable.Map fromOffsetsMap = ((TraversableOnce)offsetRangesBase.map((Function1 & Serializable & scala.Serializable)range -> new Tuple2((Object)range.topicPartition(), (Object)BoxesRunTime.boxToLong((long)range.fromOffset())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            scala.collection.immutable.Map untilOffsetsMap = ((TraversableOnce)offsetRangesBase.map((Function1 & Serializable & scala.Serializable)range -> new Tuple2((Object)range.topicPartition(), (Object)BoxesRunTime.boxToLong((long)range.untilOffset())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            scala.collection.immutable.Map<TopicPartition, Object> resolvedFromOffsets = this.fetchSpecificOffsets((scala.collection.immutable.Map<TopicPartition, Object>)fromOffsetsMap, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$8 -> {
                KafkaOffsetReaderAdmin.$anonfun$getOffsetRangesFromUnresolvedOffsets$6(x$8);
                return BoxedUnit.UNIT;
            }).partitionToOffsets();
            scala.collection.immutable.Map<TopicPartition, Object> resolvedUntilOffsets = this.fetchSpecificOffsets((scala.collection.immutable.Map<TopicPartition, Object>)untilOffsetsMap, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$9 -> {
                KafkaOffsetReaderAdmin.$anonfun$getOffsetRangesFromUnresolvedOffsets$7(x$9);
                return BoxedUnit.UNIT;
            }).partitionToOffsets();
            Seq ranges = (Seq)((TraversableLike)offsetRangesBase.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.topicPartition(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)tp -> new KafkaOffsetRange((TopicPartition)tp, BoxesRunTime.unboxToLong((Object)resolvedFromOffsets.apply(tp)), BoxesRunTime.unboxToLong((Object)resolvedUntilOffsets.apply(tp)), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom());
            scala.collection.immutable.Map divvied = this.rangeCalculator().getRanges((Seq<KafkaOffsetRange>)ranges, this.rangeCalculator().getRanges$default$2()).groupBy((Function1 & Serializable & scala.Serializable)x$11 -> x$11.topicPartition());
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)divvied.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    Seq splitOffsetRanges = (Seq)tuple2._2();
                    if (splitOffsetRanges.length() == 1) {
                        return (Seq)new .colon.colon((Object)new KafkaOffsetRange(tp, BoxesRunTime.unboxToLong((Object)fromOffsetsMap.apply((Object)tp)), BoxesRunTime.unboxToLong((Object)untilOffsetsMap.apply((Object)tp)), (Option<String>)None$.MODULE$), (List)Nil$.MODULE$);
                    }
                    KafkaOffsetRange qual$1 = (KafkaOffsetRange)splitOffsetRanges.head();
                    long x$1 = BoxesRunTime.unboxToLong((Object)fromOffsetsMap.apply((Object)tp));
                    TopicPartition x$2 = qual$1.copy$default$1();
                    long x$3 = qual$1.copy$default$3();
                    Option<String> x$4 = qual$1.copy$default$4();
                    KafkaOffsetRange first = qual$1.copy(x$2, x$1, x$3, x$4);
                    KafkaOffsetRange qual$2 = (KafkaOffsetRange)splitOffsetRanges.last();
                    long x$5 = BoxesRunTime.unboxToLong((Object)untilOffsetsMap.apply((Object)tp));
                    TopicPartition x$6 = qual$2.copy$default$1();
                    long x$7 = qual$2.copy$default$2();
                    Option<String> x$8 = qual$2.copy$default$4();
                    KafkaOffsetRange end = qual$2.copy(x$6, x$7, x$5, x$8);
                    return (Seq)((SeqLike)((TraversableLike)new .colon.colon((Object)first, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)((IterableLike)splitOffsetRanges.drop(1)).dropRight(1), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)end, Seq$.MODULE$.canBuildFrom());
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(KafkaOffsetRange.class)))).toSeq();
        }
        return offsetRangesBase;
    }

    private String[] getSortedExecutorList() {
        BlockManager bm = SparkEnv$.MODULE$.get().blockManager();
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bm.master().getPeers(bm.blockManagerId()).toArray(ClassTag$.MODULE$.apply(BlockManagerId.class)))).map((Function1 & Serializable & scala.Serializable)x -> new ExecutorCacheTaskLocation(x.host(), x.executorId()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExecutorCacheTaskLocation.class))))).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetReaderAdmin.compare$1(a, b))))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    @Override
    public Seq<KafkaOffsetRange> getOffsetRangesFromResolvedOffsets(scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets, scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets, Function1<String, BoxedUnit> reportDataLoss) {
        Object object;
        Object object2;
        scala.collection.immutable.Set newPartitions = (scala.collection.immutable.Set)untilPartitionOffsets.keySet().diff((GenSet)fromPartitionOffsets.keySet());
        scala.collection.immutable.Map<TopicPartition, Object> newPartitionInitialOffsets = this.fetchEarliestOffsets((Seq<TopicPartition>)newPartitions.toSeq());
        scala.collection.immutable.Set set = newPartitionInitialOffsets.keySet();
        scala.collection.immutable.Set set2 = newPartitions;
        if (set == null ? set2 != null : !set.equals(set2)) {
            scala.collection.immutable.Set deletedPartitions = (scala.collection.immutable.Set)newPartitions.diff((GenSet)newPartitionInitialOffsets.keySet());
            object2 = reportDataLoss.apply((Object)new StringBuilder(64).append("Cannot find earliest offsets of ").append(deletedPartitions).append(". Some data may have been missed").toString());
        } else {
            object2 = BoxedUnit.UNIT;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Partitions added: ").append(newPartitionInitialOffsets).toString());
        ((IterableLike)newPartitionInitialOffsets.filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetReaderAdmin.$anonfun$getOffsetRangesFromResolvedOffsets$2(x$13)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaOffsetReaderAdmin.$anonfun$getOffsetRangesFromResolvedOffsets$3(reportDataLoss, x0$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set deletedPartitions = (scala.collection.immutable.Set)fromPartitionOffsets.keySet().diff((GenSet)untilPartitionOffsets.keySet());
        if (deletedPartitions.nonEmpty()) {
            String message = this.driverKafkaParams().containsKey("group.id") ? new StringBuilder(11).append(deletedPartitions).append(" are gone. ").append(KafkaSourceProvider$.MODULE$.CUSTOM_GROUP_ID_ERROR_MESSAGE()).toString() : new StringBuilder(42).append(deletedPartitions).append(" are gone. Some data may have been missed.").toString();
            object = reportDataLoss.apply((Object)message);
        } else {
            object = BoxedUnit.UNIT;
        }
        Seq topicPartitions = ((SetLike)untilPartitionOffsets.keySet().filter((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetReaderAdmin.$anonfun$getOffsetRangesFromResolvedOffsets$4(newPartitionInitialOffsets, fromPartitionOffsets, tp)))).toSeq();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("TopicPartitions: ").append(topicPartitions.mkString(", ")).toString());
        scala.collection.immutable.Map fromOffsets = fromPartitionOffsets.$plus$plus(newPartitionInitialOffsets);
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = untilPartitionOffsets;
        Seq ranges = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
            long fromOffset = BoxesRunTime.unboxToLong((Object)fromOffsets.apply(tp));
            long untilOffset = BoxesRunTime.unboxToLong((Object)untilOffsets.apply(tp));
            Object object = untilOffset < fromOffset ? reportDataLoss.apply((Object)new StringBuilder(73).append("Partition ").append(tp).append("'s offset was changed from ").append(fromOffset).append(" to ").append(untilOffset).append(", some data may have been missed").toString()) : BoxedUnit.UNIT;
            return new KafkaOffsetRange((TopicPartition)tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom());
        return this.rangeCalculator().getRanges((Seq<KafkaOffsetRange>)ranges, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.getSortedExecutorList()));
    }

    private scala.collection.immutable.Map<TopicPartition, Object> partitionsAssignedToAdmin(Function1<Set<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Object>> body) {
        return this.withRetries((Function0<scala.collection.immutable.Map<TopicPartition, Object>>)(Function0 & Serializable & scala.Serializable)() -> {
            Set partitions = (Set)JavaConverters$.MODULE$.setAsJavaSetConverter($this.consumerStrategy.assignedTopicPartitions(this.admin())).asJava();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Partitions assigned: ").append(partitions).append(".").toString());
            return (scala.collection.immutable.Map)body.apply((Object)partitions);
        });
    }

    private synchronized scala.collection.immutable.Map<TopicPartition, Object> withRetries(Function0<scala.collection.immutable.Map<TopicPartition, Object>> body) {
        None$ result = None$.MODULE$;
        IntRef attempt = IntRef.create((int)1);
        Throwable lastException = null;
        while (result.isEmpty() && attempt.elem <= this.maxOffsetFetchAttempts() && !Thread.currentThread().isInterrupted()) {
            try {
                result = new Some(body.apply());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e;
                    lastException = e = (Throwable)option.get();
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Error in attempt ").append(attempt$1.elem).append(" getting Kafka offsets: ").toString(), e);
                    ++attempt.elem;
                    Thread.sleep(this.offsetFetchAttemptIntervalMs());
                    this.resetAdmin();
                    continue;
                }
                throw throwable;
            }
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (result.isEmpty()) {
            Predef$.MODULE$.assert(attempt.elem > this.maxOffsetFetchAttempts());
            Predef$.MODULE$.assert(lastException != null);
            throw lastException;
        }
        return (scala.collection.immutable.Map)result.get();
    }

    private synchronized void stopAdmin() {
        if (this._admin() != null) {
            this._admin().close();
            return;
        }
    }

    private synchronized void resetAdmin() {
        this.stopAdmin();
        this._admin_$eq(null);
    }

    public static final /* synthetic */ int $anonfun$minPartitions$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    private final scala.collection.immutable.Map validateTopicPartitions$1(scala.collection.immutable.Set partitions, scala.collection.immutable.Map partitionOffsets) {
        scala.collection.immutable.Set set = partitions;
        scala.collection.immutable.Set set2 = partitionOffsets.keySet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(142).append("If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest.\n").append("Specified: ").append(partitionOffsets.keySet()).append(" Assigned: ").append(partitions).toString());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Assigned partitions: ").append(partitions).append(". Seeking to ").append(partitionOffsets).toString());
        return partitionOffsets;
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificOffsets$1(KafkaOffsetReaderAdmin $this, scala.collection.immutable.Map partitionOffsets$2, Set partitions) {
        Object object = JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala();
        scala.collection.immutable.Set set = partitionOffsets$2.keySet();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(set) : set != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(161).append("If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest, if you don't care.\n").append("Specified: ").append(partitionOffsets$2.keySet()).append(" Assigned: ").append(JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toString());
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Assigned partitions: ").append(partitions).append(". Seeking to ").append(partitionOffsets$2).toString());
    }

    public static final /* synthetic */ void $anonfun$fetchSpecificTimestampBasedOffsets$1(KafkaOffsetReaderAdmin $this, scala.collection.immutable.Map partitionTimestamps$1, Set partitions) {
        Object object = JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala();
        scala.collection.immutable.Set set = partitionTimestamps$1.keySet();
        Predef$.MODULE$.assert(!(object != null ? !object.equals(set) : set != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("If starting/endingOffsetsByTimestamp contains specific offsets, you must specify all ").append("topics. Specified: ").append(partitionTimestamps$1.keySet()).append(" Assigned: ").append(JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toString());
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Assigned partitions: ").append(partitions).append(". Seeking to ").append(partitionTimestamps$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$fetchSpecificOffsets0$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long off = tuple2._2$mcJ$sp();
            return off == KafkaOffsetRangeLimit$.MODULE$.LATEST() || off == KafkaOffsetRangeLimit$.MODULE$.EARLIEST();
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Object $anonfun$fetchLatestOffsets$6(long offset$1, TopicPartition tp$1, ArrayBuffer incorrectOffsets$1, long knownOffset) {
        if (knownOffset > offset$1) {
            Tuple3 incorrectOffset = new Tuple3((Object)tp$1, (Object)BoxesRunTime.boxToLong((long)knownOffset), (Object)BoxesRunTime.boxToLong((long)offset$1));
            return incorrectOffsets$1.$plus$eq((Object)incorrectOffset);
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$fetchLatestOffsets$5(TopicPartition tp$1, long offset$1, ArrayBuffer incorrectOffsets$1, scala.collection.immutable.Map x$7) {
        x$7.get((Object)tp$1).foreach((Function1 & Serializable & scala.Serializable)knownOffset -> KafkaOffsetReaderAdmin.$anonfun$fetchLatestOffsets$6(offset$1, tp$1, incorrectOffsets$1, BoxesRunTime.unboxToLong((Object)knownOffset)));
    }

    public static final /* synthetic */ void $anonfun$fetchLatestOffsets$4(Option knownOffsets$1, ArrayBuffer incorrectOffsets$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            long offset = tuple2._2$mcJ$sp();
            knownOffsets$1.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                KafkaOffsetReaderAdmin.$anonfun$fetchLatestOffsets$5(tp, offset, incorrectOffsets$1, x$7);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final Seq findIncorrectOffsets$1(ObjectRef partitionOffsets$5, Option knownOffsets$1) {
        ArrayBuffer incorrectOffsets = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((scala.collection.immutable.Map)partitionOffsets$5.elem).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaOffsetReaderAdmin.$anonfun$fetchLatestOffsets$4(knownOffsets$1, incorrectOffsets, x0$1);
            return BoxedUnit.UNIT;
        });
        return incorrectOffsets.toSeq();
    }

    public static final /* synthetic */ void $anonfun$getOffsetRangesFromUnresolvedOffsets$6(String x$8) {
    }

    public static final /* synthetic */ void $anonfun$getOffsetRangesFromUnresolvedOffsets$7(String x$9) {
    }

    private static final boolean compare$1(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
        String string = a.host();
        String string2 = b.host();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return new StringOps(Predef$.MODULE$.augmentString(a.executorId())).$greater((Object)b.executorId());
        }
        return new StringOps(Predef$.MODULE$.augmentString(a.host())).$greater((Object)b.host());
    }

    public static final /* synthetic */ boolean $anonfun$getOffsetRangesFromResolvedOffsets$2(Tuple2 x$13) {
        return x$13._2$mcJ$sp() != 0L;
    }

    public static final /* synthetic */ void $anonfun$getOffsetRangesFromResolvedOffsets$3(Function1 reportDataLoss$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TopicPartition p = (TopicPartition)tuple2._1();
            long o = tuple2._2$mcJ$sp();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)reportDataLoss$1.apply((Object)new StringBuilder(74).append("Added partition ").append(p).append(" starts from ").append(o).append(" instead of 0. Some data may have been missed").toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getOffsetRangesFromResolvedOffsets$4(scala.collection.immutable.Map newPartitionInitialOffsets$1, scala.collection.immutable.Map fromPartitionOffsets$2, TopicPartition tp) {
        return newPartitionInitialOffsets$1.contains((Object)tp) || fromPartitionOffsets$2.contains((Object)tp);
    }

    public KafkaOffsetReaderAdmin(ConsumerStrategy consumerStrategy, java.util.Map<String, Object> driverKafkaParams, CaseInsensitiveMap<String> readerOptions, String driverGroupIdPrefix) {
        this.consumerStrategy = consumerStrategy;
        this.driverKafkaParams = driverKafkaParams;
        Logging.$init$((Logging)this);
        this.maxOffsetFetchAttempts = new StringOps(Predef$.MODULE$.augmentString((String)readerOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.FETCH_OFFSET_NUM_RETRY(), (Function0 & Serializable & scala.Serializable)() -> "3"))).toInt();
        this.offsetFetchAttemptIntervalMs = new StringOps(Predef$.MODULE$.augmentString((String)readerOptions.getOrElse((Object)KafkaSourceProvider$.MODULE$.FETCH_OFFSET_RETRY_INTERVAL_MS(), (Function0 & Serializable & scala.Serializable)() -> "1000"))).toLong();
        this._admin = null;
        this.minPartitions = readerOptions.get(KafkaSourceProvider$.MODULE$.MIN_PARTITIONS_OPTION_KEY()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)KafkaOffsetReaderAdmin.$anonfun$minPartitions$1(x$1)));
        this.rangeCalculator = new KafkaOffsetRangeCalculator(this.minPartitions());
    }
}

