/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.sketch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.util.sketch.BloomFilter;
import org.apache.spark.util.sketch.IncompatibleMergeException;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0005\u000b\u0001UAQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u001351\u0005\u0003\u0004'\u0001\u0001\u0006i\u0001\n\u0005\u0006O\u0001!I\u0001\u000b\u0005\u0006i\u0001!\t!\u000e\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0005A\u0011En\\8n\r&dG/\u001a:Tk&$XM\u0003\u0002\f\u0019\u000511o[3uG\"T!!\u0004\b\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u001fA\tQa\u001d9be.T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sO\u000e\u00011C\u0001\u0001\u0017!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0005gk:\u001cX/\u001b;f\u0015\tY\"#A\u0005tG\u0006d\u0017\r^3ti&\u0011Q\u0004\u0007\u0002\f\u0003:Lh)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002\u0015\u00059Q\tU*J\u0019>sU#\u0001\u0013\u0010\u0003\u0015\u0002\u0003b\u0010C{C sKc_\u0001\t\u000bB\u001b\u0016\nT(OA\u0005Q1\r[3dWN+'\u000fR3\u0015\u0005%z\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#\u0001B+oSRDQ\u0001\r\u0003A\u0002E\naAZ5mi\u0016\u0014\bCA\u00113\u0013\t\u0019$BA\u0006CY>|WNR5mi\u0016\u0014\u0018\u0001\u0004;fgR\f5mY;sC\u000eLXC\u0001\u001cD)\r9dk\u0019\u000b\u0003q1#\"!K\u001d\t\u000fi*\u0011\u0011!a\u0002w\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007qz\u0014)D\u0001>\u0015\tq4&A\u0004sK\u001adWm\u0019;\n\u0005\u0001k$\u0001C\"mCN\u001cH+Y4\u0011\u0005\t\u001bE\u0002\u0001\u0003\u0006\t\u0016\u0011\r!\u0012\u0002\u0002)F\u0011a)\u0013\t\u0003U\u001dK!\u0001S\u0016\u0003\u000f9{G\u000f[5oOB\u0011!FS\u0005\u0003\u0017.\u00121!\u00118z\u0011\u0015iU\u00011\u0001O\u0003\u001dIG/Z7HK:\u0004BAK(R\u0003&\u0011\u0001k\u000b\u0002\n\rVt7\r^5p]F\u0002\"A\u0015+\u000e\u0003MS!!D\u0016\n\u0005U\u001b&A\u0002*b]\u0012|W\u000eC\u0003X\u000b\u0001\u0007\u0001,\u0001\u0005usB,g*Y7f!\tI\u0006M\u0004\u0002[=B\u00111lK\u0007\u00029*\u0011Q\fF\u0001\u0007yI|w\u000e\u001e \n\u0005}[\u0013A\u0002)sK\u0012,g-\u0003\u0002bE\n11\u000b\u001e:j]\u001eT!aX\u0016\t\u000b\u0011,\u0001\u0019A3\u0002\u00119,X.\u0013;f[N\u0004\"A\u000b4\n\u0005\u001d\\#aA%oi\u0006\u0001B/Z:u\u001b\u0016\u0014x-Z%o!2\f7-Z\u000b\u0003UF$2a\u001b;v)\ta'\u000f\u0006\u0002*[\"9aNBA\u0001\u0002\by\u0017AC3wS\u0012,gnY3%eA\u0019Ah\u00109\u0011\u0005\t\u000bH!\u0002#\u0007\u0005\u0004)\u0005\"B'\u0007\u0001\u0004\u0019\b\u0003\u0002\u0016P#BDQa\u0016\u0004A\u0002aCQ\u0001\u001a\u0004A\u0002\u0015\fA\u0003^3ti&sG/\u001a:tK\u000e$\u0018J\u001c)mC\u000e,WC\u0001=\u0000)\u0015I\u0018QAA\u0004)\rQ\u0018\u0011\u0001\u000b\u0003SmDq\u0001`\u0004\u0002\u0002\u0003\u000fQ0\u0001\u0006fm&$WM\\2fIM\u00022\u0001P \u007f!\t\u0011u\u0010B\u0003E\u000f\t\u0007Q\t\u0003\u0004N\u000f\u0001\u0007\u00111\u0001\t\u0005U=\u000bf\u0010C\u0003X\u000f\u0001\u0007\u0001\fC\u0003e\u000f\u0001\u0007Q-\u0001\u0007uKN$\u0018\n^3n)f\u0004X-\u0006\u0003\u0002\u000e\u0005mACBA\b\u0003C\t\u0019\u0003\u0006\u0003\u0002\u0012\u0005uAcA\u0015\u0002\u0014!I\u0011Q\u0003\u0005\u0002\u0002\u0003\u000f\u0011qC\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004\u0003\u0002\u001f@\u00033\u00012AQA\u000e\t\u0015!\u0005B1\u0001F\u0011\u0019i\u0005\u00021\u0001\u0002 A)!fT)\u0002\u001a!)q\u000b\u0003a\u00011\")A\r\u0003a\u0001K\u0002")
public class BloomFilterSuite
extends AnyFunSuite {
    private final double EPSILON() {
        return 0.01;
    }

    private void checkSerDe(BloomFilter filter) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        filter.writeTo((OutputStream)out);
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BloomFilter deserialized = BloomFilter.readFrom((InputStream)in);
        in.close();
        BloomFilter $org_scalatest_assert_macro_left = filter;
        BloomFilter $org_scalatest_assert_macro_right = deserialized;
        BloomFilter bloomFilter = $org_scalatest_assert_macro_left;
        BloomFilter bloomFilter2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(bloomFilter != null ? !bloomFilter.equals(bloomFilter2) : bloomFilter2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
    }

    public <T> void testAccuracy(String typeName, int numItems, Function1<Random, T> itemGen, ClassTag<T> evidence$1) {
        this.test(new StringBuilder(11).append("accuracy - ").append(typeName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Random r = new Random(37);
            double fpp = 0.05;
            int numInsertion = numItems / 10;
            Object allItems = Array$.MODULE$.fill(numItems, (Function0 & Serializable & scala.Serializable)() -> itemGen.apply((Object)r), evidence$1);
            BloomFilter filter = BloomFilter.create((long)numInsertion, (double)fpp);
            Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(allItems).take(numInsertion)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.put(x$1)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(allItems).take(numInsertion)).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.mightContain(x$1))), "scala.Predef.genericArrayOps[T](scala.Predef.genericArrayOps[T](allItems).take(numInsertion)).forall({\n  ((x$1: Any) => filter.mightContain(x$1))\n})", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            double $org_scalatest_assert_macro_left = filter.expectedFpp() - fpp;
            double $org_scalatest_assert_macro_right = 0.01;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            int errorCount = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(allItems).drop(numInsertion)).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.mightContain(x$1)));
            double actualFpp = (double)errorCount / (double)(numItems - numInsertion);
            double $org_scalatest_assert_macro_left2 = actualFpp - fpp;
            double $org_scalatest_assert_macro_right2 = 0.01;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            this.checkSerDe(filter);
        }, new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
    }

    public <T> void testMergeInPlace(String typeName, int numItems, Function1<Random, T> itemGen, ClassTag<T> evidence$2) {
        this.test(new StringBuilder(15).append("mergeInPlace - ").append(typeName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Random r = new Random(37);
            Object items1 = Array$.MODULE$.fill(numItems / 2, (Function0 & Serializable & scala.Serializable)() -> itemGen.apply((Object)r), evidence$2);
            Object items2 = Array$.MODULE$.fill(numItems / 2, (Function0 & Serializable & scala.Serializable)() -> itemGen.apply((Object)r), evidence$2);
            BloomFilter filter1 = BloomFilter.create((long)numItems);
            Predef$.MODULE$.genericArrayOps(items1).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter1.put(x$1)));
            BloomFilter filter2 = BloomFilter.create((long)numItems);
            Predef$.MODULE$.genericArrayOps(items2).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter2.put(x$1)));
            filter1.mergeInPlace(filter2);
            double $org_scalatest_assert_macro_left = filter1.expectedFpp() - 0.03;
            double $org_scalatest_assert_macro_right = 0.01;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            Predef$.MODULE$.genericArrayOps(items1).foreach((Function1 & Serializable & scala.Serializable)i -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filter1.mightContain(i), "filter1.mightContain(i)", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            });
            Predef$.MODULE$.genericArrayOps(items2).foreach((Function1 & Serializable & scala.Serializable)i -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filter1.mightContain(i), "filter1.mightContain(i)", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            });
            this.checkSerDe(filter1);
        }, new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
    }

    public <T> void testIntersectInPlace(String typeName, int numItems, Function1<Random, T> itemGen, ClassTag<T> evidence$3) {
        this.test(new StringBuilder(19).append("intersectInPlace - ").append(typeName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Random r = new Random(37);
            Object items1 = Array$.MODULE$.fill(numItems / 2, (Function0 & Serializable & scala.Serializable)() -> itemGen.apply((Object)r), evidence$3);
            Object items2 = Array$.MODULE$.fill(numItems / 2, (Function0 & Serializable & scala.Serializable)() -> itemGen.apply((Object)r), evidence$3);
            BloomFilter filter1 = BloomFilter.create((long)(numItems / 2));
            Predef$.MODULE$.genericArrayOps(items1).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter1.put(x$1)));
            BloomFilter filter2 = BloomFilter.create((long)(numItems / 2));
            Predef$.MODULE$.genericArrayOps(items2).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter2.put(x$1)));
            filter1.intersectInPlace(filter2);
            Object common_items = Predef$.MODULE$.genericArrayOps(items1).intersect((GenSeq)Predef$.MODULE$.genericWrapArray(items2));
            Predef$.MODULE$.genericArrayOps(common_items).foreach((Function1 & Serializable & scala.Serializable)i -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filter1.mightContain(i), "filter1.mightContain(i)", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            });
            double $org_scalatest_assert_macro_left = filter1.expectedFpp() - 0.03;
            double $org_scalatest_assert_macro_right = 0.01;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            this.checkSerDe(filter1);
        }, new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
    }

    public <T> void testItemType(String typeName, int numItems, Function1<Random, T> itemGen, ClassTag<T> evidence$4) {
        this.testAccuracy(typeName, numItems, itemGen, evidence$4);
        this.testMergeInPlace(typeName, numItems, itemGen, evidence$4);
        this.testIntersectInPlace(typeName, numItems, itemGen, evidence$4);
    }

    public static final /* synthetic */ byte $anonfun$new$1(Random x$1) {
        return (byte)x$1.nextInt();
    }

    public static final /* synthetic */ short $anonfun$new$2(Random x$2) {
        return (short)x$2.nextInt();
    }

    public BloomFilterSuite() {
        this.testItemType("Byte", 160, (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)BloomFilterSuite.$anonfun$new$1(x$1)), ClassTag$.MODULE$.Byte());
        this.testItemType("Short", 1000, (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToShort((short)BloomFilterSuite.$anonfun$new$2(x$2)), ClassTag$.MODULE$.Short());
        this.testItemType("Int", 100000, (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.nextInt()), ClassTag$.MODULE$.Int());
        this.testItemType("Long", 100000, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.nextLong()), ClassTag$.MODULE$.Long());
        this.testItemType("String", 100000, (Function1 & Serializable & scala.Serializable)r -> r.nextString(r.nextInt(512)), ClassTag$.MODULE$.apply(String.class));
        this.test("incompatible merge", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> BloomFilter.create((long)1000L).mergeInPlace(null), ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                BloomFilter filter1 = BloomFilter.create((long)1000L, (long)6400L);
                BloomFilter filter2 = BloomFilter.create((long)1000L, (long)3200L);
                return filter1.mergeInPlace(filter2);
            }, ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            return (IncompatibleMergeException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                BloomFilter filter1 = BloomFilter.create((long)1000L, (long)6400L);
                BloomFilter filter2 = BloomFilter.create((long)2000L, (long)6400L);
                return filter1.mergeInPlace(filter2);
            }, ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        }, new Position("BloomFilterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
    }
}

