/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.sketch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.util.sketch.CountMinSketch;
import org.apache.spark.util.sketch.IncompatibleMergeException;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001\u0002\u0007\u000e\u0001aAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u0004.\u0001\u0001\u0006Ia\n\u0005\b]\u0001\u0011\r\u0011\"\u0003'\u0011\u0019y\u0003\u0001)A\u0005O!9\u0001\u0007\u0001b\u0001\n\u0013\t\u0004BB\u001b\u0001A\u0003%!\u0007C\u00037\u0001\u0011%q\u0007C\u0003@\u0001\u0011\u0005\u0001\tC\u0003o\u0001\u0011\u0005q\u000eC\u0003|\u0001\u0011\u0005APA\nD_VtG/T5o'.,Go\u00195Tk&$XM\u0003\u0002\u000f\u001f\u000511o[3uG\"T!\u0001E\t\u0002\tU$\u0018\u000e\u001c\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011C\u0001\u0001\u001a!\tQr$D\u0001\u001c\u0015\taR$\u0001\u0005gk:\u001cX/\u001b;f\u0015\tqR#A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0001e\u0007\u0002\f\u0003:Lh)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002\u001b\u0005yQ\r]:PMR{G/\u00197D_VtG/F\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019!u.\u001e2mK\u0006\u0001R\r]:PMR{G/\u00197D_VtG\u000fI\u0001\u000bG>tg-\u001b3f]\u000e,\u0017aC2p]\u001aLG-\u001a8dK\u0002\nAa]3fIV\t!\u0007\u0005\u0002)g%\u0011A'\u000b\u0002\u0004\u0013:$\u0018!B:fK\u0012\u0004\u0013AC2iK\u000e\\7+\u001a:EKR\u0011\u0001h\u000f\t\u0003QeJ!AO\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001d!\u0001\r\u0001\u0010\t\u0003IuJ!AP\u0007\u0003\u001d\r{WO\u001c;NS:\u001c6.\u001a;dQ\u0006aA/Z:u\u0003\u000e\u001cWO]1dsV\u0011\u0011I\u0014\u000b\u0003\u0005\u0006$\"aQ,\u0015\u0005a\"\u0005bB#\n\u0003\u0003\u0005\u001dAR\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA$K\u00196\t\u0001J\u0003\u0002JS\u00059!/\u001a4mK\u000e$\u0018BA&I\u0005!\u0019E.Y:t)\u0006<\u0007CA'O\u0019\u0001!QaT\u0005C\u0002A\u0013\u0011\u0001V\t\u0003#R\u0003\"\u0001\u000b*\n\u0005MK#a\u0002(pi\"Lgn\u001a\t\u0003QUK!AV\u0015\u0003\u0007\u0005s\u0017\u0010C\u0003Y\u0013\u0001\u0007\u0011,A\u0007ji\u0016lw)\u001a8fe\u0006$xN\u001d\t\u0005QicF*\u0003\u0002\\S\tIa)\u001e8di&|g.\r\t\u0003;~k\u0011A\u0018\u0006\u0003!%J!\u0001\u00190\u0003\rI\u000bg\u000eZ8n\u0011\u0015\u0011\u0017\u00021\u0001d\u0003!!\u0018\u0010]3OC6,\u0007C\u00013l\u001d\t)\u0017\u000e\u0005\u0002gS5\tqM\u0003\u0002i/\u00051AH]8pizJ!A[\u0015\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003U&\n\u0001\u0003^3ti6+'oZ3J]Bc\u0017mY3\u0016\u0005A<HCA9{)\t\u0011\b\u0010\u0006\u00029g\"9AOCA\u0001\u0002\b)\u0018AC3wS\u0012,gnY3%eA\u0019qI\u0013<\u0011\u00055;H!B(\u000b\u0005\u0004\u0001\u0006\"\u0002-\u000b\u0001\u0004I\b\u0003\u0002\u0015[9ZDQA\u0019\u0006A\u0002\r\fA\u0002^3ti&#X-\u001c+za\u0016,2!`A\u0005)\rq\u0018q\u0002\u000b\u0004\u007f\u0006-Ac\u0001\u001d\u0002\u0002!I\u00111A\u0006\u0002\u0002\u0003\u000f\u0011QA\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004\u0003B$K\u0003\u000f\u00012!TA\u0005\t\u0015y5B1\u0001Q\u0011\u0019A6\u00021\u0001\u0002\u000eA)\u0001F\u0017/\u0002\b!)!m\u0003a\u0001G\u0002")
public class CountMinSketchSuite
extends AnyFunSuite {
    private final double epsOfTotalCount;
    private final double confidence;
    private final int seed;

    private double epsOfTotalCount() {
        return this.epsOfTotalCount;
    }

    private double confidence() {
        return this.confidence;
    }

    private int seed() {
        return this.seed;
    }

    private void checkSerDe(CountMinSketch sketch) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sketch.writeTo((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        CountMinSketch deserialized = CountMinSketch.readFrom((InputStream)in);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(sketch);
        CountMinSketch $org_scalatest_assert_macro_right = deserialized;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
    }

    public <T> void testAccuracy(String typeName, Function1<Random, T> itemGenerator, ClassTag<T> evidence$1) {
        this.test(new StringBuilder(11).append("accuracy - ").append(typeName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double probCorrect;
            Random r = new Random(31);
            int numAllItems = 1000000;
            Object allItems = Array$.MODULE$.fill(numAllItems, (Function0 & Serializable & scala.Serializable)() -> itemGenerator.apply((Object)r), evidence$1);
            int numSamples = numAllItems / 10;
            int[] sampledItemIndices = (int[])Array$.MODULE$.fill(numSamples, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> r.nextInt(numAllItems), ClassTag$.MODULE$.Int());
            Object sampledItems = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sampledItemIndices)).map((Function1)Predef$.MODULE$.genericWrapArray(allItems), Array$.MODULE$.canBuildFrom(evidence$1));
            Map exactFreq = Predef$.MODULE$.genericArrayOps(sampledItems).groupBy((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x)).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)ScalaRunTime$.MODULE$.array_length(x$1)));
            CountMinSketch sketch = CountMinSketch.create((double)this.epsOfTotalCount(), (double)this.confidence(), (int)this.seed());
            this.checkSerDe(sketch);
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sampledItemIndices)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> sketch.add(ScalaRunTime$.MODULE$.array_apply(allItems, i)));
            this.checkSerDe(sketch);
            int numErrors = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.genericArrayOps(allItems).map((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToInteger((int)CountMinSketchSuite.$anonfun$testAccuracy$7(this, exactFreq, sketch, numAllItems, item)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            double $org_scalatest_assert_macro_left = probCorrect = 1.0 - (double)numErrors / (double)numAllItems;
            double $org_scalatest_assert_macro_right = this.confidence();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(43).append("Confidence not reached: required ").append(this.confidence()).append(", reached ").append(probCorrect).toString(), Prettifier$.MODULE$.default(), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
    }

    public <T> void testMergeInPlace(String typeName, Function1<Random, T> itemGenerator, ClassTag<T> evidence$2) {
        this.test(new StringBuilder(15).append("mergeInPlace - ").append(typeName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Random r = new Random(31);
            int numToMerge = 5;
            int numItemsPerSketch = 100000;
            Object[] perSketchItems = Array$.MODULE$.fill(numToMerge, numItemsPerSketch, (Function0 & Serializable & scala.Serializable)() -> itemGenerator.apply((Object)r), evidence$2);
            CountMinSketch[] sketches = (CountMinSketch[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(perSketchItems)).map((Function1 & Serializable & scala.Serializable)items -> {
                CountMinSketch sketch = CountMinSketch.create((double)this.epsOfTotalCount(), (double)this.confidence(), (int)this.seed());
                this.checkSerDe(sketch);
                Predef$.MODULE$.genericArrayOps(items).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    sketch.add(x$1);
                    return BoxedUnit.UNIT;
                });
                this.checkSerDe(sketch);
                return sketch;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CountMinSketch.class)));
            CountMinSketch mergedSketch = (CountMinSketch)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sketches)).reduce((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.mergeInPlace(x$3));
            this.checkSerDe(mergedSketch);
            CountMinSketch expectedSketch = CountMinSketch.create((double)this.epsOfTotalCount(), (double)this.confidence(), (int)this.seed());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(perSketchItems)).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                CountMinSketchSuite.$anonfun$testMergeInPlace$6(expectedSketch, x$4);
                return BoxedUnit.UNIT;
            });
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(perSketchItems)).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                CountMinSketchSuite.$anonfun$testMergeInPlace$8(this, mergedSketch, expectedSketch, x$5);
                return BoxedUnit.UNIT;
            });
        }, new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
    }

    public <T> void testItemType(String typeName, Function1<Random, T> itemGenerator, ClassTag<T> evidence$3) {
        this.testAccuracy(typeName, itemGenerator, evidence$3);
        this.testMergeInPlace(typeName, itemGenerator, evidence$3);
    }

    public static final /* synthetic */ int $anonfun$testAccuracy$7(CountMinSketchSuite $this, Map exactFreq$1, CountMinSketch sketch$1, int numAllItems$1, Object item) {
        long count = BoxesRunTime.unboxToLong((Object)exactFreq$1.getOrElse(item, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        double ratio = (double)(sketch$1.estimateCount(item) - count) / (double)numAllItems$1;
        if (ratio > $this.epsOfTotalCount()) {
            return 1;
        }
        return 0;
    }

    public static final /* synthetic */ void $anonfun$testMergeInPlace$6(CountMinSketch expectedSketch$1, Object x$4) {
        Predef$.MODULE$.genericArrayOps(x$4).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            expectedSketch$1.add(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testMergeInPlace$8(CountMinSketchSuite $this, CountMinSketch mergedSketch$1, CountMinSketch expectedSketch$1, Object x$5) {
        Predef$.MODULE$.genericArrayOps(x$5).foreach((Function1 & Serializable & scala.Serializable)item -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)mergedSketch$1.estimateCount(item)));
            long $org_scalatest_assert_macro_right = expectedSketch$1.estimateCount(item);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        });
    }

    public static final /* synthetic */ byte $anonfun$new$1(Random x$6) {
        return (byte)x$6.nextInt();
    }

    public static final /* synthetic */ short $anonfun$new$2(Random x$7) {
        return (short)x$7.nextInt();
    }

    public CountMinSketchSuite() {
        this.epsOfTotalCount = 0.01;
        this.confidence = 0.9;
        this.seed = 42;
        this.testItemType("Byte", (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToByte((byte)CountMinSketchSuite.$anonfun$new$1(x$6)), ClassTag$.MODULE$.Byte());
        this.testItemType("Short", (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToShort((short)CountMinSketchSuite.$anonfun$new$2(x$7)), ClassTag$.MODULE$.Short());
        this.testItemType("Int", (Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.nextInt()), ClassTag$.MODULE$.Int());
        this.testItemType("Long", (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.nextLong()), ClassTag$.MODULE$.Long());
        this.testItemType("String", (Function1 & Serializable & scala.Serializable)r -> r.nextString(r.nextInt(20)), ClassTag$.MODULE$.apply(String.class));
        this.testItemType("Byte array", (Function1 & Serializable & scala.Serializable)r -> r.nextString(r.nextInt(60)).getBytes(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        this.test("incompatible merge", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> CountMinSketch.create((int)10, (int)10, (int)1).mergeInPlace(null), ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                CountMinSketch sketch1 = CountMinSketch.create((int)10, (int)20, (int)1);
                CountMinSketch sketch2 = CountMinSketch.create((int)10, (int)20, (int)2);
                return sketch1.mergeInPlace(sketch2);
            }, ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            return (IncompatibleMergeException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                CountMinSketch sketch1 = CountMinSketch.create((int)10, (int)10, (int)1);
                CountMinSketch sketch2 = CountMinSketch.create((int)10, (int)20, (int)2);
                return sketch1.mergeInPlace(sketch2);
            }, ClassTag$.MODULE$.apply(IncompatibleMergeException.class), new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        }, new Position("CountMinSketchSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }
}

