/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.spark.ProcessTestUtils;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.util.ThreadUtils$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0002\u0004\u0001\u001f!)\u0001\u0005\u0001C\u0001C!)A\u0005\u0001C\u0001K!9q\u000bAI\u0001\n\u0003A\u0006bB2\u0001#\u0003%\t\u0001\u0017\u0002\u0010'B\f'o[*iK2d7+^5uK*\u0011q\u0001C\u0001\u0005e\u0016\u0004HN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00155A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005UAR\"\u0001\f\u000b\u0005]a\u0011!C:dC2\fG/Z:u\u0013\tIbCA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0005\u0002\u0011%tG/\u001a:oC2L!a\b\u000f\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011AB\u0001\u000feVt\u0017J\u001c;feB\u0014X\r^3s)\u00111\u0003IS+\u0015\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#\u0001B+oSRDQA\f\u0002A\u0002=\n\u0011d]2sSB$8/\u00118e\u000bb\u0004Xm\u0019;fI\u0006s7o^3sgB\u0019\u0001\u0006\r\u001a\n\u0005EJ#A\u0003\u001fsKB,\u0017\r^3e}A!\u0001fM\u001b6\u0013\t!\u0014F\u0001\u0004UkBdWM\r\t\u0003mur!aN\u001e\u0011\u0005aJS\"A\u001d\u000b\u0005ir\u0011A\u0002\u001fs_>$h(\u0003\u0002=S\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\ta\u0014\u0006C\u0003B\u0005\u0001\u0007!)A\u0004uS6,w.\u001e;\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005\u001dK\u0013AC2p]\u000e,(O]3oi&\u0011\u0011\n\u0012\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011\u001dY%\u0001%AA\u00021\u000b\u0011\"\u001a=ue\u0006\f%oZ:\u0011\u00075\u0013VG\u0004\u0002O!:\u0011\u0001hT\u0005\u0002U%\u0011\u0011+K\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019FKA\u0002TKFT!!U\u0015\t\u000fY\u0013\u0001\u0013!a\u0001\u0019\u0006qQM\u001d:peJ+7\u000f]8og\u0016\u001c\u0018\u0001\u0007:v]&sG/\u001a:qe\u0016$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\t\u0011L\u000b\u0002M5.\n1\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003A&\n!\"\u00198o_R\fG/[8o\u0013\t\u0011WLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001D];o\u0013:$XM\u001d9sKR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0001")
public class SparkShellSuite
extends SparkFunSuite {
    public void runInterpreter(FiniteDuration timeout, Seq<String> extraArgs, Seq<String> errorResponses, Seq<Tuple2<String, String>> scriptsAndExpectedAnswers) {
        String scripts = ((TraversableOnce)scriptsAndExpectedAnswers.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append((String)x$1._1()).append("\n").toString(), Seq$.MODULE$.canBuildFrom())).mkString();
        Seq expectedAnswers = (Seq)scriptsAndExpectedAnswers.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String answer = (String)tuple2._2();
                return (Seq)new .colon.colon((Object)answer, (List)Nil$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        String cliScript = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"../bin/spark-shell".split("/"))).mkString(File.separator);
        Seq command = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(77).append(cliScript).append("\n         |  --master local\n         |  --conf spark.ui.enabled=false\n       ").toString())).stripMargin().split("\\s+"))).toSeq().$plus$plus(extraArgs, Seq$.MODULE$.canBuildFrom());
        IntRef next = IntRef.create((int)0);
        Promise foundMasterAndApplicationIdMessage = Promise$.MODULE$.apply();
        Promise foundAllExpectedAnswers = Promise$.MODULE$.apply();
        ArrayBuffer buffer = new ArrayBuffer();
        Object lock = new Object();
        Process process = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class))).start();
        OutputStreamWriter stdinWriter = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
        stdinWriter.write(scripts);
        stdinWriter.flush();
        stdinWriter.close();
        new ProcessTestUtils.ProcessOutputCapturer(process.getInputStream(), (Function1 & Serializable & scala.Serializable)line -> {
            this.captureOutput$1("stdout", line, lock, buffer, foundMasterAndApplicationIdMessage, next, expectedAnswers, foundAllExpectedAnswers, errorResponses);
            return BoxedUnit.UNIT;
        }).start();
        new ProcessTestUtils.ProcessOutputCapturer(process.getErrorStream(), (Function1 & Serializable & scala.Serializable)line -> {
            this.captureOutput$1("stderr", line, lock, buffer, foundMasterAndApplicationIdMessage, next, expectedAnswers, foundAllExpectedAnswers, errorResponses);
            return BoxedUnit.UNIT;
        }).start();
        try {
            try {
                FiniteDuration finiteDuration;
                if (!extraArgs.contains((Object)"-e")) {
                    ThreadUtils$.MODULE$.awaitResult((Awaitable)foundMasterAndApplicationIdMessage.future(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(2)).minutes());
                    this.log().info("spark-shell driver is booted. Waiting for expected answers.");
                    finiteDuration = timeout;
                } else {
                    finiteDuration = new package.DurationInt(package$.MODULE$.DurationInt(2)).minutes().$plus(timeout);
                }
                FiniteDuration timeoutForQuery = finiteDuration;
                ThreadUtils$.MODULE$.awaitResult((Awaitable)foundAllExpectedAnswers.future(), (Duration)timeoutForQuery);
                this.log().info("Found all expected output.");
            }
            catch (Throwable cause) {
                String message = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(404).append("\n           |=======================\n           |SparkShellSuite failure output\n           |=======================\n           |Spark Shell command line: ").append(command.mkString(" ")).append("\n           |Exception: ").append(cause).append("\n           |Failed to capture next expected output \"").append(expectedAnswers.apply(next.elem)).append("\" within ").append(timeout).append(".\n           |\n           |").append(buffer.mkString("\n")).append("\n           |===========================\n           |End SparkShellSuite failure output\n           |===========================\n         ").toString())).stripMargin();
                this.logError((Function0 & Serializable & scala.Serializable)() -> message, cause);
                throw this.fail(message, cause, new Position("SparkShellSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            }
        }
        finally {
            if (!process.waitFor(1L, TimeUnit.MINUTES)) {
                try {
                    this.log().warn("spark-shell did not exit gracefully.");
                }
                finally {
                    process.destroy();
                }
            }
        }
    }

    public Seq<String> runInterpreter$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    public Seq<String> runInterpreter$default$3() {
        return (Seq)new .colon.colon((Object)"Error:", (List)Nil$.MODULE$);
    }

    private final void captureOutput$1(String source, String line, Object lock$1, ArrayBuffer buffer$1, Promise foundMasterAndApplicationIdMessage$1, IntRef next$1, Seq expectedAnswers$1, Promise foundAllExpectedAnswers$1, Seq errorResponses$1) {
        Object object = lock$1;
        synchronized (object) {
            Object object2;
            String newLine = new StringBuilder(5).append(new Timestamp(new Date().getTime())).append(" - ").append(source).append("> ").append(line).toString();
            this.log().info(newLine);
            buffer$1.$plus$eq((Object)newLine);
            Object object3 = line.startsWith("Spark context available") && line.contains("app id") ? BoxesRunTime.boxToBoolean((boolean)foundMasterAndApplicationIdMessage$1.trySuccess((Object)BoxedUnit.UNIT)) : BoxedUnit.UNIT;
            if (next$1.elem < expectedAnswers$1.size() && line.contains((CharSequence)expectedAnswers$1.apply(next$1.elem))) {
                this.log().info(new StringBuilder(33).append(source).append("> found expected output line ").append(next$1.elem).append(": '").append(expectedAnswers$1.apply(next$1.elem)).append("'").toString());
                ++next$1.elem;
                object2 = next$1.elem == expectedAnswers$1.size() ? BoxesRunTime.boxToBoolean((boolean)foundAllExpectedAnswers$1.trySuccess((Object)BoxedUnit.UNIT)) : BoxedUnit.UNIT;
            } else {
                errorResponses$1.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    if (line.contains((CharSequence)r)) {
                        return BoxesRunTime.boxToBoolean((boolean)foundAllExpectedAnswers$1.tryFailure((Throwable)new RuntimeException(new StringBuilder(25).append("Failed with error line '").append(line).append("'").toString())));
                    }
                    return BoxedUnit.UNIT;
                });
                object2 = BoxedUnit.UNIT;
            }
        }
    }

    public SparkShellSuite() {
        this.test("SPARK-37058: Add command line unit test for spark-shell", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInterpreter(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)Nil$.MODULE$), this.runInterpreter$default$3(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |spark.sql(\"drop table if exists t_37058\")\n      ")).stripMargin()), (Object)"res0: org.apache.spark.sql.DataFrame = []")})), new Position("SparkShellSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("SPARK-37058: Add command line unit test for spark-shell with --verbose", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInterpreter(new package.DurationInt(package$.MODULE$.DurationInt(2)).minute(), (Seq<String>)((Seq)new .colon.colon((Object)"--verbose", (List)Nil$.MODULE$)), this.runInterpreter$default$3(), (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringOps(Predef$.MODULE$.augmentString("")).stripMargin()), (Object)"org.apache.spark.repl.Main")})), new Position("SparkShellSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
    }
}

