/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.repl.Main$;
import org.apache.spark.repl.SparkILoop;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]4Aa\u0005\u000b\u0001;!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003B\u0002\u0019\u0001A\u0003%\u0001\u0006C\u00042\u0001\t\u0007I\u0011\u0002\u001a\t\rY\u0002\u0001\u0015!\u00034\u0011%9\u0004\u00011AA\u0002\u0013%\u0001\bC\u0005@\u0001\u0001\u0007\t\u0019!C\u0005\u0001\"I\u0011\n\u0001a\u0001\u0002\u0003\u0006K!\u000f\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u0019y\u0005\u0001)A\u0005\u0019\"9\u0001\u000b\u0001b\u0001\n\u0013Y\u0005BB)\u0001A\u0003%A\nC\u0003S\u0001\u0011\u00053\u000bC\u0003U\u0001\u0011\u00053\u000bC\u0003V\u0001\u0011%a\u000bC\u0003`\u0001\u0011\u0005\u0001\rC\u0003n\u0001\u0011\u0005a\u000eC\u0003t\u0001\u0011\u0005AOA\nTS:<G.\u001a;p]J+\u0007\u000f\u001c\u001aTk&$XM\u0003\u0002\u0016-\u0005!!/\u001a9m\u0015\t9\u0002$A\u0003ta\u0006\u00148N\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<7\u0001A\n\u0003\u0001y\u0001\"a\b\u0011\u000e\u0003YI!!\t\f\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\tA#A\u0002pkR,\u0012\u0001\u000b\t\u0003S9j\u0011A\u000b\u0006\u0003W1\n!![8\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\r'R\u0014\u0018N\\4Xe&$XM]\u0001\u0005_V$\b%\u0001\u0002j]V\t1\u0007\u0005\u0002*i%\u0011QG\u000b\u0002\u0012!&\u0004X\rZ(viB,Ho\u0015;sK\u0006l\u0017aA5oA\u00051A\u000f\u001b:fC\u0012,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y1\nA\u0001\\1oO&\u0011ah\u000f\u0002\u0007)\"\u0014X-\u00193\u0002\u0015QD'/Z1e?\u0012*\u0017\u000f\u0006\u0002B\u000fB\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n!QK\\5u\u0011\u001dAu!!AA\u0002e\n1\u0001\u001f\u00132\u0003\u001d!\bN]3bI\u0002\nqcQ(O\r~+\u0005,R\"V)>\u0013vl\u0011'B'N\u0003\u0016\t\u0016%\u0016\u00031\u0003\"AO'\n\u00059[$AB*ue&tw-\u0001\rD\u001f:3u,\u0012-F\u0007V#vJU0D\u0019\u0006\u001b6\u000bU!U\u0011\u0002\nAc\u001c7e\u000bb,7-\u001e;pe\u000ec\u0017m]:qCRD\u0017!F8mI\u0016CXmY;u_J\u001cE.Y:ta\u0006$\b\u000eI\u0001\nE\u00164wN]3BY2$\u0012!Q\u0001\tC\u001a$XM]!mY\u0006Iq/Y5u+:$\u0018\u000e\u001c\u000b\u0003\u0003^CQ\u0001W\bA\u0002e\u000bAaY8oIB\u0019!I\u0017/\n\u0005m\u001b%!\u0003$v]\u000e$\u0018n\u001c81!\t\u0011U,\u0003\u0002_\u0007\n9!i\\8mK\u0006t\u0017A\u0004:v]&sG/\u001a:qe\u0016$XM\u001d\u000b\u0003C.\u0004\"AY5\u000f\u0005\r<\u0007C\u00013D\u001b\u0005)'B\u00014\u001d\u0003\u0019a$o\\8u}%\u0011\u0001nQ\u0001\u0007!J,G-\u001a4\n\u00059S'B\u00015D\u0011\u0015a\u0007\u00031\u0001b\u0003\u0015Ig\u000e];u\u00039\t7o]3si\u000e{g\u000e^1j]N$2!Q8r\u0011\u0015\u0001\u0018\u00031\u0001b\u0003\u001diWm]:bO\u0016DQA]\tA\u0002\u0005\faa\\;uaV$\u0018\u0001F1tg\u0016\u0014H\u000fR8fg:{GoQ8oi\u0006Lg\u000eF\u0002BkZDQ\u0001\u001d\nA\u0002\u0005DQA\u001d\nA\u0002\u0005\u0004")
public class SingletonRepl2Suite
extends SparkFunSuite {
    private final StringWriter out = new StringWriter();
    private final PipedOutputStream in = new PipedOutputStream();
    private Thread thread;
    private final String CONF_EXECUTOR_CLASSPATH;
    private final String oldExecutorClasspath = System.getProperty(this.CONF_EXECUTOR_CLASSPATH());

    private StringWriter out() {
        return this.out;
    }

    private PipedOutputStream in() {
        return this.in;
    }

    private Thread thread() {
        return this.thread;
    }

    private void thread_$eq(Thread x$1) {
        this.thread = x$1;
    }

    private String CONF_EXECUTOR_CLASSPATH() {
        return this.CONF_EXECUTOR_CLASSPATH;
    }

    private String oldExecutorClasspath() {
        return this.oldExecutorClasspath;
    }

    public void beforeAll() {
        super.beforeAll();
        String classpath = System.getProperty("java.class.path");
        System.setProperty(this.CONF_EXECUTOR_CLASSPATH(), classpath);
        Main$.MODULE$.conf().set("spark.master", "local-cluster[2,1,1024]");
        SparkILoop interp = new SparkILoop(new BufferedReader(new InputStreamReader(new PipedInputStream(this.in()))), new PrintWriter(this.out()));
        Main$.MODULE$.sparkContext_$eq(null);
        Main$.MODULE$.sparkSession_$eq(null);
        this.thread_$eq(new Thread(() -> Main$.MODULE$.doMain((String[])((Object[])new String[]{"-classpath", classpath}), interp)));
        this.thread().setDaemon(true);
        this.thread().start();
        this.waitUntil((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.out().toString().contains("Type :help for more information"));
    }

    public void afterAll() {
        this.in().close();
        this.thread().join();
        String string = this.oldExecutorClasspath() != null ? System.setProperty(this.CONF_EXECUTOR_CLASSPATH(), this.oldExecutorClasspath()) : System.clearProperty(this.CONF_EXECUTOR_CLASSPATH());
        super.afterAll();
    }

    private void waitUntil(Function0<Object> cond) {
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).seconds())), Eventually$.MODULE$.interval(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(500)).millis())), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(cond.apply$mcZ$sp(), "cond.apply()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(16).append("current output: ").append(this.out().toString()).toString(), Prettifier$.MODULE$.default(), new Position("SingletonRepl2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        }, Retrying$.MODULE$.retryingNatureOfT(), new Position("SingletonRepl2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
    }

    public String runInterpreter(String input) {
        int currentOffset = this.out().getBuffer().length();
        long timestamp = System.currentTimeMillis();
        this.in().write(new StringBuilder(18).append(input).append("\nval _result_").append(timestamp).append(" = 1\n").toString().getBytes());
        this.in().flush();
        String stopMessage = new StringBuilder(17).append("_result_").append(timestamp).append(": Int = 1").toString();
        this.waitUntil((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.out().getBuffer().substring(currentOffset).contains(stopMessage));
        return this.out().getBuffer().substring(currentOffset);
    }

    public void assertContains(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(39).append("Interpreter output did not contain '").append(message).append("':\n").append(output).toString(), Prettifier$.MODULE$.default(), new Position("SingletonRepl2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
    }

    public void assertDoesNotContain(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(33).append("Interpreter output contained '").append(message).append("':\n").append(output).toString(), Prettifier$.MODULE$.default(), new Position("SingletonRepl2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }

    public SingletonRepl2Suite() {
        this.CONF_EXECUTOR_CLASSPATH = "spark.executor.extraClassPath";
        this.test("SPARK-31399: should clone+clean line object w/ non-serializable state in ClosureCleaner", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |class NotSerializableClass(val x: Int)\n        |val ns = new NotSerializableClass(42); val topLevelValue = \"someValue\"; val closure =\n        |(j: Int) => {\n        |  (1 to j).flatMap { x =>\n        |    (1 to x).map { y => y + topLevelValue }\n        |  }\n        |}\n        |val r = sc.parallelize(0 to 2).map(closure).collect\n      ")).stripMargin());
            this.assertContains("r: Array[scala.collection.immutable.IndexedSeq[String]] = Array(Vector(), Vector(1someValue), Vector(1someValue, 1someValue, 2someValue))", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("SingletonRepl2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("SPARK-31399: ClosureCleaner should discover indirectly nested closure in inner class", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreter(new StringOps(Predef$.MODULE$.augmentString("\n        |class NotSerializableClass(val x: Int)\n        |val ns = new NotSerializableClass(42); val topLevelValue = \"someValue\"; val closure =\n        |(j: Int) => {\n        |  class InnerFoo {\n        |    val innerClosure = (x: Int) => (1 to x).map { y => y + topLevelValue }\n        |  }\n        |  val innerFoo = new InnerFoo\n        |  (1 to j).flatMap(innerFoo.innerClosure)\n        |}\n        |val r = sc.parallelize(0 to 2).map(closure).collect\n      ")).stripMargin());
            this.assertContains("r: Array[scala.collection.immutable.IndexedSeq[String]] = Array(Vector(), Vector(1someValue), Vector(1someValue, 1someValue, 2someValue))", output);
            this.assertDoesNotContain("Array(Vector(), Vector(1null), Vector(1null, 1null, 2null)", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("SingletonRepl2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
    }
}

