/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction2;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005Ufa\u0002\u000e\u001c!\u0003\r\tC\n\u0005\u0006a\u0001!\t!\r\u0005\u0006k\u00011\tA\u000e\u0005\u0006\u0007\u00021\t\u0001\u0012\u0005\u0006\u0019\u0002!\t%\u0014\u0005\u0006-\u0002!\te\u0016\u0005\u00071\u00021\taH-\t\u000b\u0001\u0004A\u0011A1\t\u000b\u001d\u0004A\u0011\u00015\t\r1\u0004A\u0011A\u0010n\u0011\u0015\u0019\b\u0001\"\u0001u\u0011\u0019I\b\u0001\"\u0001 u\")A\u0010\u0001D\u0001m!1\u0011\u0011\u0001\u0001\u0007\u0002YBq!!\u0002\u0001\t\u0003\t9\u0001\u0003\u0005\u0002\u0012\u00011\taGA\n\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aa!!\n\u0001\t\u0003A\u0007BBA\u0015\u0001\u0019\u0005a\u0007C\u0004\u00022\u00011\t!a\r\t\u000f\u00055\u0003A\"\u0001\u0002P!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004\u0002CA9\u0001\u0011\u0005q$a\u001d\t\u0011\u00055\u0005A\"\u0001 \u0003gB\u0001\"a$\u0001\t\u0003y\u00121\u000f\u0005\t\u0003#\u0003A\u0011A\u0010\u0002\u0014\n1a+Z2u_JT!\u0001H\u000f\u0002\r1Lg.\u00197h\u0015\tqr$A\u0003nY2L'M\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011\u0001FL\u0005\u0003_%\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001J5oSR$C#\u0001\u001a\u0011\u0005!\u001a\u0014B\u0001\u001b*\u0005\u0011)f.\u001b;\u0002\tML'0Z\u000b\u0002oA\u0011\u0001\u0006O\u0005\u0003s%\u00121!\u00138uQ\r\u00111(\u0011\t\u0003y}j\u0011!\u0010\u0006\u0003}}\t!\"\u00198o_R\fG/[8o\u0013\t\u0001UHA\u0003TS:\u001cW-I\u0001C\u0003\u0015\td\u0006\r\u00181\u0003\u001d!x.\u0011:sCf,\u0012!\u0012\t\u0004Q\u0019C\u0015BA$*\u0005\u0015\t%O]1z!\tA\u0013*\u0003\u0002KS\t1Ai\\;cY\u0016D3aA\u001eB\u0003\u0019)\u0017/^1mgR\u0011a*\u0015\t\u0003Q=K!\u0001U\u0015\u0003\u000f\t{w\u000e\\3b]\")!\u000b\u0002a\u0001'\u0006)q\u000e\u001e5feB\u0011\u0001\u0006V\u0005\u0003+&\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#A\u001c\u0002\u0011\u0005\u001c(I]3fu\u0016,\u0012A\u0017\t\u00047~CU\"\u0001/\u000b\u0005qi&\"\u00010\u0002\r\t\u0014X-\u001a>f\u0013\tQB,A\u0003baBd\u0017\u0010\u0006\u0002IE\")1m\u0002a\u0001o\u0005\t\u0011\u000eK\u0002\bw\u0015\f\u0013AZ\u0001\u0006c9\nd\u0006M\u0001\u0005G>\u0004\u00180F\u0001j!\tQ\u0007!D\u0001\u001cQ\rA1(Z\u0001\bM>\u0014X-Y2i)\t\u0011d\u000eC\u0003p\u0013\u0001\u0007\u0001/A\u0001g!\u0015A\u0013o\u000e%3\u0013\t\u0011\u0018FA\u0005Gk:\u001cG/[8oe\u0005iam\u001c:fC\u000eD\u0017i\u0019;jm\u0016$\"AM;\t\u000b=T\u0001\u0019\u00019)\u0007)Yt/I\u0001y\u0003\u0015\tdF\u000e\u00181\u000391wN]3bG\"tuN\u001c.fe>$\"AM>\t\u000b=\\\u0001\u0019\u00019\u0002\u00159,X.Q2uSZ,7\u000fK\u0002\rwy\f\u0013a`\u0001\u0006c9\"d\u0006M\u0001\f]Vlgj\u001c8{KJ|7\u000fK\u0002\u000ewy\f\u0001\u0002^8Ta\u0006\u00148/Z\u000b\u0003\u0003\u0013\u00012A[A\u0006\u0013\r\tia\u0007\u0002\r'B\f'o]3WK\u000e$xN\u001d\u0015\u0004\u001dmr\u0018\u0001\u0005;p'B\f'o]3XSRD7+\u001b>f)\u0011\tI!!\u0006\t\r\u0005]q\u00021\u00018\u0003\rqgN_\u0001\bi>$UM\\:f+\t\ti\u0002E\u0002k\u0003?I1!!\t\u001c\u0005-!UM\\:f-\u0016\u001cGo\u001c:)\u0007AYd0\u0001\u0006d_6\u0004(/Z:tK\u0012D3!E\u001e\u007f\u0003\u0019\t'oZ7bq\"\"!cOA\u0017C\t\ty#A\u00032]Ur\u0003'\u0001\u0004u_*\u001bxN\\\u000b\u0003\u0003k\u0001B!a\u000e\u0002F9!\u0011\u0011HA!!\r\tY$K\u0007\u0003\u0003{Q1!a\u0010&\u0003\u0019a$o\\8u}%\u0019\u00111I\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\t9%!\u0013\u0003\rM#(/\u001b8h\u0015\r\t\u0019%\u000b\u0015\u0004'm:\u0018\u0001B1t\u001b2+\"!!\u0015\u0011\t\u0005M\u00131L\u0007\u0003\u0003+R1\u0001HA,\u0015\r\tIfH\u0001\u0003[2L1AGA+Q\u0011!2(a\u0018\"\u0005\u0005\u0005\u0014!\u0002\u001a/a9\u0002\u0014a\u00013piR\u0019\u0001*a\u001a\t\r\u0005%T\u00031\u0001j\u0003\u00051\b\u0006B\u000b<\u0003[\n#!a\u001c\u0002\u000bMr\u0003G\f\u0019\u0002\u0011%$XM]1u_J,\"!!\u001e\u0011\r\u0005]\u0014\u0011QAD\u001d\u0011\tI(! \u000f\t\u0005m\u00121P\u0005\u0002U%\u0019\u0011qP\u0015\u0002\u000fA\f7m[1hK&!\u00111QAC\u0005!IE/\u001a:bi>\u0014(bAA@SA)\u0001&!#8\u0011&\u0019\u00111R\u0015\u0003\rQ+\b\u000f\\33\u00039\t7\r^5wK&#XM]1u_J\fqB\\8o5\u0016\u0014x.\u0013;fe\u0006$xN]\u0001\tgB\f'o]5usR\t\u0001*K\u0003\u0001\u0003?\tY\u0001K\u0002\u0001w\u0005Cs\u0001AAN\u0003W\u000bi\u000b\u0005\u0003\u0002\u001e\u0006\u001dVBAAP\u0015\u0011\t\t+a)\u0002\u000bQL\b/Z:\u000b\u0007\u0005\u0015v$A\u0002tc2LA!!+\u0002 \n\u00112+\u0015'Vg\u0016\u0014H)\u001a4j]\u0016$G+\u001f9f\u0003\r)H\r^\u0012\u0003\u0003_\u00032A[AY\u0013\r\t\u0019l\u0007\u0002\n-\u0016\u001cGo\u001c:V\tR\u0003")
public interface Vector
extends scala.Serializable {
    public int size();

    public double[] toArray();

    public static /* synthetic */ boolean equals$(Vector $this, Object other) {
        return $this.equals(other);
    }

    default public boolean equals(Object other) {
        Object object = other;
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            if (this.size() != vector.size()) {
                return false;
            }
            Tuple2 tuple2 = new Tuple2((Object)this, (Object)vector);
            if (tuple2 != null) {
                Vector s1 = (Vector)tuple2._1();
                Vector s2 = (Vector)tuple2._2();
                if (s1 instanceof SparseVector) {
                    SparseVector sparseVector = (SparseVector)s1;
                    if (s2 instanceof SparseVector) {
                        SparseVector sparseVector2 = (SparseVector)s2;
                        return Vectors$.MODULE$.equals((IndexedSeq<Object>)Predef$.MODULE$.wrapIntArray(sparseVector.indices()), sparseVector.values(), (IndexedSeq<Object>)Predef$.MODULE$.wrapIntArray(sparseVector2.indices()), sparseVector2.values());
                    }
                }
            }
            if (tuple2 != null) {
                Vector s1 = (Vector)tuple2._1();
                Vector d1 = (Vector)tuple2._2();
                if (s1 instanceof SparseVector) {
                    SparseVector sparseVector = (SparseVector)s1;
                    if (d1 instanceof DenseVector) {
                        DenseVector denseVector = (DenseVector)d1;
                        return Vectors$.MODULE$.equals((IndexedSeq<Object>)Predef$.MODULE$.wrapIntArray(sparseVector.indices()), sparseVector.values(), (IndexedSeq<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), denseVector.size()), denseVector.values());
                    }
                }
            }
            if (tuple2 != null) {
                Vector d1 = (Vector)tuple2._1();
                Vector s1 = (Vector)tuple2._2();
                if (d1 instanceof DenseVector) {
                    DenseVector denseVector = (DenseVector)d1;
                    if (s1 instanceof SparseVector) {
                        SparseVector sparseVector = (SparseVector)s1;
                        return Vectors$.MODULE$.equals((IndexedSeq<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), denseVector.size()), denseVector.values(), (IndexedSeq<Object>)Predef$.MODULE$.wrapIntArray(sparseVector.indices()), sparseVector.values());
                    }
                }
            }
            if (tuple2 != null) {
                return Arrays.equals(this.toArray(), vector.toArray());
            }
            throw new MatchError((Object)tuple2);
        }
        return false;
    }

    public static /* synthetic */ int hashCode$(Vector $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        int n;
        Object object = new Object();
        try {
            IntRef result = IntRef.create((int)(31 + this.size()));
            IntRef nnz = IntRef.create((int)0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(index, value) -> {
                if (nnz$1.elem < Vectors$.MODULE$.MAX_HASH_NNZ()) {
                    if (value != 0.0) {
                        result$1.elem = 31 * result$1.elem + index;
                        long bits = Double.doubleToLongBits(value);
                        result$1.elem = 31 * result$1.elem + (int)(bits ^ bits >>> 32);
                        ++nnz$1.elem;
                        return;
                    }
                    return;
                }
                throw new NonLocalReturnControl.mcI.sp(object, result$1.elem);
            });
            n = result.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    public breeze.linalg.Vector<Object> asBreeze();

    public static /* synthetic */ double apply$(Vector $this, int i) {
        return $this.apply(i);
    }

    default public double apply(int i) {
        return this.asBreeze().apply$mcID$sp(i);
    }

    public static /* synthetic */ Vector copy$(Vector $this) {
        return $this.copy();
    }

    default public Vector copy() {
        throw new UnsupportedOperationException(new StringBuilder(29).append("copy is not implemented for ").append(this.getClass()).append(".").toString());
    }

    public static /* synthetic */ void foreach$(Vector $this, Function2 f) {
        $this.foreach((Function2<Object, Object, BoxedUnit>)f);
    }

    default public void foreach(Function2<Object, Object, BoxedUnit> f) {
        this.iterator().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Vector.$anonfun$foreach$1(f, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void foreachActive$(Vector $this, Function2 f) {
        $this.foreachActive((Function2<Object, Object, BoxedUnit>)f);
    }

    default public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        this.activeIterator().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Vector.$anonfun$foreachActive$1(f, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void foreachNonZero$(Vector $this, Function2 f) {
        $this.foreachNonZero((Function2<Object, Object, BoxedUnit>)f);
    }

    default public void foreachNonZero(Function2<Object, Object, BoxedUnit> f) {
        this.nonZeroIterator().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Vector.$anonfun$foreachNonZero$1(f, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public int numActives();

    public int numNonzeros();

    public static /* synthetic */ SparseVector toSparse$(Vector $this) {
        return $this.toSparse();
    }

    default public SparseVector toSparse() {
        return this.toSparseWithSize(this.numNonzeros());
    }

    public SparseVector toSparseWithSize(int var1);

    public static /* synthetic */ DenseVector toDense$(Vector $this) {
        return $this.toDense();
    }

    default public DenseVector toDense() {
        return new DenseVector(this.toArray());
    }

    public static /* synthetic */ Vector compressed$(Vector $this) {
        return $this.compressed();
    }

    default public Vector compressed() {
        int nnz = this.numNonzeros();
        if (1.5 * ((double)nnz + 1.0) < (double)this.size()) {
            return this.toSparseWithSize(nnz);
        }
        return this.toDense();
    }

    public int argmax();

    public String toJson();

    public org.apache.spark.ml.linalg.Vector asML();

    public static /* synthetic */ double dot$(Vector $this, Vector v) {
        return $this.dot(v);
    }

    default public double dot(Vector v) {
        return BLAS$.MODULE$.dot(this, v);
    }

    public static /* synthetic */ Iterator iterator$(Vector $this) {
        return $this.iterator();
    }

    default public Iterator<Tuple2<Object, Object>> iterator() {
        return package$.MODULE$.Iterator().tabulate(this.size(), (Function1 & Serializable & scala.Serializable)i -> Vector.$anonfun$iterator$1(this, BoxesRunTime.unboxToInt((Object)i)));
    }

    public Iterator<Tuple2<Object, Object>> activeIterator();

    public static /* synthetic */ Iterator nonZeroIterator$(Vector $this) {
        return $this.nonZeroIterator();
    }

    default public Iterator<Tuple2<Object, Object>> nonZeroIterator() {
        return this.activeIterator().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Vector.$anonfun$nonZeroIterator$1(x$1)));
    }

    public static /* synthetic */ double sparsity$(Vector $this) {
        return $this.sparsity();
    }

    default public double sparsity() {
        return 1.0 - (double)this.numNonzeros() / (double)this.size();
    }

    public static /* synthetic */ void $anonfun$foreach$1(Function2 f$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int i = tuple2._1$mcI$sp();
            double v = tuple2._2$mcD$sp();
            f$1.apply$mcVID$sp(i, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$foreachActive$1(Function2 f$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int i = tuple2._1$mcI$sp();
            double v = tuple2._2$mcD$sp();
            f$2.apply$mcVID$sp(i, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$foreachNonZero$1(Function2 f$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int i = tuple2._1$mcI$sp();
            double v = tuple2._2$mcD$sp();
            f$3.apply$mcVID$sp(i, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ Tuple2 $anonfun$iterator$1(Vector $this, int i) {
        return new Tuple2.mcID.sp(i, $this.apply(i));
    }

    public static /* synthetic */ boolean $anonfun$nonZeroIterator$1(Tuple2 x$1) {
        return x$1._2$mcD$sp() != 0.0;
    }

    public static void $init$(Vector $this) {
    }
}

