/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.MultilabelClassificationEvaluator$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.MultilabelMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u000e\u001d\u0001\u001dB\u0001\"\u0010\u0001\u0003\u0006\u0004%\tE\u0010\u0005\t+\u0002\u0011\t\u0011)A\u0005\u007f!)q\u000b\u0001C\u00011\")q\u000b\u0001C\u0001;\"9q\f\u0001b\u0001\n\u000b\u0001\u0007B\u00024\u0001A\u00035\u0011\rC\u0003i\u0001\u0011\u0005a\bC\u0003k\u0001\u0011\u00051\u000eC\u0004q\u0001\t\u0007IQA9\t\rY\u0004\u0001\u0015!\u0004s\u0011\u0015A\b\u0001\"\u0001z\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002t\u0001!\t%!\u001e\t\u000f\u0005\r\u0005\u0001\"\u0011\u0002\u0006\u001e9\u00111\u0013\u000f\t\u0002\u0005UeAB\u000e\u001d\u0011\u0003\t9\n\u0003\u0004X+\u0011\u0005\u00111\u0016\u0005\n\u0003[+\"\u0019!C\u0005\u0003_C\u0001\"a.\u0016A\u0003%\u0011\u0011\u0017\u0005\b\u0003s+B\u0011IA^\u0011%\t\u0019-FA\u0001\n\u0013\t)MA\u0011Nk2$\u0018\u000e\\1cK2\u001cE.Y:tS\u001aL7-\u0019;j_:,e/\u00197vCR|'O\u0003\u0002\u001e=\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005}\u0001\u0013AA7m\u0015\t\t#%A\u0003ta\u0006\u00148N\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0006\u0001!bCg\u000e\t\u0003S)j\u0011\u0001H\u0005\u0003Wq\u0011\u0011\"\u0012<bYV\fGo\u001c:\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014AB:iCJ,GM\u0003\u00022=\u0005)\u0001/\u0019:b[&\u00111G\f\u0002\u0011\u0011\u0006\u001c\bK]3eS\u000e$\u0018n\u001c8D_2\u0004\"!L\u001b\n\u0005Yr#a\u0003%bg2\u000b'-\u001a7D_2\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003ye\u0012Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW-A\u0002vS\u0012,\u0012a\u0010\t\u0003\u0001&s!!Q$\u0011\u0005\t+U\"A\"\u000b\u0005\u00113\u0013A\u0002\u001fs_>$hHC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAU)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%FQ\r\tQj\u0015\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0002\n!\"\u00198o_R\fG/[8o\u0013\t\u0011vJA\u0003TS:\u001cW-I\u0001U\u0003\u0015\u0019d\u0006\r\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\ti5+\u0001\u0004=S:LGO\u0010\u000b\u00033j\u0003\"!\u000b\u0001\t\u000bu\u001a\u0001\u0019A )\u0007ik5\u000bK\u0002\u0004\u001bN#\u0012!\u0017\u0015\u0004\t5\u001b\u0016AC7fiJL7MT1nKV\t\u0011\rE\u0002cG~j\u0011\u0001M\u0005\u0003IB\u0012Q\u0001U1sC6D3!B'T\u0003-iW\r\u001e:jG:\u000bW.\u001a\u0011)\u0007\u0019i5+A\u0007hKRlU\r\u001e:jG:\u000bW.\u001a\u0015\u0004\u000f5\u001b\u0016!D:fi6+GO]5d\u001d\u0006lW\r\u0006\u0002m[6\t\u0001\u0001C\u0003o\u0011\u0001\u0007q(A\u0003wC2,X\rK\u0002\t\u001bN\u000b1\"\\3ue&\u001cG*\u00192fYV\t!\u000f\u0005\u0002cg&\u0011A\u000f\r\u0002\f\t>,(\r\\3QCJ\fW\u000eK\u0002\n\u001bN\u000bA\"\\3ue&\u001cG*\u00192fY\u0002B3AC'T\u000399W\r^'fiJL7\rT1cK2,\u0012A\u001f\t\u0003wrl\u0011!R\u0005\u0003{\u0016\u0013a\u0001R8vE2,\u0007fA\u0006N'\u0006q1/\u001a;NKR\u0014\u0018n\u0019'bE\u0016dGc\u00017\u0002\u0004!)a\u000e\u0004a\u0001u\u0006\u00012/\u001a;Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0004Y\u0006%\u0001\"\u00028\u000e\u0001\u0004y\u0004fA\u0007N'\u0006Y1/\u001a;MC\n,GnQ8m)\ra\u0017\u0011\u0003\u0005\u0006]:\u0001\ra\u0010\u0015\u0004\u001d5\u001b\u0016\u0001C3wC2,\u0018\r^3\u0015\u0007i\fI\u0002C\u0004\u0002\u001c=\u0001\r!!\b\u0002\u000f\u0011\fG/Y:fiB\"\u0011qDA\u0018!\u0019\t\t#a\n\u0002,5\u0011\u00111\u0005\u0006\u0004\u0003K\u0001\u0013aA:rY&!\u0011\u0011FA\u0012\u0005\u001d!\u0015\r^1tKR\u0004B!!\f\u000201\u0001A\u0001DA\u0019\u00033\t\t\u0011!A\u0003\u0002\u0005M\"aA0%cE!\u0011QGA\u001e!\rY\u0018qG\u0005\u0004\u0003s)%a\u0002(pi\"Lgn\u001a\t\u0004w\u0006u\u0012bAA \u000b\n\u0019\u0011I\\=)\u0007=i5+\u0001\u0006hKRlU\r\u001e:jGN$B!a\u0012\u0002VA!\u0011\u0011JA)\u001b\t\tYEC\u0002\u001e\u0003\u001bR1!a\u0014!\u0003\u0015iG\u000e\\5c\u0013\u0011\t\u0019&a\u0013\u0003#5+H\u000e^5mC\n,G.T3ue&\u001c7\u000fC\u0004\u0002\u001cA\u0001\r!a\u00161\t\u0005e\u0013Q\f\t\u0007\u0003C\t9#a\u0017\u0011\t\u00055\u0012Q\f\u0003\r\u0003?\n)&!A\u0001\u0002\u000b\u0005\u00111\u0007\u0002\u0004?\u0012\u0012\u0004\u0006\u0002\tN\u0003G\n#!!\u001a\u0002\u000bMr\u0013G\f\u0019\u0002\u001d%\u001cH*\u0019:hKJ\u0014U\r\u001e;feV\u0011\u00111\u000e\t\u0004w\u00065\u0014bAA8\u000b\n9!i\\8mK\u0006t\u0007fA\tN'\u0006!1m\u001c9z)\rI\u0016q\u000f\u0005\b\u0003s\u0012\u0002\u0019AA>\u0003\u0015)\u0007\u0010\u001e:b!\r\u0011\u0017QP\u0005\u0004\u0003\u007f\u0002$\u0001\u0003)be\u0006lW*\u00199)\u0007Ii5+\u0001\u0005u_N#(/\u001b8h)\u0005y\u0004fA\nN'\"\u001a\u0001!a#\u0011\u00079\u000bi)C\u0002\u0002\u0010>\u0013A\"\u0012=qKJLW.\u001a8uC2D3\u0001A'T\u0003\u0005jU\u000f\u001c;jY\u0006\u0014W\r\\\"mCN\u001c\u0018NZ5dCRLwN\\#wC2,\u0018\r^8s!\tIScE\u0004\u0016\u00033\u000by*!*\u0011\u0007m\fY*C\u0002\u0002\u001e\u0016\u0013a!\u00118z%\u00164\u0007\u0003\u0002\u001d\u0002\"fK1!a):\u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042a_AT\u0013\r\tI+\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003+\u000bAc];qa>\u0014H/\u001a3NKR\u0014\u0018n\u0019(b[\u0016\u001cXCAAY!\u0011Y\u00181W \n\u0007\u0005UVIA\u0003BeJ\f\u00170A\u000btkB\u0004xN\u001d;fI6+GO]5d\u001d\u0006lWm\u001d\u0011\u0002\t1|\u0017\r\u001a\u000b\u00043\u0006u\u0006BBA`3\u0001\u0007q(\u0001\u0003qCRD\u0007fA\rN'\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\r\u0005\u0003\u0002J\u0006MWBAAf\u0015\u0011\ti-a4\u0002\t1\fgn\u001a\u0006\u0003\u0003#\fAA[1wC&!\u0011Q[Af\u0005\u0019y%M[3di\"\u001aQ#T*)\u0007Qi5\u000b")
public class MultilabelClassificationEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final DoubleParam metricLabel;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    public static MultilabelClassificationEvaluator load(String string) {
        return MultilabelClassificationEvaluator$.MODULE$.load(string);
    }

    public static MLReader<MultilabelClassificationEvaluator> read() {
        return MultilabelClassificationEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public final Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public MultilabelClassificationEvaluator setMetricName(String value) {
        return (MultilabelClassificationEvaluator)this.set(this.metricName(), value);
    }

    public final DoubleParam metricLabel() {
        return this.metricLabel;
    }

    public double getMetricLabel() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel()));
    }

    public MultilabelClassificationEvaluator setMetricLabel(double value) {
        return (MultilabelClassificationEvaluator)this.set(this.metricLabel(), BoxesRunTime.boxToDouble((double)value));
    }

    public MultilabelClassificationEvaluator setPredictionCol(String value) {
        return (MultilabelClassificationEvaluator)this.set(this.predictionCol(), value);
    }

    public MultilabelClassificationEvaluator setLabelCol(String value) {
        return (MultilabelClassificationEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        MultilabelMetrics metrics = this.getMetrics(dataset);
        String string = this.$(this.metricName());
        if ("subsetAccuracy".equals(string)) {
            return metrics.subsetAccuracy();
        }
        if ("accuracy".equals(string)) {
            return metrics.accuracy();
        }
        if ("hammingLoss".equals(string)) {
            return metrics.hammingLoss();
        }
        if ("precision".equals(string)) {
            return metrics.precision();
        }
        if ("recall".equals(string)) {
            return metrics.recall();
        }
        if ("f1Measure".equals(string)) {
            return metrics.f1Measure();
        }
        if ("precisionByLabel".equals(string)) {
            return metrics.precision(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
        }
        if ("recallByLabel".equals(string)) {
            return metrics.recall(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
        }
        if ("f1MeasureByLabel".equals(string)) {
            return metrics.f1Measure(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
        }
        if ("microPrecision".equals(string)) {
            return metrics.microPrecision();
        }
        if ("microRecall".equals(string)) {
            return metrics.microRecall();
        }
        if ("microF1Measure".equals(string)) {
            return metrics.microF1Measure();
        }
        throw new MatchError((Object)string);
    }

    public MultilabelMetrics getMetrics(Dataset<?> dataset) {
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.predictionCol()), (Seq<DataType>)((Seq)new .colon.colon((Object)new ArrayType((DataType)DoubleType$.MODULE$, false), (List)new .colon.colon((Object)new ArrayType((DataType)DoubleType$.MODULE$, true), (List)Nil$.MODULE$))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.labelCol()), (Seq<DataType>)((Seq)new .colon.colon((Object)new ArrayType((DataType)DoubleType$.MODULE$, false), (List)new .colon.colon((Object)new ArrayType((DataType)DoubleType$.MODULE$, true), (List)Nil$.MODULE$))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        RDD predictionAndLabels = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), functions$.MODULE$.col(this.$(this.labelCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)row -> new Tuple2(row.getSeq(0).toArray(ClassTag$.MODULE$.Double()), row.getSeq(1).toArray(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(Tuple2.class));
        return new MultilabelMetrics((RDD<Tuple2<double[], double[]>>)predictionAndLabels);
    }

    @Override
    public boolean isLargerBetter() {
        String string = this.$(this.metricName());
        return !"hammingLoss".equals(string);
    }

    @Override
    public MultilabelClassificationEvaluator copy(ParamMap extra) {
        return (MultilabelClassificationEvaluator)this.defaultCopy(extra);
    }

    @Override
    public String toString() {
        return new StringBuilder(66).append("MultilabelClassificationEvaluator: uid=").append(this.uid()).append(", metricName=").append((Object)this.$(this.metricName())).append(", ").append("metricLabel=").append(this.$(this.metricLabel())).toString();
    }

    public MultilabelClassificationEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(MultilabelClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MultilabelClassificationEvaluator$$supportedMetricNames());
        this.metricName = new Param(this, "metricName", new StringBuilder(26).append("metric name in evaluation ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MultilabelClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MultilabelClassificationEvaluator$$supportedMetricNames())).mkString("(", "|", ")")).toString(), allowedParams);
        this.metricLabel = new DoubleParam((Identifiable)this, "metricLabel", new StringBuilder(82).append("The class whose metric will be computed in ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MultilabelClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MultilabelClassificationEvaluator$$supportedMetricNames())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.endsWith("ByLabel"))))).mkString("(", "|", ")")).append(". ").append("Must be >= 0. The default value is 0.").toString(), (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricLabel().$minus$greater(BoxesRunTime.boxToDouble((double)0.0)), this.metricName().$minus$greater("f1Measure")}));
    }

    public MultilabelClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("mlcEval"));
    }
}

