/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.ml.feature.StandardScalerModel;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;

public final class StandardScalerModel$
implements MLReadable<StandardScalerModel>,
Serializable {
    public static StandardScalerModel$ MODULE$;

    static {
        new StandardScalerModel$();
    }

    @Override
    public MLReader<StandardScalerModel> read() {
        return new StandardScalerModel.StandardScalerModelReader();
    }

    @Override
    public StandardScalerModel load(String path) {
        return (StandardScalerModel)MLReadable.load$(this, path);
    }

    public double[] transformWithBoth(double[] shift, double[] scale, double[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = (values[i] - shift[i]) * scale[i];
        }
        return values;
    }

    public double[] transformWithShift(double[] shift, double[] values) {
        for (int i = 0; i < values.length; ++i) {
            int n = i;
            values[n] = values[n] - shift[i];
        }
        return values;
    }

    public double[] transformDenseWithScale(double[] scale, double[] values) {
        for (int i = 0; i < values.length; ++i) {
            int n = i;
            values[n] = values[n] * scale[i];
        }
        return values;
    }

    public double[] transformSparseWithScale(double[] scale, int[] indices, double[] values) {
        for (int i = 0; i < values.length; ++i) {
            int n = i;
            values[n] = values[n] * scale[indices[i]];
        }
        return values;
    }

    public Function1<Vector, Vector> getTransformFunc(double[] shift, double[] scale, boolean withShift, boolean withScale) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(withShift, withScale);
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return (Function1 & java.io.Serializable & Serializable)vector -> {
                    double[] dArray;
                    Vector vector2 = vector;
                    if (vector2 instanceof DenseVector) {
                        DenseVector denseVector = (DenseVector)vector2;
                        dArray = (double[])denseVector.values().clone();
                    } else if (vector2 != null) {
                        Vector vector3 = vector2;
                        dArray = vector3.toArray();
                    } else {
                        throw new MatchError((Object)vector2);
                    }
                    double[] values = dArray;
                    double[] newValues = MODULE$.transformWithBoth(shift, scale, values);
                    return Vectors$.MODULE$.dense(newValues);
                };
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return (Function1 & java.io.Serializable & Serializable)vector -> {
                    double[] dArray;
                    Vector vector2 = vector;
                    if (vector2 instanceof DenseVector) {
                        DenseVector denseVector = (DenseVector)vector2;
                        dArray = (double[])denseVector.values().clone();
                    } else if (vector2 != null) {
                        Vector vector3 = vector2;
                        dArray = vector3.toArray();
                    } else {
                        throw new MatchError((Object)vector2);
                    }
                    double[] values = dArray;
                    double[] newValues = MODULE$.transformWithShift(shift, values);
                    return Vectors$.MODULE$.dense(newValues);
                };
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl4 = sp2._2$mcZ$sp();
            if (!bl && bl4) {
                return (Function1 & java.io.Serializable & Serializable)vector -> {
                    SparseVector sparseVector;
                    Option option;
                    DenseVector denseVector;
                    Option option2;
                    Vector vector2 = vector;
                    if (vector2 instanceof DenseVector && !(option2 = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector2)).isEmpty()) {
                        double[] values = (double[])option2.get();
                        double[] newValues = MODULE$.transformDenseWithScale(scale, (double[])values.clone());
                        return Vectors$.MODULE$.dense(newValues);
                    }
                    if (vector2 instanceof SparseVector && !(option = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector2)).isEmpty()) {
                        int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._1());
                        int[] indices = (int[])((Tuple3)option.get())._2();
                        double[] values = (double[])((Tuple3)option.get())._3();
                        double[] newValues = MODULE$.transformSparseWithScale(scale, indices, (double[])values.clone());
                        return Vectors$.MODULE$.sparse(size, indices, newValues);
                    }
                    throw new IllegalArgumentException(new StringBuilder(21).append("Unknown vector type ").append(vector2.getClass()).append(".").toString());
                };
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (!bl && !bl5) {
                return (Function1 & java.io.Serializable & Serializable)vector -> vector;
            }
        }
        throw new MatchError((Object)sp2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StandardScalerModel$() {
        MODULE$ = this;
        MLReadable.$init$(this);
    }
}

