/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.visitors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sparkproject.dmg.pmml.Field;
import org.sparkproject.dmg.pmml.FieldName;
import org.sparkproject.dmg.pmml.LocalTransformations;
import org.sparkproject.dmg.pmml.Model;
import org.sparkproject.dmg.pmml.Output;
import org.sparkproject.dmg.pmml.OutputField;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.Predicate;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.mining.MiningModel;
import org.sparkproject.dmg.pmml.mining.Segment;
import org.sparkproject.dmg.pmml.mining.Segmentation;
import org.sparkproject.jpmml.model.visitors.DeepFieldResolver;
import org.sparkproject.jpmml.model.visitors.FieldReferenceFinder;
import org.sparkproject.jpmml.model.visitors.FieldUtil;

public class DeepFieldResolverUtil {
    private DeepFieldResolverUtil() {
    }

    public static Set<Field<?>> getActiveFields(DeepFieldResolver resolver, MiningModel miningModel) {
        Set<Field<?>> modelFields = DeepFieldResolverUtil.getModelFields(resolver, miningModel);
        HashSet activeFields = new HashSet();
        Segmentation segmentation = miningModel.getSegmentation();
        List<Segment> segments = segmentation.getSegments();
        for (Segment segment : segments) {
            Set<FieldName> names;
            Predicate predicate = segment.getPredicate();
            if (predicate == null || (names = DeepFieldResolverUtil.getFieldNames(predicate)).size() <= 0) continue;
            Set<Field<?>> segmentFields = resolver.getFields(miningModel, segmentation, segment);
            activeFields.addAll(FieldUtil.selectAll(segmentFields, names));
        }
        Output output = miningModel.getOutput();
        if (output != null) {
            Set<FieldName> names = DeepFieldResolverUtil.getFieldNames(output);
            if (names.size() > 0) {
                activeFields.addAll(FieldUtil.selectAll(modelFields, names));
            }
            activeFields.removeAll(output.getOutputFields());
        }
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.getMultipleModelMethod();
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                Set<Field<Field<?>>> segmentationFields = resolver.getFields(miningModel, segmentation);
                segmentationFields.removeAll(modelFields);
                activeFields.removeAll(segmentationFields);
                break;
            }
        }
        return activeFields;
    }

    public static Set<Field<?>> getActiveFields(DeepFieldResolver resolver, Model model) {
        Set<Field<?>> modelFields = DeepFieldResolverUtil.getModelFields(resolver, model);
        FieldReferenceFinder fieldReferenceFinder = new FieldReferenceFinder(){

            @Override
            public VisitorAction visit(LocalTransformations localTransformations) {
                return VisitorAction.SKIP;
            }
        };
        fieldReferenceFinder.applyTo(model);
        Set<Field<OutputField>> activeFields = FieldUtil.selectAll(modelFields, fieldReferenceFinder.getFieldNames());
        Output output = model.getOutput();
        if (output != null) {
            activeFields.removeAll(output.getOutputFields());
        }
        return activeFields;
    }

    private static Set<Field<?>> getModelFields(DeepFieldResolver resolver, Model model) {
        Output output = model.getOutput();
        if (output != null && output.hasOutputFields()) {
            return resolver.getFields(model, output);
        }
        return resolver.getFields(model);
    }

    private static Set<FieldName> getFieldNames(PMMLObject object) {
        FieldReferenceFinder fieldReferenceFinder = new FieldReferenceFinder();
        fieldReferenceFinder.applyTo(object);
        return fieldReferenceFinder.getFieldNames();
    }
}

