/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.mllib.stat.KernelDensity$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\t\u0013\u0001uAQa\n\u0001\u0005\u0002!Bqa\u000b\u0001A\u0002\u0013%A\u0006C\u00041\u0001\u0001\u0007I\u0011B\u0019\t\r]\u0002\u0001\u0015)\u0003.\u0011%A\u0004\u00011AA\u0002\u0013%\u0011\bC\u0005A\u0001\u0001\u0007\t\u0019!C\u0005\u0003\"I1\t\u0001a\u0001\u0002\u0003\u0006KA\u000f\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006#\u0002!\tA\u0015\u0005\u0006#\u0002!\t!\u0016\u0005\u0006M\u0002!\taZ\u0004\u0006_JAI\u0001\u001d\u0004\u0006#IAI!\u001d\u0005\u0006O5!\tA\u001d\u0005\u0006g6!\t\u0001\u001e\u0005\b{6\t\t\u0011\"\u0003\u007f\u00055YUM\u001d8fY\u0012+gn]5us*\u00111\u0003F\u0001\u0005gR\fGO\u0003\u0002\u0016-\u0005)Q\u000e\u001c7jE*\u0011q\u0003G\u0001\u0006gB\f'o\u001b\u0006\u00033i\ta!\u00199bG\",'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0015J!A\n\u0011\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005\u0011\u0012!\u00032b]\u0012<\u0018\u000e\u001a;i+\u0005i\u0003CA\u0010/\u0013\ty\u0003E\u0001\u0004E_V\u0014G.Z\u0001\u000eE\u0006tGm^5ei\"|F%Z9\u0015\u0005I*\u0004CA\u00104\u0013\t!\u0004E\u0001\u0003V]&$\bb\u0002\u001c\u0004\u0003\u0003\u0005\r!L\u0001\u0004q\u0012\n\u0014A\u00032b]\u0012<\u0018\u000e\u001a;iA\u000511/Y7qY\u0016,\u0012A\u000f\t\u0004wyjS\"\u0001\u001f\u000b\u0005u2\u0012a\u0001:eI&\u0011q\b\u0010\u0002\u0004%\u0012#\u0015AC:b[BdWm\u0018\u0013fcR\u0011!G\u0011\u0005\bm\u0019\t\t\u00111\u0001;\u0003\u001d\u0019\u0018-\u001c9mK\u0002\nAb]3u\u0005\u0006tGm^5ei\"$\"AR$\u000e\u0003\u0001AQa\u000b\u0005A\u00025B3\u0001C%P!\tQU*D\u0001L\u0015\tae#\u0001\u0006b]:|G/\u0019;j_:L!AT&\u0003\u000bMKgnY3\"\u0003A\u000bQ!\r\u00185]A\n\u0011b]3u'\u0006l\u0007\u000f\\3\u0015\u0005\u0019\u001b\u0006\"\u0002\u001d\n\u0001\u0004Q\u0004fA\u0005J\u001fR\u0011aI\u0016\u0005\u0006q)\u0001\ra\u0016\t\u00041v{V\"A-\u000b\u0005i[\u0016\u0001\u00026bm\u0006T!\u0001\u0018\f\u0002\u0007\u0005\u0004\u0018.\u0003\u0002_3\n9!*\u0019<b%\u0012#\u0005C\u00011e\u001b\u0005\t'B\u00012d\u0003\u0011a\u0017M\\4\u000b\u0003iK!aL1)\u0007)Iu*\u0001\u0005fgRLW.\u0019;f)\tA7\u000eE\u0002 S6J!A\u001b\u0011\u0003\u000b\u0005\u0013(/Y=\t\u000b1\\\u0001\u0019\u00015\u0002\rA|\u0017N\u001c;tQ\rY\u0011j\u0014\u0015\u0004\u0001%{\u0015!D&fe:,G\u000eR3og&$\u0018\u0010\u0005\u0002+\u001bM\u0019QB\b\u0013\u0015\u0003A\fqA\\8s[B#g\rF\u0003.k^L8\u0010C\u0003w\u001f\u0001\u0007Q&\u0001\u0003nK\u0006t\u0007\"\u0002=\u0010\u0001\u0004i\u0013!E:uC:$\u0017M\u001d3EKZL\u0017\r^5p]\")!p\u0004a\u0001[\u0005\u0011Cn\\4Ti\u0006tG-\u0019:e\t\u00164\u0018.\u0019;j_:\u0004F.^:IC24Gj\\43!&DQ\u0001`\bA\u00025\n\u0011\u0001_\u0001\fe\u0016\fGMU3t_24X\rF\u0001\u0000!\r\u0001\u0017\u0011A\u0005\u0004\u0003\u0007\t'AB(cU\u0016\u001cG\u000f")
public class KernelDensity
implements Serializable {
    private double bandwidth = 1.0;
    private RDD<Object> sample;

    public static double normPdf(double d, double d2, double d3, double d4) {
        return KernelDensity$.MODULE$.normPdf(d, d2, d3, d4);
    }

    private double bandwidth() {
        return this.bandwidth;
    }

    private void bandwidth_$eq(double x$1) {
        this.bandwidth = x$1;
    }

    private RDD<Object> sample() {
        return this.sample;
    }

    private void sample_$eq(RDD<Object> x$1) {
        this.sample = x$1;
    }

    public KernelDensity setBandwidth(double bandwidth) {
        Predef$.MODULE$.require(bandwidth > 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append("Bandwidth must be positive, but got ").append(bandwidth).append(".").toString());
        this.bandwidth_$eq(bandwidth);
        return this;
    }

    public KernelDensity setSample(RDD<Object> sample) {
        this.sample_$eq(sample);
        return this;
    }

    public KernelDensity setSample(JavaRDD<Double> sample) {
        this.sample_$eq((RDD<Object>)sample.rdd());
        return this;
    }

    public double[] estimate(double[] points) {
        RDD<Object> sample = this.sample();
        double bandwidth = this.bandwidth();
        Predef$.MODULE$.require(sample != null, (Function0 & java.io.Serializable & Serializable)() -> "Must set sample before calling estimate.");
        int n = points.length;
        double logStandardDeviationPlusHalfLog2Pi = package$.MODULE$.log(bandwidth) + 0.5 * package$.MODULE$.log(Math.PI * 2);
        Tuple2 tuple2 = (Tuple2)sample.aggregate((Object)new Tuple2((Object)new double[n], (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & java.io.Serializable & Serializable)(x, y) -> KernelDensity.$anonfun$estimate$2(n, bandwidth, logStandardDeviationPlusHalfLog2Pi, points, x, BoxesRunTime.unboxToDouble((Object)y)), (Function2 & java.io.Serializable & Serializable)(x, y) -> {
            BLAS$.MODULE$.nativeBLAS().daxpy(n, 1.0, (double[])y._1(), 1, (double[])x._1(), 1);
            return new Tuple2(x._1(), (Object)BoxesRunTime.boxToLong((long)(x._2$mcJ$sp() + y._2$mcJ$sp())));
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double[] densities = (double[])tuple2._1();
        long count = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)densities, (Object)BoxesRunTime.boxToLong((long)count));
        double[] densities2 = (double[])tuple22._1();
        long count2 = tuple22._2$mcJ$sp();
        BLAS$.MODULE$.nativeBLAS().dscal(n, 1.0 / (double)count2, densities2, 1);
        return densities2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$estimate$2(int n$1, double bandwidth$2, double logStandardDeviationPlusHalfLog2Pi$1, double[] points$1, Tuple2 x, double y) {
        for (int i = 0; i < n$1; ++i) {
            int n = i;
            ((double[])x._1())[n] = ((double[])x._1())[n] + KernelDensity$.MODULE$.normPdf(y, bandwidth$2, logStandardDeviationPlusHalfLog2Pi$1, points$1[i]);
        }
        return new Tuple2(x._1(), (Object)BoxesRunTime.boxToLong((long)(x._2$mcJ$sp() + 1L)));
    }
}

