/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasLoss;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.LinearRegressionModel$;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.GeneralMLWritable;
import org.apache.spark.ml.util.GeneralMLWriter;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0010!\u0001-B\u0001B\u0012\u0001\u0003\u0006\u0004%\te\u0012\u0005\t=\u0002\u0011\t\u0011)A\u0005\u0011\"A\u0001\r\u0001BC\u0002\u0013\u0005\u0011\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u00031\u0011!9\u0007A!b\u0001\n\u0003A\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u0011I\u0004!Q1A\u0005\u0002!D\u0001B\u001e\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\u0007q\u0002!\tAI=\t\u000fa\u0004A\u0011\u0001\u0012\u0002\u0006!I\u0011Q\u0002\u0001C\u0002\u0013\u0005\u0013q\u0002\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0012!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\t\u0003/\u0002A\u0011\u0001\u0011\u0002Z!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA5\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003\u007f\u0002A\u0011IAA\u0011\u001d\ty\t\u0001C!\u0003#;q!a'!\u0011\u0003\tiJ\u0002\u0004 A!\u0005\u0011q\u0014\u0005\u0007qV!\t!a-\t\u000f\u0005UV\u0003\"\u0011\u00028\"9\u0011\u0011Y\u000b\u0005B\u0005\rgABAf+\u0011\ti\r\u0003\u0004y3\u0011\u0005\u0011q\u001a\u0005\n\u0003+L\"\u0019!C\u0005\u0003/D\u0001\"a:\u001aA\u0003%\u0011\u0011\u001c\u0005\b\u0003\u0003LB\u0011IAu\u0011%\ti/FA\u0001\n\u0013\tyOA\u000bMS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\u0005\u0012\u0013A\u0003:fOJ,7o]5p]*\u00111\u0005J\u0001\u0003[2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\u0015\u0001Af\u000e\u001eA!\u0011ic\u0006\r\u001c\u000e\u0003\u0001J!a\f\u0011\u0003\u001fI+wM]3tg&|g.T8eK2\u0004\"!\r\u001b\u000e\u0003IR!a\r\u0012\u0002\r1Lg.\u00197h\u0013\t)$G\u0001\u0004WK\u000e$xN\u001d\t\u0003[\u0001\u0001\"!\f\u001d\n\u0005e\u0002#A\u0006'j]\u0016\f'OU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\u0012\u0013\u0001B;uS2L!a\u0010\u001f\u0003#\u001d+g.\u001a:bY6cuK]5uC\ndW\rE\u0002<\u0003\u000eK!A\u0011\u001f\u0003%!\u000b7\u000f\u0016:bS:LgnZ*v[6\f'/\u001f\t\u0003[\u0011K!!\u0012\u0011\u0003?1Kg.Z1s%\u0016<'/Z:tS>tGK]1j]&twmU;n[\u0006\u0014\u00180A\u0002vS\u0012,\u0012\u0001\u0013\t\u0003\u0013Js!A\u0013)\u0011\u0005-sU\"\u0001'\u000b\u00055S\u0013A\u0002\u001fs_>$hHC\u0001P\u0003\u0015\u00198-\u00197b\u0013\t\tf*\u0001\u0004Qe\u0016$WMZ\u0005\u0003'R\u0013aa\u0015;sS:<'BA)OQ\r\ta\u000b\u0018\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u0012\n!\"\u00198o_R\fG/[8o\u0013\tY\u0006LA\u0003TS:\u001cW-I\u0001^\u0003\u0015\td\u0006\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t1F,\u0001\u0007d_\u00164g-[2jK:$8/F\u00011Q\r\u0019akY\u0011\u0002I\u0006)!G\f\u0019/a\u0005i1m\\3gM&\u001c\u0017.\u001a8ug\u0002B3\u0001\u0002,d\u0003%Ig\u000e^3sG\u0016\u0004H/F\u0001j!\tQ7.D\u0001O\u0013\tagJ\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u000bYs\u0017%A8\u0002\u000bEr3G\f\u0019\u0002\u0015%tG/\u001a:dKB$\b\u0005K\u0002\u0007-:\fQa]2bY\u0016D3a\u0002,uC\u0005)\u0018!\u0002\u001a/g9\u0002\u0014AB:dC2,\u0007\u0005K\u0002\t-R\fa\u0001P5oSRtDC\u0002\u001c{yz\f\t\u0001C\u0003G\u0013\u0001\u0007\u0001\nK\u0002{-rCQ\u0001Y\u0005A\u0002AB3\u0001 ,d\u0011\u00159\u0017\u00021\u0001jQ\rqhK\u001c\u0005\u0006e&\u0001\r!\u001b\u0015\u0005\u0003\u00031F\u000fF\u00047\u0003\u000f\tI!a\u0003\t\u000b\u0019S\u0001\u0019\u0001%\t\u000b\u0001T\u0001\u0019\u0001\u0019\t\u000b\u001dT\u0001\u0019A5\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0003\u0003#\u00012A[A\n\u0013\r\t)B\u0014\u0002\u0004\u0013:$\u0018\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0013aB:v[6\f'/_\u000b\u0002\u0007\"\"QBVA\u0010C\t\t\t#A\u00032]Ur\u0003'\u0001\u0005fm\u0006dW/\u0019;f)\u0011\t9#!\f\u0011\u00075\nI#C\u0002\u0002,\u0001\u0012q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Tk6l\u0017M]=\t\u000f\u0005=b\u00021\u0001\u00022\u00059A-\u0019;bg\u0016$\b\u0007BA\u001a\u0003\u0007\u0002b!!\u000e\u0002<\u0005}RBAA\u001c\u0015\r\tI\u0004J\u0001\u0004gFd\u0017\u0002BA\u001f\u0003o\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u0002B\u0005\rC\u0002\u0001\u0003\r\u0003\u000b\ni#!A\u0001\u0002\u000b\u0005\u0011q\t\u0002\u0004?\u0012\"\u0014\u0003BA%\u0003\u001f\u00022A[A&\u0013\r\tiE\u0014\u0002\b\u001d>$\b.\u001b8h!\rQ\u0017\u0011K\u0005\u0004\u0003'r%aA!os\"\u001aaBV2\u0002A\u0019Lg\u000eZ*v[6\f'/_'pI\u0016d\u0017I\u001c3Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0003\u00037\u0002RA[A/m!K1!a\u0018O\u0005\u0019!V\u000f\u001d7fe\u00059\u0001O]3eS\u000e$HcA5\u0002f!1\u0011q\r\tA\u0002A\n\u0001BZ3biV\u0014Xm]\u0001\u0005G>\u0004\u0018\u0010F\u00027\u0003[Bq!a\u001c\u0012\u0001\u0004\t\t(A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9HI\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003w\n)H\u0001\u0005QCJ\fW.T1qQ\r\tb\u000bX\u0001\u0006oJLG/Z\u000b\u0003\u0003\u0007\u00032aOAC\u0013\r\t9\t\u0010\u0002\u0010\u000f\u0016tWM]1m\u001b2;&/\u001b;fe\"\"!CVAFC\t\ti)A\u00032]Yr\u0003'\u0001\u0005u_N#(/\u001b8h)\u0005A\u0005\u0006B\nW\u0003+\u000b#!a&\u0002\u000bMr\u0003G\f\u0019)\u0007\u00011f.A\u000bMS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7\u0011\u00055*2cB\u000b\u0002\"\u0006\u001d\u0016Q\u0016\t\u0004U\u0006\r\u0016bAAS\u001d\n1\u0011I\\=SK\u001a\u0004BaOAUm%\u0019\u00111\u0016\u001f\u0003\u00155c%+Z1eC\ndW\rE\u0002k\u0003_K1!!-O\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\ti*\u0001\u0003sK\u0006$WCAA]!\u0011Y\u00141\u0018\u001c\n\u0007\u0005uFH\u0001\u0005N\u0019J+\u0017\rZ3sQ\u00119b+a#\u0002\t1|\u0017\r\u001a\u000b\u0004m\u0005\u0015\u0007BBAd1\u0001\u0007\u0001*\u0001\u0003qCRD\u0007\u0006\u0002\rW\u0003\u0017\u00131\u0004T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GNU3bI\u0016\u00148cA\r\u0002:R\u0011\u0011\u0011\u001b\t\u0004\u0003'LR\"A\u000b\u0002\u0013\rd\u0017m]:OC6,WCAAm!\u0011\tY.!:\u000e\u0005\u0005u'\u0002BAp\u0003C\fA\u0001\\1oO*\u0011\u00111]\u0001\u0005U\u00064\u0018-C\u0002T\u0003;\f!b\u00197bgNt\u0015-\\3!)\r1\u00141\u001e\u0005\u0007\u0003\u000fl\u0002\u0019\u0001%\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003c\u0004B!a7\u0002t&!\u0011Q_Ao\u0005\u0019y%M[3di\"\"QCVAFQ\u0011!b+a#")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams,
GeneralMLWritable,
HasTrainingSummary<LinearRegressionTrainingSummary> {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private final int numFeatures;
    private Option<LinearRegressionTrainingSummary> trainingSummary;
    private final Param<String> solver;
    private final Param<String> loss;
    private final DoubleParam epsilon;
    private final DoubleParam maxBlockSizeInMB;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static LinearRegressionModel load(String string) {
        return LinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LinearRegressionModel> read() {
        return LinearRegressionModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LinearRegressionTrainingSummary> setSummary(Option<LinearRegressionTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$LinearRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double getEpsilon() {
        return LinearRegressionParams.getEpsilon$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LinearRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final String getLoss() {
        return HasLoss.getLoss$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Option<LinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<String> loss() {
        return this.loss;
    }

    @Override
    public final DoubleParam epsilon() {
        return this.epsilon;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$loss_$eq(Param<String> x$1) {
        this.loss = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$LinearRegressionParams$_setter_$epsilon_$eq(DoubleParam x$1) {
        this.epsilon = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasLoss$_setter_$loss_$eq(Param<String> x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public LinearRegressionTrainingSummary summary() {
        return (LinearRegressionTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public LinearRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple2<LinearRegressionModel, String> tuple2 = this.findSummaryModelAndPredictionCol();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
        String predictionColName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
        LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple22._1();
        String predictionColName2 = (String)tuple22._2();
        return new LinearRegressionSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), summaryModel2, new double[]{0.0});
    }

    public Tuple2<LinearRegressionModel, String> findSummaryModelAndPredictionCol() {
        String string = this.$(this.predictionCol());
        if ("".equals(string)) {
            String predictionColName = new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString();
            return new Tuple2(this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(predictionColName), (Object)predictionColName);
        }
        return new Tuple2((Object)this, (Object)string);
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept();
    }

    @Override
    public LinearRegressionModel copy(ParamMap extra) {
        LinearRegressionModel newModel = this.copyValues(new LinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (LinearRegressionModel)((Model)((Object)newModel.setSummary(this.trainingSummary()))).setParent(this.parent());
    }

    @Override
    public GeneralMLWriter write() {
        return new GeneralMLWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(41).append("LinearRegressionModel: uid=").append(this.uid()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    public LinearRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasSolver.$init$(this);
        HasAggregationDepth.$init$(this);
        HasLoss.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LinearRegressionParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        this.numFeatures = coefficients.size();
    }

    public LinearRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, coefficients, intercept, 1.0);
    }

    private static class LinearRegressionModelReader
    extends MLReader<LinearRegressionModel> {
        private final String className = LinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LinearRegressionModel load(String path) {
            LinearRegressionModel linearRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Vector vector;
                double d;
                Object scale;
                block12: {
                    Row row;
                    block11: {
                        Dataset data;
                        block7: {
                            double d2;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int majorVersion = tuple2._1$mcI$sp();
                                    int minorVersion = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(majorVersion, minorVersion);
                                    int majorVersion2 = sp2._1$mcI$sp();
                                    int minorVersion2 = sp2._2$mcI$sp();
                                    if (majorVersion2 >= 2 && (majorVersion2 != 2 || minorVersion2 > 2)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
                                    Some some = Row$.MODULE$.unapplySeq(row2);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block8;
                                    Object intercept = ((SeqLike)some.get()).apply(0);
                                    coefficients = ((SeqLike)some.get()).apply(1);
                                    if (!(intercept instanceof Double)) break block8;
                                    d2 = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)d2), (Object)vector2);
                            double intercept = tuple2._1$mcD$sp();
                            Vector coefficients2 = (Vector)tuple2._2();
                            linearRegressionModel = new LinearRegressionModel(metadata.uid(), coefficients2, intercept);
                            break block10;
                        }
                        row = (Row)data.select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients", "scale"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block11;
                        Object intercept = ((SeqLike)some.get()).apply(0);
                        Object coefficients = ((SeqLike)some.get()).apply(1);
                        scale = ((SeqLike)some.get()).apply(2);
                        if (!(intercept instanceof Double)) break block11;
                        d = BoxesRunTime.unboxToDouble((Object)intercept);
                        if (!(coefficients instanceof Vector)) break block11;
                        vector = (Vector)coefficients;
                        if (scale instanceof Double) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                double d3 = BoxesRunTime.unboxToDouble((Object)scale);
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)vector, (Object)BoxesRunTime.boxToDouble((double)d3));
                double intercept = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                Vector coefficients = (Vector)tuple3._2();
                double scale2 = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                linearRegressionModel = new LinearRegressionModel(metadata.uid(), coefficients, intercept, scale2);
            }
            LinearRegressionModel model = linearRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }
}

