/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.classification.LinearSVC;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.LinearSVCWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.BoxedUnit;

public final class LinearSVCWrapper$
implements MLReadable<LinearSVCWrapper> {
    public static LinearSVCWrapper$ MODULE$;
    private final String PREDICTED_LABEL_INDEX_COL;
    private final String PREDICTED_LABEL_COL;

    static {
        new LinearSVCWrapper$();
    }

    public String PREDICTED_LABEL_INDEX_COL() {
        return this.PREDICTED_LABEL_INDEX_COL;
    }

    public String PREDICTED_LABEL_COL() {
        return this.PREDICTED_LABEL_COL;
    }

    public LinearSVCWrapper fit(Dataset<Row> data, String formula, double regParam, int maxIter, double tol, boolean standardization, double threshold, String weightCol, int aggregationDepth, String handleInvalid) {
        RFormula rFormula = new RFormula().setFormula(formula).setForceIndexLabel(true).setHandleInvalid(handleInvalid);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        boolean fitIntercept = rFormula.hasIntercept();
        Tuple2<String[], String[]> tuple2 = RWrapperUtils$.MODULE$.getFeaturesAndLabels((RFormulaModel)rFormulaModel, data);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String[] features = (String[])tuple2._1();
        String[] labels = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)features, (Object)labels);
        String[] features2 = (String[])tuple22._1();
        String[] labels2 = (String[])tuple22._2();
        LinearSVC svc = ((LinearSVC)((Predictor)((Predictor)new LinearSVC().setRegParam(regParam).setMaxIter(maxIter).setTol(tol).setFitIntercept(fitIntercept).setStandardization(standardization).setFeaturesCol(rFormula.getFeaturesCol())).setLabelCol(rFormula.getLabelCol())).setPredictionCol(this.PREDICTED_LABEL_INDEX_COL())).setThreshold(threshold).setAggregationDepth(aggregationDepth);
        Object object = weightCol != null ? svc.setWeightCol(weightCol) : BoxedUnit.UNIT;
        IndexToString idxToStr = new IndexToString().setInputCol(this.PREDICTED_LABEL_INDEX_COL()).setOutputCol(this.PREDICTED_LABEL_COL()).setLabels(labels2);
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, svc, idxToStr})).fit((Dataset)data);
        return new LinearSVCWrapper((PipelineModel)pipeline, features2, labels2);
    }

    @Override
    public MLReader<LinearSVCWrapper> read() {
        return new LinearSVCWrapper.LinearSVCWrapperReader();
    }

    @Override
    public LinearSVCWrapper load(String path) {
        return (LinearSVCWrapper)MLReadable.load$(this, path);
    }

    private LinearSVCWrapper$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        this.PREDICTED_LABEL_INDEX_COL = "pred_label_idx";
        this.PREDICTED_LABEL_COL = "prediction";
    }
}

