/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.Params;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ParamValidators$ {
    public static ParamValidators$ MODULE$;

    static {
        new ParamValidators$();
    }

    public <T> Function1<T, Object> alwaysTrue() {
        return (Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$alwaysTrue$1(x$2));
    }

    private <T> double getDouble(T value) {
        T t = value;
        if (t instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(t);
            return n;
        }
        if (t instanceof Long) {
            long l = BoxesRunTime.unboxToLong(t);
            return l;
        }
        if (t instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(t);
            return f;
        }
        if (t instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(t);
            return d;
        }
        throw new IllegalArgumentException(new StringBuilder(68).append("Numerical Param validation failed because").append(" of unexpected input type: ").append(value.getClass()).toString());
    }

    public <T> Function1<T, Object> gt(double lowerBound) {
        return (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$gt$1(lowerBound, value));
    }

    public <T> Function1<T, Object> gtEq(double lowerBound) {
        return (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$gtEq$1(lowerBound, value));
    }

    public <T> Function1<T, Object> lt(double upperBound) {
        return (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$lt$1(upperBound, value));
    }

    public <T> Function1<T, Object> ltEq(double upperBound) {
        return (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$ltEq$1(upperBound, value));
    }

    public <T> Function1<T, Object> inRange(double lowerBound, double upperBound, boolean lowerInclusive, boolean upperInclusive) {
        return (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$inRange$1(lowerInclusive, lowerBound, upperInclusive, upperBound, value));
    }

    public <T> Function1<T, Object> inRange(double lowerBound, double upperBound) {
        return this.inRange(lowerBound, upperBound, true, true);
    }

    public <T> Function1<T, Object> inArray(Object allowed) {
        return (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$inArray$1(allowed, value));
    }

    public <T> Function1<T, Object> inArray(List<T> allowed) {
        return (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)allowed.contains(value));
    }

    public <T> Function1<Object, Object> arrayLengthGt(double lowerBound) {
        return (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$arrayLengthGt$1(lowerBound, value));
    }

    public void checkSingleVsMultiColumnParams(Params model, Seq<Param<?>> singleColumnParams, Seq<Param<?>> multiColumnParams) {
        String name = new StringBuilder(1).append(model.getClass().getSimpleName()).append(" ").append(model).toString();
        Param<Object> inputCol = model.getParam("inputCol");
        Param<Object> inputCols = model.getParam("inputCols");
        if (model.isSet(inputCol)) {
            Predef$.MODULE$.require(!model.isSet(inputCols), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append(name).append(" requires ").append("exactly one of inputCol, inputCols Params to be set, but both are set.").toString());
            ParamValidators$.checkExclusiveParams$1(true, singleColumnParams, multiColumnParams, model, name);
            return;
        }
        if (model.isSet(inputCols)) {
            ParamValidators$.checkExclusiveParams$1(false, multiColumnParams, singleColumnParams, model, name);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(82).append(name).append(" requires ").append("exactly one of inputCol, inputCols Params to be set, but neither is set.").toString());
    }

    public static final /* synthetic */ boolean $anonfun$alwaysTrue$1(Object x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$gt$1(double lowerBound$1, Object value) {
        return MODULE$.getDouble(value) > lowerBound$1;
    }

    public static final /* synthetic */ boolean $anonfun$gtEq$1(double lowerBound$2, Object value) {
        return MODULE$.getDouble(value) >= lowerBound$2;
    }

    public static final /* synthetic */ boolean $anonfun$lt$1(double upperBound$1, Object value) {
        return MODULE$.getDouble(value) < upperBound$1;
    }

    public static final /* synthetic */ boolean $anonfun$ltEq$1(double upperBound$2, Object value) {
        return MODULE$.getDouble(value) <= upperBound$2;
    }

    public static final /* synthetic */ boolean $anonfun$inRange$1(boolean lowerInclusive$1, double lowerBound$3, boolean upperInclusive$1, double upperBound$3, Object value) {
        boolean lowerValid;
        double x = MODULE$.getDouble(value);
        boolean bl = lowerInclusive$1 ? x >= lowerBound$3 : (lowerValid = x > lowerBound$3);
        boolean upperValid = upperInclusive$1 ? x <= upperBound$3 : x < upperBound$3;
        return lowerValid && upperValid;
    }

    public static final /* synthetic */ boolean $anonfun$inArray$1(Object allowed$1, Object value) {
        return Predef$.MODULE$.genericArrayOps(allowed$1).contains(value);
    }

    public static final /* synthetic */ boolean $anonfun$arrayLengthGt$1(double lowerBound$4, Object value) {
        return (double)ScalaRunTime$.MODULE$.array_length(value) > lowerBound$4;
    }

    public static final /* synthetic */ boolean $anonfun$checkSingleVsMultiColumnParams$3(Params model$1, Param p) {
        return !model$1.isDefined(p);
    }

    private static final void checkExclusiveParams$1(boolean isSingleCol, Seq requiredParams, Seq excludedParams, Params model$1, String name$1) {
        scala.collection.mutable.StringBuilder badParamsMsgBuilder = new scala.collection.mutable.StringBuilder();
        String mustUnsetParams = ((TraversableOnce)((TraversableLike)excludedParams.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)model$1.isSet(p)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        Object object = new StringOps(Predef$.MODULE$.augmentString(mustUnsetParams)).nonEmpty() ? badParamsMsgBuilder.$plus$plus$eq(new StringBuilder(64).append("The following Params are not applicable and should not be set: ").append(mustUnsetParams).append(".").toString()) : BoxedUnit.UNIT;
        String mustSetParams = ((TraversableOnce)((TraversableLike)requiredParams.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ParamValidators$.$anonfun$checkSingleVsMultiColumnParams$3(model$1, p)))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        Object object2 = new StringOps(Predef$.MODULE$.augmentString(mustSetParams)).nonEmpty() ? badParamsMsgBuilder.$plus$plus$eq(new StringBuilder(55).append("The following Params must be defined but are not set: ").append(mustSetParams).append(".").toString()) : BoxedUnit.UNIT;
        String badParamsMsg = badParamsMsgBuilder.toString();
        if (new StringOps(Predef$.MODULE$.augmentString(badParamsMsg)).nonEmpty()) {
            String errPrefix = isSingleCol ? new StringBuilder(56).append(name$1).append(" has the inputCol Param set for single-column transform.").toString() : new StringBuilder(56).append(name$1).append(" has the inputCols Param set for multi-column transform.").toString();
            throw new IllegalArgumentException(new StringBuilder(1).append(errPrefix).append(" ").append(badParamsMsg).toString());
        }
    }

    private ParamValidators$() {
        MODULE$ = this;
    }
}

