/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.distribution;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.linalg.eigSym;
import breeze.linalg.eigSym$;
import breeze.linalg.max$;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001}4A\u0001E\t\u0001=!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011\u0006\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003+\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\r\u0003A\u0011\u0001#\t\u00111\u0003\u0001R1A\u0005\n5Caa\u0011\u0001\u0005\u0002Ua\u0006\u0002\u00032\u0001\u0011\u000b\u0007I\u0011B2\t\u0011!\u0004\u0001R1A\u0005\n%D\u0001b\u001b\u0001\t\u0006\u0004%I\u0001\u001c\u0005\u0006]\u0002!\ta\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0007]\u0002!\t!F<\t\rM\u0004A\u0011A\u000b|\u0011\u0015i\b\u0001\"\u0003d\u0005QiU\u000f\u001c;jm\u0006\u0014\u0018.\u0019;f\u000f\u0006,8o]5b]*\u0011!cE\u0001\rI&\u001cHO]5ckRLwN\u001c\u0006\u0003)U\tAa\u001d;bi*\u0011acF\u0001\u0006[2d\u0017N\u0019\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011c\u0001\u0001 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"\u0001\t\u0014\n\u0005\u001d\n#\u0001D*fe&\fG.\u001b>bE2,\u0017AA7v+\u0005Q\u0003CA\u0016/\u001b\u0005a#BA\u0017\u0016\u0003\u0019a\u0017N\\1mO&\u0011q\u0006\f\u0002\u0007-\u0016\u001cGo\u001c:)\u0007\u0005\tt\u0007\u0005\u00023k5\t1G\u0003\u00025/\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u001a$!B*j]\u000e,\u0017%\u0001\u001d\u0002\u000bEr3G\f\u0019\u0002\u00075,\b\u0005K\u0002\u0003c]\nQa]5h[\u0006,\u0012!\u0010\t\u0003WyJ!a\u0010\u0017\u0003\r5\u000bGO]5yQ\r\u0019\u0011gN\u0001\u0007g&<W.\u0019\u0011)\u0007\u0011\tt'\u0001\u0004=S:LGO\u0010\u000b\u0004\u000b\u001eK\u0005C\u0001$\u0001\u001b\u0005\t\u0002\"\u0002\u0015\u0006\u0001\u0004Q\u0003fA$2o!)1(\u0002a\u0001{!\u001a\u0011*M\u001c)\u0007\u0015\tt'\u0001\u0005ce\u0016,'0Z'v+\u0005q\u0005cA(T+6\t\u0001K\u0003\u0002.#*\t!+\u0001\u0004ce\u0016,'0Z\u0005\u0003)B\u00131\u0002R3og\u00164Vm\u0019;peB\u0011\u0001EV\u0005\u0003/\u0006\u0012a\u0001R8vE2,\u0007F\u0001\u0004Z!\t\u0001#,\u0003\u0002\\C\tIAO]1og&,g\u000e\u001e\u000b\u0004\u000bvs\u0006\"\u0002\u0015\b\u0001\u0004q\u0005\"B\u001e\b\u0001\u0004y\u0006cA(a+&\u0011\u0011\r\u0015\u0002\f\t\u0016t7/Z'biJL\u00070A\u0003ukBdW-F\u0001e!\u0011\u0001SmX+\n\u0005\u0019\f#A\u0002+va2,'\u0007\u000b\u0002\t3\u0006a!o\\8u'&<W.Y%omV\tq\f\u000b\u0002\n3\u0006\tQ/F\u0001VQ\tQ\u0011,A\u0002qI\u001a$\"!\u00169\t\u000bE\\\u0001\u0019\u0001\u0016\u0002\u0003aD3aC\u00198\u0003\u0019awn\u001a9eMR\u0011Q+\u001e\u0005\u0006c2\u0001\rA\u000b\u0015\u0004\u0019E:DCA+y\u0011\u0015\tX\u00021\u0001z!\ry%0V\u0005\u0003_A#\"!\u0016?\t\u000bEt\u0001\u0019A=\u00029\r\fGnY;mCR,7i\u001c<be&\fgnY3D_:\u001cH/\u00198ug\"\u001a\u0001!M\u001c")
public class MultivariateGaussian
implements scala.Serializable {
    private transient DenseVector<Object> breezeMu;
    private transient Tuple2<DenseMatrix<Object>, Object> tuple;
    private transient DenseMatrix<Object> rootSigmaInv;
    private transient double u;
    private final Vector mu;
    private final org.apache.spark.mllib.linalg.Matrix sigma;
    private volatile transient byte bitmap$trans$0;

    public Vector mu() {
        return this.mu;
    }

    public org.apache.spark.mllib.linalg.Matrix sigma() {
        return this.sigma;
    }

    private DenseVector<Object> breezeMu$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.breezeMu = this.mu().asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.breezeMu;
    }

    private DenseVector<Object> breezeMu() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.breezeMu$lzycompute() : this.breezeMu;
    }

    private Tuple2<DenseMatrix<Object>, Object> tuple$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.tuple = this.calculateCovarianceConstants();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.tuple;
    }

    private Tuple2<DenseMatrix<Object>, Object> tuple() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.tuple$lzycompute() : this.tuple;
    }

    private DenseMatrix<Object> rootSigmaInv$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.rootSigmaInv = (DenseMatrix)this.tuple()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.rootSigmaInv;
    }

    private DenseMatrix<Object> rootSigmaInv() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.rootSigmaInv$lzycompute() : this.rootSigmaInv;
    }

    private double u$lzycompute() {
        MultivariateGaussian multivariateGaussian = this;
        synchronized (multivariateGaussian) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.u = this.tuple()._2$mcD$sp();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.u;
    }

    private double u() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.u$lzycompute() : this.u;
    }

    public double pdf(Vector x) {
        return this.pdf(x.asBreeze());
    }

    public double logpdf(Vector x) {
        return this.logpdf(x.asBreeze());
    }

    public double pdf(breeze.linalg.Vector<Object> x) {
        return package$.MODULE$.exp(this.logpdf(x));
    }

    public double logpdf(breeze.linalg.Vector<Object> x) {
        breeze.linalg.Vector delta = (breeze.linalg.Vector)x.$minus(this.breezeMu(), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()));
        DenseVector v = (DenseVector)this.rootSigmaInv().$times((Object)delta, (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double());
        return this.u() + BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)v.t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))).$times((Object)v, Transpose$.MODULE$.transTimesNormalFromDot((UFunc.UImpl2)DenseVector.canDotD$.MODULE$))) * -0.5;
    }

    private Tuple2<DenseMatrix<Object>, Object> calculateCovarianceConstants() {
        Tuple2 tuple2;
        eigSym.EigSym eigSym2 = (eigSym.EigSym)eigSym$.MODULE$.apply((Object)this.sigma().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (UFunc.UImpl)eigSym.EigSym_DM_Impl$.MODULE$);
        if (eigSym2 == null) {
            throw new MatchError((Object)eigSym2);
        }
        DenseVector d = (DenseVector)eigSym2.eigenvalues();
        DenseMatrix u = (DenseMatrix)eigSym2.eigenvectors();
        Tuple2 tuple22 = new Tuple2((Object)d, (Object)u);
        Tuple2 tuple23 = tuple22;
        DenseVector d2 = (DenseVector)tuple23._1();
        DenseMatrix u2 = (DenseMatrix)tuple23._2();
        double tol = MLUtils$.MODULE$.EPSILON() * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply((Object)d2, max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) * (double)d2.length();
        try {
            double logPseudoDetSigma = BoxesRunTime.unboxToDouble((Object)d2.activeValuesIterator().filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$2 -> x$2 > tol).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log(x)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DenseMatrix pinvS = (DenseMatrix)diag$.MODULE$.apply((Object)new DenseVector.mcD.sp(((DenseVector)d2.map$mcD$sp((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)v -> v > tol ? package$.MODULE$.sqrt(1.0 / v) : 0.0, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
            tuple2 = new Tuple2(pinvS.$times(u2.t(DenseMatrix$.MODULE$.canTranspose()), (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)(-0.5 * ((double)this.mu().size() * package$.MODULE$.log(Math.PI * 2) + logPseudoDetSigma))));
        }
        catch (UnsupportedOperationException uex) {
            throw new IllegalArgumentException("Covariance matrix has no non-zero singular values");
        }
        return tuple2;
    }

    public MultivariateGaussian(Vector mu, org.apache.spark.mllib.linalg.Matrix sigma) {
        this.mu = mu;
        this.sigma = sigma;
        Predef$.MODULE$.require(sigma.numCols() == sigma.numRows(), (Function0 & Serializable & scala.Serializable)() -> "Covariance matrix must be square");
        Predef$.MODULE$.require(mu.size() == sigma.numCols(), (Function0 & Serializable & scala.Serializable)() -> "Mean vector length must match covariance matrix size");
    }

    public MultivariateGaussian(DenseVector<Object> mu, DenseMatrix<Object> sigma) {
        this(Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mu), Matrices$.MODULE$.fromBreeze((Matrix<Object>)sigma));
    }
}

