/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U2AAB\u0004\u0001%!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0019\u0001A\u0003%1\u0005C\u00043\u0001\t\u0007I\u0011A\u001a\t\rQ\u0002\u0001\u0015!\u0003.\u0005Y\u0011Vm\u001a:fgNLwN\\'fiJL7m]*vSR,'B\u0001\u0005\n\u0003))g/\u00197vCRLwN\u001c\u0006\u0003\u0015-\tQ!\u001c7mS\nT!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\r\u00011c\u0006\t\u0003)Ui\u0011aC\u0005\u0003--\u0011Qb\u00159be.4UO\\*vSR,\u0007C\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\n\u0003\u0011)H/\u001b7\n\u0005qI\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\u001d\t1a\u001c2t+\u0005\u0019\u0003c\u0001\u0013,[5\tQE\u0003\u0002'O\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003Q%\n!bY8mY\u0016\u001cG/[8o\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017&\u0005\u0011a\u0015n\u001d;\u0011\u00059zS\"A\u0015\n\u0005AJ#A\u0002#pk\ndW-\u0001\u0003pEN\u0004\u0013aA3qgV\tQ&\u0001\u0003faN\u0004\u0003")
public class RegressionMetricsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final List<Object> obs;
    private final double eps;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public List<Object> obs() {
        return this.obs;
    }

    public double eps() {
        return this.eps;
    }

    private final void testImplicits$lzycompute$1() {
        RegressionMetricsSuite regressionMetricsSuite = this;
        synchronized (regressionMetricsSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public RegressionMetricsSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.obs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{77.0, 85.0, 62.0, 55.0, 63.0, 88.0, 57.0, 81.0, 51.0}));
        this.eps = 1.0E-5;
        this.test("regression metrics for unbiased (includes intercept term) predictor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            List preds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{72.08, 91.88, 65.48, 52.28, 62.18, 81.98, 58.88, 78.68, 55.58}));
            RDD predictionAndObservations = this.sc().parallelize((Seq)preds.zip(this.obs(), List$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            RegressionMetrics metrics = new RegressionMetrics(predictionAndObservations);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(157.3).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(157.3).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(3.7355556).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(3.7355556).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(17.539511).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(17.539511).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(4.18802).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(4.18802).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.89968225).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.89968225).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("regression metrics for biased (no intercept term) predictor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            List preds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{72.12, 99.17, 63.11, 45.08, 58.6, 85.65, 54.09, 81.14, 49.58}));
            RDD predictionAndObservations = this.sc().parallelize((Seq)preds.zip(this.obs(), List$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            RegressionMetrics metrics = new RegressionMetrics(predictionAndObservations, true);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(294.88167).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(294.88167).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(4.5888889).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(4.5888889).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(39.958711).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(39.958711).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(6.3212903).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(6.3212903).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.99185395).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.99185395).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }, new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        this.test("regression metrics with complete fitting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            List<Object> preds = this.obs();
            RDD predictionAndObservations = this.sc().parallelize((Seq)preds.zip(this.obs(), List$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            RegressionMetrics metrics = new RegressionMetrics(predictionAndObservations);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(174.83951).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(174.83951).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        }, new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        this.test("regression metrics with same (1.0) weight samples", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD predictionAndObservationWithWeight = this.sc().parallelize((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)2.25), (Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)-0.25), (Object)BoxesRunTime.boxToDouble((double)-0.5), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)1.75), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)7.75), (Object)BoxesRunTime.boxToDouble((double)7.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)Nil$.MODULE$)))), 2, ClassTag$.MODULE$.apply(Tuple3.class));
            RegressionMetrics metrics = new RegressionMetrics(predictionAndObservationWithWeight, false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(8.79687).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(8.79687).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.5).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.5).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.3125).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.3125).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.55901).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.55901).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.95717).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.95717).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        }, new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("regression metrics with weighted samples", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD predictionAndObservationWithWeight = this.sc().parallelize((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)2.25), (Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)0.1)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)-0.25), (Object)BoxesRunTime.boxToDouble((double)-0.5), (Object)BoxesRunTime.boxToDouble((double)0.2)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)1.75), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)0.15)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)7.75), (Object)BoxesRunTime.boxToDouble((double)7.0), (Object)BoxesRunTime.boxToDouble((double)0.05)), (List)Nil$.MODULE$)))), 2, ClassTag$.MODULE$.apply(Tuple3.class));
            RegressionMetrics metrics = new RegressionMetrics(predictionAndObservationWithWeight, false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(5.2425).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(5.2425).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.4).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.4).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.2125).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.2125).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.46098).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.46098).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0291).absTol(this.eps())), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0291).absTol(RegressionMetricsSuite.this.eps))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch", Prettifier$.MODULE$.default(), new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        }, new Position("RegressionMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
    }
}

