/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressionModel$;
import org.apache.spark.ml.regression.RandomForestRegressor;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RandomForestRegressorSuite$
extends SparkFunSuite {
    public static RandomForestRegressorSuite$ MODULE$;

    static {
        new RandomForestRegressorSuite$();
    }

    public void compareAPIs(RDD<org.apache.spark.ml.feature.LabeledPoint> data, RandomForestRegressor rf, Map<Object, Object> categoricalFeatures) {
        int numFeatures = ((org.apache.spark.ml.feature.LabeledPoint)data.first()).features().size();
        Strategy oldStrategy = rf.getOldStrategy(categoricalFeatures, 0, Algo$.MODULE$.Regression(), rf.getOldImpurity());
        RandomForestModel oldModel = RandomForest$.MODULE$.trainRegressor(data.map((Function1 & Serializable & scala.Serializable)point -> LabeledPoint$.MODULE$.fromML(point), ClassTag$.MODULE$.apply(LabeledPoint.class)), oldStrategy, rf.getNumTrees(), rf.getFeatureSubsetStrategy(), (int)rf.getSeed());
        Dataset<Row> newData = TreeTests$.MODULE$.setMetadata(data, categoricalFeatures, 0);
        RandomForestRegressionModel newModel = (RandomForestRegressionModel)rf.fit(newData);
        RandomForestRegressionModel oldModelAsNew = RandomForestRegressionModel$.MODULE$.fromOld(oldModel, (RandomForestRegressor)newModel.parent(), categoricalFeatures, RandomForestRegressionModel$.MODULE$.fromOld$default$4());
        TreeTests$.MODULE$.checkEqual(oldModelAsNew, newModel);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newModel.numFeatures()));
        int $org_scalatest_assert_macro_right = numFeatures;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestRegressorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RandomForestRegressorSuite$() {
        MODULE$ = this;
    }
}

