/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel$;
import org.apache.spark.ml.classification.DecisionTreeClassifier;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DecisionTreeClassifierSuite$
extends SparkFunSuite {
    public static DecisionTreeClassifierSuite$ MODULE$;

    static {
        new DecisionTreeClassifierSuite$();
    }

    public void compareAPIs(RDD<org.apache.spark.ml.feature.LabeledPoint> data, DecisionTreeClassifier dt, Map<Object, Object> categoricalFeatures, int numClasses) {
        int numFeatures = ((org.apache.spark.ml.feature.LabeledPoint)data.first()).features().size();
        Strategy oldStrategy = dt.getOldStrategy(categoricalFeatures, numClasses);
        org.apache.spark.mllib.tree.model.DecisionTreeModel oldTree = DecisionTree$.MODULE$.train(data.map((Function1 & Serializable & scala.Serializable)point -> LabeledPoint$.MODULE$.fromML(point), ClassTag$.MODULE$.apply(LabeledPoint.class)), oldStrategy);
        Dataset<Row> newData = TreeTests$.MODULE$.setMetadata(data, categoricalFeatures, numClasses);
        DecisionTreeClassificationModel newTree = (DecisionTreeClassificationModel)dt.fit(newData);
        DecisionTreeClassificationModel oldTreeAsNew = DecisionTreeClassificationModel$.MODULE$.fromOld(oldTree, (DecisionTreeClassifier)newTree.parent(), categoricalFeatures, DecisionTreeClassificationModel$.MODULE$.fromOld$default$4());
        TreeTests$.MODULE$.checkEqual((DecisionTreeModel)oldTreeAsNew, (DecisionTreeModel)newTree);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)newTree.numFeatures()));
        int $org_scalatest_assert_macro_right = numFeatures;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DecisionTreeClassifierSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DecisionTreeClassifierSuite$() {
        MODULE$ = this;
    }
}

