/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseVector;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u001c9\u0001\rC\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\tI\u0002\u0011\t\u0011)A\u0005+\"Aa\r\u0001BC\u0002\u0013\u0005q\r\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003i\u0011\u0015!\b\u0001\"\u0001v\u0011\u0015i\b\u0001\"\u0011\u007f\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002>\u0001!\t!!\u0019\t\u000f\u0005u\u0002\u0001\"\u0001\u0002n!9\u00111\u0013\u0001\u0005\u0002\u0005U\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003G\u0003A\u0011BAS\u000f\u001d\t\u0019\r\u000fE\u0001\u0003\u000b4aa\u000e\u001d\t\u0002\u0005\u001d\u0007B\u0002;\u0010\t\u0003\tymB\u0004\u0002R>AI!a5\u0007\u000f\u0005]w\u0002#\u0003\u0002Z\"1AO\u0005C\u0001\u000374a!!8\u0013\u0001\u0006}\u0007BCAt)\tU\r\u0011\"\u0001\u0002j\"I\u00111\u001e\u000b\u0003\u0012\u0003\u0006I\u0001\u0017\u0005\u000b\u0003[$\"Q3A\u0005\u0002\u0005=\bBCAy)\tE\t\u0015!\u0003\u0002T!Q\u00111\u001f\u000b\u0003\u0016\u0004%\t!!>\t\u0015\u0005uHC!E!\u0002\u0013\t9\u0010\u0003\u0004u)\u0011\u0005\u0011q \u0005\n\u0005\u0017!\u0012\u0011!C\u0001\u0005\u001bA\u0011B!\u0006\u0015#\u0003%\tAa\u0006\t\u0013\t-B#%A\u0005\u0002\t5\u0002\"\u0003B\u0019)E\u0005I\u0011\u0001B\u001a\u0011%\u00119\u0004FA\u0001\n\u0003\u0012I\u0004C\u0005\u0003@Q\t\t\u0011\"\u0001\u00024!I!\u0011\t\u000b\u0002\u0002\u0013\u0005!1\t\u0005\n\u0005\u001f\"\u0012\u0011!C!\u0005#B\u0011Ba\u0018\u0015\u0003\u0003%\tA!\u0019\t\u0013\t-D#!A\u0005B\t5\u0004\"\u0003B8)\u0005\u0005I\u0011\tB9\u0011%\u0011\u0019\bFA\u0001\n\u0003\u0012)hB\u0005\u0003zI\t\t\u0011#\u0001\u0003|\u0019I\u0011Q\u001c\n\u0002\u0002#\u0005!Q\u0010\u0005\u0007i&\"\tAa#\t\u0013\t=\u0014&!A\u0005F\tE\u0004\"\u0003BGS\u0005\u0005I\u0011\u0011BH\u0011%\u00119*KA\u0001\n\u0003\u0013I\nC\u0005\u0003,&\n\t\u0011\"\u0003\u0003.\"I!Q\u0017\nC\u0002\u0013\u0005!\u0011\b\u0005\t\u0005o\u0013\u0002\u0015!\u0003\u0003<!I!\u0011\u0018\nC\u0002\u0013\u0005!\u0011\b\u0005\t\u0005w\u0013\u0002\u0015!\u0003\u0003<!1QP\u0005C\u0001\u0005{CqAa2\u0013\t\u0003\u0011I\rC\u0004\u0003H>!\tEa4\t\u0013\t-v\"!A\u0005\n\t5&\u0001F$bkN\u001c\u0018.\u00198NSb$XO]3N_\u0012,GN\u0003\u0002:u\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005mb\u0014!B7mY&\u0014'BA\u001f?\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\u0004\u0001M!\u0001\u0001\u0012&N!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\u0019\te.\u001f*fMB\u0011QiS\u0005\u0003\u0019\u001a\u0013AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"AT)\u000e\u0003=S!\u0001\u0015\u001e\u0002\tU$\u0018\u000e\\\u0005\u0003%>\u0013\u0001bU1wK\u0006\u0014G.Z\u0001\bo\u0016Lw\r\u001b;t+\u0005)\u0006cA#W1&\u0011qK\u0012\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u000bfK!A\u0017$\u0003\r\u0011{WO\u00197fQ\r\tAL\u0019\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?r\n!\"\u00198o_R\fG/[8o\u0013\t\tgLA\u0003TS:\u001cW-I\u0001d\u0003\u0015\tdf\r\u00181\u0003!9X-[4iiN\u0004\u0003f\u0001\u0002]E\u0006Iq-Y;tg&\fgn]\u000b\u0002QB\u0019QIV5\u0011\u0005)|W\"A6\u000b\u00051l\u0017\u0001\u00043jgR\u0014\u0018NY;uS>t'B\u00018;\u0003\u0011\u0019H/\u0019;\n\u0005A\\'\u0001F'vYRLg/\u0019:jCR,w)Y;tg&\fg\u000eK\u0002\u00049\n\f!bZ1vgNL\u0017M\\:!Q\r!ALY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007YD(\u0010\u0005\u0002x\u00015\t\u0001\bC\u0003T\u000b\u0001\u0007Q\u000bK\u0002y9\nDQAZ\u0003A\u0002!D3A\u001f/cQ\r)ALY\u0001\u0005g\u00064X\rF\u0003\u0000\u0003\u000b\t\t\u0002E\u0002F\u0003\u0003I1!a\u0001G\u0005\u0011)f.\u001b;\t\u000f\u0005\u001da\u00011\u0001\u0002\n\u0005\u00111o\u0019\t\u0005\u0003\u0017\ti!D\u0001=\u0013\r\ty\u0001\u0010\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003'1\u0001\u0019AA\u000b\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u0005]\u0011Q\u0005\b\u0005\u00033\t\t\u0003E\u0002\u0002\u001c\u0019k!!!\b\u000b\u0007\u0005}!)\u0001\u0004=e>|GOP\u0005\u0004\u0003G1\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002(\u0005%\"AB*ue&twMC\u0002\u0002$\u0019CCA\u0002/\u0002.\u0005\u0012\u0011qF\u0001\u0006c9\"d\u0006M\u0001\u0002WV\u0011\u0011Q\u0007\t\u0004\u000b\u0006]\u0012bAA\u001d\r\n\u0019\u0011J\u001c;)\u0007\u001da&-A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005\u0005\u0013Q\n\t\u0007\u0003\u0007\nI%!\u000e\u000e\u0005\u0005\u0015#bAA$y\u0005\u0019!\u000f\u001a3\n\t\u0005-\u0013Q\t\u0002\u0004%\u0012#\u0005bBA(\u0011\u0001\u0007\u0011\u0011K\u0001\u0007a>Lg\u000e^:\u0011\r\u0005\r\u0013\u0011JA*!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-u\u00051A.\u001b8bY\u001eLA!!\u0018\u0002X\t1a+Z2u_JD3\u0001\u0003/c)\u0011\t)$a\u0019\t\u000f\u0005\u0015\u0014\u00021\u0001\u0002T\u0005)\u0001o\\5oi\"\"\u0011\u0002XA5C\t\tY'A\u00032]Ur\u0003\u0007\u0006\u0003\u0002p\u00055\u0005CBA9\u0003w\ny(\u0004\u0002\u0002t)!\u0011QOA<\u0003\u0011Q\u0017M^1\u000b\u0007\u0005eD(A\u0002ba&LA!! \u0002t\t9!*\u0019<b%\u0012#\u0005\u0003BAA\u0003\u0013k!!a!\u000b\t\u0005\u0015\u0015qQ\u0001\u0005Y\u0006twM\u0003\u0002\u0002v%!\u00111RAB\u0005\u001dIe\u000e^3hKJDq!a\u0014\u000b\u0001\u0004\ty\t\u0005\u0004\u0002r\u0005m\u00141\u000b\u0015\u0005\u0015q\u000bi#A\u0006qe\u0016$\u0017n\u0019;T_\u001a$H\u0003BAL\u00033\u0003R!a\u0011\u0002JUCq!a\u0014\f\u0001\u0004\t\t\u0006K\u0002\f9\n$2!VAP\u0011\u001d\t)\u0007\u0004a\u0001\u0003'BC\u0001\u0004/\u0002.\u000512m\\7qkR,7k\u001c4u\u0003N\u001c\u0018n\u001a8nK:$8\u000fF\u0005V\u0003O\u000bI,!0\u0002@\"9\u0011\u0011V\u0007A\u0002\u0005-\u0016A\u00019u!\u0015\ti+!.Y\u001b\t\tyK\u0003\u0003\u0002Z\u0005E&BAAZ\u0003\u0019\u0011'/Z3{K&!\u0011qWAX\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\r\u0005mV\u00021\u0001i\u0003\u0015!\u0017n\u001d;t\u0011\u0015\u0019V\u00021\u0001V\u0011\u001d\t\t$\u0004a\u0001\u0003kA3\u0001\u0001/c\u0003Q9\u0015-^:tS\u0006tW*\u001b=ukJ,Wj\u001c3fYB\u0011qoD\n\u0006\u001f\u0011\u000bIM\u0013\t\u0005\u001d\u0006-g/C\u0002\u0002N>\u0013a\u0001T8bI\u0016\u0014HCAAc\u00031\u0019\u0016M^3M_\u0006$g+M01!\r\t)NE\u0007\u0002\u001f\ta1+\u0019<f\u0019>\fGMV\u0019`aM\u0011!\u0003\u0012\u000b\u0003\u0003'\u0014A\u0001R1uCN)A\u0003RAq\u0015B\u0019Q)a9\n\u0007\u0005\u0015hIA\u0004Qe>$Wo\u0019;\u0002\r],\u0017n\u001a5u+\u0005A\u0016aB<fS\u001eDG\u000fI\u0001\u0003[V,\"!a\u0015\u0002\u00075,\b%A\u0003tS\u001el\u0017-\u0006\u0002\u0002xB!\u0011QKA}\u0013\u0011\tY0a\u0016\u0003\r5\u000bGO]5y\u0003\u0019\u0019\u0018nZ7bAQA!\u0011\u0001B\u0003\u0005\u000f\u0011I\u0001E\u0002\u0003\u0004Qi\u0011A\u0005\u0005\u0007\u0003O\\\u0002\u0019\u0001-\t\u000f\u000558\u00041\u0001\u0002T!9\u00111_\u000eA\u0002\u0005]\u0018\u0001B2paf$\u0002B!\u0001\u0003\u0010\tE!1\u0003\u0005\t\u0003Od\u0002\u0013!a\u00011\"I\u0011Q\u001e\u000f\u0011\u0002\u0003\u0007\u00111\u000b\u0005\n\u0003gd\u0002\u0013!a\u0001\u0003o\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u001a)\u001a\u0001La\u0007,\u0005\tu\u0001\u0003\u0002B\u0010\u0005Oi!A!\t\u000b\t\t\r\"QE\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u0018$\n\t\t%\"\u0011\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005_QC!a\u0015\u0003\u001c\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u001bU\u0011\t9Pa\u0007\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011Y\u0004\u0005\u0003\u0002\u0002\nu\u0012\u0002BA\u0014\u0003\u0007\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003F\t-\u0003cA#\u0003H%\u0019!\u0011\n$\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003N\t\n\t\u00111\u0001\u00026\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0015\u0011\r\tU#1\fB#\u001b\t\u00119FC\u0002\u0003Z\u0019\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iFa\u0016\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005G\u0012I\u0007E\u0002F\u0005KJ1Aa\u001aG\u0005\u001d\u0011un\u001c7fC:D\u0011B!\u0014%\u0003\u0003\u0005\rA!\u0012\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u000e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u000f\u0002\r\u0015\fX/\u00197t)\u0011\u0011\u0019Ga\u001e\t\u0013\t5s%!AA\u0002\t\u0015\u0013\u0001\u0002#bi\u0006\u00042Aa\u0001*'\u0011I#q\u0010&\u0011\u0017\t\u0005%q\u0011-\u0002T\u0005](\u0011A\u0007\u0003\u0005\u0007S1A!\"G\u0003\u001d\u0011XO\u001c;j[\u0016LAA!#\u0003\u0004\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\tm\u0014!B1qa2LH\u0003\u0003B\u0001\u0005#\u0013\u0019J!&\t\r\u0005\u001dH\u00061\u0001Y\u0011\u001d\ti\u000f\fa\u0001\u0003'Bq!a=-\u0001\u0004\t90A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tm%q\u0015\t\u0006\u000b\nu%\u0011U\u0005\u0004\u0005?3%AB(qi&|g\u000e\u0005\u0005F\u0005GC\u00161KA|\u0013\r\u0011)K\u0012\u0002\u0007)V\u0004H.Z\u001a\t\u0013\t%V&!AA\u0002\t\u0005\u0011a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\u000b\u0005\u0003\u0002\u0002\nE\u0016\u0002\u0002BZ\u0003\u0007\u0013aa\u00142kK\u000e$\u0018!\u00054pe6\fGOV3sg&|gNV\u0019`a\u0005\u0011bm\u001c:nCR4VM]:j_:4\u0016g\u0018\u0019!\u00035\u0019G.Y:t\u001d\u0006lWMV\u0019`a\u0005q1\r\\1tg:\u000bW.\u001a,2?B\u0002C#C@\u0003@\n\u0005'1\u0019Bc\u0011\u001d\t9a\ra\u0001\u0003\u0013Aq!a\u00054\u0001\u0004\t)\u0002C\u0003Tg\u0001\u0007Q\u000bC\u0003gg\u0001\u0007\u0001.\u0001\u0003m_\u0006$G#\u0002<\u0003L\n5\u0007bBA\u0004i\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003'!\u0004\u0019AA\u000b)\u00151(\u0011\u001bBj\u0011\u001d\t9!\u000ea\u0001\u0003\u0013Aq!a\u00056\u0001\u0004\t)\u0002\u000b\u000369\u00065\u0002\u0006B\b]\u0003[ACA\u0004/\u0002.\u0001")
public class GaussianMixtureModel
implements scala.Serializable,
Saveable {
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;

    public static GaussianMixtureModel load(SparkContext sparkContext, String string) {
        return GaussianMixtureModel$.MODULE$.load(sparkContext, string);
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    @Override
    public void save(SparkContext sc, String path) {
        GaussianMixtureModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.weights(), this.gaussians());
    }

    public int k() {
        return this.weights().length;
    }

    public RDD<Object> predict(RDD<Vector> points) {
        RDD<double[]> responsibilityMatrix = this.predictSoft(points);
        return responsibilityMatrix.map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)GaussianMixtureModel.$anonfun$predict$1(r)), ClassTag$.MODULE$.Int());
    }

    public int predict(Vector point) {
        double[] r = this.predictSoft(point);
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).indexOf(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).max((Ordering)Ordering.Double$.MODULE$));
    }

    public JavaRDD<Integer> predict(JavaRDD<Vector> points) {
        return this.predict((RDD<Vector>)points.rdd()).toJavaRDD();
    }

    public RDD<double[]> predictSoft(RDD<Vector> points) {
        SparkContext sc = points.sparkContext();
        Broadcast bcDists = sc.broadcast((Object)this.gaussians(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(MultivariateGaussian.class)));
        Broadcast bcWeights = sc.broadcast((Object)this.weights(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return points.map((Function1 & Serializable & scala.Serializable)x -> this.computeSoftAssignments((DenseVector<Object>)x.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), (MultivariateGaussian[])bcDists.value(), (double[])bcWeights.value(), this.k()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public double[] predictSoft(Vector point) {
        return this.computeSoftAssignments((DenseVector<Object>)point.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), this.gaussians(), this.weights(), this.k());
    }

    private double[] computeSoftAssignments(DenseVector<Object> pt, MultivariateGaussian[] dists, double[] weights, int k) {
        double[] p = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weights)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])dists), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)GaussianMixtureModel.$anonfun$computeSoftAssignments$1(pt, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double pSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            p$1[i] = p[i] / pSum;
        });
        return p;
    }

    public static final /* synthetic */ int $anonfun$predict$1(double[] r) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).indexOf(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(r)).max((Ordering)Ordering.Double$.MODULE$));
    }

    public static final /* synthetic */ double $anonfun$computeSoftAssignments$1(DenseVector pt$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double weight = tuple2._1$mcD$sp();
        MultivariateGaussian dist = (MultivariateGaussian)tuple2._2();
        double d = MLUtils$.MODULE$.EPSILON() + weight * dist.pdf((breeze.linalg.Vector<Object>)pt$1);
        return d;
    }

    public GaussianMixtureModel(double[] weights, MultivariateGaussian[] gaussians) {
        this.weights = weights;
        this.gaussians = gaussians;
        Predef$.MODULE$.require(weights.length == gaussians.length, (Function0 & Serializable & scala.Serializable)() -> "Length of weight and Gaussian arrays must match");
    }
}

