/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.classification.NaiveBayes$;
import org.apache.spark.ml.classification.NaiveBayesModel;
import org.apache.spark.ml.classification.NaiveBayesParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.functions$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001\u0002\u0010 \u0001)B\u0001B\u0011\u0001\u0003\u0006\u0004%\te\u0011\u0005\t5\u0002\u0011\t\u0011)A\u0005\t\")A\f\u0001C\u0001;\")A\f\u0001C\u0001C\")1\r\u0001C\u0001I\")Q\u000e\u0001C\u0001]\")\u0011\u000f\u0001C\u0001e\")q\u000f\u0001C)q\"A\u00111\u0004\u0001\u0005\u0002\r\ni\u0002C\u0004\u00026\u0001!I!a\u000e\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u0011\u0011\r\u0001\u0005B\u0005\rtaBA=?!\u0005\u00111\u0010\u0004\u0007=}A\t!! \t\rqsA\u0011AAI\u0011%\t\u0019J\u0004b\u0001\n\u0003y2\tC\u0004\u0002\u0016:\u0001\u000b\u0011\u0002#\t\u0013\u0005]eB1A\u0005\u0002}\u0019\u0005bBAM\u001d\u0001\u0006I\u0001\u0012\u0005\n\u00037s!\u0019!C\u0001?\rCq!!(\u000fA\u0003%A\tC\u0005\u0002 :\u0011\r\u0011\"\u0001 \u0007\"9\u0011\u0011\u0015\b!\u0002\u0013!\u0005BCAR\u001d\t\u0007I\u0011A\u0010\u0002&\"A\u0011q\u0017\b!\u0002\u0013\t9\u000b\u0003\u0005\u0002::!\t!IA^\u0011!\t9M\u0004C\u0001C\u0005%\u0007bBAg\u001d\u0011\u0005\u0013q\u001a\u0005\n\u00037t\u0011\u0011!C\u0005\u0003;\u0014!BT1jm\u0016\u0014\u0015-_3t\u0015\t\u0001\u0013%\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\t\u001a\u0013AA7m\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0005\u0001-JD\bE\u0003-[=*d'D\u0001 \u0013\tqsDA\fQe>\u0014\u0017MY5mSN$\u0018nY\"mCN\u001c\u0018NZ5feB\u0011\u0001gM\u0007\u0002c)\u0011!'I\u0001\u0007Y&t\u0017\r\\4\n\u0005Q\n$A\u0002,fGR|'\u000f\u0005\u0002-\u0001A\u0011AfN\u0005\u0003q}\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\t\u0003YiJ!aO\u0010\u0003!9\u000b\u0017N^3CCf,7\u000fU1sC6\u001c\bCA\u001fA\u001b\u0005q$BA \"\u0003\u0011)H/\u001b7\n\u0005\u0005s$!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.Z\u0001\u0004k&$W#\u0001#\u0011\u0005\u0015seB\u0001$M!\t9%*D\u0001I\u0015\tI\u0015&\u0001\u0004=e>|GO\u0010\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJS\u0001\u0007!J,G-\u001a4\n\u0005=\u0003&AB*ue&twM\u0003\u0002N\u0015\"\u001a\u0011A\u0015-\u0011\u0005M3V\"\u0001+\u000b\u0005U\u001b\u0013AC1o]>$\u0018\r^5p]&\u0011q\u000b\u0016\u0002\u0006'&t7-Z\u0011\u00023\u0006)\u0011GL\u001b/a\u0005!Q/\u001b3!Q\r\u0011!\u000bW\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Ur\u0006\"\u0002\"\u0004\u0001\u0004!\u0005f\u00010S1\"\u001a1A\u0015-\u0015\u0003UB3\u0001\u0002*Y\u00031\u0019X\r^*n_>$\b.\u001b8h)\t)g-D\u0001\u0001\u0011\u00159W\u00011\u0001i\u0003\u00151\u0018\r\\;f!\tI'.D\u0001K\u0013\tY'J\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u000bIC\u0016\u0001D:fi6{G-\u001a7UsB,GCA3p\u0011\u00159g\u00011\u0001EQ\r1!\u000bW\u0001\rg\u0016$x+Z5hQR\u001cu\u000e\u001c\u000b\u0003KNDQaZ\u0004A\u0002\u0011C3a\u0002*vC\u00051\u0018!\u0002\u001a/c9\u0002\u0014!\u0002;sC&tGC\u0001\u001cz\u0011\u0015Q\b\u00021\u0001|\u0003\u001d!\u0017\r^1tKR\u00044\u0001`A\u0005!\u0015i\u0018\u0011AA\u0003\u001b\u0005q(BA@$\u0003\r\u0019\u0018\u000f\\\u0005\u0004\u0003\u0007q(a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003\u000f\tI\u0001\u0004\u0001\u0005\u0017\u0005-\u00110!A\u0001\u0002\u000b\u0005\u0011Q\u0002\u0002\u0004?\u0012\n\u0014\u0003BA\b\u0003+\u00012![A\t\u0013\r\t\u0019B\u0013\u0002\b\u001d>$\b.\u001b8h!\rI\u0017qC\u0005\u0004\u00033Q%aA!os\u0006\u0019BO]1j]^KG\u000f\u001b'bE\u0016d7\t[3dWR)a'a\b\u0002,!1!0\u0003a\u0001\u0003C\u0001D!a\t\u0002(A)Q0!\u0001\u0002&A!\u0011qAA\u0014\t1\tI#a\b\u0002\u0002\u0003\u0005)\u0011AA\u0007\u0005\ryFE\r\u0005\b\u0003[I\u0001\u0019AA\u0018\u00035\u0001xn]5uSZ,G*\u00192fYB\u0019\u0011.!\r\n\u0007\u0005M\"JA\u0004C_>dW-\u00198\u0002#Q\u0014\u0018-\u001b8ESN\u001c'/\u001a;f\u00136\u0004H\u000eF\u00037\u0003s\t)\u0005\u0003\u0004{\u0015\u0001\u0007\u00111\b\u0019\u0005\u0003{\t\t\u0005E\u0003~\u0003\u0003\ty\u0004\u0005\u0003\u0002\b\u0005\u0005C\u0001DA\"\u0003s\t\t\u0011!A\u0003\u0002\u00055!aA0%g!9\u0011q\t\u0006A\u0002\u0005%\u0013!B5ogR\u0014\bcA\u001f\u0002L%\u0019\u0011Q\n \u0003\u001f%s7\u000f\u001e:v[\u0016tG/\u0019;j_:\f\u0011\u0003\u001e:bS:<\u0015-^:tS\u0006t\u0017*\u001c9m)\u00151\u00141KA0\u0011\u0019Q8\u00021\u0001\u0002VA\"\u0011qKA.!\u0015i\u0018\u0011AA-!\u0011\t9!a\u0017\u0005\u0019\u0005u\u00131KA\u0001\u0002\u0003\u0015\t!!\u0004\u0003\u0007}#C\u0007C\u0004\u0002H-\u0001\r!!\u0013\u0002\t\r|\u0007/\u001f\u000b\u0004k\u0005\u0015\u0004bBA4\u0019\u0001\u0007\u0011\u0011N\u0001\u0006Kb$(/\u0019\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN\u0011\u0002\u000bA\f'/Y7\n\t\u0005M\u0014Q\u000e\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001aAB\u0015-)\u0007\u0001\u0011\u0006,\u0001\u0006OC&4XMQ1zKN\u0004\"\u0001\f\b\u0014\u000f9\ty(!\"\u0002\fB\u0019\u0011.!!\n\u0007\u0005\r%J\u0001\u0004B]f\u0014VM\u001a\t\u0005{\u0005\u001dU'C\u0002\u0002\nz\u0012Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\rE\u0002j\u0003\u001bK1!a$K\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\tY(A\u0006Nk2$\u0018N\\8nS\u0006d\u0017\u0001D'vYRLgn\\7jC2\u0004\u0013!\u0003\"fe:|W\u000f\u001c7j\u0003)\u0011UM\u001d8pk2d\u0017\u000eI\u0001\t\u000f\u0006,8o]5b]\u0006Iq)Y;tg&\fg\u000eI\u0001\u000b\u0007>l\u0007\u000f\\3nK:$\u0018aC\"p[BdW-\\3oi\u0002\n1c];qa>\u0014H/\u001a3N_\u0012,G\u000eV=qKN,\"!a*\u0011\u000b\u0005%\u00161\u0017#\u000e\u0005\u0005-&\u0002BAW\u0003_\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005E&*\u0001\u0006d_2dWm\u0019;j_:LA!!.\u0002,\n\u00191+\u001a;\u0002)M,\b\u000f]8si\u0016$Wj\u001c3fYRK\b/Z:!\u0003a\u0011X-];je\u0016tuN\u001c8fO\u0006$\u0018N^3WC2,Xm\u001d\u000b\u0005\u0003{\u000b\u0019\rE\u0002j\u0003\u007fK1!!1K\u0005\u0011)f.\u001b;\t\r\u0005\u0015'\u00041\u00010\u0003\u00051\u0018!\b:fcVL'/\u001a.fe>|e.\u001a\"fe:|W\u000f\u001c7j-\u0006dW/Z:\u0015\t\u0005u\u00161\u001a\u0005\u0007\u0003\u000b\\\u0002\u0019A\u0018\u0002\t1|\u0017\r\u001a\u000b\u0004k\u0005E\u0007BBAj9\u0001\u0007A)\u0001\u0003qCRD\u0007\u0006\u0002\u000fS\u0003/\f#!!7\u0002\u000bErcG\f\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/\u0001\u0003mC:<'BAAu\u0003\u0011Q\u0017M^1\n\t\u00055\u00181\u001d\u0002\u0007\u001f\nTWm\u0019;)\t9\u0011\u0016q\u001b\u0015\u0005\u001bI\u000b9\u000e")
public class NaiveBayes
extends ProbabilisticClassifier<Vector, NaiveBayes, NaiveBayesModel>
implements NaiveBayesParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam smoothing;
    private final Param<String> modelType;
    private final Param<String> weightCol;

    public static NaiveBayes load(String string) {
        return NaiveBayes$.MODULE$.load(string);
    }

    public static MLReader<NaiveBayes> read() {
        return NaiveBayes$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getSmoothing() {
        return NaiveBayesParams.getSmoothing$(this);
    }

    @Override
    public final String getModelType() {
        return NaiveBayesParams.getModelType$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public final Param<String> modelType() {
        return this.modelType;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$modelType_$eq(Param<String> x$1) {
        this.modelType = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public NaiveBayes setSmoothing(double value) {
        return (NaiveBayes)this.set(this.smoothing(), BoxesRunTime.boxToDouble((double)value));
    }

    public NaiveBayes setModelType(String value) {
        return (NaiveBayes)this.set(this.modelType(), value);
    }

    public NaiveBayes setWeightCol(String value) {
        return (NaiveBayes)this.set(this.weightCol(), value);
    }

    @Override
    public NaiveBayesModel train(Dataset<?> dataset) {
        return this.trainWithLabelCheck(dataset, true);
    }

    public NaiveBayesModel trainWithLabelCheck(Dataset<?> dataset, boolean positiveLabel) {
        return (NaiveBayesModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            NaiveBayesModel naiveBayesModel;
            boolean bl;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.weightCol(), this.predictionCol(), this.rawPredictionCol(), this.probabilityCol(), this.modelType(), this.smoothing(), this.thresholds()}));
            if (positiveLabel && this.isDefined(this.thresholds())) {
                int numClasses = this.getNumClasses(dataset, this.getNumClasses$default$2());
                instr.logNumClasses(numClasses);
                Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append(this.getClass().getSimpleName()).append(".train() called with non-matching numClasses and thresholds.length.").append(" numClasses=").append(numClasses).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString());
            }
            String string = this.$(this.modelType());
            String string2 = NaiveBayes$.MODULE$.Bernoulli();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Multinomial();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = NaiveBayes$.MODULE$.Complement();
                    String string7 = string;
                    bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                }
            }
            if (bl) {
                naiveBayesModel = this.trainDiscreteImpl(dataset, (Instrumentation)instr);
            } else {
                String string8 = NaiveBayes$.MODULE$.Gaussian();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    naiveBayesModel = this.trainGaussianImpl(dataset, (Instrumentation)instr);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(20).append("Invalid modelType: ").append((Object)this.$(this.modelType())).append(".").toString());
                }
            }
            return naiveBayesModel;
        });
    }

    private NaiveBayesModel trainDiscreteImpl(Dataset<?> dataset, Instrumentation instr) {
        NaiveBayesModel naiveBayesModel;
        boolean bl;
        Iterator iterator;
        boolean bl2;
        UserDefinedFunction userDefinedFunction;
        boolean bl3;
        SparkSession spark = dataset.sparkSession();
        String string = this.$(this.modelType());
        String string2 = NaiveBayes$.MODULE$.Multinomial();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            bl3 = true;
        } else {
            String string4 = NaiveBayes$.MODULE$.Complement();
            String string5 = string;
            bl3 = !(string4 != null ? !string4.equals(string5) : string5 != null);
        }
        if (bl3) {
            public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_NaiveBayes$$typecreator2$1(NaiveBayes $outer) {
                }
            }
            public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_NaiveBayes$$typecreator1$1(NaiveBayes $outer) {
                }
            }
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
            JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
            userDefinedFunction = org.apache.spark.sql.functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> {
                NaiveBayes$.MODULE$.requireNonnegativeValues((Vector)vector);
                return vector;
            }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator2$1(null)));
        } else {
            String string6 = NaiveBayes$.MODULE$.Bernoulli();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_NaiveBayes$$typecreator4$1(NaiveBayes $outer) {
                    }
                }
                public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_NaiveBayes$$typecreator3$1(NaiveBayes $outer) {
                    }
                }
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
                JavaUniverse $u3 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
                userDefinedFunction = org.apache.spark.sql.functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> {
                    NaiveBayes$.MODULE$.requireZeroOneBernoulliValues((Vector)vector);
                    return vector;
                }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator3$1(null)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator4$1(null)));
            } else {
                throw new MatchError((Object)string);
            }
        }
        UserDefinedFunction validateUDF = userDefinedFunction;
        Column w = this.isDefined(this.weightCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(this.weightCol()))).nonEmpty() ? functions$.MODULE$.checkNonNegativeWeight().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.col(this.$(this.weightCol())).cast((DataType)DoubleType$.MODULE$)})) : org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_classification_NaiveBayes$$typecreator9$1(NaiveBayes $outer) {
            }
        }
        Tuple4[] aggregated = (Tuple4[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.col(this.$(this.labelCol()))})).agg(org.apache.spark.sql.functions$.MODULE$.sum(w).as("weightSum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Summarizer$.MODULE$.metrics((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sum", "count"})).summary(validateUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.col(this.$(this.featuresCol()))})), w).as("summary")})).select(this.$(this.labelCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"weightSum", "summary.sum", "summary.count"})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator9$1(null)))).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainDiscreteImpl$3(x$1)), (Ordering)Ordering.Double$.MODULE$);
        int numFeatures = ((Vector)((Tuple4)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregated)).head())._3()).size();
        instr.logNumFeatures(numFeatures);
        long numSamples = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregated)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)NaiveBayes.$anonfun$trainDiscreteImpl$4(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        instr.logNumExamples(numSamples);
        int numLabels = aggregated.length;
        instr.logNumClasses(numLabels);
        double numDocuments = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregated)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainDiscreteImpl$5(x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        instr.logSumOfWeights(numDocuments);
        double[] labelArray = new double[numLabels];
        double[] piArray = new double[numLabels];
        double[] thetaArray = new double[numLabels * numFeatures];
        String string8 = this.$(this.modelType());
        String string9 = NaiveBayes$.MODULE$.Multinomial();
        String string10 = string8;
        if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
            bl2 = true;
        } else {
            String string11 = NaiveBayes$.MODULE$.Bernoulli();
            String string12 = string8;
            bl2 = !(string11 != null ? !string11.equals(string12) : string12 != null);
        }
        if (bl2) {
            iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregated)).iterator();
        } else {
            String string13 = NaiveBayes$.MODULE$.Complement();
            String string14 = string8;
            if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                Vector featureSum = Vectors$.MODULE$.zeros(numFeatures);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregated)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    NaiveBayes.$anonfun$trainDiscreteImpl$6(featureSum, x0$1);
                    return BoxedUnit.UNIT;
                });
                iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregated)).iterator().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple4 tuple4 = x0$2;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    double label = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double n = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    Vector sumTermFreqs = (Vector)tuple4._3();
                    long count = BoxesRunTime.unboxToLong((Object)tuple4._4());
                    Vector comp = featureSum.copy();
                    BLAS$.MODULE$.axpy(-1.0, sumTermFreqs, comp);
                    Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)n), (Object)comp, (Object)BoxesRunTime.boxToLong((long)count));
                    return tuple42;
                });
            } else {
                throw new MatchError((Object)string8);
            }
        }
        Iterator aggIter = iterator;
        double lambda = BoxesRunTime.unboxToDouble((Object)this.$(this.smoothing()));
        double piLogDenom = scala.math.package$.MODULE$.log(numDocuments + (double)numLabels * lambda);
        IntRef i = IntRef.create((int)0);
        aggIter.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            NaiveBayes.$anonfun$trainDiscreteImpl$8(this, labelArray, i, piArray, lambda, piLogDenom, numFeatures, thetaArray, x0$3);
            return BoxedUnit.UNIT;
        });
        Vector pi = Vectors$.MODULE$.dense(piArray);
        String string15 = this.$(this.modelType());
        String string16 = NaiveBayes$.MODULE$.Multinomial();
        String string17 = string15;
        if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
            bl = true;
        } else {
            String string18 = NaiveBayes$.MODULE$.Bernoulli();
            String string19 = string15;
            bl = !(string18 != null ? !string18.equals(string19) : string19 != null);
        }
        if (bl) {
            DenseMatrix theta = new DenseMatrix(numLabels, numFeatures, thetaArray, true);
            naiveBayesModel = new NaiveBayesModel(this.uid(), pi.compressed(), theta.compressed(), Matrices$.MODULE$.zeros(0, 0)).setOldLabels(labelArray);
        } else {
            String string20 = NaiveBayes$.MODULE$.Complement();
            String string21 = string15;
            if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
                DenseMatrix theta = new DenseMatrix(numLabels, numFeatures, (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(thetaArray)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)v -> -v, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), true);
                naiveBayesModel = new NaiveBayesModel(this.uid(), pi.compressed(), theta.compressed(), Matrices$.MODULE$.zeros(0, 0));
            } else {
                throw new MatchError((Object)string15);
            }
        }
        return naiveBayesModel;
    }

    private NaiveBayesModel trainGaussianImpl(Dataset<?> dataset, Instrumentation instr) {
        public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_classification_NaiveBayes$$typecreator6$1(NaiveBayes $outer) {
            }
        }
        SparkSession spark = dataset.sparkSession();
        Column w = this.isDefined(this.weightCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(this.weightCol()))).nonEmpty() ? functions$.MODULE$.checkNonNegativeWeight().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.col(this.$(this.weightCol())).cast((DataType)DoubleType$.MODULE$)})) : org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayes.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$1(NaiveBayes $outer) {
            }
        }
        Tuple4[] aggregated = (Tuple4[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.col(this.$(this.labelCol()))})).agg(org.apache.spark.sql.functions$.MODULE$.sum(w).as("weightSum"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{Summarizer$.MODULE$.metrics((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "normL2"})).summary(org.apache.spark.sql.functions$.MODULE$.col(this.$(this.featuresCol())), w).as("summary")})).select(this.$(this.labelCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"weightSum", "summary.mean", "summary.normL2"})).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator5$1(null)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            double label = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double weightSum = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector mean = (Vector)tuple4._3();
            Vector normL2 = (Vector)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)weightSum), (Object)mean, (Object)Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(normL2.toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)v -> v * v, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
            return tuple42;
        }, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayes$$typecreator6$1(null)))).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainGaussianImpl$3(x$4)), (Ordering)Ordering.Double$.MODULE$);
        int numFeatures = ((Vector)((Tuple4)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregated)).head())._3()).size();
        instr.logNumFeatures(numFeatures);
        int numLabels = aggregated.length;
        instr.logNumClasses(numLabels);
        double numInstances = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregated)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)NaiveBayes.$anonfun$trainGaussianImpl$4(x$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        instr.logSumOfWeights(numInstances);
        double epsilon = BoxesRunTime.unboxToDouble((Object)package$.MODULE$.Iterator().range(0, numFeatures).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> {
            DoubleRef globalSum = DoubleRef.create((double)0.0);
            DoubleRef globalSqrSum = DoubleRef.create((double)0.0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregated)).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                NaiveBayes.$anonfun$trainGaussianImpl$6(globalSum, j, globalSqrSum, x0$2);
                return BoxedUnit.UNIT;
            });
            return globalSqrSum.elem / numInstances - globalSum.elem * globalSum.elem / numInstances / numInstances;
        }).max((Ordering)Ordering.Double$.MODULE$)) * 1.0E-9;
        double[] piArray = new double[numLabels];
        double[] thetaArray = new double[numLabels * numFeatures];
        double[] sigmaArray = new double[numLabels * numFeatures];
        IntRef i = IntRef.create((int)0);
        double logNumInstances = scala.math.package$.MODULE$.log(numInstances);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggregated)).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            NaiveBayes.$anonfun$trainGaussianImpl$7(piArray, i, logNumInstances, numFeatures, thetaArray, sigmaArray, epsilon, x0$3);
            return BoxedUnit.UNIT;
        });
        Vector pi = Vectors$.MODULE$.dense(piArray);
        DenseMatrix theta = new DenseMatrix(numLabels, numFeatures, thetaArray, true);
        DenseMatrix sigma = new DenseMatrix(numLabels, numFeatures, sigmaArray, true);
        return new NaiveBayesModel(this.uid(), pi.compressed(), theta.compressed(), sigma.compressed());
    }

    @Override
    public NaiveBayes copy(ParamMap extra) {
        return (NaiveBayes)this.defaultCopy(extra);
    }

    public static final /* synthetic */ double $anonfun$trainDiscreteImpl$3(Tuple4 x$1) {
        return BoxesRunTime.unboxToDouble((Object)x$1._1());
    }

    public static final /* synthetic */ long $anonfun$trainDiscreteImpl$4(Tuple4 x$2) {
        return BoxesRunTime.unboxToLong((Object)x$2._4());
    }

    public static final /* synthetic */ double $anonfun$trainDiscreteImpl$5(Tuple4 x$3) {
        return BoxesRunTime.unboxToDouble((Object)x$3._2());
    }

    public static final /* synthetic */ void $anonfun$trainDiscreteImpl$6(Vector featureSum$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Vector sumTermFreqs = (Vector)tuple4._3();
        BLAS$.MODULE$.axpy(1.0, sumTermFreqs, featureSum$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$trainDiscreteImpl$8(NaiveBayes $this, double[] labelArray$1, IntRef i$1, double[] piArray$1, double lambda$1, double piLogDenom$1, int numFeatures$1, double[] thetaArray$1, Tuple4 x0$3) {
        Tuple4 tuple4 = x0$3;
        if (tuple4 != null) {
            double d;
            boolean bl;
            double label = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double n = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector sumTermFreqs = (Vector)tuple4._3();
            labelArray$1[i$1.elem] = label;
            piArray$1[i$1.elem] = scala.math.package$.MODULE$.log(n + lambda$1) - piLogDenom$1;
            String string = $this.$($this.modelType());
            String string2 = NaiveBayes$.MODULE$.Multinomial();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Complement();
                String string5 = string;
                bl = !(string4 != null ? !string4.equals(string5) : string5 != null);
            }
            if (bl) {
                d = scala.math.package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sumTermFreqs.toArray())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + (double)numFeatures$1 * lambda$1);
            } else {
                String string6 = NaiveBayes$.MODULE$.Bernoulli();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    d = scala.math.package$.MODULE$.log(n + 2.0 * lambda$1);
                } else {
                    throw new MatchError((Object)string);
                }
            }
            double thetaLogDenom = d;
            int offset = i$1.elem * numFeatures$1;
            for (int j = 0; j < numFeatures$1; ++j) {
                thetaArray$1[offset + j] = scala.math.package$.MODULE$.log(sumTermFreqs.apply(j) + lambda$1) - thetaLogDenom;
            }
            ++i$1.elem;
        } else {
            throw new MatchError((Object)tuple4);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$trainGaussianImpl$3(Tuple4 x$4) {
        return BoxesRunTime.unboxToDouble((Object)x$4._1());
    }

    public static final /* synthetic */ double $anonfun$trainGaussianImpl$4(Tuple4 x$5) {
        return BoxesRunTime.unboxToDouble((Object)x$5._2());
    }

    public static final /* synthetic */ void $anonfun$trainGaussianImpl$6(DoubleRef globalSum$1, int j$1, DoubleRef globalSqrSum$1, Tuple4 x0$2) {
        Tuple4 tuple4 = x0$2;
        if (tuple4 != null) {
            double weightSum = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector mean = (Vector)tuple4._3();
            Vector squareSum = (Vector)tuple4._4();
            globalSum$1.elem += mean.apply(j$1) * weightSum;
            globalSqrSum$1.elem += squareSum.apply(j$1);
        } else {
            throw new MatchError((Object)tuple4);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$trainGaussianImpl$7(double[] piArray$2, IntRef i$2, double logNumInstances$1, int numFeatures$2, double[] thetaArray$2, double[] sigmaArray$1, double epsilon$1, Tuple4 x0$3) {
        Tuple4 tuple4 = x0$3;
        if (tuple4 != null) {
            double weightSum = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            Vector mean = (Vector)tuple4._3();
            Vector squareSum = (Vector)tuple4._4();
            piArray$2[i$2.elem] = scala.math.package$.MODULE$.log(weightSum) - logNumInstances$1;
            int offset = i$2.elem * numFeatures$2;
            for (int j = 0; j < numFeatures$2; ++j) {
                double m;
                thetaArray$2[offset + j] = m = mean.apply(j);
                sigmaArray$1[offset + j] = epsilon$1 + squareSum.apply(j) / weightSum - m * m;
            }
            ++i$2.elem;
        } else {
            throw new MatchError((Object)tuple4);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public NaiveBayes(String uid) {
        this.uid = uid;
        HasWeightCol.$init$(this);
        NaiveBayesParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public NaiveBayes() {
        this(Identifiable$.MODULE$.randomUID("nb"));
    }
}

