/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tuning;

import java.io.IOException;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionSuite;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.tuning.CrossValidator;
import org.apache.spark.ml.tuning.CrossValidatorModel;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.Assert;
import org.junit.Test;

public class JavaCrossValidatorSuite
extends SharedSparkSession {
    private transient Dataset<Row> dataset;

    @Override
    public void setUp() throws IOException {
        super.setUp();
        List<LabeledPoint> points = LogisticRegressionSuite.generateLogisticInputAsList(1.0, 1.0, 100, 42);
        this.dataset = this.spark.createDataFrame(this.jsc.parallelize(points, 2), LabeledPoint.class);
    }

    @Test
    public void crossValidationWithLogisticRegression() {
        LogisticRegression lr = new LogisticRegression();
        ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.001, 1000.0}).addGrid(lr.maxIter(), new int[]{0, 10}).build();
        BinaryClassificationEvaluator eval = new BinaryClassificationEvaluator();
        CrossValidator cv = new CrossValidator().setEstimator((Estimator)lr).setEstimatorParamMaps(lrParamMaps).setEvaluator((Evaluator)eval).setNumFolds(3);
        CrossValidatorModel cvModel = cv.fit(this.dataset);
        LogisticRegression parent = (LogisticRegression)cvModel.bestModel().parent();
        Assert.assertEquals((double)0.001, (double)parent.getRegParam(), (double)0.0);
        Assert.assertEquals((long)10L, (long)parent.getMaxIter());
    }
}

