/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.LeastSquaresBlockAggregator;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001A4A\u0001E\t\u0001=!)1\u0006\u0001C\u0001Y!Iq\u0006\u0001a\u0001\u0002\u0004%\t\u0001\r\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002yB\u0011\u0002\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B\u0019\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0003\u0001\u0004\"\u0003&\u0001\u0001\u0004\u0005\r\u0011\"\u0001L\u0011%i\u0005\u00011A\u0001B\u0003&\u0011\u0007C\u0005P\u0001\u0001\u0007\t\u0019!C\u0001a!I\u0001\u000b\u0001a\u0001\u0002\u0004%\t!\u0015\u0005\n'\u0002\u0001\r\u0011!Q!\nEB\u0011\"\u0016\u0001A\u0002\u0003\u0007I\u0011\u0001\u0019\t\u0013Y\u0003\u0001\u0019!a\u0001\n\u00039\u0006\"C-\u0001\u0001\u0004\u0005\t\u0015)\u00032\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015i\u0006\u0001\"\u0003_\u0005\u0001bU-Y:u'F,\u0018M]3t\u00052|7m[!hOJ,w-\u0019;peN+\u0018\u000e^3\u000b\u0005I\u0019\u0012AC1hOJ,w-\u0019;pe*\u0011A#F\u0001\u0006_B$\u0018.\u001c\u0006\u0003-]\t!!\u001c7\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001?\r\u0002\"\u0001I\u0011\u000e\u0003]I!AI\f\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0003vi&d'B\u0001\u0015\u0018\u0003\u0015iG\u000e\\5c\u0013\tQSEA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005i\u0003C\u0001\u0018\u0001\u001b\u0005\t\u0012!C5ogR\fgnY3t+\u0005\t\u0004c\u0001\u001a6o5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14GA\u0003BeJ\f\u0017\u0010\u0005\u00029w5\t\u0011H\u0003\u0002;+\u00059a-Z1ukJ,\u0017B\u0001\u001f:\u0005!Ien\u001d;b]\u000e,\u0017!D5ogR\fgnY3t?\u0012*\u0017\u000f\u0006\u0002@\u0005B\u0011!\u0007Q\u0005\u0003\u0003N\u0012A!\u00168ji\"91iAA\u0001\u0002\u0004\t\u0014a\u0001=%c\u0005Q\u0011N\\:uC:\u001cWm\u001d\u0011)\u0005\u00111\u0005C\u0001\u001aH\u0013\tA5GA\u0005ue\u0006t7/[3oi\u0006A\u0012N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;GK\u0006$XO]3\u00029%t7\u000f^1oG\u0016\u001c8i\u001c8ti\u0006tGOR3biV\u0014Xm\u0018\u0013fcR\u0011q\b\u0014\u0005\b\u0007\u001a\t\t\u00111\u00012\u0003eIgn\u001d;b]\u000e,7oQ8ogR\fg\u000e\u001e$fCR,(/\u001a\u0011)\u0005\u001d1\u0015\u0001I5ogR\fgnY3t\u0007>t7\u000f^1oi\u001a+\u0017\r^;sK\u001aKG\u000e^3sK\u0012\fA%\u001b8ti\u0006t7-Z:D_:\u001cH/\u00198u\r\u0016\fG/\u001e:f\r&dG/\u001a:fI~#S-\u001d\u000b\u0003\u007fICqaQ\u0005\u0002\u0002\u0003\u0007\u0011'A\u0011j]N$\u0018M\\2fg\u000e{gn\u001d;b]R4U-\u0019;ve\u00164\u0015\u000e\u001c;fe\u0016$\u0007\u0005\u000b\u0002\u000b\r\u0006y1oY1mK\u0012Len\u001d;b]\u000e,7/A\ntG\u0006dW\rZ%ogR\fgnY3t?\u0012*\u0017\u000f\u0006\u0002@1\"91\tDA\u0001\u0002\u0004\t\u0014\u0001E:dC2,G-\u00138ti\u0006t7-Z:!Q\tia)A\u0005cK\u001a|'/Z!mYR\tq(\u0001\thKRtUm^!hOJ,w-\u0019;peR!qLY2l!\tq\u0003-\u0003\u0002b#\tYB*Z1tiN\u000bX/\u0019:fg\ncwnY6BO\u001e\u0014XmZ1u_JDQaL\bA\u0002EBQ\u0001Z\bA\u0002\u0015\fAbY8fM\u001aL7-[3oiN\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\u000b\u0002\r1Lg.\u00197h\u0013\tQwM\u0001\u0004WK\u000e$xN\u001d\u0005\u0006Y>\u0001\r!\\\u0001\rM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\t\u0003e9L!a\\\u001a\u0003\u000f\t{w\u000e\\3b]\u0002")
public class LeastSquaresBlockAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantFeatureFiltered;
    private transient Instance[] scaledInstances;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantFeatureFiltered() {
        return this.instancesConstantFeatureFiltered;
    }

    public void instancesConstantFeatureFiltered_$eq(Instance[] x$1) {
        this.instancesConstantFeatureFiltered = x$1;
    }

    public Instance[] scaledInstances() {
        return this.scaledInstances;
    }

    public void scaledInstances_$eq(Instance[] x$1) {
        this.scaledInstances = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(0.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(1.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeatureFiltered_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.3, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
        this.scaledInstances_$eq(this.standardize(this.instances()));
    }

    private LeastSquaresBlockAggregator getNewAggregator(Instance[] instances, Vector coefficients, boolean fitIntercept) {
        int x$2;
        WrappedArray x$1;
        SparkContext qual$1 = this.sc();
        Tuple2 tuple2 = Summarizer$.MODULE$.getRegressionSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])instances)), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getRegressionSummarizers$default$2(), Summarizer$.MODULE$.getRegressionSummarizers$default$3());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
        SummarizerBuffer ySummarizer = (SummarizerBuffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
        Tuple2 tuple23 = tuple22;
        SummarizerBuffer featuresSummarizer2 = (SummarizerBuffer)tuple23._1();
        SummarizerBuffer ySummarizer2 = (SummarizerBuffer)tuple23._2();
        double yStd = ySummarizer2.std().apply(0);
        double yMean = ySummarizer2.mean().apply(0);
        double[] featuresStd = featuresSummarizer2.std().toArray();
        double[] featuresMean = featuresSummarizer2.mean().toArray();
        double[] inverseStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresStd)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)std -> std != 0.0 ? 1.0 / std : 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] scaledMean = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(inverseStd)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(featuresMean), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToDouble((double)LeastSquaresBlockAggregatorSuite.$anonfun$getNewAggregator$2(t)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Broadcast bcInverseStd = this.sc().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = this.sc().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcCoefficients = this.sc().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new LeastSquaresBlockAggregator(bcInverseStd, bcScaledMean, fitIntercept, yStd, yMean, bcCoefficients);
    }

    private final void testImplicits$lzycompute$1() {
        LeastSquaresBlockAggregatorSuite leastSquaresBlockAggregatorSuite = this;
        synchronized (leastSquaresBlockAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$getNewAggregator$2(Tuple2 t) {
        return t._1$mcD$sp() * t._2$mcD$sp();
    }

    public static final /* synthetic */ double $anonfun$new$13(int numFeatures$1, double[] featuresMean$1, double[] featuresStd$1, double yMean$1, double yStd$1, Vector coefficients$1, Instance x0$1) {
        Instance instance = x0$1;
        if (instance == null) {
            throw new MatchError((Object)instance);
        }
        double l = instance.label();
        Vector f = instance.features();
        double[] scaledFeatures = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures$1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> (f.toArray()[j] - featuresMean$1[j]) / featuresStd$1[j], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        double scaledLabel = (l - yMean$1) / yStd$1;
        double d = BLAS$.MODULE$.dot(coefficients$1, Vectors$.MODULE$.dense(scaledFeatures)) - scaledLabel;
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$15(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double error = tuple2._1$mcD$sp();
        Instance instance = (Instance)tuple2._2();
        double d = instance.weight() * error * error / 2.0;
        return d;
    }

    public static final /* synthetic */ void $anonfun$new$16(int numFeatures$1, double[] featuresStd$1, Vector expectedGradient$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double error = tuple2._1$mcD$sp();
        Instance instance = (Instance)tuple2._2();
        double[] scaledFeatures = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures$1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> instance.weight() * instance.features().toArray()[j] / featuresStd$1[j], IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
        BLAS$.MODULE$.axpy(error, Vectors$.MODULE$.dense(scaledFeatures), expectedGradient$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LeastSquaresBlockAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("sparse coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Broadcast bcInverseStd = this.sc().broadcast((Object)new double[]{1.0}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Broadcast bcScaledMean = this.sc().broadcast((Object)new double[]{2.0}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Broadcast bcCoefficients = this.sc().broadcast((Object)Vectors$.MODULE$.sparse(1, new int[]{0}, new double[]{1.0}), ClassTag$.MODULE$.apply(Vector.class));
            LeastSquaresBlockAggregator binaryAgg = new LeastSquaresBlockAggregator(bcInverseStd, bcScaledMean, false, 1.0, 2.0, bcCoefficients);
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (List)Nil$.MODULE$));
            IllegalArgumentException thrownBinary = (IllegalArgumentException)this.withClue("aggregator cannot handle sparse coefficients", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> binaryAgg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81)));
            String $org_scalatest_assert_macro_left = thrownBinary.getMessage();
            String $org_scalatest_assert_macro_right = "coefficients only supports dense";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }, new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("aggregator add method input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0};
            LeastSquaresBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense(coefArray), true);
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (List)Nil$.MODULE$));
            return (IllegalArgumentException)this.withClue("BinaryLogisticBlockAggregator features dimension must match coefficients dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93)));
        }, new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0};
            LeastSquaresBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense(coefArray), true);
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), (List)Nil$.MODULE$));
            return (IllegalArgumentException)this.withClue("BinaryLogisticBlockAggregator does not support negative instance weights", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104)));
        }, new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("check sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = new Random();
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            Vector coefVec = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.instances()));
            LeastSquaresBlockAggregator agg = this.getNewAggregator(this.instances(), coefVec, true);
            agg.add(block);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)agg.gradient().size()));
            int $org_scalatest_assert_macro_right = numFeatures;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }, new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.test("check correctness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$2;
            WrappedArray x$1;
            Vector coefficients = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            int numFeatures = coefficients.size();
            SparkContext qual$1 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getRegressionSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getRegressionSummarizers$default$2(), Summarizer$.MODULE$.getRegressionSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer ySummarizer = (SummarizerBuffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
            Tuple2 tuple23 = tuple22;
            SummarizerBuffer featuresSummarizer2 = (SummarizerBuffer)tuple23._1();
            SummarizerBuffer ySummarizer2 = (SummarizerBuffer)tuple23._2();
            double[] featuresStd = featuresSummarizer2.std().toArray();
            double[] featuresMean = featuresSummarizer2.mean().toArray();
            double yStd = ySummarizer2.std().apply(0);
            double yMean = ySummarizer2.mean().apply(0);
            double[] errors = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LeastSquaresBlockAggregatorSuite.$anonfun$new$13(numFeatures, featuresMean, featuresStd, yMean, yStd, coefficients, x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] expectedLoss = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(errors)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.instances()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)LeastSquaresBlockAggregatorSuite.$anonfun$new$15(x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            Vector expectedGradient = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(errors)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])this.instances()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                LeastSquaresBlockAggregatorSuite.$anonfun$new$16(numFeatures, featuresStd, expectedGradient, x0$3);
                return BoxedUnit.UNIT;
            });
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            BLAS$.MODULE$.scal(1.0 / weightSum, expectedGradient);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scaledInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)new .colon.colon((Object)blocks1, (List)new .colon.colon((Object)blocks2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    LeastSquaresBlockAggregator agg = this.getNewAggregator(this.instances(), coefficients, true);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> agg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(expectedLoss)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / weightSum).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(expectedLoss).sum[Double](math.this.Numeric.DoubleIsFractional)./(weightSum)).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expectedGradient).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expectedGradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                });
            });
        }, new Position("LeastSquaresBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }
}

