/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import java.io.Serializable;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

public final class LinearSVCSuite$
implements scala.Serializable {
    public static LinearSVCSuite$ MODULE$;
    private final Map<String, Object> allParamSettings;

    static {
        new LinearSVCSuite$();
    }

    public Map<String, Object> allParamSettings() {
        return this.allParamSettings;
    }

    public Seq<LabeledPoint> generateSVMInput(double intercept, double[] weights, int nPoints, int seed) {
        Random rnd = new Random(seed);
        DenseVector.mcD.sp weightsMat = new DenseVector.mcD.sp(weights);
        double[][] x = (double[][])Array$.MODULE$.fill(nPoints, (Function0 & Serializable & scala.Serializable)() -> (double[])Array$.MODULE$.fill(weights.length, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rnd.nextDouble() * 2.0 - 1.0, ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        double[] y = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).map(arg_0 -> LinearSVCSuite$.$anonfun$generateSVMInput$3$adapted((DenseVector)weightsMat, intercept, rnd, arg_0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(y)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)p -> new LabeledPoint(p._1$mcD$sp(), Vectors$.MODULE$.dense((double[])p._2())), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public void checkModels(LinearSVCModel model1, LinearSVCModel model2) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model1.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model2.intercept()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model1.intercept).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(model2.intercept).relTol(1.0E-9))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearSVCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model1.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model2.coefficients()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model1.coefficients).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(model2.coefficients).relTol(1.0E-9))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearSVCSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ double $anonfun$generateSVMInput$3(DenseVector weightsMat$1, double intercept$1, Random rnd$1, double[] xi) {
        double yD = BoxesRunTime.unboxToDouble((Object)new DenseVector.mcD.sp(xi).dot((Object)weightsMat$1, (UFunc.UImpl2)DenseVector.canDotD$.MODULE$)) + intercept$1 + 0.01 * rnd$1.nextGaussian();
        return yD > 0.0 ? 1.0 : 0.0;
    }

    private LinearSVCSuite$() {
        MODULE$ = this;
        this.allParamSettings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"regParam"), (Object)BoxesRunTime.boxToDouble((double)0.01)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxIter"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fitIntercept"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tol"), (Object)BoxesRunTime.boxToDouble((double)0.8)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"standardization"), (Object)BoxesRunTime.boxToBoolean((boolean)false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"threshold"), (Object)BoxesRunTime.boxToDouble((double)0.6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"predictionCol"), (Object)"myPredict"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rawPredictionCol"), (Object)"myRawPredict"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aggregationDepth"), (Object)BoxesRunTime.boxToInteger((int)3))}));
    }

    public static final /* synthetic */ Object $anonfun$generateSVMInput$3$adapted(DenseVector weightsMat$1, double intercept$1, Random rnd$1, double[] xi) {
        return BoxesRunTime.boxToDouble((double)LinearSVCSuite$.$anonfun$generateSVMInput$3(weightsMat$1, intercept$1, rnd$1, xi));
    }
}

