/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.PipelineSuite$;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.UnWritableStage;
import org.apache.spark.ml.WritableStage;
import org.apache.spark.ml.feature.HashingTF;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.MinMaxScaler;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatestplus.mockito.MockitoSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000112A\u0001B\u0003\u0001\u001d!)\u0001\u0005\u0001C\u0001C\u0019)A\u0005AA\u0001K!)\u0001E\u0001C\u0001W\ti\u0001+\u001b9fY&tWmU;ji\u0016T!AB\u0004\u0002\u00055d'B\u0001\u0005\n\u0003\u0015\u0019\b/\u0019:l\u0015\tQ1\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0005\u0019qN]4\u0004\u0001M!\u0001aD\n\u001c!\t\u0001\u0012#D\u0001\b\u0013\t\u0011rAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003)ei\u0011!\u0006\u0006\u0003-]\tA!\u001e;jY*\u0011\u0001dB\u0001\u0006[2d\u0017NY\u0005\u00035U\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002\u001d=5\tQD\u0003\u0002\u0017\u000b%\u0011q$\b\u0002\u0015\t\u00164\u0017-\u001e7u%\u0016\fGm\u0016:ji\u0016$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0011\u0003CA\u0012\u0001\u001b\u0005)!aB'z\u001b>$W\r\\\n\u0003\u0005\u0019\u00022aI\u0014*\u0013\tASAA\u0003N_\u0012,G\u000e\u0005\u0002+\u00055\t\u0001\u0001F\u0001*\u0001")
public class PipelineSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        PipelineSuite pipelineSuite = this;
        synchronized (pipelineSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    private final void testStage$1(int stageIdx, int numStages, String expectedPrefix, String stageUid$1, String stagesDir$1) {
        String path = Pipeline.SharedReadWrite$.MODULE$.getStagePath(stageUid$1, stageIdx, numStages, stagesDir$1);
        String expected = new Path(stagesDir$1, new StringBuilder(1).append(expectedPrefix).append("_").append(stageUid$1).toString()).toString();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(path);
        String $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
    }

    public PipelineSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("pipeline", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset output;
            Estimator estimator0 = (Estimator)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Estimator.class));
            MyModel model0 = (MyModel)((Object)((Object)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(MyModel.class))));
            Transformer transformer1 = (Transformer)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Transformer.class));
            Estimator estimator2 = (Estimator)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Estimator.class));
            MyModel model2 = (MyModel)((Object)((Object)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(MyModel.class))));
            Transformer transformer3 = (Transformer)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Transformer.class));
            Dataset dataset0 = (Dataset)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Dataset.class));
            Dataset dataset1 = (Dataset)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Dataset.class));
            Dataset dataset2 = (Dataset)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Dataset.class));
            Dataset dataset3 = (Dataset)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Dataset.class));
            Dataset dataset4 = (Dataset)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Dataset.class));
            Mockito.when((Object)dataset0.toDF()).thenReturn((Object)dataset0);
            Mockito.when((Object)dataset1.toDF()).thenReturn((Object)dataset1);
            Mockito.when((Object)dataset2.toDF()).thenReturn((Object)dataset2);
            Mockito.when((Object)dataset3.toDF()).thenReturn((Object)dataset3);
            Mockito.when((Object)dataset4.toDF()).thenReturn((Object)dataset4);
            Mockito.when((Object)estimator0.copy((ParamMap)ArgumentMatchers.any())).thenReturn((Object)estimator0);
            Mockito.when((Object)model0.copy((ParamMap)ArgumentMatchers.any())).thenReturn((Object)model0);
            Mockito.when((Object)transformer1.copy((ParamMap)ArgumentMatchers.any())).thenReturn((Object)transformer1);
            Mockito.when((Object)estimator2.copy((ParamMap)ArgumentMatchers.any())).thenReturn((Object)estimator2);
            Mockito.when((Object)model2.copy((ParamMap)ArgumentMatchers.any())).thenReturn((Object)model2);
            Mockito.when((Object)transformer3.copy((ParamMap)ArgumentMatchers.any())).thenReturn((Object)transformer3);
            Mockito.when((Object)estimator0.fit((Dataset)ArgumentMatchers.eq((Object)dataset0))).thenReturn((Object)model0);
            Mockito.when((Object)model0.transform((Dataset)ArgumentMatchers.eq((Object)dataset0))).thenReturn((Object)dataset1);
            Mockito.when((Object)model0.parent()).thenReturn((Object)estimator0);
            Mockito.when((Object)transformer1.transform((Dataset)ArgumentMatchers.eq((Object)dataset1))).thenReturn((Object)dataset2);
            Mockito.when((Object)estimator2.fit((Dataset)ArgumentMatchers.eq((Object)dataset2))).thenReturn((Object)model2);
            Mockito.when((Object)model2.transform((Dataset)ArgumentMatchers.eq((Object)dataset2))).thenReturn((Object)dataset3);
            Mockito.when((Object)model2.parent()).thenReturn((Object)estimator2);
            Mockito.when((Object)transformer3.transform((Dataset)ArgumentMatchers.eq((Object)dataset3))).thenReturn((Object)dataset4);
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{estimator0, transformer1, estimator2, transformer3}));
            PipelineModel pipelineModel = pipeline.fit(dataset0);
            MLTestingUtils$.MODULE$.checkCopyAndUids(pipeline, (Model<?>)pipelineModel);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)pipelineModel.stages().length));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            Transformer $org_scalatest_assert_macro_left2 = pipelineModel.stages()[0];
            MyModel $org_scalatest_assert_macro_right2 = model0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Transformer $org_scalatest_assert_macro_left3 = pipelineModel.stages()[1];
            Transformer $org_scalatest_assert_macro_right3 = transformer1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Transformer $org_scalatest_assert_macro_left4 = pipelineModel.stages()[2];
            MyModel $org_scalatest_assert_macro_right4 = model2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "eq", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            Transformer $org_scalatest_assert_macro_left5 = pipelineModel.stages()[3];
            Transformer $org_scalatest_assert_macro_right5 = transformer3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "eq", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Dataset $org_scalatest_assert_macro_left6 = output = pipelineModel.transform(dataset0);
            Dataset $org_scalatest_assert_macro_right6 = dataset4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "eq", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("pipeline with duplicate stages", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Estimator estimator = (Estimator)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Estimator.class));
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])new Estimator[]{estimator, estimator});
            Dataset dataset = (Dataset)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Dataset.class));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> pipeline.fit(dataset), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("Pipeline.copy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            HashingTF hashingTF = new HashingTF().setNumFeatures(100);
            Pipeline pipeline = new Pipeline("pipeline").setStages((PipelineStage[])new Transformer[]{hashingTF});
            Pipeline copied = pipeline.copy(ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{hashingTF.numFeatures().$minus$greater((Object)BoxesRunTime.boxToInteger((int)10))})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(copied.uid());
            String $org_scalatest_assert_macro_right = pipeline.uid();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"copy should create an instance with the same UID", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((HashingTF)copied.getStages()[0]).getNumFeatures()));
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"copy should handle extra stage params", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("PipelineModel.copy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            HashingTF hashingTF = new HashingTF().setNumFeatures(100);
            PipelineModel model = (PipelineModel)new PipelineModel("pipelineModel", (Transformer[])((Object[])new Transformer[]{hashingTF})).setParent((Estimator)new Pipeline());
            PipelineModel copied = model.copy(ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{hashingTF.numFeatures().$minus$greater((Object)BoxesRunTime.boxToInteger((int)10))})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(copied.uid());
            String $org_scalatest_assert_macro_right = model.uid();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"copy should create an instance with the same UID", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((HashingTF)copied.stages()[0]).getNumFeatures()));
            int $org_scalatest_assert_macro_right2 = 10;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"copy should handle extra stage params", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(copied.parent());
            Estimator $org_scalatest_assert_macro_right3 = model.parent();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"copy should create an instance with the same parent", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("pipeline model constructors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Transformer transform0 = (Transformer)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Transformer.class));
            MyModel model1 = (MyModel)((Object)((Object)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(MyModel.class))));
            Transformer[] stages = (Transformer[])((Object[])new Transformer[]{transform0, model1});
            PipelineModel pipelineModel0 = new PipelineModel("pipeline0", stages);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(pipelineModel0.uid());
            String $org_scalatest_assert_macro_right = "pipeline0";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(pipelineModel0.stages());
            Transformer[] $org_scalatest_assert_macro_right2 = stages;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            java.util.List stagesAsList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stages)).toList()).asJava();
            PipelineModel pipelineModel1 = new PipelineModel("pipeline1", stagesAsList);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(pipelineModel1.uid());
            String $org_scalatest_assert_macro_right3 = "pipeline1";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(pipelineModel1.stages());
            Transformer[] $org_scalatest_assert_macro_right4 = stages;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("Pipeline read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            WritableStage writableStage = new WritableStage("writableStage").setIntParam(56);
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new WritableStage[]{writableStage}));
            Pipeline pipeline2 = this.testDefaultReadWrite(pipeline, false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)pipeline2.getStages().length));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            PipelineStage $org_scalatest_assert_macro_left2 = pipeline2.getStages()[0];
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.WritableStage", $org_scalatest_assert_macro_left2 instanceof WritableStage, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            WritableStage writableStage2 = (WritableStage)pipeline2.getStages()[0];
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)writableStage.getIntParam()));
            int $org_scalatest_assert_macro_right2 = writableStage2.getIntParam();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        this.test("Pipeline read/write with non-Writable stage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            UnWritableStage unWritableStage = new UnWritableStage("unwritableStage");
            Pipeline unWritablePipeline = new Pipeline().setStages((PipelineStage[])((Object[])new UnWritableStage[]{unWritableStage}));
            return (UnsupportedOperationException)this.withClue("Pipeline.write should fail when Pipeline contains non-Writable stage", (Function0 & Serializable & scala.Serializable)() -> (UnsupportedOperationException)this.intercept((Function0 & Serializable & scala.Serializable)() -> unWritablePipeline.write(), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161)));
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.test("PipelineModel read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            WritableStage writableStage = new WritableStage("writableStage").setIntParam(56);
            PipelineModel pipeline = new PipelineModel("pipeline_89329327", (Transformer[])((Object[])new Transformer[]{writableStage}));
            PipelineModel pipeline2 = this.testDefaultReadWrite(pipeline, false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)pipeline2.stages().length));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
            Transformer $org_scalatest_assert_macro_left2 = pipeline2.stages()[0];
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.WritableStage", $org_scalatest_assert_macro_left2 instanceof WritableStage, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            WritableStage writableStage2 = (WritableStage)pipeline2.stages()[0];
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)writableStage.getIntParam()));
            int $org_scalatest_assert_macro_right2 = writableStage2.getIntParam();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("PipelineModel read/write: getStagePath", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String stageUid = "myStage";
            String stagesDir = new Path("pipeline", "stages").toString();
            this.testStage$1(0, 1, "0", stageUid, stagesDir);
            this.testStage$1(0, 9, "0", stageUid, stagesDir);
            this.testStage$1(0, 10, "00", stageUid, stagesDir);
            this.testStage$1(1, 10, "01", stageUid, stagesDir);
            this.testStage$1(12, 999, "012", stageUid, stagesDir);
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("PipelineModel read/write with non-Writable stage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            UnWritableStage unWritableStage = new UnWritableStage("unwritableStage");
            PipelineModel unWritablePipeline = new PipelineModel("pipeline_328957", (Transformer[])((Object[])new Transformer[]{unWritableStage}));
            return (UnsupportedOperationException)this.withClue("PipelineModel.write should fail when PipelineModel contains non-Writable stage", (Function0 & Serializable & scala.Serializable)() -> (UnsupportedOperationException)this.intercept((Function0 & Serializable & scala.Serializable)() -> unWritablePipeline.write(), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199)));
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("pipeline validateParams", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(PipelineSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_PipelineSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_ml_PipelineSuite$$typecreator6$1(PipelineSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 4.0})), (Object)BoxesRunTime.boxToDouble((double)1.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 4.0})), (Object)BoxesRunTime.boxToDouble((double)2.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 5.0})), (Object)BoxesRunTime.boxToDouble((double)3.0)), (List)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)4), (Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 5.0})), (Object)BoxesRunTime.boxToDouble((double)4.0)), (List)Nil$.MODULE$)))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_PipelineSuite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "features", "label"}));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
                MinMaxScaler scaler = new MinMaxScaler().setInputCol("features").setOutputCol("features_scaled").setMin(10.0).setMax(0.0);
                Pipeline pipeline = new Pipeline().setStages((PipelineStage[])new MinMaxScaler[]{scaler});
                return pipeline.fit(df);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        this.test("Pipeline.setStages should handle Java Arrays being non-covariant", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnWritableStage[] stages0 = (UnWritableStage[])((Object[])new UnWritableStage[]{new UnWritableStage("b")});
            WritableStage[] stages1 = (WritableStage[])((Object[])new WritableStage[]{new WritableStage("a")});
            Transformer[] steps = (Transformer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stages0)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stages1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Transformer.class)));
            Pipeline pipeline = new Pipeline().setStages((PipelineStage[])steps);
        }, new Position("PipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
    }

    public abstract class MyModel
    extends Model<MyModel> {
        public /* synthetic */ PipelineSuite org$apache$spark$ml$PipelineSuite$MyModel$$$outer() {
            return PipelineSuite.this;
        }

        public MyModel() {
            if (PipelineSuite.this == null) {
                throw null;
            }
        }
    }
}

