/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.LearningNode;
import org.apache.spark.ml.tree.LearningNode$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.impl.BaggedPoint$;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.ml.tree.impl.RandomForest;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.tree.impl.RandomForestSuite$;
import org.apache.spark.ml.tree.impl.TreePoint$;
import org.apache.spark.ml.tree.impl.TreeTests$;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.GiniCalculator;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.collection.OpenHashMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\u0006\f\u0001aAQ!\n\u0001\u0005\u0002\u0019BQ!\u000b\u0001\u0005\u0002):QAO\u0006\t\nm2QAC\u0006\t\nqBQ!\n\u0003\u0005\u0002\rCQ\u0001\u0012\u0003\u0005\u0002\u0015CQa\u0018\u0003\u0005\n\u0001Dq\u0001 \u0003\u0012\u0002\u0013%Q\u0010C\u0005\u0002\u000e\u0011\t\t\u0011\"\u0003\u0002\u0010\t\t\"+\u00198e_64uN]3tiN+\u0018\u000e^3\u000b\u00051i\u0011\u0001B5na2T!AD\b\u0002\tQ\u0014X-\u001a\u0006\u0003!E\t!!\u001c7\u000b\u0005I\u0019\u0012!B:qCJ\\'B\u0001\u000b\u0016\u0003\u0019\t\u0007/Y2iK*\ta#A\u0002pe\u001e\u001c\u0001aE\u0002\u00013u\u0001\"AG\u000e\u000e\u0003EI!\u0001H\t\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tq2%D\u0001 \u0015\t\u0001\u0013%\u0001\u0003vi&d'B\u0001\u0012\u0012\u0003\u0015iG\u000e\\5c\u0013\t!sDA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u0005Y\u0011a\u00112j]\u0006\u0014\u0018p\u00117bgNLg-[2bi&|g\u000eV3ti^KG\u000f[\"p]RLg.^8vg\u001a+\u0017\r^;sKN\fe\u000eZ*vEN\fW\u000e\u001d7fI\u001a+\u0017\r^;sKN$\"aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006e\t\u0001\raM\u0001\tgR\u0014\u0018\r^3hsB\u0011A\u0007O\u0007\u0002k)\u0011agN\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u000b\u00059\t\u0013BA\u001d6\u0005!\u0019FO]1uK\u001eL\u0018!\u0005*b]\u0012|WNR8sKN$8+^5uKB\u0011\u0001\u0006B\n\u0004\tu\u0002\u0005C\u0001\u0017?\u0013\tyTF\u0001\u0004B]f\u0014VM\u001a\t\u0003Y\u0005K!AQ\u0017\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003m\n\u0001\"\\1q)>4Vm\u0019\u000b\u0003\r2\u0003\"a\u0012&\u000e\u0003!S!!S\b\u0002\r1Lg.\u00197h\u0013\tY\u0005J\u0001\u0004WK\u000e$xN\u001d\u0005\u0006\u001b\u001a\u0001\rAT\u0001\u0004[\u0006\u0004\b\u0003B(W3rs!\u0001\u0015+\u0011\u0005EkS\"\u0001*\u000b\u0005M;\u0012A\u0002\u001fs_>$h(\u0003\u0002V[\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\u00075\u000b\u0007O\u0003\u0002V[A\u0011AFW\u0005\u000376\u00121!\u00138u!\taS,\u0003\u0002_[\t1Ai\\;cY\u0016\f!cZ3u'VlG*Z1g\u0007>,h\u000e^3sgR\u0019\u0011\rZ:\u0011\u00051\u0012\u0017BA2.\u0005\u0011auN\\4\t\u000b\u0015<\u0001\u0019\u00014\u0002\u000b9|G-Z:\u0011\u0007\u001ddwN\u0004\u0002iU:\u0011\u0011+[\u0005\u0002]%\u00111.L\u0001\ba\u0006\u001c7.Y4f\u0013\tigN\u0001\u0003MSN$(BA6.!\t\u0001\u0018/D\u0001\u000e\u0013\t\u0011XB\u0001\u0003O_\u0012,\u0007b\u0002;\b!\u0003\u0005\r!Y\u0001\u0004C\u000e\u001c\u0007FA\u0004w!\t9(0D\u0001y\u0015\tIX&\u0001\u0006b]:|G/\u0019;j_:L!a\u001f=\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006ar-\u001a;Tk6dU-\u00194D_VtG/\u001a:tI\u0011,g-Y;mi\u0012\u0012T#\u0001@+\u0005\u0005|8FAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004q\u0006IQO\\2iK\u000e\\W\rZ\u0005\u0005\u0003\u0017\t)AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0003\t\u0005\u0003'\ti\"\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0011\u0001\u00026bm\u0006LA!a\b\u0002\u0016\t1qJ\u00196fGR\u0004")
public class RandomForestSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static Vector mapToVec(Map<Object, Object> map) {
        return RandomForestSuite$.MODULE$.mapToVec(map);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public void binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(Strategy strategy2) {
        int numFeatures = 50;
        org.apache.spark.mllib.regression.LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(numFeatures, 1000);
        SparkContext qual$1 = this.sc();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])arr);
        int x$2 = qual$1.parallelize$default$2();
        RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(org.apache.spark.mllib.regression.LabeledPoint.class)).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.asML().toInstance(), ClassTag$.MODULE$.apply(Instance.class));
        this.checkFeatureSubsetStrategy$1(1, "auto", numFeatures, rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(1, "all", numFeatures, rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(1, "sqrt", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures))), rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(1, "log2", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)numFeatures) / package$.MODULE$.log(2.0))), rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(1, "onethird", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0)), rdd, strategy2, numFeatures);
        String[] realStrategies = (String[])((Object[])new String[]{".1", ".10", "0.10", "0.1", "0.9", "1.0"});
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])realStrategies)).foreach((Function1 & Serializable & scala.Serializable)strategy -> {
            RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$9(this, numFeatures, rdd, strategy2, strategy);
            return BoxedUnit.UNIT;
        });
        String[] integerStrategies = (String[])((Object[])new String[]{"1", "10", "100", "1000", "10000"});
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])integerStrategies)).foreach((Function1 & Serializable & scala.Serializable)strategy -> {
            RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$10(this, numFeatures, rdd, strategy2, strategy);
            return BoxedUnit.UNIT;
        });
        String[] invalidStrategies = (String[])((Object[])new String[]{"-.1", "-.10", "-0.10", ".0", "0.0", "1.1", "0"});
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])invalidStrategies)).foreach((Function1 & Serializable & scala.Serializable)invalidStrategy -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DecisionTreeMetadata decisionTreeMetadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy2, 1, invalidStrategy);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557)));
        this.checkFeatureSubsetStrategy$1(2, "all", numFeatures, rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(2, "auto", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures))), rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(2, "sqrt", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures))), rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(2, "log2", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)numFeatures) / package$.MODULE$.log(2.0))), rdd, strategy2, numFeatures);
        this.checkFeatureSubsetStrategy$1(2, "onethird", (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0)), rdd, strategy2, numFeatures);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])realStrategies)).foreach((Function1 & Serializable & scala.Serializable)strategy -> {
            RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$13(this, numFeatures, rdd, strategy2, strategy);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])integerStrategies)).foreach((Function1 & Serializable & scala.Serializable)strategy -> {
            RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$14(this, numFeatures, rdd, strategy2, strategy);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])invalidStrategies)).foreach((Function1 & Serializable & scala.Serializable)invalidStrategy -> (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DecisionTreeMetadata decisionTreeMetadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy2, 2, invalidStrategy);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580)));
    }

    private final void testImplicits$lzycompute$1() {
        RandomForestSuite randomForestSuite = this;
        synchronized (randomForestSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$9(Tuple2 x$4) {
        return x$4._2$mcD$sp() != 0.0;
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$10(int x) {
        return new Tuple2.mcDD.sp(1.0, (double)x);
    }

    public static final /* synthetic */ boolean $anonfun$new$11(Tuple2 x$5) {
        return x$5._2$mcD$sp() != 0.0;
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$12(int x) {
        return new Tuple2.mcDD.sp(1.0, (double)x);
    }

    public static final /* synthetic */ boolean $anonfun$new$13(Tuple2 x$6) {
        return x$6._2$mcD$sp() != 0.0;
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$14(int x) {
        return new Tuple2.mcDD.sp(1.0, (double)x);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$15(int x) {
        return new Tuple2.mcDD.sp(1.0, (double)x);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$16(int x) {
        return new Tuple2.mcDD.sp(1.0, (double)x);
    }

    private final void checkCategoricalSplit$1(Split s, int featureIndex, double[] leftCategories) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)s.featureIndex()));
        int $org_scalatest_assert_macro_right = featureIndex;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        Split $org_scalatest_assert_macro_left2 = s;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.tree.CategoricalSplit", $org_scalatest_assert_macro_left2 instanceof CategoricalSplit, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
        CategoricalSplit s0 = (CategoricalSplit)s;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(s0.leftCategories());
        double[] $org_scalatest_assert_macro_right2 = leftCategories;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)s0.numCategories()));
        int $org_scalatest_assert_macro_right3 = 3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
    }

    private final InternalNode[] getChildren$1(Node rootNode) {
        Node node = rootNode;
        if (!(node instanceof InternalNode)) {
            throw this.fail("rootNode was not an InternalNode", new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
        }
        InternalNode internalNode = (InternalNode)node;
        Node $org_scalatest_assert_macro_left = internalNode.leftChild();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.ml.tree.InternalNode", $org_scalatest_assert_macro_left instanceof InternalNode, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
        Node $org_scalatest_assert_macro_left2 = internalNode.rightChild();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.ml.tree.InternalNode", $org_scalatest_assert_macro_left2 instanceof InternalNode, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        InternalNode[] internalNodeArray = (InternalNode[])((Object[])new InternalNode[]{(InternalNode)internalNode.leftChild(), (InternalNode)internalNode.rightChild()});
        return internalNodeArray;
    }

    public static final /* synthetic */ Assertion $anonfun$new$40(RandomForestSuite $this, InternalNode[] children1$1, InternalNode[] children2$1, int i) {
        double $org_scalatest_assert_macro_left = children1$1[i].gain();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (double)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        double $org_scalatest_assert_macro_left2 = children2$1[i].gain();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(children1$1[i].split());
        Split $org_scalatest_assert_macro_right3 = children2$1[i].split();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)children1$1[i].impurity()));
        double $org_scalatest_assert_macro_right4 = children2$1[i].impurity();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(children1$1[i].impurityStats().stats());
        double[] $org_scalatest_assert_macro_right5 = children2$1[i].impurityStats().stats();
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)children1$1[i].leftChild().impurity()));
        double $org_scalatest_assert_macro_right6 = children2$1[i].leftChild().impurity();
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)children1$1[i].rightChild().impurity()));
        double $org_scalatest_assert_macro_right7 = children2$1[i].rightChild().impurity();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(BoxesRunTime.boxToDouble((double)children1$1[i].prediction()));
        double $org_scalatest_assert_macro_right8 = children2$1[i].prediction();
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$4(LearningNode[] x$15) {
        return x$15.length == 1;
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$6(RandomForest.NodeIndexInfo x$17) {
        return x$17.featureSubset().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$5(Map x$16) {
        return x$16.values().forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$6(x$17)));
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$8(RandomForestSuite $this, int numFeaturesPerNode$1, RandomForest.NodeIndexInfo x$19) {
        return $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((int[])x$19.featureSubset().get()).length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numFeaturesPerNode$1), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ boolean $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$7(RandomForestSuite $this, int numFeaturesPerNode$1, Map x$18) {
        return x$18.values().forall((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$8($this, numFeaturesPerNode$1, x$19)));
    }

    public static final /* synthetic */ Assertion $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$2(RandomForestSuite $this, int numTrees$1, String featureSubsetStrategy$1, int numFeaturesPerNode$1, long maxMemoryUsage$1, DecisionTreeMetadata metadata$1, int numFeatures$1, int seed) {
        Assertion assertion;
        Map map;
        Map treeToNodeToIndexInfo;
        String failString;
        block6: {
            Tuple2 tuple2;
            block5: {
                failString = new StringBuilder(81).append("Failed on test with:").append("numTrees=").append(numTrees$1).append(", featureSubsetStrategy=").append(featureSubsetStrategy$1).append(",").append(" numFeaturesPerNode=").append(numFeaturesPerNode$1).append(", seed=").append(seed).toString();
                ListBuffer nodeStack = new ListBuffer();
                LearningNode[] topNodes = new LearningNode[numTrees$1];
                scala.package$.MODULE$.Range().apply(0, numTrees$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)treeIndex -> {
                    topNodes$1[treeIndex] = LearningNode$.MODULE$.emptyNode(1);
                    nodeStack.prepend((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)topNodes[treeIndex])}));
                });
                Random rng = new Random(seed);
                tuple2 = RandomForest$.MODULE$.selectNodesToSplit(nodeStack, maxMemoryUsage$1, metadata$1, rng);
                if (tuple2 == null) break block5;
                Map nodesForGroup = (Map)tuple2._1();
                treeToNodeToIndexInfo = (Map)tuple2._2();
                if (nodesForGroup == null) break block5;
                map = nodesForGroup;
                if (treeToNodeToIndexInfo != null) break block6;
            }
            throw new MatchError((Object)tuple2);
        }
        Map map2 = treeToNodeToIndexInfo;
        Tuple2 tuple2 = new Tuple2((Object)map, (Object)map2);
        Tuple2 tuple22 = tuple2;
        Map nodesForGroup = (Map)tuple22._1();
        Map treeToNodeToIndexInfo2 = (Map)tuple22._2();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)nodesForGroup.size()));
        int $org_scalatest_assert_macro_right = numTrees$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)failString, Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(nodesForGroup.values().forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$4(x$15))), "nodesForGroup.values.forall(((x$15: Array[org.apache.spark.ml.tree.LearningNode]) => x$15.length.==(1)))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)failString, Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
        if (numFeaturesPerNode$1 == numFeatures$1) {
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(treeToNodeToIndexInfo2.values().forall((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$5(x$16))), "treeToNodeToIndexInfo.values.forall(((x$16: Map[Int,org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo]) => x$16.values.forall(((x$17: org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo) => x$17.featureSubset.isEmpty))))", Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)failString, Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
        } else {
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(treeToNodeToIndexInfo2.values().forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$7($this, numFeaturesPerNode$1, x$18))), "treeToNodeToIndexInfo.values.forall(((x$18: Map[Int,org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo]) => x$18.values.forall(((x$19: org.apache.spark.ml.tree.impl.RandomForest.NodeIndexInfo) => RandomForestSuite.this.convertToEqualizer[Int](x$19.featureSubset.get.length).===(numFeaturesPerNode)(scalactic.this.Equality.default[Int])))))", Prettifier$.MODULE$.default());
            assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)failString, Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        }
        return assertion;
    }

    private final void checkFeatureSubsetStrategy$1(int numTrees, String featureSubsetStrategy, int numFeaturesPerNode, RDD rdd$2, Strategy strategy$2, int numFeatures$1) {
        int[] seeds = new int[]{123, 5354, 230, 349867, 23987};
        long maxMemoryUsage = 0x8000000L;
        DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd$2, strategy$2, numTrees, featureSubsetStrategy);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(seeds)).foreach((Function1 & Serializable & scala.Serializable)seed -> RandomForestSuite.$anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$2(this, numTrees, featureSubsetStrategy, numFeaturesPerNode, maxMemoryUsage, metadata, numFeatures$1, BoxesRunTime.unboxToInt((Object)seed)));
    }

    public static final /* synthetic */ void $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$9(RandomForestSuite $this, int numFeatures$1, RDD rdd$2, Strategy strategy$2, String strategy) {
        int expected = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(strategy)).toDouble() * (double)numFeatures$1));
        $this.checkFeatureSubsetStrategy$1(1, strategy, expected, rdd$2, strategy$2, numFeatures$1);
    }

    public static final /* synthetic */ void $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$10(RandomForestSuite $this, int numFeatures$1, RDD rdd$2, Strategy strategy$2, String strategy) {
        int expected = new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() < numFeatures$1 ? new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() : numFeatures$1;
        $this.checkFeatureSubsetStrategy$1(1, strategy, expected, rdd$2, strategy$2, numFeatures$1);
    }

    public static final /* synthetic */ void $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$13(RandomForestSuite $this, int numFeatures$1, RDD rdd$2, Strategy strategy$2, String strategy) {
        int expected = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(new StringOps(Predef$.MODULE$.augmentString(strategy)).toDouble() * (double)numFeatures$1));
        $this.checkFeatureSubsetStrategy$1(2, strategy, expected, rdd$2, strategy$2, numFeatures$1);
    }

    public static final /* synthetic */ void $anonfun$binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures$14(RandomForestSuite $this, int numFeatures$1, RDD rdd$2, Strategy strategy$2, String strategy) {
        int expected = new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() < numFeatures$1 ? new StringOps(Predef$.MODULE$.augmentString(strategy)).toInt() : numFeatures$1;
        $this.checkFeatureSubsetStrategy$1(2, strategy, expected, rdd$2, strategy$2, numFeatures$1);
    }

    private static final void testNode$1(Node node, Map expected) {
        OpenHashMap.mcD.sp map = new OpenHashMap.mcD.sp(ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
        TreeEnsembleModel$.MODULE$.computeFeatureImportance(node, (OpenHashMap)map);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)map.toMap(Predef$.MODULE$.$conforms()))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)expected)).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(map.toMap[Int, Double](scala.Predef.$conforms[(Int, Double)]))).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(expected)).relTol(0.01))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
    }

    public static final /* synthetic */ void $anonfun$new$52(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DecisionTreeModel unitTree = (DecisionTreeModel)tuple2._1();
        DecisionTreeModel smallWeightTree = (DecisionTreeModel)tuple2._2();
        TreeTests$.MODULE$.checkEqual(unitTree, smallWeightTree);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$53(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        DecisionTreeModel unitTree = (DecisionTreeModel)tuple2._1();
        DecisionTreeModel bigWeightTree = (DecisionTreeModel)tuple2._2();
        TreeTests$.MODULE$.checkEqual(unitTree, bigWeightTree);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public RandomForestSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Binary classification with continuous features: split calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Instance[] arr = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asML().toInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            SparkContext qual$1 = this.sc();
            WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize((Seq)x$12, x$2, ClassTag$.MODULE$.apply(Instance.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
            int $org_scalatest_assert_macro_right3 = 99;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("Binary classification with binary (ordered) categorical features: split calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Instance[] arr = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.asML().toInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            SparkContext qual$2 = this.sc();
            WrappedArray x$3 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$4 = qual$2.parallelize$default$2();
            RDD rdd = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$5 = Algo$.MODULE$.Classification();
            Gini$ x$6 = Gini$.MODULE$;
            int x$7 = 2;
            int x$8 = 2;
            int x$9 = 100;
            Map x$10 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Enumeration.Value x$11 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$12 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$13 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$14 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$15 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$16 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$17 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$18 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$19 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$5, (Impurity)x$6, x$7, x$8, x$9, x$11, x$10, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
            Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("Binary classification with 3-ary (ordered) categorical features, with no samples for one category: split calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Instance[] arr = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.asML().toInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            SparkContext qual$3 = this.sc();
            WrappedArray x$20 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$21 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize((Seq)x$20, x$21, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$22 = Algo$.MODULE$.Classification();
            Gini$ x$23 = Gini$.MODULE$;
            int x$24 = 2;
            int x$25 = 2;
            int x$26 = 100;
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Enumeration.Value x$28 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$29 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$30 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$31 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$32 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$33 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$34 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$35 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$36 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$22, (Impurity)x$23, x$24, x$25, x$26, x$28, x$27, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("find splits for a continuous feature", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DecisionTreeMetadata fakeMetadata = new DecisionTreeMetadata(1, 200000L, 200000.0, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{6}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0.0, 0, 0);
            Tuple2[] featureSamples = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(10000, (Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcDD.sp(1.0, package$.MODULE$.random()), ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$new$9(x$4)));
            double[] splits = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapRefArray((Object[])featureSamples), fakeMetadata, 0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)fakeMetadata.numSplits(0)));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)fakeMetadata.numBins()[0]));
            int $org_scalatest_assert_macro_right3 = 6;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits)).distinct()).length));
            int $org_scalatest_assert_macro_right4 = splits.length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            DecisionTreeMetadata fakeMetadata2 = new DecisionTreeMetadata(1, 8L, 8.0, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{3}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0.0, 0, 0);
            Tuple2[] featureSamples2 = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, 1, 0, 0, 1, 0, 1, 1})).map((Function1 & Serializable & scala.Serializable)x -> RandomForestSuite.$anonfun$new$10(BoxesRunTime.unboxToInt((Object)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$new$11(x$5)));
            double[] splits2 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapRefArray((Object[])featureSamples2), fakeMetadata2, 0);
            double[] expectedSplits = new double[]{0.5};
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(splits2);
            double[] $org_scalatest_assert_macro_right5 = expectedSplits;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            Tuple2[] featureSamples3 = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, 0, 1, 1, 2, 2, 3, 3})).map((Function1 & Serializable & scala.Serializable)x -> RandomForestSuite.$anonfun$new$12(BoxesRunTime.unboxToInt((Object)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)RandomForestSuite.$anonfun$new$13(x$6)));
            double[] splits3 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapRefArray((Object[])featureSamples3), fakeMetadata2, 0);
            double[] expectedSplits2 = new double[]{0.5, 2.5};
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(splits3);
            double[] $org_scalatest_assert_macro_right6 = expectedSplits2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            DecisionTreeMetadata fakeMetadata3 = new DecisionTreeMetadata(1, 12L, 12.0, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{5}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0.0, 0, 0);
            Tuple2[] featureSamples4 = (Tuple2[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3})).map((Function1 & Serializable & scala.Serializable)x -> RandomForestSuite.$anonfun$new$14(BoxesRunTime.unboxToInt((Object)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            double[] splits4 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapRefArray((Object[])featureSamples4), fakeMetadata3, 0);
            double[] expectedSplits3 = new double[]{1.5, 2.5};
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(splits4);
            double[] $org_scalatest_assert_macro_right7 = expectedSplits3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits4)).distinct()).length));
            int $org_scalatest_assert_macro_right8 = splits4.length;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            DecisionTreeMetadata fakeMetadata4 = new DecisionTreeMetadata(1, 18L, 18.0, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{3}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0.0, 0, 0);
            Tuple2[] featureSamples5 = (Tuple2[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 5})).map((Function1 & Serializable & scala.Serializable)x -> RandomForestSuite.$anonfun$new$15(BoxesRunTime.unboxToInt((Object)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            double[] splits5 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapRefArray((Object[])featureSamples5), fakeMetadata4, 0);
            double[] expectedSplits4 = new double[]{2.5, 3.5};
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(splits5);
            double[] $org_scalatest_assert_macro_right9 = expectedSplits4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            DecisionTreeMetadata fakeMetadata5 = new DecisionTreeMetadata(1, 17L, 17.0, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{2}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0.0, 0, 0);
            Tuple2[] featureSamples6 = (Tuple2[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2})).map((Function1 & Serializable & scala.Serializable)x -> RandomForestSuite.$anonfun$new$16(BoxesRunTime.unboxToInt((Object)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            double[] splits6 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapRefArray((Object[])featureSamples6), fakeMetadata5, 0);
            double[] expectedSplits5 = new double[]{1.5};
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(splits6);
            double[] $org_scalatest_assert_macro_right10 = expectedSplits5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            DecisionTreeMetadata fakeMetadata6 = new DecisionTreeMetadata(1, 0L, 0.0, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{6}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0.0, 0, 0);
            Tuple2[] featureSamplesUnitWeight = (Tuple2[])Array$.MODULE$.fill(10, (Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcDD.sp(1.0, package$.MODULE$.random()), ClassTag$.MODULE$.apply(Tuple2.class));
            Tuple2[] featureSamplesSmallWeight = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureSamplesUnitWeight)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double w = tuple2._1$mcD$sp();
                double x = tuple2._2$mcD$sp();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(w * 0.001, x);
                return sp2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Tuple2[] featureSamplesLargeWeight = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureSamplesUnitWeight)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double w = tuple2._1$mcD$sp();
                double x = tuple2._2$mcD$sp();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(w * (double)1000, x);
                return sp2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            double[] splitsUnitWeight = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapRefArray((Object[])featureSamplesUnitWeight), fakeMetadata6, 0);
            double[] splitsSmallWeight = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapRefArray((Object[])featureSamplesSmallWeight), fakeMetadata6, 0);
            double[] splitsLargeWeight = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapRefArray((Object[])featureSamplesLargeWeight), fakeMetadata6, 0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(splitsUnitWeight);
            double[] $org_scalatest_assert_macro_right11 = splitsSmallWeight;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(splitsUnitWeight);
            double[] $org_scalatest_assert_macro_right12 = splitsLargeWeight;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            DecisionTreeMetadata fakeMetadata7 = new DecisionTreeMetadata(1, 0L, 0.0, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{3}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0.0, 0, 0);
            Tuple2[] featureSamples7 = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2.mcII.sp(10, 1), new Tuple2.mcII.sp(1, 2), new Tuple2.mcII.sp(1, 3), new Tuple2.mcII.sp(1, 4), new Tuple2.mcII.sp(1, 5), new Tuple2.mcII.sp(1, 6)})).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int w = tuple2._1$mcI$sp();
                int x = tuple2._2$mcI$sp();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp((double)w, (double)x);
                return sp2;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            double[] splits7 = RandomForest$.MODULE$.findSplitsForContinuousFeature((Iterable)Predef$.MODULE$.wrapRefArray((Object[])featureSamples7), fakeMetadata7, 0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(splits7);
            double[] $org_scalatest_assert_macro_right13 = new double[]{1.5, 2.5, 3.5, 4.5, 5.5};
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("train with empty arrays", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Instance lp = new LabeledPoint(1.0, Vectors$.MODULE$.dense((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()))).toInstance();
            Instance[] data = (Instance[])Array$.MODULE$.fill(5, (Function0 & Serializable & scala.Serializable)() -> lp, ClassTag$.MODULE$.apply(Instance.class));
            SparkContext qual$4 = this.sc();
            WrappedArray x$37 = Predef$.MODULE$.wrapRefArray((Object[])data);
            int x$38 = qual$4.parallelize$default$2();
            RDD rdd = qual$4.parallelize((Seq)x$37, x$38, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$39 = Algo$.MODULE$.Regression();
            Gini$ x$40 = Gini$.MODULE$;
            int x$41 = 2;
            int x$42 = 5;
            int x$43 = Strategy$.MODULE$.$lessinit$greater$default$4();
            Enumeration.Value x$44 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$45 = Strategy$.MODULE$.$lessinit$greater$default$7();
            int x$46 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$47 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$48 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$49 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$50 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$51 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$52 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$53 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$39, (Impurity)x$40, x$41, x$43, x$42, x$44, x$45, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53);
            return (IllegalArgumentException)this.withClue("DecisionTree requires number of features > 0, but was given an empty features vector", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> RandomForest$.MODULE$.run(rdd, strategy, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223)));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("train with constant features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DecisionTreeModel tree2;
            DecisionTreeModel tree;
            boolean x$70;
            double x$69;
            int x$68;
            boolean x$67;
            double x$66;
            int x$65;
            double x$64;
            int x$63;
            Instance instance = new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))).toInstance();
            Instance[] data = (Instance[])Array$.MODULE$.fill(5, (Function0 & Serializable & scala.Serializable)() -> instance, ClassTag$.MODULE$.apply(Instance.class));
            SparkContext qual$5 = this.sc();
            WrappedArray x$54 = Predef$.MODULE$.wrapRefArray((Object[])data);
            int x$55 = qual$5.parallelize$default$2();
            RDD rdd = qual$5.parallelize((Seq)x$54, x$55, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$56 = Algo$.MODULE$.Classification();
            Gini$ x$57 = Gini$.MODULE$;
            int x$58 = 2;
            int x$59 = 2;
            int x$60 = 5;
            Map x$61 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)5))}));
            Enumeration.Value x$62 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Strategy strategy = new Strategy(x$56, (Impurity)x$57, x$58, x$59, x$60, x$62, x$61, x$63 = Strategy$.MODULE$.$lessinit$greater$default$8(), x$64 = Strategy$.MODULE$.$lessinit$greater$default$9(), x$65 = Strategy$.MODULE$.$lessinit$greater$default$10(), x$66 = Strategy$.MODULE$.$lessinit$greater$default$11(), x$67 = Strategy$.MODULE$.$lessinit$greater$default$12(), x$68 = Strategy$.MODULE$.$lessinit$greater$default$13(), x$69 = Strategy$.MODULE$.$lessinit$greater$default$14(), x$70 = Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeModel[] decisionTreeModelArray = RandomForest$.MODULE$.run(rdd, strategy, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            Option option = Array$.MODULE$.unapplySeq((Object)decisionTreeModelArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)decisionTreeModelArray);
            }
            DecisionTreeModel decisionTreeModel = tree = (DecisionTreeModel)((SeqLike)option.get()).apply(0);
            DecisionTreeModel tree3 = decisionTreeModel;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)tree3.rootNode().impurity()));
            double $org_scalatest_assert_macro_right = -1.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)tree3.depth()));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)tree3.rootNode().prediction()));
            double $org_scalatest_assert_macro_right3 = instance.label();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            Enumeration.Value x$71 = Algo$.MODULE$.Regression();
            Variance$ x$72 = Variance$.MODULE$;
            int x$73 = 2;
            int x$74 = 5;
            int x$75 = Strategy$.MODULE$.$lessinit$greater$default$4();
            Enumeration.Value x$76 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$77 = Strategy$.MODULE$.$lessinit$greater$default$7();
            int x$78 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$79 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$80 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$81 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$82 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$83 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$84 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$85 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy2 = new Strategy(x$71, (Impurity)x$72, x$73, x$75, x$74, x$76, x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84, x$85);
            DecisionTreeModel[] decisionTreeModelArray2 = RandomForest$.MODULE$.run(rdd, strategy2, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            Option option2 = Array$.MODULE$.unapplySeq((Object)decisionTreeModelArray2);
            if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)decisionTreeModelArray2);
            }
            DecisionTreeModel decisionTreeModel2 = tree2 = (DecisionTreeModel)((SeqLike)option2.get()).apply(0);
            DecisionTreeModel tree22 = decisionTreeModel2;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)tree22.rootNode().impurity()));
            double $org_scalatest_assert_macro_right4 = -1.0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)tree22.depth()));
            int $org_scalatest_assert_macro_right5 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)tree22.rootNode().prediction()));
            double $org_scalatest_assert_macro_right6 = instance.label();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        this.test("Multiclass classification with unordered categorical features: split calculations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Instance[] arr = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.asML().toInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            SparkContext qual$6 = this.sc();
            WrappedArray x$86 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$87 = qual$6.parallelize$default$2();
            RDD rdd = qual$6.parallelize((Seq)x$86, x$87, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$88 = Algo$.MODULE$.Classification();
            Gini$ x$89 = Gini$.MODULE$;
            int x$90 = 2;
            int x$91 = 100;
            int x$92 = 100;
            Map x$93 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            Enumeration.Value x$94 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$95 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$96 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$97 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$98 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$99 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$100 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$101 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$102 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$88, (Impurity)x$89, x$90, x$91, x$92, x$94, x$93, x$95, x$96, x$97, x$98, x$99, x$100, x$101, x$102);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numSplits(0)));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numBins()[0]));
            int $org_scalatest_assert_macro_right5 = 3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numSplits(1)));
            int $org_scalatest_assert_macro_right6 = 3;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)metadata.numBins()[1]));
            int $org_scalatest_assert_macro_right7 = 3;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            this.checkCategoricalSplit$1(splits[0][0], 0, new double[]{0.0});
            this.checkCategoricalSplit$1(splits[0][1], 0, new double[]{1.0});
            this.checkCategoricalSplit$1(splits[0][2], 0, new double[]{0.0, 1.0});
            this.checkCategoricalSplit$1(splits[1][0], 1, new double[]{0.0});
            this.checkCategoricalSplit$1(splits[1][1], 1, new double[]{1.0});
            this.checkCategoricalSplit$1(splits[1][2], 1, new double[]{0.0, 1.0});
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        this.test("Multiclass classification with ordered categorical features: split calculations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Instance[] arr = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.asML().toInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 3000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            SparkContext qual$7 = this.sc();
            WrappedArray x$103 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$104 = qual$7.parallelize$default$2();
            RDD rdd = qual$7.parallelize((Seq)x$103, x$104, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$105 = Algo$.MODULE$.Classification();
            Gini$ x$106 = Gini$.MODULE$;
            int x$107 = 2;
            int x$108 = 100;
            int x$109 = 100;
            Map x$110 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
            Enumeration.Value x$111 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$112 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$113 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$114 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$115 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$116 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$117 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$118 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$119 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$105, (Impurity)x$106, x$107, x$108, x$109, x$111, x$110, x$112, x$113, x$114, x$115, x$116, x$117, x$118, x$119);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            Split[][] splits = RandomForest$.MODULE$.findSplits(rdd, metadata, 42L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits[0].length));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("extract categories from a number for multiclass classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            List l = RandomForest$.MODULE$.extractMultiClassCategories(13, 10);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)l.length()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 2.0, 0.0})));
            List $org_scalatest_assert_macro_right2 = l;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("Avoid aggregation on the last level", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0})))});
            SparkContext qual$8 = this.sc();
            WrappedArray x$120 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class))));
            int x$121 = qual$8.parallelize$default$2();
            RDD input = qual$8.parallelize((Seq)x$120, x$121, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$122 = Algo$.MODULE$.Classification();
            Gini$ x$123 = Gini$.MODULE$;
            int x$124 = 1;
            int x$125 = 2;
            Map x$126 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            int x$127 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$128 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$129 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$130 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$131 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$132 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$133 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$134 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$135 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$136 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$122, (Impurity)x$123, x$124, x$125, x$127, x$128, x$126, x$129, x$130, x$131, x$132, x$133, x$134, x$135, x$136);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(input, strategy);
            Split[][] splits = RandomForest$.MODULE$.findSplits(input, metadata, 42L);
            Broadcast bcSplits = input.sparkContext().broadcast((Object)splits, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Split.class))));
            RDD treeInput = TreePoint$.MODULE$.convertToTreeRDD(input, splits, metadata);
            RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, 1.0, 1, false, BaggedPoint$.MODULE$.convertToBaggedRDD$default$5(), BaggedPoint$.MODULE$.convertToBaggedRDD$default$6());
            LearningNode topNode = LearningNode$.MODULE$.emptyNode(1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)topNode.isLeaf()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(topNode.stats());
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            Map nodesForGroup = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new LearningNode[]{topNode})}));
            Map treeToNodeToIndexInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topNode.id())), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$))})))}));
            ListBuffer nodeStack = new ListBuffer();
            RandomForest$.MODULE$.findBestSplits(baggedInput, metadata, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)topNode)})), nodesForGroup, treeToNodeToIndexInfo, bcSplits, nodeStack, RandomForest$.MODULE$.findBestSplits$default$8(), RandomForest$.MODULE$.findBestSplits$default$9(), RandomForest$.MODULE$.findBestSplits$default$10());
            bcSplits.destroy();
            ListBuffer $org_scalatest_assert_macro_left3 = nodeStack;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(topNode.stats());
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!==", null, $org_scalatest_assert_macro_left4.$bang$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
            double $org_scalatest_assert_macro_left5 = topNode.stats().impurity();
            double $org_scalatest_assert_macro_right4 = 0.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).toNode().prediction()));
            double $org_scalatest_assert_macro_right5 = 0.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).toNode().prediction()));
            double $org_scalatest_assert_macro_right6 = 1.0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).stats().impurity()));
            double $org_scalatest_assert_macro_right7 = 0.0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).stats().impurity()));
            double $org_scalatest_assert_macro_right8 = 0.0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        this.test("Avoid aggregation if impurity is 0.0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0})))});
            SparkContext qual$9 = this.sc();
            WrappedArray x$137 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class))));
            int x$138 = qual$9.parallelize$default$2();
            RDD input = qual$9.parallelize((Seq)x$137, x$138, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$139 = Algo$.MODULE$.Classification();
            Gini$ x$140 = Gini$.MODULE$;
            int x$141 = 5;
            int x$142 = 2;
            Map x$143 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            int x$144 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$145 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$146 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$147 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$148 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$149 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$150 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$151 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$152 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$153 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$139, (Impurity)x$140, x$141, x$142, x$144, x$145, x$143, x$146, x$147, x$148, x$149, x$150, x$151, x$152, x$153);
            DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(input, strategy);
            Split[][] splits = RandomForest$.MODULE$.findSplits(input, metadata, 42L);
            Broadcast bcSplits = input.sparkContext().broadcast((Object)splits, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Split.class))));
            RDD treeInput = TreePoint$.MODULE$.convertToTreeRDD(input, splits, metadata);
            RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, 1.0, 1, false, BaggedPoint$.MODULE$.convertToBaggedRDD$default$5(), BaggedPoint$.MODULE$.convertToBaggedRDD$default$6());
            LearningNode topNode = LearningNode$.MODULE$.emptyNode(1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)topNode.isLeaf()));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(topNode.stats());
            Null$ $org_scalatest_assert_macro_right2 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
            Map nodesForGroup = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new LearningNode[]{topNode})}));
            Map treeToNodeToIndexInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topNode.id())), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$))})))}));
            ListBuffer nodeStack = new ListBuffer();
            RandomForest$.MODULE$.findBestSplits(baggedInput, metadata, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)topNode)})), nodesForGroup, treeToNodeToIndexInfo, bcSplits, nodeStack, RandomForest$.MODULE$.findBestSplits$default$8(), RandomForest$.MODULE$.findBestSplits$default$9(), RandomForest$.MODULE$.findBestSplits$default$10());
            bcSplits.destroy();
            ListBuffer $org_scalatest_assert_macro_left3 = nodeStack;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(topNode.stats());
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!==", null, $org_scalatest_assert_macro_left4.$bang$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
            double $org_scalatest_assert_macro_left5 = topNode.stats().impurity();
            double $org_scalatest_assert_macro_right4 = 0.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).toNode().prediction()));
            double $org_scalatest_assert_macro_right5 = 0.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).toNode().prediction()));
            double $org_scalatest_assert_macro_right6 = 1.0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.leftChild().get()).stats().impurity()));
            double $org_scalatest_assert_macro_right7 = 0.0;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)((LearningNode)topNode.rightChild().get()).stats().impurity()));
            double $org_scalatest_assert_macro_right8 = 0.0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        this.test("Use soft prediction for binary classification with ordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            boolean x$170;
            double x$169;
            int x$168;
            boolean x$167;
            double x$166;
            int x$165;
            double x$164;
            int x$163;
            LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))});
            SparkContext qual$10 = this.sc();
            WrappedArray x$154 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class))));
            int x$155 = qual$10.parallelize$default$2();
            RDD input = qual$10.parallelize((Seq)x$154, x$155, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$156 = Algo$.MODULE$.Classification();
            Gini$ x$157 = Gini$.MODULE$;
            int x$158 = 1;
            int x$159 = 2;
            Map x$160 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
            int x$161 = 3;
            Enumeration.Value x$162 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Strategy strategy = new Strategy(x$156, (Impurity)x$157, x$158, x$159, x$161, x$162, x$160, x$163 = Strategy$.MODULE$.$lessinit$greater$default$8(), x$164 = Strategy$.MODULE$.$lessinit$greater$default$9(), x$165 = Strategy$.MODULE$.$lessinit$greater$default$10(), x$166 = Strategy$.MODULE$.$lessinit$greater$default$11(), x$167 = Strategy$.MODULE$.$lessinit$greater$default$12(), x$168 = Strategy$.MODULE$.$lessinit$greater$default$13(), x$169 = Strategy$.MODULE$.$lessinit$greater$default$14(), x$170 = Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeModel model = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(input, strategy, 1, "all", 42L, (Option)None$.MODULE$, false, RandomForest$.MODULE$.run$default$8()))).head();
            Node node = model.rootNode();
            if (node instanceof InternalNode) {
                InternalNode internalNode = (InternalNode)node;
                Split split = internalNode.split();
                if (!(split instanceof CategoricalSplit)) {
                    throw this.fail("model.rootNode.split was not a CategoricalSplit", new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
                }
                CategoricalSplit categoricalSplit = (CategoricalSplit)split;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(categoricalSplit.leftCategories());
                double[] $org_scalatest_assert_macro_right = new double[]{1.0};
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
            } else {
                throw this.fail("model.rootNode was not an InternalNode", new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
            }
            Assertion assertion2 = assertion;
            return assertion2;
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
        this.test("Second level node building with vs. without groups", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Instance[] arr = (Instance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DecisionTreeSuite$.MODULE$.generateOrderedLabeledPoints())).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.asML().toInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
            int $org_scalatest_assert_macro_right = 1000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
            SparkContext qual$11 = this.sc();
            WrappedArray x$171 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$172 = qual$11.parallelize$default$2();
            RDD rdd = qual$11.parallelize((Seq)x$171, x$172, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$173 = Algo$.MODULE$.Classification();
            Entropy$ x$174 = Entropy$.MODULE$;
            int x$175 = 3;
            int x$176 = 2;
            int x$177 = 100;
            int x$178 = 1000;
            Enumeration.Value x$179 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$180 = Strategy$.MODULE$.$lessinit$greater$default$7();
            int x$181 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$182 = Strategy$.MODULE$.$lessinit$greater$default$9();
            double x$183 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$184 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$185 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$186 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$187 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy1 = new Strategy(x$173, (Impurity)x$174, x$175, x$176, x$177, x$179, x$180, x$181, x$182, x$178, x$183, x$184, x$185, x$186, x$187);
            Enumeration.Value x$188 = Algo$.MODULE$.Classification();
            Entropy$ x$189 = Entropy$.MODULE$;
            int x$190 = 3;
            int x$191 = 2;
            int x$192 = 100;
            int x$193 = 0;
            Enumeration.Value x$194 = Strategy$.MODULE$.$lessinit$greater$default$6();
            Map x$195 = Strategy$.MODULE$.$lessinit$greater$default$7();
            int x$196 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$197 = Strategy$.MODULE$.$lessinit$greater$default$9();
            double x$198 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$199 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$200 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$201 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$202 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy2 = new Strategy(x$188, (Impurity)x$189, x$190, x$191, x$192, x$194, x$195, x$196, x$197, x$193, x$198, x$199, x$200, x$201, x$202);
            DecisionTreeModel tree1 = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy1, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8()))).head();
            DecisionTreeModel tree2 = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy2, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8()))).head();
            InternalNode[] children1 = this.getChildren$1(tree1.rootNode());
            InternalNode[] children2 = this.getChildren$1(tree2.rootNode());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1 & Serializable & scala.Serializable)i -> RandomForestSuite.$anonfun$new$40(this, children1, children2, BoxesRunTime.unboxToInt((Object)i)));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        this.test("Binary classification with continuous features: subsampling features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
            Enumeration.Value x$203 = Algo$.MODULE$.Classification();
            Gini$ x$204 = Gini$.MODULE$;
            int x$205 = 2;
            int x$206 = 2;
            Map x$207 = categoricalFeaturesInfo;
            int x$208 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$209 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$210 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$211 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$212 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$213 = Strategy$.MODULE$.$lessinit$greater$default$11();
            boolean x$214 = Strategy$.MODULE$.$lessinit$greater$default$12();
            int x$215 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$216 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$217 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$203, (Impurity)x$204, x$205, x$206, x$208, x$209, x$207, x$210, x$211, x$212, x$213, x$214, x$215, x$216, x$217);
            this.binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(strategy);
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
        this.test("Binary classification with continuous features and node Id cache: subsampling features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
            Enumeration.Value x$218 = Algo$.MODULE$.Classification();
            Gini$ x$219 = Gini$.MODULE$;
            int x$220 = 2;
            int x$221 = 2;
            Map x$222 = categoricalFeaturesInfo;
            boolean x$223 = true;
            int x$224 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Enumeration.Value x$225 = Strategy$.MODULE$.$lessinit$greater$default$6();
            int x$226 = Strategy$.MODULE$.$lessinit$greater$default$8();
            double x$227 = Strategy$.MODULE$.$lessinit$greater$default$9();
            int x$228 = Strategy$.MODULE$.$lessinit$greater$default$10();
            double x$229 = Strategy$.MODULE$.$lessinit$greater$default$11();
            int x$230 = Strategy$.MODULE$.$lessinit$greater$default$13();
            double x$231 = Strategy$.MODULE$.$lessinit$greater$default$14();
            boolean x$232 = Strategy$.MODULE$.$lessinit$greater$default$15();
            Strategy strategy = new Strategy(x$218, (Impurity)x$219, x$220, x$221, x$224, x$225, x$222, x$226, x$227, x$228, x$229, x$223, x$230, x$231, x$232);
            this.binaryClassificationTestWithContinuousFeaturesAndSubsampledFeatures(strategy);
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        this.test("computeFeatureImportance, featureImportances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GiniCalculator leftImp = new GiniCalculator(new double[]{3.0, 2.0, 1.0}, 6L);
            LeafNode left = new LeafNode(0.0, leftImp.calculate(), (ImpurityCalculator)leftImp);
            GiniCalculator rightImp = new GiniCalculator(new double[]{1.0, 2.0, 5.0}, 8L);
            LeafNode right = new LeafNode(2.0, rightImp.calculate(), (ImpurityCalculator)rightImp);
            Node parent = TreeTests$.MODULE$.buildParentNode((Node)left, (Node)right, (Split)new ContinuousSplit(0, 0.5));
            ImpurityCalculator parentImp = parent.impurityStats();
            GiniCalculator left2Imp = new GiniCalculator(new double[]{1.0, 6.0, 1.0}, 8L);
            LeafNode left2 = new LeafNode(0.0, left2Imp.calculate(), (ImpurityCalculator)left2Imp);
            Node grandParent = TreeTests$.MODULE$.buildParentNode((Node)left2, parent, (Split)new ContinuousSplit(1, 1.0));
            ImpurityCalculator grandImp = grandParent.impurityStats();
            RandomForestSuite.testNode$1((Node)left, Predef$.MODULE$.Map().empty());
            double feature0importance = parentImp.calculate() * parentImp.count() - (leftImp.calculate() * leftImp.count() + rightImp.calculate() * rightImp.count());
            RandomForestSuite.testNode$1(parent, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)feature0importance))})));
            double feature1importance = grandImp.calculate() * grandImp.count() - (left2Imp.calculate() * left2Imp.count() + parentImp.calculate() * parentImp.count());
            RandomForestSuite.testNode$1(grandParent, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)feature0importance)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToDouble((double)feature1importance))})));
            DecisionTreeModel[] trees = (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Node[]{parent, grandParent})).map((Function1 & Serializable & scala.Serializable)root -> new DecisionTreeClassificationModel(root, 2, 3), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
            Vector importances = TreeEnsembleModel$.MODULE$.featureImportances(trees, 2, TreeEnsembleModel$.MODULE$.featureImportances$default$3());
            double tree2norm = feature0importance + feature1importance;
            Vector expected = Vectors$.MODULE$.dense((1.0 + feature0importance / tree2norm) / 2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{feature1importance / tree2norm / 2.0}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(importances).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(importances).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(expected).relTol(0.01))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
        this.test("normalizeMapValues", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            OpenHashMap.mcD.sp map = new OpenHashMap.mcD.sp(ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double());
            map.update$mcD$sp((Object)BoxesRunTime.boxToInteger((int)0), 1.0);
            map.update$mcD$sp((Object)BoxesRunTime.boxToInteger((int)2), 2.0);
            TreeEnsembleModel$.MODULE$.normalizeMapValues((OpenHashMap)map);
            Map expected = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToDouble((double)0.3333333333333333)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToDouble((double)0.6666666666666666))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)map.toMap(Predef$.MODULE$.$conforms()))).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(RandomForestSuite$.MODULE$.mapToVec((Map<Object, Object>)expected)).relTol(0.01)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(map.toMap[Int, Double](scala.Predef.$conforms[(Int, Double)]))).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(RandomForestSuite.mapToVec(expected)).relTol(0.01))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 661));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
        this.test("SPARK-3159 tree model redundancy - classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Instance[] arr = (Instance[])((Object[])new Instance[]{new Instance(0.0, 1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(1.0, 1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(0.0, 1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new Instance(1.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new Instance(0.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new Instance(1.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))});
            SparkContext qual$12 = this.sc();
            WrappedArray x$233 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$234 = qual$12.parallelize$default$2();
            RDD rdd = qual$12.parallelize((Seq)x$233, x$234, ClassTag$.MODULE$.apply(Instance.class));
            int numClasses = 2;
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, numClasses, 32, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeModel prunedTree = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy, 1, "auto", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8()))).head();
            DecisionTreeModel unprunedTree = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy, 1, "auto", 42L, (Option)None$.MODULE$, false, RandomForest$.MODULE$.run$default$8()))).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)prunedTree.numNodes()));
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)unprunedTree.numNodes()));
            int $org_scalatest_assert_macro_right2 = 7;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)RandomForestSuite$.MODULE$.org$apache$spark$ml$tree$impl$RandomForestSuite$$getSumLeafCounters((List<Node>)new .colon.colon((Object)prunedTree.rootNode(), (List)Nil$.MODULE$), RandomForestSuite$.MODULE$.org$apache$spark$ml$tree$impl$RandomForestSuite$$getSumLeafCounters$default$2())));
            int $org_scalatest_assert_macro_right3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        this.test("SPARK-3159 tree model redundancy - regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Instance[] arr = (Instance[])((Object[])new Instance[]{new Instance(0.0, 1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(1.0, 1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(0.0, 1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new Instance(0.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new Instance(1.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(0.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(0.5, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})))});
            SparkContext qual$13 = this.sc();
            WrappedArray x$235 = Predef$.MODULE$.wrapRefArray((Object[])arr);
            int x$236 = qual$13.parallelize$default$2();
            RDD rdd = qual$13.parallelize((Seq)x$235, x$236, ClassTag$.MODULE$.apply(Instance.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Regression(), (Impurity)Variance$.MODULE$, 4, 0, 32, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeModel prunedTree = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy, 1, "auto", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8()))).head();
            DecisionTreeModel unprunedTree = (DecisionTreeModel)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(rdd, strategy, 1, "auto", 42L, (Option)None$.MODULE$, false, RandomForest$.MODULE$.run$default$8()))).head();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)prunedTree.numNodes()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)unprunedTree.numNodes()));
            int $org_scalatest_assert_macro_right2 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)RandomForestSuite$.MODULE$.org$apache$spark$ml$tree$impl$RandomForestSuite$$getSumLeafCounters((List<Node>)new .colon.colon((Object)prunedTree.rootNode(), (List)Nil$.MODULE$), RandomForestSuite$.MODULE$.org$apache$spark$ml$tree$impl$RandomForestSuite$$getSumLeafCounters$default$2())));
            int $org_scalatest_assert_macro_right3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).size();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
        this.test("weights at arbitrary scale", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.mllib.regression.LabeledPoint[] arr = EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(3, 10);
            SparkContext qual$14 = this.sc();
            WrappedArray x$237 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.asML().toInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Instance.class))));
            int x$238 = qual$14.parallelize$default$2();
            RDD rddWithUnitWeights = qual$14.parallelize((Seq)x$237, x$238, ClassTag$.MODULE$.apply(Instance.class));
            RDD rddWithSmallWeights = rddWithUnitWeights.map((Function1 & Serializable & scala.Serializable)inst -> new Instance(inst.label(), 0.001, inst.features()), ClassTag$.MODULE$.apply(Instance.class));
            RDD rddWithBigWeights = rddWithUnitWeights.map((Function1 & Serializable & scala.Serializable)inst -> new Instance(inst.label(), 1000.0, inst.features()), ClassTag$.MODULE$.apply(Instance.class));
            Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13(), Strategy$.MODULE$.$lessinit$greater$default$14(), Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeModel[] unitWeightTrees = RandomForest$.MODULE$.run(rddWithUnitWeights, strategy, 3, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            DecisionTreeModel[] smallWeightTrees = RandomForest$.MODULE$.run(rddWithSmallWeights, strategy, 3, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unitWeightTrees)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])smallWeightTrees), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                RandomForestSuite.$anonfun$new$52(x0$4);
                return BoxedUnit.UNIT;
            });
            DecisionTreeModel[] bigWeightTrees = RandomForest$.MODULE$.run(rddWithBigWeights, strategy, 3, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])unitWeightTrees)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])bigWeightTrees), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                RandomForestSuite.$anonfun$new$53(x0$5);
                return BoxedUnit.UNIT;
            });
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
        this.test("minWeightFraction and minInstancesPerNode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DecisionTreeModel tree4;
            DecisionTreeModel tree3;
            DecisionTreeModel tree2;
            DecisionTreeModel tree1;
            boolean x$255;
            int x$254;
            boolean x$253;
            double x$252;
            int x$251;
            double x$250;
            int x$249;
            Map x$248;
            Enumeration.Value x$247;
            Instance[] data = (Instance[])((Object[])new Instance[]{new Instance(0.0, 1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(0.0, 1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(0.0, 1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(0.0, 1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))});
            SparkContext qual$15 = this.sc();
            WrappedArray x$239 = Predef$.MODULE$.wrapRefArray((Object[])data);
            int x$240 = qual$15.parallelize$default$2();
            RDD rdd = qual$15.parallelize((Seq)x$239, x$240, ClassTag$.MODULE$.apply(Instance.class));
            Enumeration.Value x$241 = Algo$.MODULE$.Classification();
            Gini$ x$242 = Gini$.MODULE$;
            int x$243 = 3;
            int x$244 = 2;
            double x$245 = 0.5;
            int x$246 = Strategy$.MODULE$.$lessinit$greater$default$5();
            Strategy strategy = new Strategy(x$241, (Impurity)x$242, x$243, x$244, x$246, x$247 = Strategy$.MODULE$.$lessinit$greater$default$6(), x$248 = Strategy$.MODULE$.$lessinit$greater$default$7(), x$249 = Strategy$.MODULE$.$lessinit$greater$default$8(), x$250 = Strategy$.MODULE$.$lessinit$greater$default$9(), x$251 = Strategy$.MODULE$.$lessinit$greater$default$10(), x$252 = Strategy$.MODULE$.$lessinit$greater$default$11(), x$253 = Strategy$.MODULE$.$lessinit$greater$default$12(), x$254 = Strategy$.MODULE$.$lessinit$greater$default$13(), x$245, x$255 = Strategy$.MODULE$.$lessinit$greater$default$15());
            DecisionTreeModel[] decisionTreeModelArray = RandomForest$.MODULE$.run(rdd, strategy, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            Option option = Array$.MODULE$.unapplySeq((Object)decisionTreeModelArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)decisionTreeModelArray);
            }
            DecisionTreeModel decisionTreeModel = tree1 = (DecisionTreeModel)((SeqLike)option.get()).apply(0);
            DecisionTreeModel tree12 = decisionTreeModel;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)tree12.depth()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
            strategy.minWeightFractionPerNode_$eq(0.0);
            DecisionTreeModel[] decisionTreeModelArray2 = RandomForest$.MODULE$.run(rdd, strategy, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            Option option2 = Array$.MODULE$.unapplySeq((Object)decisionTreeModelArray2);
            if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)decisionTreeModelArray2);
            }
            DecisionTreeModel decisionTreeModel2 = tree2 = (DecisionTreeModel)((SeqLike)option2.get()).apply(0);
            DecisionTreeModel tree22 = decisionTreeModel2;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)tree22.depth()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
            strategy.minInstancesPerNode_$eq(2);
            DecisionTreeModel[] decisionTreeModelArray3 = RandomForest$.MODULE$.run(rdd, strategy, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            Option option3 = Array$.MODULE$.unapplySeq((Object)decisionTreeModelArray3);
            if (option3.isEmpty() || option3.get() == null || ((SeqLike)option3.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)decisionTreeModelArray3);
            }
            DecisionTreeModel decisionTreeModel3 = tree3 = (DecisionTreeModel)((SeqLike)option3.get()).apply(0);
            DecisionTreeModel tree32 = decisionTreeModel3;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)tree32.depth()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
            strategy.minInstancesPerNode_$eq(1);
            DecisionTreeModel[] decisionTreeModelArray4 = RandomForest$.MODULE$.run(rdd, strategy, 1, "all", 42L, (Option)None$.MODULE$, RandomForest$.MODULE$.run$default$7(), RandomForest$.MODULE$.run$default$8());
            Option option4 = Array$.MODULE$.unapplySeq((Object)decisionTreeModelArray4);
            if (option4.isEmpty() || option4.get() == null || ((SeqLike)option4.get()).lengthCompare(1) != 0) {
                throw new MatchError((Object)decisionTreeModelArray4);
            }
            DecisionTreeModel decisionTreeModel4 = tree4 = (DecisionTreeModel)((SeqLike)option4.get()).apply(0);
            DecisionTreeModel tree42 = decisionTreeModel4;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)tree42.depth()));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
        }, new Position("RandomForestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
    }
}

