/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.SharedSparkSession;
import org.apache.spark.ml.feature.DCT;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.jtransforms.dct.DoubleDCT_1D;
import org.junit.Assert;
import org.junit.Test;

public class JavaDCTSuite
extends SharedSparkSession {
    @Test
    public void javaCompatibilityTest() {
        double[] input = new double[]{1.0, 2.0, 3.0, 4.0};
        Dataset dataset = this.spark.createDataFrame(Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.dense((double[])input)})), new StructType(new StructField[]{new StructField("vec", (DataType)new VectorUDT(), false, Metadata.empty())}));
        double[] expectedResult = (double[])input.clone();
        new DoubleDCT_1D((long)input.length).forward(expectedResult, true);
        DCT dct = (DCT)((DCT)new DCT().setInputCol("vec")).setOutputCol("resultVec");
        List result = dct.transform(dataset).select("resultVec", new String[0]).collectAsList();
        Vector resultVec = (Vector)((Row)result.get(0)).getAs("resultVec");
        Assert.assertArrayEquals((double[])expectedResult, (double[])resultVec.toArray(), (double)1.0E-6);
    }
}

