/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.LinearRegressionWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class LinearRegressionWrapper$
implements MLReadable<LinearRegressionWrapper> {
    public static LinearRegressionWrapper$ MODULE$;

    static {
        new LinearRegressionWrapper$();
    }

    @Override
    public Object load(String path) {
        return MLReadable.load$(this, path);
    }

    public LinearRegressionWrapper fit(Dataset<Row> data, String formula, int maxIter, double regParam, double elasticNetParam, double tol, boolean standardization, String solver, String weightCol, int aggregationDepth, String loss, double epsilon, String stringIndexerOrderType) {
        RFormula rFormula = new RFormula().setFormula(formula).setStringIndexerOrderType(stringIndexerOrderType);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        boolean fitIntercept = rFormula.hasIntercept();
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureAttrs)).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.name().get(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        LinearRegression lm = (LinearRegression)new LinearRegression().setMaxIter(maxIter).setRegParam(regParam).setElasticNetParam(elasticNetParam).setTol(tol).setFitIntercept(fitIntercept).setStandardization(standardization).setSolver(solver).setAggregationDepth(aggregationDepth).setLoss(loss).setEpsilon(epsilon).setFeaturesCol(rFormula.getFeaturesCol());
        Object object = weightCol != null ? lm.setWeightCol(weightCol) : BoxedUnit.UNIT;
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, lm})).fit((Dataset)data);
        return new LinearRegressionWrapper((PipelineModel)pipeline, features);
    }

    @Override
    public MLReader<LinearRegressionWrapper> read() {
        return new LinearRegressionWrapper.LinearRegressionWrapperReader();
    }

    private LinearRegressionWrapper$() {
        MODULE$ = this;
        MLReadable.$init$(this);
    }
}

