/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.BlockMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner$;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001\u0002\u000b\u0016\u0001\tB\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005_!A1\t\u0001BA\u0002\u0013%A\t\u0003\u0005I\u0001\t\u0005\r\u0011\"\u0003J\u0011!y\u0005A!A!B\u0013)\u0005\u0002\u0003)\u0001\u0005\u0003\u0007I\u0011\u0002#\t\u0011E\u0003!\u00111A\u0005\nIC\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006K!\u0012\u0005\u0006+\u0002!\tA\u0016\u0005\u0006+\u0002!\t!\u0018\u0005\u0006A\u0002!\t%\u0019\u0005\u0006G\u0002!\t%\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\u0006U\u0002!\ta\u001b\u0005\u0006a\u0002!\t!\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\u0006m\u0002!\t\u0001 \u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011!\ty\u0001\u0001C!3\u0005E!\u0001E\"p_J$\u0017N\\1uK6\u000bGO]5y\u0015\t1r#A\u0006eSN$(/\u001b2vi\u0016$'B\u0001\r\u001a\u0003\u0019a\u0017N\\1mO*\u0011!dG\u0001\u0006[2d\u0017N\u0019\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0016\u000e\u0003UI!\u0001L\u000b\u0003#\u0011K7\u000f\u001e:jEV$X\rZ'biJL\u00070A\u0004f]R\u0014\u0018.Z:\u0016\u0003=\u00022\u0001M\u001a6\u001b\u0005\t$B\u0001\u001a\u001c\u0003\r\u0011H\rZ\u0005\u0003iE\u00121A\u0015#E!\tQc'\u0003\u00028+\tYQ*\u0019;sSb,e\u000e\u001e:zQ\r\t\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0003ym\t!\"\u00198o_R\fG/[8o\u0013\tq4HA\u0003TS:\u001cW-I\u0001A\u0003\u0015\td\u0006\r\u00181\u0003!)g\u000e\u001e:jKN\u0004\u0003f\u0001\u0002:\u007f\u0005)aNU8xgV\tQ\t\u0005\u0002%\r&\u0011q)\n\u0002\u0005\u0019>tw-A\u0005o%><8o\u0018\u0013fcR\u0011!*\u0014\t\u0003I-K!\u0001T\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u0012\t\t\u00111\u0001F\u0003\rAH%M\u0001\u0007]J{wo\u001d\u0011\u0002\u000b9\u001cu\u000e\\:\u0002\u00139\u001cu\u000e\\:`I\u0015\fHC\u0001&T\u0011\u001dqu!!AA\u0002\u0015\u000baA\\\"pYN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003X1j[\u0006C\u0001\u0016\u0001\u0011\u0015i\u0013\u00021\u00010Q\rA\u0016h\u0010\u0005\u0006\u0007&\u0001\r!\u0012\u0005\u0006!&\u0001\r!\u0012\u0015\u0004\u0013ezDCA,_\u0011\u0015i#\u00021\u00010Q\rQ\u0011hP\u0001\b]Vl7i\u001c7t)\u0005)\u0005fA\u0006:\u007f\u00059a.^7S_^\u001c\bf\u0001\u0007:\u007f\u0005IAO]1ogB|7/\u001a\u000b\u0002/\"\u001aQ\"\u000f5\"\u0003%\fQ!\r\u00184]A\n!\u0003^8J]\u0012,\u00070\u001a3S_^l\u0015\r\u001e:jqR\tA\u000e\u0005\u0002+[&\u0011a.\u0006\u0002\u0011\u0013:$W\r_3e%><X*\u0019;sSbD3AD\u001d@\u0003-!xNU8x\u001b\u0006$(/\u001b=\u0015\u0003I\u0004\"AK:\n\u0005Q,\"!\u0003*po6\u000bGO]5yQ\ry\u0011hP\u0001\u000ei>\u0014En\\2l\u001b\u0006$(/\u001b=\u0015\u0003a\u0004\"AK=\n\u0005i,\"a\u0003\"m_\u000e\\W*\u0019;sSbD3\u0001E\u001di)\u0011AX0!\u0002\t\u000by\f\u0002\u0019A@\u0002\u0019I|wo\u001d)fe\ncwnY6\u0011\u0007\u0011\n\t!C\u0002\u0002\u0004\u0015\u00121!\u00138u\u0011\u0019\t9!\u0005a\u0001\u007f\u0006a1m\u001c7t!\u0016\u0014(\t\\8dW\"\u001a\u0011#\u000f5\u0002\u0017\r|W\u000e];uKNK'0\u001a\u000b\u0002\u0015\u0006AAo\u001c\"sK\u0016TX\r\u0006\u0002\u0002\u0014A1\u0011QCA\u000f\u0003Ci!!a\u0006\u000b\u0007a\tIB\u0003\u0002\u0002\u001c\u00051!M]3fu\u0016LA!a\b\u0002\u0018\tYA)\u001a8tK6\u000bGO]5y!\r!\u00131E\u0005\u0004\u0003K)#A\u0002#pk\ndW\rK\u0002\u0001s}\u0002")
public class CoordinateMatrix
implements DistributedMatrix {
    private final RDD<MatrixEntry> entries;
    private long nRows;
    private long nCols;

    public RDD<MatrixEntry> entries() {
        return this.entries;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private long nCols() {
        return this.nCols;
    }

    private void nCols_$eq(long x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numCols() {
        block0: {
            if (this.nCols() > 0L) break block0;
            this.computeSize();
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        block0: {
            if (this.nRows() > 0L) break block0;
            this.computeSize();
        }
        return this.nRows();
    }

    public CoordinateMatrix transpose() {
        return new CoordinateMatrix((RDD<MatrixEntry>)this.entries().map((Function1 & Serializable & scala.Serializable)x -> new MatrixEntry(x.j(), x.i(), x.value()), ClassTag$.MODULE$.apply(MatrixEntry.class)), this.numCols(), this.numRows());
    }

    public IndexedRowMatrix toIndexedRowMatrix() {
        long nl = this.numCols();
        if (nl > Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(84).append("Cannot convert to a row-oriented format because the number of columns ").append(nl).append(" is ").append("too large.").toString());
        }
        int n = (int)nl;
        RDD indexedRows = RDD$.MODULE$.rddToPairRDDFunctions(this.entries().map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)BoxesRunTime.boxToLong((long)entry.i()), (Object)new Tuple2.mcID.sp((int)entry.j(), entry.value())), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).groupByKey().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long i = tuple2._1$mcJ$sp();
                Iterable vectorEntries = (Iterable)tuple2._2();
                return new IndexedRow(i, Vectors$.MODULE$.sparse(n, (Seq<Tuple2<Object, Object>>)vectorEntries.toSeq()));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(IndexedRow.class));
        return new IndexedRowMatrix((RDD<IndexedRow>)indexedRows, this.numRows(), n);
    }

    public RowMatrix toRowMatrix() {
        return this.toIndexedRowMatrix().toRowMatrix();
    }

    public BlockMatrix toBlockMatrix() {
        return this.toBlockMatrix(1024, 1024);
    }

    public BlockMatrix toBlockMatrix(int rowsPerBlock, int colsPerBlock) {
        Predef$.MODULE$.require(rowsPerBlock > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("rowsPerBlock needs to be greater than 0. rowsPerBlock: ").append(rowsPerBlock).toString());
        Predef$.MODULE$.require(colsPerBlock > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("colsPerBlock needs to be greater than 0. colsPerBlock: ").append(colsPerBlock).toString());
        long m = this.numRows();
        long n = this.numCols();
        Predef$.MODULE$.require(package$.MODULE$.ceil((double)m / (double)rowsPerBlock) <= (double)Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> "Number of rows divided by rowsPerBlock cannot exceed maximum integer.");
        Predef$.MODULE$.require(package$.MODULE$.ceil((double)n / (double)colsPerBlock) <= (double)Integer.MAX_VALUE, (Function0 & Serializable & scala.Serializable)() -> "Number of cols divided by colsPerBlock cannot exceed maximum integer.");
        int numRowBlocks = (int)package$.MODULE$.ceil((double)m / (double)rowsPerBlock);
        int numColBlocks = (int)package$.MODULE$.ceil((double)n / (double)colsPerBlock);
        GridPartitioner partitioner = GridPartitioner$.MODULE$.apply(numRowBlocks, numColBlocks, this.entries().partitions().length);
        RDD blocks = RDD$.MODULE$.rddToPairRDDFunctions(this.entries().map((Function1 & Serializable & scala.Serializable)entry -> {
            int blockRowIndex = (int)(entry.i() / (long)rowsPerBlock);
            int blockColIndex = (int)(entry.j() / (long)colsPerBlock);
            long rowId = entry.i() % (long)rowsPerBlock;
            long colId = entry.j() % (long)colsPerBlock;
            return new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)((int)rowId)), (Object)BoxesRunTime.boxToInteger((int)((int)colId)), (Object)BoxesRunTime.boxToDouble((double)entry.value())));
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple3.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).groupByKey((Partitioner)partitioner).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Iterable entry = (Iterable)tuple2._2();
                if (tuple22 != null) {
                    int blockRowIndex = tuple22._1$mcI$sp();
                    int blockColIndex = tuple22._2$mcI$sp();
                    int effRows = (int)package$.MODULE$.min(m - (long)blockRowIndex * (long)rowsPerBlock, (long)rowsPerBlock);
                    int effCols = (int)package$.MODULE$.min(n - (long)blockColIndex * (long)colsPerBlock, (long)colsPerBlock);
                    return new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)SparseMatrix$.MODULE$.fromCOO(effRows, effCols, (Iterable<Tuple3<Object, Object, Object>>)entry));
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)blocks, rowsPerBlock, colsPerBlock, m, n);
    }

    private void computeSize() {
        Tuple2 tuple2 = (Tuple2)this.entries().map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2.mcJJ.sp(entry.i(), entry.j()), ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    long i1 = tuple22._1$mcJ$sp();
                    long j1 = tuple22._2$mcJ$sp();
                    if (tuple23 != null) {
                        long i2 = tuple23._1$mcJ$sp();
                        long j2 = tuple23._2$mcJ$sp();
                        return new Tuple2.mcJJ.sp(package$.MODULE$.max(i1, i2), package$.MODULE$.max(j1, j2));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long m1 = tuple2._1$mcJ$sp();
        long n1 = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(m1, n1);
        long m12 = sp2._1$mcJ$sp();
        long n12 = sp2._2$mcJ$sp();
        this.nRows_$eq(package$.MODULE$.max(this.nRows(), m12 + 1L));
        this.nCols_$eq(package$.MODULE$.max(this.nCols(), n12 + 1L));
    }

    @Override
    public DenseMatrix<Object> toBreeze() {
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.entries().collect())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CoordinateMatrix.$anonfun$toBreeze$1(mat, x0$1);
            return BoxedUnit.UNIT;
        });
        return mat;
    }

    public static final /* synthetic */ void $anonfun$toBreeze$1(DenseMatrix mat$1, MatrixEntry x0$1) {
        MatrixEntry matrixEntry = x0$1;
        if (matrixEntry != null) {
            long i = matrixEntry.i();
            long j = matrixEntry.j();
            double value = matrixEntry.value();
            mat$1.update$mcD$sp((int)i, (int)j, value);
            return;
        }
        throw new MatchError((Object)matrixEntry);
    }

    public CoordinateMatrix(RDD<MatrixEntry> entries, long nRows, long nCols) {
        this.entries = entries;
        this.nRows = nRows;
        this.nCols = nCols;
    }

    public CoordinateMatrix(RDD<MatrixEntry> entries) {
        this(entries, 0L, 0L);
    }
}

