/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.mllib.feature.VocabWord;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t=f\u0001B\u001d;\u0001\u0015CQ!\u0016\u0001\u0005\u0002YCq!\u0017\u0001A\u0002\u0013%!\fC\u0004_\u0001\u0001\u0007I\u0011B0\t\r\u0015\u0004\u0001\u0015)\u0003\\\u0011\u001d1\u0007\u00011A\u0005\n\u001dDqa\u001b\u0001A\u0002\u0013%A\u000e\u0003\u0004o\u0001\u0001\u0006K\u0001\u001b\u0005\b_\u0002\u0001\r\u0011\"\u0003[\u0011\u001d\u0001\b\u00011A\u0005\nEDaa\u001d\u0001!B\u0013Y\u0006b\u0002;\u0001\u0001\u0004%IA\u0017\u0005\bk\u0002\u0001\r\u0011\"\u0003w\u0011\u0019A\b\u0001)Q\u00057\"9\u0011\u0010\u0001a\u0001\n\u0013Q\bb\u0002@\u0001\u0001\u0004%Ia \u0005\b\u0003\u0007\u0001\u0001\u0015)\u0003|\u0011!\t)\u0001\u0001a\u0001\n\u0013Q\u0006\"CA\u0004\u0001\u0001\u0007I\u0011BA\u0005\u0011\u001d\ti\u0001\u0001Q!\nmC\u0001\"a\u0004\u0001\u0001\u0004%IA\u0017\u0005\n\u0003#\u0001\u0001\u0019!C\u0005\u0003'Aq!a\u0006\u0001A\u0003&1\fC\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0003bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002n\u0001!\t!a\u001c\t\u0011\u0005e\u0004A1A\u0005\niCq!a\u001f\u0001A\u0003%1\f\u0003\u0005\u0002~\u0001\u0011\r\u0011\"\u0003[\u0011\u001d\ty\b\u0001Q\u0001\nmC\u0001\"!!\u0001\u0005\u0004%IA\u0017\u0005\b\u0003\u0007\u0003\u0001\u0015!\u0003\\\u0011!\t)\u0007\u0001a\u0001\n\u0013Q\u0006\"CAC\u0001\u0001\u0007I\u0011BAD\u0011\u001d\tY\t\u0001Q!\nmC\u0001\"!$\u0001\u0001\u0004%IA\u001f\u0005\n\u0003\u001f\u0003\u0001\u0019!C\u0005\u0003#Cq!!&\u0001A\u0003&1\u0010\u0003\u0005\u0002\u0018\u0002\u0001\r\u0011\"\u0003[\u0011%\tI\n\u0001a\u0001\n\u0013\tY\nC\u0004\u0002 \u0002\u0001\u000b\u0015B.\t\u0013\u0005\u0005\u0006\u00011A\u0005\n\u0005\r\u0006\"CAY\u0001\u0001\u0007I\u0011BAZ\u0011!\t9\f\u0001Q!\n\u0005\u0015\u0006\"CAa\u0001\t\u0007I\u0011BAb\u0011!\tY\u000f\u0001Q\u0001\n\u0005\u0015\u0007bBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005kAqAa\u000e\u0001\t\u0003\u0011I\u0004C\u0004\u0003N\u0001!IAa\u0014\t\u000f\t]\u0002\u0001\"\u0001\u0003\u0004\nAqk\u001c:eeY+7M\u0003\u0002<y\u00059a-Z1ukJ,'BA\u001f?\u0003\u0015iG\u000e\\5c\u0015\ty\u0004)A\u0003ta\u0006\u00148N\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0019cu\n\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u000f6K!A\u0014%\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005A\u001bV\"A)\u000b\u0005Is\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005Q\u000b&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0003\"\u0001\u0017\u0001\u000e\u0003i\n!B^3di>\u00148+\u001b>f+\u0005Y\u0006CA$]\u0013\ti\u0006JA\u0002J]R\faB^3di>\u00148+\u001b>f?\u0012*\u0017\u000f\u0006\u0002aGB\u0011q)Y\u0005\u0003E\"\u0013A!\u00168ji\"9AmAA\u0001\u0002\u0004Y\u0016a\u0001=%c\u0005Ya/Z2u_J\u001c\u0016N_3!\u00031aW-\u0019:oS:<'+\u0019;f+\u0005A\u0007CA$j\u0013\tQ\u0007J\u0001\u0004E_V\u0014G.Z\u0001\u0011Y\u0016\f'O\\5oOJ\u000bG/Z0%KF$\"\u0001Y7\t\u000f\u00114\u0011\u0011!a\u0001Q\u0006iA.Z1s]&twMU1uK\u0002\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00058v[B\u000b'\u000f^5uS>t7o\u0018\u0013fcR\u0011\u0001M\u001d\u0005\bI&\t\t\u00111\u0001\\\u00039qW/\u001c)beRLG/[8og\u0002\nQB\\;n\u0013R,'/\u0019;j_:\u001c\u0018!\u00058v[&#XM]1uS>t7o\u0018\u0013fcR\u0011\u0001m\u001e\u0005\bI2\t\t\u00111\u0001\\\u00039qW/\\%uKJ\fG/[8og\u0002\nAa]3fIV\t1\u0010\u0005\u0002Hy&\u0011Q\u0010\u0013\u0002\u0005\u0019>tw-\u0001\u0005tK\u0016$w\fJ3r)\r\u0001\u0017\u0011\u0001\u0005\bI>\t\t\u00111\u0001|\u0003\u0015\u0019X-\u001a3!\u0003!i\u0017N\\\"pk:$\u0018\u0001D7j]\u000e{WO\u001c;`I\u0015\fHc\u00011\u0002\f!9AMEA\u0001\u0002\u0004Y\u0016!C7j]\u000e{WO\u001c;!\u0003Ei\u0017\r_*f]R,gnY3MK:<G\u000f[\u0001\u0016[\u0006D8+\u001a8uK:\u001cW\rT3oORDw\fJ3r)\r\u0001\u0017Q\u0003\u0005\bIV\t\t\u00111\u0001\\\u0003Ii\u0017\r_*f]R,gnY3MK:<G\u000f\u001b\u0011\u0002)M,G/T1y'\u0016tG/\u001a8dK2+gn\u001a;i)\u0011\ti\"a\b\u000e\u0003\u0001Aa!a\u0004\u0018\u0001\u0004Y\u0006&B\f\u0002$\u0005=\u0002\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%b(\u0001\u0006b]:|G/\u0019;j_:LA!!\f\u0002(\t)1+\u001b8dK\u0006\u0012\u0011\u0011G\u0001\u0006e9\u0002d\u0006M\u0001\u000eg\u0016$h+Z2u_J\u001c\u0016N_3\u0015\t\u0005u\u0011q\u0007\u0005\u00063b\u0001\ra\u0017\u0015\u00061\u0005\r\u00121H\u0011\u0003\u0003{\tQ!\r\u00182]A\nqb]3u\u0019\u0016\f'O\\5oOJ\u000bG/\u001a\u000b\u0005\u0003;\t\u0019\u0005C\u0003g3\u0001\u0007\u0001\u000eK\u0003\u001a\u0003G\tY$\u0001\ttKRtU/\u001c)beRLG/[8ogR!\u0011QDA&\u0011\u0015y'\u00041\u0001\\Q\u0015Q\u00121EA\u001e\u0003A\u0019X\r\u001e(v[&#XM]1uS>t7\u000f\u0006\u0003\u0002\u001e\u0005M\u0003\"\u0002;\u001c\u0001\u0004Y\u0006&B\u000e\u0002$\u0005m\u0012aB:fiN+W\r\u001a\u000b\u0005\u0003;\tY\u0006C\u0003z9\u0001\u00071\u0010K\u0003\u001d\u0003G\tY$A\u0007tKR<\u0016N\u001c3poNK'0\u001a\u000b\u0005\u0003;\t\u0019\u0007\u0003\u0004\u0002fu\u0001\raW\u0001\u0007o&tGm\\<)\u000bu\t\u0019#!\u001b\"\u0005\u0005-\u0014!B\u0019/m9\u0002\u0014aC:fi6KgnQ8v]R$B!!\b\u0002r!1\u0011Q\u0001\u0010A\u0002mCSAHA\u0012\u0003k\n#!a\u001e\u0002\u000bEr3G\f\u0019\u0002\u001d\u0015C\u0006k\u0018+B\u00052+ulU%[\u000b\u0006yQ\t\u0017)`)\u0006\u0013E*R0T\u0013j+\u0005%A\u0004N\u0003b{V\t\u0017)\u0002\u00115\u000b\u0005lX#Y!\u0002\nq\"T!Y?\u000e{E)R0M\u000b:;E\u000bS\u0001\u0011\u001b\u0006CvlQ(E\u000b~cUIT$U\u0011\u0002\n!b^5oI><x\fJ3r)\r\u0001\u0017\u0011\u0012\u0005\bI\u001a\n\t\u00111\u0001\\\u0003\u001d9\u0018N\u001c3po\u0002\nq\u0002\u001e:bS:<vN\u001d3t\u0007>,h\u000e^\u0001\u0014iJ\f\u0017N\\,pe\u0012\u001c8i\\;oi~#S-\u001d\u000b\u0004A\u0006M\u0005b\u00023*\u0003\u0003\u0005\ra_\u0001\u0011iJ\f\u0017N\\,pe\u0012\u001c8i\\;oi\u0002\n\u0011B^8dC\n\u001c\u0016N_3\u0002\u001bY|7-\u00192TSj,w\fJ3r)\r\u0001\u0017Q\u0014\u0005\bI2\n\t\u00111\u0001\\\u0003)1xnY1c'&TX\rI\u0001\u0006m>\u001c\u0017MY\u000b\u0003\u0003K\u0003RaRAT\u0003WK1!!+I\u0005\u0015\t%O]1z!\rA\u0016QV\u0005\u0004\u0003_S$!\u0003,pG\u0006\u0014wk\u001c:e\u0003%1xnY1c?\u0012*\u0017\u000fF\u0002a\u0003kC\u0001\u0002Z\u0018\u0002\u0002\u0003\u0007\u0011QU\u0001\u0007m>\u001c\u0017M\u0019\u0011)\u0007A\nY\fE\u0002H\u0003{K1!a0I\u0005%!(/\u00198tS\u0016tG/A\u0005w_\u000e\f'\rS1tQV\u0011\u0011Q\u0019\t\b\u0003\u000f\f\t.!6\\\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001fD\u0015AC2pY2,7\r^5p]&!\u00111[Ae\u0005\u001dA\u0015m\u001d5NCB\u0004B!a6\u0002f:!\u0011\u0011\\Aq!\r\tY\u000eS\u0007\u0003\u0003;T1!a8E\u0003\u0019a$o\\8u}%\u0019\u00111\u001d%\u0002\rA\u0013X\rZ3g\u0013\u0011\t9/!;\u0003\rM#(/\u001b8h\u0015\r\t\u0019\u000fS\u0001\u000bm>\u001c\u0017M\u0019%bg\"\u0004\u0003f\u0001\u001a\u0002<\u0006QA.Z1s]Z{7-\u00192\u0016\t\u0005M(\u0011\u0002\u000b\u0004A\u0006U\bbBA|g\u0001\u0007\u0011\u0011`\u0001\bI\u0006$\u0018m]3u!\u0019\tYP!\u0001\u0003\u00065\u0011\u0011Q \u0006\u0004\u0003\u007ft\u0014a\u0001:eI&!!1AA\u007f\u0005\r\u0011F\t\u0012\t\u0005\u0005\u000f\u0011I\u0001\u0004\u0001\u0005\u000f\t-1G1\u0001\u0003\u000e\t\t1+\u0005\u0003\u0003\u0010\tU\u0001cA$\u0003\u0012%\u0019!1\u0003%\u0003\u000f9{G\u000f[5oOB1!q\u0003B\u0011\u0003+tAA!\u0007\u0003\u001e9!\u00111\u001cB\u000e\u0013\u0005I\u0015b\u0001B\u0010\u0011\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0012\u0005K\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0005?A\u0015AD2sK\u0006$X-\u0012=q)\u0006\u0014G.\u001a\u000b\u0003\u0005W\u0001RaRAT\u0005[\u00012a\u0012B\u0018\u0013\r\u0011\t\u0004\u0013\u0002\u0006\r2|\u0017\r^\u0001\u0011GJ,\u0017\r^3CS:\f'/\u001f+sK\u0016$\u0012\u0001Y\u0001\u0004M&$X\u0003\u0002B\u001e\u0005\u0013\"BA!\u0010\u0003DA\u0019\u0001La\u0010\n\u0007\t\u0005#HA\u0007X_J$'GV3d\u001b>$W\r\u001c\u0005\b\u0003o4\u0004\u0019\u0001B#!\u0019\tYP!\u0001\u0003HA!!q\u0001B%\t\u001d\u0011YA\u000eb\u0001\u0005\u001bASANA\u0012\u0003w\tQ\u0001Z8GSR,BA!\u0015\u0003ZQa!Q\bB*\u00057\u00129Ga\u001e\u0003~!9\u0011q_\u001cA\u0002\tU\u0003CBA~\u0005\u0003\u00119\u0006\u0005\u0003\u0003\b\teCa\u0002B\u0006o\t\u0007!Q\u0002\u0005\b\u0005;:\u0004\u0019\u0001B0\u0003\t\u00198\r\u0005\u0003\u0003b\t\rT\"\u0001 \n\u0007\t\u0015dH\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0004\u0003j]\u0002\rAa\u001b\u0002\u0011\u0015D\b\u000fV1cY\u0016\u0004bA!\u001c\u0003t\t-RB\u0001B8\u0015\r\u0011\tHP\u0001\nEJ|\u0017\rZ2bgRLAA!\u001e\u0003p\tI!I]8bI\u000e\f7\u000f\u001e\u0005\b\u0005s:\u0004\u0019\u0001B>\u0003\u001d\u00117MV8dC\n\u0004bA!\u001c\u0003t\u0005\u0015\u0006b\u0002B@o\u0001\u0007!\u0011Q\u0001\fE\u000e4vnY1c\u0011\u0006\u001c\b\u000e\u0005\u0004\u0003n\tM\u0014QY\u000b\u0005\u0005\u000b\u0013Y\n\u0006\u0003\u0003>\t\u001d\u0005bBA|q\u0001\u0007!\u0011\u0012\t\u0007\u0005\u0017\u0013)J!'\u000e\u0005\t5%\u0002\u0002BH\u0005#\u000bAA[1wC*\u0019!1\u0013 \u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003\u0018\n5%a\u0002&bm\u0006\u0014F\t\u0012\t\u0005\u0005\u000f\u0011Y\nB\u0004\u0003\fa\u0012\rA!(\u0012\t\t=!q\u0014\t\u0007\u0005C\u0013I+!6\u000e\u0005\t\r&\u0002\u0002BS\u0005O\u000bA\u0001\\1oO*\u0011!qR\u0005\u0005\u0005G\u0011\u0019\u000bK\u00039\u0003G\tY\u0004K\u0003\u0001\u0003G\tY\u0004")
public class Word2Vec
implements scala.Serializable,
Logging {
    private int vectorSize;
    private double learningRate;
    private int numPartitions;
    private int numIterations;
    private long seed;
    private int minCount;
    private int maxSentenceLength;
    private final int EXP_TABLE_SIZE;
    private final int MAX_EXP;
    private final int MAX_CODE_LENGTH;
    private int window;
    private long trainWordsCount;
    private int vocabSize;
    private transient VocabWord[] vocab;
    private final transient HashMap<String, Object> vocabHash;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int vectorSize() {
        return this.vectorSize;
    }

    private void vectorSize_$eq(int x$1) {
        this.vectorSize = x$1;
    }

    private double learningRate() {
        return this.learningRate;
    }

    private void learningRate_$eq(double x$1) {
        this.learningRate = x$1;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(int x$1) {
        this.numPartitions = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int minCount() {
        return this.minCount;
    }

    private void minCount_$eq(int x$1) {
        this.minCount = x$1;
    }

    private int maxSentenceLength() {
        return this.maxSentenceLength;
    }

    private void maxSentenceLength_$eq(int x$1) {
        this.maxSentenceLength = x$1;
    }

    public Word2Vec setMaxSentenceLength(int maxSentenceLength) {
        Predef$.MODULE$.require(maxSentenceLength > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Maximum length of sentences must be positive but got ").append(maxSentenceLength).toString());
        this.maxSentenceLength_$eq(maxSentenceLength);
        return this;
    }

    public Word2Vec setVectorSize(int vectorSize) {
        Predef$.MODULE$.require(vectorSize > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("vector size must be positive but got ").append(vectorSize).toString());
        this.vectorSize_$eq(vectorSize);
        return this;
    }

    public Word2Vec setLearningRate(double learningRate) {
        Predef$.MODULE$.require(learningRate > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Initial learning rate must be positive but got ").append(learningRate).toString());
        this.learningRate_$eq(learningRate);
        return this;
    }

    public Word2Vec setNumPartitions(int numPartitions) {
        Predef$.MODULE$.require(numPartitions > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Number of partitions must be positive but got ").append(numPartitions).toString());
        this.numPartitions_$eq(numPartitions);
        return this;
    }

    public Word2Vec setNumIterations(int numIterations) {
        Predef$.MODULE$.require(numIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Number of iterations must be nonnegative but got ").append(numIterations).toString());
        this.numIterations_$eq(numIterations);
        return this;
    }

    public Word2Vec setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public Word2Vec setWindowSize(int window) {
        Predef$.MODULE$.require(window > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Window of words must be positive but got ").append(window).toString());
        this.window_$eq(window);
        return this;
    }

    public Word2Vec setMinCount(int minCount) {
        Predef$.MODULE$.require(minCount >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Minimum number of times must be nonnegative but got ").append(minCount).toString());
        this.minCount_$eq(minCount);
        return this;
    }

    private int EXP_TABLE_SIZE() {
        return this.EXP_TABLE_SIZE;
    }

    private int MAX_EXP() {
        return this.MAX_EXP;
    }

    private int MAX_CODE_LENGTH() {
        return this.MAX_CODE_LENGTH;
    }

    private int window() {
        return this.window;
    }

    private void window_$eq(int x$1) {
        this.window = x$1;
    }

    private long trainWordsCount() {
        return this.trainWordsCount;
    }

    private void trainWordsCount_$eq(long x$1) {
        this.trainWordsCount = x$1;
    }

    private int vocabSize() {
        return this.vocabSize;
    }

    private void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    private VocabWord[] vocab() {
        return this.vocab;
    }

    private void vocab_$eq(VocabWord[] x$1) {
        this.vocab = x$1;
    }

    private HashMap<String, Object> vocabHash() {
        return this.vocabHash;
    }

    private <S extends Iterable<String>> void learnVocab(RDD<S> dataset) {
        RDD words = dataset.flatMap((Function1 & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.apply(String.class));
        this.vocab_$eq((VocabWord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(words.map((Function1 & Serializable & scala.Serializable)w -> new Tuple2(w, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Word2Vec.$anonfun$learnVocab$4(this, x$3))).map((Function1 & Serializable & scala.Serializable)x -> new VocabWord((String)x._1(), x._2$mcI$sp(), new int[this.MAX_CODE_LENGTH()], new int[this.MAX_CODE_LENGTH()], 0), ClassTag$.MODULE$.apply(VocabWord.class)).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.cn()), package$.MODULE$.Ordering().apply((Ordering)Ordering.Long$.MODULE$).reverse()));
        this.vocabSize_$eq(this.vocab().length);
        Predef$.MODULE$.require(this.vocabSize() > 0, (Function0 & Serializable & scala.Serializable)() -> "The vocabulary size should be > 0. You may need to check the setting of minCount, which could be large enough to remove all your words in sentences.");
        for (int a = 0; a < this.vocabSize(); ++a) {
            this.vocabHash().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.vocab()[a].word()), (Object)BoxesRunTime.boxToInteger((int)a)));
            this.trainWordsCount_$eq(this.trainWordsCount() + this.vocab()[a].cn());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("vocabSize = ").append(this.vocabSize()).append(", trainWordsCount = ").append(this.trainWordsCount()).toString());
    }

    private float[] createExpTable() {
        float[] expTable = new float[this.EXP_TABLE_SIZE()];
        for (int i = 0; i < this.EXP_TABLE_SIZE(); ++i) {
            double tmp = scala.math.package$.MODULE$.exp((2.0 * (double)i / (double)this.EXP_TABLE_SIZE() - 1.0) * (double)this.MAX_EXP());
            expTable[i] = (float)(tmp / (tmp + 1.0));
        }
        return expTable;
    }

    private void createBinaryTree() {
        int a;
        long[] count = new long[this.vocabSize() * 2 + 1];
        int[] binary = new int[this.vocabSize() * 2 + 1];
        int[] parentNode = new int[this.vocabSize() * 2 + 1];
        int[] code = new int[this.MAX_CODE_LENGTH()];
        int[] point = new int[this.MAX_CODE_LENGTH()];
        for (a = 0; a < this.vocabSize(); ++a) {
            count[a] = this.vocab()[a].cn();
        }
        while (a < 2 * this.vocabSize()) {
            count[a] = Long.MAX_VALUE;
            ++a;
        }
        int pos1 = this.vocabSize() - 1;
        int pos2 = this.vocabSize();
        int min1i = 0;
        int min2i = 0;
        for (a = 0; a < this.vocabSize() - 1; ++a) {
            min1i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            min2i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            Predef$.MODULE$.assert(count[min1i] < Long.MAX_VALUE);
            Predef$.MODULE$.assert(count[min2i] < Long.MAX_VALUE);
            count[this.vocabSize() + a] = count[min1i] + count[min2i];
            parentNode[min1i] = this.vocabSize() + a;
            parentNode[min2i] = this.vocabSize() + a;
            binary[min2i] = 1;
        }
        int i = 0;
        for (a = 0; a < this.vocabSize(); ++a) {
            int b = a;
            i = 0;
            while (b != this.vocabSize() * 2 - 2) {
                code[i] = binary[b];
                point[i] = b;
                ++i;
                b = parentNode[b];
            }
            this.vocab()[a].codeLen_$eq(i);
            this.vocab()[a].point()[0] = this.vocabSize() - 2;
            for (b = 0; b < i; ++b) {
                this.vocab()[a].code()[i - b - 1] = code[b];
                this.vocab()[a].point()[i - b] = point[b] - this.vocabSize();
            }
        }
    }

    public <S extends Iterable<String>> Word2VecModel fit(RDD<S> dataset) {
        Word2VecModel word2VecModel;
        this.learnVocab(dataset);
        this.createBinaryTree();
        SparkContext sc = dataset.context();
        Broadcast expTable = sc.broadcast((Object)this.createExpTable(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
        Broadcast bcVocab = sc.broadcast((Object)this.vocab(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VocabWord.class)));
        Broadcast bcVocabHash = sc.broadcast(this.vocabHash(), ClassTag$.MODULE$.apply(HashMap.class));
        try {
            word2VecModel = this.doFit(dataset, sc, (Broadcast<float[]>)expTable, (Broadcast<VocabWord[]>)bcVocab, (Broadcast<HashMap<String, Object>>)bcVocabHash);
        }
        finally {
            expTable.destroy();
            bcVocab.destroy();
            bcVocabHash.destroy();
        }
        return word2VecModel;
    }

    private <S extends Iterable<String>> Word2VecModel doFit(RDD<S> dataset, SparkContext sc, Broadcast<float[]> expTable, Broadcast<VocabWord[]> bcVocab, Broadcast<HashMap<String, Object>> bcVocabHash) {
        RDD sentences = dataset.mapPartitions((Function1 & Serializable & scala.Serializable)sentenceIter -> sentenceIter.flatMap((Function1 & Serializable & scala.Serializable)sentence -> {
            HashMap hashMap = (HashMap)bcVocabHash.value();
            Iterable wordIndexes = (Iterable)sentence.flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(hashMap.get(key)), Iterable$.MODULE$.canBuildFrom());
            return wordIndexes.grouped(this.maxSentenceLength()).map((Function1 & Serializable & scala.Serializable)x$5 -> (int[])x$5.toArray(ClassTag$.MODULE$.Int()));
        }), dataset.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        int x$1 = this.numPartitions();
        Ordering x$2 = sentences.repartition$default$2(x$1);
        RDD newSentences = sentences.repartition(x$1, x$2).cache();
        XORShiftRandom initRandom = new XORShiftRandom(this.seed());
        if ((long)this.vocabSize() * (long)this.vectorSize() >= Integer.MAX_VALUE) {
            throw new RuntimeException(new StringBuilder(184).append("Please increase minCount or decrease vectorSize in Word2Vec to avoid an OOM. You are highly recommended to make your vocabSize*vectorSize, which is ").append(this.vocabSize()).append("*").append(this.vectorSize()).append(" for now, less than `Int.MaxValue`.").toString());
        }
        float[] syn0Global = (float[])Array$.MODULE$.fill(this.vocabSize() * this.vectorSize(), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> (initRandom.nextFloat() - 0.5f) / (float)this.vectorSize(), ClassTag$.MODULE$.Float());
        float[] syn1Global = new float[this.vocabSize() * this.vectorSize()];
        long totalWordsCounts = (long)this.numIterations() * this.trainWordsCount() + 1L;
        DoubleRef alpha = DoubleRef.create((double)this.learningRate());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numIterations()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
            Broadcast bcSyn0Global = sc.broadcast((Object)syn0Global, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
            Broadcast bcSyn1Global = sc.broadcast((Object)syn1Global, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
            long numWordsProcessedInPreviousIterations = (long)(k - 1) * this.trainWordsCount();
            RDD partial = newSentences.mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> Word2Vec.$anonfun$doFit$7(this, k, bcSyn0Global, bcSyn1Global, alpha, numWordsProcessedInPreviousIterations, totalWordsCounts, bcVocab, expTable, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), newSentences.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Tuple2[] synAgg = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(partial.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> iter.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    float[] vec = (float[])tuple2._2();
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)new Tuple2((Object)vec, (Object)BoxesRunTime.boxToInteger((int)1)));
                }
                throw new MatchError((Object)tuple2);
            }), partial.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(vc1, vc2) -> {
                BLAS$.MODULE$.nativeBLAS().saxpy(this.vectorSize(), 1.0f, (float[])vc2._1(), 1, (float[])vc1._1(), 1);
                return new Tuple2(vc1._1(), (Object)BoxesRunTime.boxToInteger((int)(vc1._2$mcI$sp() + vc2._2$mcI$sp())));
            }).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        float[] vec = (float[])tuple22._1();
                        int count = tuple22._2$mcI$sp();
                        BLAS$.MODULE$.nativeBLAS().sscal(this.vectorSize(), 1.0f / (float)count, vec, 1);
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)vec);
                    }
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
            for (int i = 0; i < synAgg.length; ++i) {
                int index = synAgg[i]._1$mcI$sp();
                if (index < this.vocabSize()) {
                    Array$.MODULE$.copy(synAgg[i]._2(), 0, (Object)syn0Global, index * this.vectorSize(), this.vectorSize());
                    continue;
                }
                Array$.MODULE$.copy(synAgg[i]._2(), 0, (Object)syn1Global, (index - this.vocabSize()) * this.vectorSize(), this.vectorSize());
            }
            bcSyn0Global.destroy();
            bcSyn1Global.destroy();
        });
        newSentences.unpersist(newSentences.unpersist$default$1());
        String[] wordArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.vocab())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.word(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new Word2VecModel((Map<String, Object>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])wordArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()), syn0Global);
    }

    public <S extends java.lang.Iterable<String>> Word2VecModel fit(JavaRDD<S> dataset) {
        return this.fit(dataset.rdd().map((Function1 & Serializable & scala.Serializable)x$7 -> (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$7).asScala(), ClassTag$.MODULE$.apply(Iterable.class)));
    }

    public static final /* synthetic */ boolean $anonfun$learnVocab$4(Word2Vec $this, Tuple2 x$3) {
        return x$3._2$mcI$sp() >= $this.minCount();
    }

    public static final /* synthetic */ Option $anonfun$doFit$10(Word2Vec $this, int[] syn0Modify$1, float[] syn0Local$1, int index) {
        if (syn0Modify$1[index] > 0) {
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(syn0Local$1)).slice(index * $this.vectorSize(), (index + 1) * $this.vectorSize())));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$doFit$13(Word2Vec $this, int[] syn1Modify$1, float[] syn1Local$1, int index) {
        if (syn1Modify$1[index] > 0) {
            return new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(index + $this.vocabSize())), new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(syn1Local$1)).slice(index * $this.vectorSize(), (index + 1) * $this.vectorSize())));
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ Iterator $anonfun$doFit$7(Word2Vec $this, int k$1, Broadcast bcSyn0Global$1, Broadcast bcSyn1Global$1, DoubleRef alpha$1, long numWordsProcessedInPreviousIterations$1, long totalWordsCounts$1, Broadcast bcVocab$1, Broadcast expTable$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int idx = tuple2._1$mcI$sp();
            Iterator iter = (Iterator)tuple2._2();
            XORShiftRandom random = new XORShiftRandom($this.seed() ^ (long)(idx + 1 << 16) ^ (long)(-k$1 - 1 << 8));
            int[] syn0Modify = new int[$this.vocabSize()];
            int[] syn1Modify = new int[$this.vocabSize()];
            Tuple4 model = (Tuple4)iter.foldLeft((Object)new Tuple4(bcSyn0Global$1.value(), bcSyn1Global$1.value(), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (tuple2 != null) {
                    Tuple4 tuple4 = (Tuple4)tuple2._1();
                    int[] sentence = (int[])tuple2._2();
                    if (tuple4 != null) {
                        float[] syn0 = (float[])tuple4._1();
                        float[] syn1 = (float[])tuple4._2();
                        long lastWordCount = BoxesRunTime.unboxToLong((Object)tuple4._3());
                        long wordCount = BoxesRunTime.unboxToLong((Object)tuple4._4());
                        long lwc = lastWordCount;
                        long wc = wordCount;
                        if (wordCount - lastWordCount > 10000L) {
                            lwc = wordCount;
                            alpha$1.elem = $this.learningRate() * (1.0 - ((double)$this.numPartitions() * (double)wordCount + (double)numWordsProcessedInPreviousIterations$1) / (double)totalWordsCounts$1);
                            if (alpha$1.elem < $this.learningRate() * 1.0E-4) {
                                alpha$1.elem = $this.learningRate() * 1.0E-4;
                            }
                            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("wordCount = ").append(wordCount + numWordsProcessedInPreviousIterations$1).append(", ").append("alpha = ").append(alpha$1.elem).toString());
                        }
                        wc += (long)sentence.length;
                        for (int pos = 0; pos < sentence.length; ++pos) {
                            int b;
                            int word = sentence[pos];
                            for (int a = b = random.nextInt($this.window()); a < $this.window() * 2 + 1 - b; ++a) {
                                int c;
                                if (a == $this.window() || (c = pos - $this.window() + a) < 0 || c >= sentence.length) continue;
                                int lastWord = sentence[c];
                                int l1 = lastWord * $this.vectorSize();
                                float[] neu1e = new float[$this.vectorSize()];
                                for (int d = 0; d < ((VocabWord[])bcVocab$1.value())[word].codeLen(); ++d) {
                                    int inner = ((VocabWord[])bcVocab$1.value())[word].point()[d];
                                    int l2 = inner * $this.vectorSize();
                                    float f = BLAS$.MODULE$.nativeBLAS().sdot($this.vectorSize(), syn0, l1, 1, syn1, l2, 1);
                                    if (!(f > (float)(-$this.MAX_EXP())) || !(f < (float)$this.MAX_EXP())) continue;
                                    int ind = (int)((double)(f + (float)$this.MAX_EXP()) * ((double)($this.EXP_TABLE_SIZE() / $this.MAX_EXP()) / 2.0));
                                    f = ((float[])expTable$1.value())[ind];
                                    float g = (float)((double)((float)(1 - ((VocabWord[])bcVocab$1.value())[word].code()[d]) - f) * alpha$1.elem);
                                    BLAS$.MODULE$.nativeBLAS().saxpy($this.vectorSize(), g, syn1, l2, 1, neu1e, 0, 1);
                                    BLAS$.MODULE$.nativeBLAS().saxpy($this.vectorSize(), g, syn0, l1, 1, syn1, l2, 1);
                                    syn1Modify$1[inner] = syn1Modify[inner] + 1;
                                }
                                BLAS$.MODULE$.nativeBLAS().saxpy($this.vectorSize(), 1.0f, neu1e, 0, 1, syn0, l1, 1);
                                syn0Modify$1[lastWord] = syn0Modify[lastWord] + 1;
                            }
                        }
                        return new Tuple4((Object)syn0, (Object)syn1, (Object)BoxesRunTime.boxToLong((long)lwc), (Object)BoxesRunTime.boxToLong((long)wc));
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            float[] syn0Local = (float[])model._1();
            float[] syn1Local = (float[])model._2();
            return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)package$.MODULE$.Iterator().tabulate($this.vocabSize(), (Function1 & Serializable & scala.Serializable)index -> Word2Vec.$anonfun$doFit$10($this, syn0Modify, syn0Local, BoxesRunTime.unboxToInt((Object)index))), (Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)).flatten().$plus$plus((Function0 & Serializable & scala.Serializable)() -> TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)package$.MODULE$.Iterator().tabulate($this.vocabSize(), (Function1 & Serializable & scala.Serializable)index -> Word2Vec.$anonfun$doFit$13($this, syn1Modify, syn1Local, BoxesRunTime.unboxToInt((Object)index))), (Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)).flatten());
        }
        throw new MatchError((Object)tuple2);
    }

    public Word2Vec() {
        Logging.$init$((Logging)this);
        this.vectorSize = 100;
        this.learningRate = 0.025;
        this.numPartitions = 1;
        this.numIterations = 1;
        this.seed = Utils$.MODULE$.random().nextLong();
        this.minCount = 5;
        this.maxSentenceLength = 1000;
        this.EXP_TABLE_SIZE = 1000;
        this.MAX_EXP = 6;
        this.MAX_CODE_LENGTH = 40;
        this.window = 5;
        this.trainWordsCount = 0L;
        this.vocabSize = 0;
        this.vocab = null;
        this.vocabHash = HashMap$.MODULE$.empty();
    }
}

