/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.UnresolvedAttribute$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class MetadataUtils$ {
    public static MetadataUtils$ MODULE$;

    static {
        new MetadataUtils$();
    }

    public Option<Object> getNumClasses(StructField labelSchema) {
        Attribute attribute = Attribute$.MODULE$.fromStructField(labelSchema);
        if (attribute instanceof BinaryAttribute) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)2));
        }
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            return nominalAttribute.getNumValues();
        }
        if (attribute instanceof NumericAttribute ? true : UnresolvedAttribute$.MODULE$.equals(attribute)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)attribute);
    }

    public int getNumFeatures(Dataset<?> dataset, String vectorCol) {
        return BoxesRunTime.unboxToInt((Object)this.getNumFeatures(dataset.schema().apply(vectorCol)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((Vector)((Row)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, vectorCol)})).head()).getAs(0)).size()));
    }

    public Option<Object> getNumFeatures(StructField vectorSchema) {
        DataType dataType = vectorSchema.dataType();
        VectorUDT vectorUDT = new VectorUDT();
        if (!(dataType != null ? !dataType.equals((Object)vectorUDT) : vectorUDT != null)) {
            AttributeGroup group = AttributeGroup$.MODULE$.fromStructField(vectorSchema);
            int size = group.size();
            if (size >= 0) {
                return new Some((Object)BoxesRunTime.boxToInteger((int)size));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public Map<Object, Object> getCategoricalFeatures(StructField featuresSchema) {
        AttributeGroup metadata = AttributeGroup$.MODULE$.fromStructField(featuresSchema);
        if (metadata.attributes().isEmpty()) {
            return HashMap$.MODULE$.empty();
        }
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadata.attributes().get())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (attr == null) {
                    return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                }
                Attribute attribute = attr;
                if (attribute instanceof NumericAttribute ? true : UnresolvedAttribute$.MODULE$.equals(attribute)) {
                    return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                }
                if (attribute instanceof BinaryAttribute) {
                    return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)idx)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                }
                if (attribute instanceof NominalAttribute) {
                    NominalAttribute nominalAttribute = (NominalAttribute)attribute;
                    Option<Object> option = nominalAttribute.getNumValues();
                    if (option instanceof Some) {
                        int numValues;
                        Some some = (Some)option;
                        int n = numValues = BoxesRunTime.unboxToInt((Object)some.value());
                        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)idx)), (Object)BoxesRunTime.boxToInteger((int)n))}));
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalArgumentException(new StringBuilder(97).append("Feature ").append(idx).append(" is marked as").append(" Nominal (categorical), but it does not have the number of values specified.").toString());
                    }
                    throw new MatchError(option);
                }
                throw new MatchError((Object)attribute);
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public int[] getFeatureIndicesFromNames(StructField col, String[] names) {
        Predef$.MODULE$.require(col.dataType() instanceof VectorUDT, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("getFeatureIndicesFromNames expected column ").append(col).append(" to be Vector type, but it was type ").append(col.dataType()).append(" instead.").toString());
        AttributeGroup inputAttr = AttributeGroup$.MODULE$.fromStructField(col);
        return (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).map((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToInteger((int)MetadataUtils$.$anonfun$getFeatureIndicesFromNames$2(inputAttr, col, name)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    public static final /* synthetic */ int $anonfun$getFeatureIndicesFromNames$2(AttributeGroup inputAttr$1, StructField col$1, String name) {
        Predef$.MODULE$.require(inputAttr$1.hasAttr(name), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("getFeatureIndicesFromNames found no feature with name ").append(name).append(" in column ").append(col$1).append(".").toString());
        return BoxesRunTime.unboxToInt((Object)inputAttr$1.getAttr(name).index().get());
    }

    private MetadataUtils$() {
        MODULE$ = this;
    }
}

