/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.loss;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.operators.OpAdd$;
import breeze.linalg.operators.OpAnd$;
import breeze.linalg.operators.OpDiv$;
import breeze.linalg.operators.OpEq$;
import breeze.linalg.operators.OpGT$;
import breeze.linalg.operators.OpGTE$;
import breeze.linalg.operators.OpLT$;
import breeze.linalg.operators.OpLTE$;
import breeze.linalg.operators.OpMod$;
import breeze.linalg.operators.OpMulInner$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.operators.OpMulScalar$;
import breeze.linalg.operators.OpNe$;
import breeze.linalg.operators.OpNeg$;
import breeze.linalg.operators.OpNot$;
import breeze.linalg.operators.OpOr$;
import breeze.linalg.operators.OpPow$;
import breeze.linalg.operators.OpSolveMatrixBy$;
import breeze.linalg.operators.OpSub$;
import breeze.linalg.operators.OpXor$;
import breeze.linalg.support.CanCopy;
import breeze.linalg.support.CanSlice;
import breeze.linalg.support.CanSlice2;
import breeze.linalg.support.CanTranspose;
import breeze.optimize.DiffFunction;
import breeze.optimize.StochasticDiffFunction;
import breeze.util.Isomorphism;
import java.io.Serializable;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.loss.DifferentiableRegularization;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0001!3Qa\u0002\u0005\u0001\u0019QA\u0001\"\n\u0001\u0003\u0006\u0004%\te\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Q!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015\t\u0005\u0001\"\u0011C\u0005Aa%GU3hk2\f'/\u001b>bi&|gN\u0003\u0002\n\u0015\u0005!An\\:t\u0015\tYA\"A\u0003paRLWN\u0003\u0002\u000e\u001d\u0005\u0011Q\u000e\u001c\u0006\u0003\u001fA\tQa\u001d9be.T!!\u0005\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0012aA8sON\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\raRdH\u0007\u0002\u0011%\u0011a\u0004\u0003\u0002\u001d\t&4g-\u001a:f]RL\u0017M\u00197f%\u0016<W\u000f\\1sSj\fG/[8o!\t\u00013%D\u0001\"\u0015\t\u0011C\"\u0001\u0004mS:\fGnZ\u0005\u0003I\u0005\u0012aAV3di>\u0014\u0018\u0001\u0003:fOB\u000b'/Y7\u0004\u0001U\t\u0001\u0006\u0005\u0002\u0017S%\u0011!f\u0006\u0002\u0007\t>,(\r\\3\u0002\u0013I,w\rU1sC6\u0004\u0013aC:i_VdG-\u00119qYf\u0004BA\u0006\u00181g%\u0011qf\u0006\u0002\n\rVt7\r^5p]F\u0002\"AF\u0019\n\u0005I:\"aA%oiB\u0011a\u0003N\u0005\u0003k]\u0011qAQ8pY\u0016\fg.\u0001\tbaBd\u0017PR3biV\u0014Xm]*uIB\u0019a\u0003\u000f\u001e\n\u0005e:\"AB(qi&|g\u000e\u0005\u0003\u0017]AB\u0013A\u0002\u001fj]&$h\b\u0006\u0003>}}\u0002\u0005C\u0001\u000f\u0001\u0011\u0015)S\u00011\u0001)\u0011\u0015aS\u00011\u0001.\u0011\u00151T\u00011\u00018\u0003%\u0019\u0017\r\\2vY\u0006$X\r\u0006\u0002D\rB!a\u0003\u0012\u0015 \u0013\t)uC\u0001\u0004UkBdWM\r\u0005\u0006\u000f\u001a\u0001\raH\u0001\rG>,gMZ5dS\u0016tGo\u001d")
public class L2Regularization
implements DifferentiableRegularization<Vector> {
    private final double regParam;
    private final Function1<Object, Object> shouldApply;
    private final Option<Function1<Object, Object>> applyFeaturesStd;

    public DiffFunction<Vector> repr() {
        return DiffFunction.repr$((DiffFunction)this);
    }

    public DiffFunction<Vector> cached(CanCopy<Vector> copy) {
        return DiffFunction.cached$((DiffFunction)this, copy);
    }

    public <U> DiffFunction<U> throughLens(Isomorphism<Vector, U> l) {
        return DiffFunction.throughLens$((DiffFunction)this, l);
    }

    public Object gradientAt(Object x) {
        return StochasticDiffFunction.gradientAt$((StochasticDiffFunction)this, (Object)x);
    }

    public double valueAt(Object x) {
        return StochasticDiffFunction.valueAt$((StochasticDiffFunction)this, (Object)x);
    }

    public final double apply(Object x) {
        return StochasticDiffFunction.apply$((StochasticDiffFunction)this, (Object)x);
    }

    public final <TT, B, C, That> That $plus(B b, UFunc.UImpl2<OpAdd$, TT, B, That> op) {
        return (That)NumericOps.$plus$((NumericOps)this, b, op);
    }

    public final Object $colon$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$colon$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $colon$plus$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$colon$plus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $colon$times$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$colon$times$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $plus$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$plus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $times$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$times$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $colon$minus$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$colon$minus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $colon$percent$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$colon$percent$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $percent$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$percent$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $minus$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$minus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $colon$div$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$colon$div$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $colon$up$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$colon$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $div$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$div$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final <TT, B, That> That $less$colon$less(B b, UFunc.UImpl2<OpLT$, TT, B, That> op) {
        return (That)NumericOps.$less$colon$less$((NumericOps)this, b, op);
    }

    public final <TT, B, That> That $less$colon$eq(B b, UFunc.UImpl2<OpLTE$, TT, B, That> op) {
        return (That)NumericOps.$less$colon$eq$((NumericOps)this, b, op);
    }

    public final <TT, B, That> That $greater$colon$greater(B b, UFunc.UImpl2<OpGT$, TT, B, That> op) {
        return (That)NumericOps.$greater$colon$greater$((NumericOps)this, b, op);
    }

    public final <TT, B, That> That $greater$colon$eq(B b, UFunc.UImpl2<OpGTE$, TT, B, That> op) {
        return (That)NumericOps.$greater$colon$eq$((NumericOps)this, b, op);
    }

    public final Object $colon$amp$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$colon$amp$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $colon$bar$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$colon$bar$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $colon$up$up$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$colon$up$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $amp$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$amp$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $bar$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$bar$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final Object $up$up$eq(Object b, UFunc.InPlaceImpl2 op) {
        return NumericOps.$up$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
    }

    public final <TT, B, That> That $plus$colon$plus(B b, UFunc.UImpl2<OpAdd$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$plus$colon$plus$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $times$colon$times(B b, UFunc.UImpl2<OpMulScalar$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$times$colon$times$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $colon$eq$eq(B b, UFunc.UImpl2<OpEq$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$colon$eq$eq$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $colon$bang$eq(B b, UFunc.UImpl2<OpNe$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$colon$bang$eq$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, That> That unary_$minus(UFunc.UImpl<OpNeg$, TT, That> op) {
        return (That)ImmutableNumericOps.unary_$minus$((ImmutableNumericOps)this, op);
    }

    public final <TT, B, That> That $minus$colon$minus(B b, UFunc.UImpl2<OpSub$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$minus$colon$minus$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $minus(B b, UFunc.UImpl2<OpSub$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$minus$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $percent$colon$percent(B b, UFunc.UImpl2<OpMod$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$percent$colon$percent$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $percent(B b, UFunc.UImpl2<OpMod$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$percent$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $div$colon$div(B b, UFunc.UImpl2<OpDiv$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$div$colon$div$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $div(B b, UFunc.UImpl2<OpDiv$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$div$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $up$colon$up(B b, UFunc.UImpl2<OpPow$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$up$colon$up$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, BB, That> That dot(B b, UFunc.UImpl2<OpMulInner$, TT, BB, That> op) {
        return (That)ImmutableNumericOps.dot$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, That> That unary_$bang(UFunc.UImpl<OpNot$, TT, That> op) {
        return (That)ImmutableNumericOps.unary_$bang$((ImmutableNumericOps)this, op);
    }

    public final <TT, B, That> That $amp$colon$amp(B b, UFunc.UImpl2<OpAnd$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$amp$colon$amp$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $bar$colon$bar(B b, UFunc.UImpl2<OpOr$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$bar$colon$bar$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $up$up$colon$up$up(B b, UFunc.UImpl2<OpXor$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$up$up$colon$up$up$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $amp(B b, UFunc.UImpl2<OpAnd$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$amp$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $bar(B b, UFunc.UImpl2<OpOr$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$bar$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $up$up(B b, UFunc.UImpl2<OpXor$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$up$up$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, B, That> That $times(B b, UFunc.UImpl2<OpMulMatrix$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$times$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, That> That t(CanTranspose<TT, That> op) {
        return (That)ImmutableNumericOps.t$((ImmutableNumericOps)this, op);
    }

    public <TT, B, That> That $bslash(B b, UFunc.UImpl2<OpSolveMatrixBy$, TT, B, That> op) {
        return (That)ImmutableNumericOps.$bslash$((ImmutableNumericOps)this, b, op);
    }

    public final <TT, That, Slice1, Slice2, Result> Result t(Slice1 a, Slice2 b, CanTranspose<TT, That> op, CanSlice2<That, Slice1, Slice2, Result> canSlice) {
        return (Result)ImmutableNumericOps.t$((ImmutableNumericOps)this, a, b, op, canSlice);
    }

    public final <TT, That, Slice1, Result> Result t(Slice1 a, CanTranspose<TT, That> op, CanSlice<That, Slice1, Result> canSlice) {
        return (Result)ImmutableNumericOps.t$((ImmutableNumericOps)this, a, op, canSlice);
    }

    public boolean apply$mcZD$sp(double v1) {
        return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
    }

    public double apply$mcDD$sp(double v1) {
        return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
    }

    public float apply$mcFD$sp(double v1) {
        return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
    }

    public int apply$mcID$sp(double v1) {
        return Function1.apply$mcID$sp$((Function1)this, (double)v1);
    }

    public long apply$mcJD$sp(double v1) {
        return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
    }

    public void apply$mcVD$sp(double v1) {
        Function1.apply$mcVD$sp$((Function1)this, (double)v1);
    }

    public boolean apply$mcZF$sp(float v1) {
        return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
    }

    public double apply$mcDF$sp(float v1) {
        return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
    }

    public float apply$mcFF$sp(float v1) {
        return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
    }

    public int apply$mcIF$sp(float v1) {
        return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
    }

    public long apply$mcJF$sp(float v1) {
        return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
    }

    public void apply$mcVF$sp(float v1) {
        Function1.apply$mcVF$sp$((Function1)this, (float)v1);
    }

    public boolean apply$mcZI$sp(int v1) {
        return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
    }

    public double apply$mcDI$sp(int v1) {
        return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
    }

    public float apply$mcFI$sp(int v1) {
        return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
    }

    public int apply$mcII$sp(int v1) {
        return Function1.apply$mcII$sp$((Function1)this, (int)v1);
    }

    public long apply$mcJI$sp(int v1) {
        return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
    }

    public void apply$mcVI$sp(int v1) {
        Function1.apply$mcVI$sp$((Function1)this, (int)v1);
    }

    public boolean apply$mcZJ$sp(long v1) {
        return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
    }

    public double apply$mcDJ$sp(long v1) {
        return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
    }

    public float apply$mcFJ$sp(long v1) {
        return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
    }

    public int apply$mcIJ$sp(long v1) {
        return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
    }

    public long apply$mcJJ$sp(long v1) {
        return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
    }

    public void apply$mcVJ$sp(long v1) {
        Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
    }

    public <A> Function1<A, Object> compose(Function1<A, Vector> g) {
        return Function1.compose$((Function1)this, g);
    }

    public <A> Function1<Vector, A> andThen(Function1<Object, A> g) {
        return Function1.andThen$((Function1)this, g);
    }

    public String toString() {
        return Function1.toString$((Function1)this);
    }

    @Override
    public double regParam() {
        return this.regParam;
    }

    public Tuple2<Object, Vector> calculate(Vector coefficients) {
        Vector vector = coefficients;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            DoubleRef sum = DoubleRef.create((double)0.0);
            double[] gradient = new double[denseVector.size()];
            ((IterableLike)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(denseVector.values())).indices().filter(this.shouldApply)).foreach((Function1 & Serializable & scala.Serializable)j -> L2Regularization.$anonfun$calculate$1(this, coefficients, sum, gradient, BoxesRunTime.unboxToInt((Object)j)));
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)(0.5 * sum.elem * this.regParam())), (Object)Vectors$.MODULE$.dense(gradient));
        }
        if (vector instanceof SparseVector) {
            throw new IllegalArgumentException("Sparse coefficients are not currently supported.");
        }
        throw new MatchError((Object)vector);
    }

    public static final /* synthetic */ Object $anonfun$calculate$1(L2Regularization $this, Vector coefficients$1, DoubleRef sum$1, double[] gradient$1, int j) {
        double coef = coefficients$1.apply(j);
        Option<Function1<Object, Object>> option = $this.applyFeaturesStd;
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 getStd = (Function1)some.value();
            double std = getStd.apply$mcDI$sp(j);
            if (std != 0.0) {
                double temp = coef / (std * std);
                sum$1.elem += coef * temp;
                gradient$1[j] = $this.regParam() * temp;
                return BoxedUnit.UNIT;
            }
            return BoxesRunTime.boxToDouble((double)0.0);
        }
        if (None$.MODULE$.equals(option)) {
            sum$1.elem += coef * coef;
            gradient$1[j] = coef * $this.regParam();
            return BoxedUnit.UNIT;
        }
        throw new MatchError(option);
    }

    public L2Regularization(double regParam, Function1<Object, Object> shouldApply, Option<Function1<Object, Object>> applyFeaturesStd) {
        this.regParam = regParam;
        this.shouldApply = shouldApply;
        this.applyFeaturesStd = applyFeaturesStd;
        Function1.$init$((Function1)this);
        ImmutableNumericOps.$init$((ImmutableNumericOps)this);
        NumericOps.$init$((NumericOps)this);
        StochasticDiffFunction.$init$((StochasticDiffFunction)this);
        DiffFunction.$init$((DiffFunction)this);
    }
}

