/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.operators.OpAdd$;
import breeze.linalg.operators.OpAnd$;
import breeze.linalg.operators.OpDiv$;
import breeze.linalg.operators.OpEq$;
import breeze.linalg.operators.OpGT$;
import breeze.linalg.operators.OpGTE$;
import breeze.linalg.operators.OpLT$;
import breeze.linalg.operators.OpLTE$;
import breeze.linalg.operators.OpMod$;
import breeze.linalg.operators.OpMulInner$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.operators.OpMulScalar$;
import breeze.linalg.operators.OpNe$;
import breeze.linalg.operators.OpNeg$;
import breeze.linalg.operators.OpNot$;
import breeze.linalg.operators.OpOr$;
import breeze.linalg.operators.OpPow$;
import breeze.linalg.operators.OpSolveMatrixBy$;
import breeze.linalg.operators.OpSub$;
import breeze.linalg.operators.OpXor$;
import breeze.linalg.support.CanCopy;
import breeze.linalg.support.CanSlice;
import breeze.linalg.support.CanSlice2;
import breeze.linalg.support.CanTranspose;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import breeze.util.Isomorphism;
import java.io.Serializable;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.NormalEquationSolution;
import org.apache.spark.ml.optim.NormalEquationSolver;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4Qa\u0005\u000b\u0001)yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015!\u0005\u0001\"\u0011F\r\u0011I\u0006\u0001\u0002.\t\u0011);!\u0011!Q\u0001\nMB\u0001\u0002T\u0004\u0003\u0002\u0003\u0006Ia\r\u0005\tO\u001e\u0011\t\u0011)A\u0005\u001f\"A\u0001n\u0002B\u0001B\u0003%q\n\u0003\u0005Y\u000f\t\u0005\t\u0015!\u0003P\u0011!IsA!A!\u0002\u0013Y\u0003\u0002C5\b\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000bu:A\u0011\u00016\t\u000fQ<!\u0019!C\u0005k\"1ao\u0002Q\u0001\n=BQa^\u0004\u0005Ba\u0014\u0011#U;bg&tUm\u001e;p]N{GN^3s\u0015\t)b#A\u0003paRLWN\u0003\u0002\u00181\u0005\u0011Q\u000e\u001c\u0006\u00033i\tQa\u001d9be.T!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sON\u0019\u0001aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0015\u0013\tACC\u0001\u000bO_Jl\u0017\r\\#rk\u0006$\u0018n\u001c8T_24XM]\u0001\rM&$\u0018J\u001c;fe\u000e,\u0007\u000f^\u0002\u0001!\t\u0001C&\u0003\u0002.C\t9!i\\8mK\u0006t\u0017aB7bq&#XM\u001d\t\u0003AAJ!!M\u0011\u0003\u0007%sG/A\u0002u_2\u0004\"\u0001\t\u001b\n\u0005U\n#A\u0002#pk\ndW-A\u0005mcI+wMR;oGB\u0019\u0001\u0005\u000f\u001e\n\u0005e\n#AB(qi&|g\u000e\u0005\u0003!w=\u001a\u0014B\u0001\u001f\"\u0005%1UO\\2uS>t\u0017'\u0001\u0004=S:LGO\u0010\u000b\u0006\u007f\u0001\u000b%i\u0011\t\u0003M\u0001AQ!K\u0003A\u0002-BQAL\u0003A\u0002=BQAM\u0003A\u0002MBQAN\u0003A\u0002]\nQa]8mm\u0016$bAR%L\u001bV;\u0006C\u0001\u0014H\u0013\tAEC\u0001\fO_Jl\u0017\r\\#rk\u0006$\u0018n\u001c8T_2,H/[8o\u0011\u0015Qe\u00011\u00014\u0003\u0011\u0011')\u0019:\t\u000b13\u0001\u0019A\u001a\u0002\u000b\t\u0014')\u0019:\t\u000b93\u0001\u0019A(\u0002\u000b\u0005\u0014')\u0019:\u0011\u0005A\u001bV\"A)\u000b\u0005I3\u0012A\u00027j]\u0006dw-\u0003\u0002U#\nYA)\u001a8tKZ+7\r^8s\u0011\u00151f\u00011\u0001P\u0003\u0015\t\u0017MQ1s\u0011\u0015Af\u00011\u0001P\u0003\u0011\t')\u0019:\u0003+9{'/\\1m\u000bF,\u0018\r^5p]\u000e{7\u000f\u001e$v]N\u0019qaH.\u0011\u0007q\u000b7-D\u0001^\u0015\tqv,\u0001\u0005paRLW.\u001b>f\u0015\u0005\u0001\u0017A\u00022sK\u0016TX-\u0003\u0002c;\naA)\u001b4g\rVt7\r^5p]B\u0019AMZ\u001a\u000e\u0003\u0015T!AU0\n\u0005Q+\u0017AA1c\u0003\t\t\u0017-A\u0006ok64U-\u0019;ve\u0016\u001cH\u0003C6n]>\u0004\u0018O]:\u0011\u00051<Q\"\u0001\u0001\t\u000b){\u0001\u0019A\u001a\t\u000b1{\u0001\u0019A\u001a\t\u000b\u001d|\u0001\u0019A(\t\u000b!|\u0001\u0019A(\t\u000ba{\u0001\u0019A(\t\u000b%z\u0001\u0019A\u0016\t\u000b%|\u0001\u0019A\u0018\u000219,XNR3biV\u0014Xm\u001d)mkNLe\u000e^3sG\u0016\u0004H/F\u00010\u0003eqW/\u001c$fCR,(/Z:QYV\u001c\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u0011\u0002\u0013\r\fGnY;mCR,GCA=}!\u0011\u0001#pM2\n\u0005m\f#A\u0002+va2,'\u0007C\u0003~%\u0001\u00071-\u0001\u0007d_\u00164g-[2jK:$8\u000f")
public class QuasiNewtonSolver
implements NormalEquationSolver {
    private final boolean fitIntercept;
    private final int maxIter;
    private final double tol;
    private final Option<Function1<Object, Object>> l1RegFunc;

    @Override
    public NormalEquationSolution solve(double bBar, double bbBar, org.apache.spark.ml.linalg.DenseVector abBar, org.apache.spark.ml.linalg.DenseVector aaBar, org.apache.spark.ml.linalg.DenseVector aBar) {
        int numFeatures = aBar.size();
        int numFeaturesPlusIntercept = this.fitIntercept ? numFeatures + 1 : numFeatures;
        double[] initialCoefficientsWithIntercept = new double[numFeaturesPlusIntercept];
        if (this.fitIntercept) {
            initialCoefficientsWithIntercept[numFeaturesPlusIntercept - 1] = bBar;
        }
        NormalEquationCostFun costFun = new NormalEquationCostFun(this, bBar, bbBar, abBar, aaBar, aBar, this.fitIntercept, numFeatures);
        LBFGS optimizer = (LBFGS)this.l1RegFunc.map((Function1 & Serializable & scala.Serializable)func -> new OWLQN($this.maxIter, 10, func, $this.tol, (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new LBFGS($this.maxIter, 10, $this.tol, (MutableInnerProductModule)DenseVector$.MODULE$.space_Double()));
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialCoefficientsWithIntercept));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        double[] x = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
        return new NormalEquationSolution(x, (Option<double[]>)None$.MODULE$, (Option<double[]>)new Some(arrayBuilder.result()));
    }

    public QuasiNewtonSolver(boolean fitIntercept, int maxIter, double tol, Option<Function1<Object, Object>> l1RegFunc) {
        this.fitIntercept = fitIntercept;
        this.maxIter = maxIter;
        this.tol = tol;
        this.l1RegFunc = l1RegFunc;
    }

    private class NormalEquationCostFun
    implements DiffFunction<DenseVector<Object>> {
        private final double bBar;
        private final double bbBar;
        private final org.apache.spark.ml.linalg.DenseVector ab;
        private final org.apache.spark.ml.linalg.DenseVector aa;
        private final org.apache.spark.ml.linalg.DenseVector aBar;
        private final boolean fitIntercept;
        private final int numFeatures;
        private final int numFeaturesPlusIntercept;
        public final /* synthetic */ QuasiNewtonSolver $outer;

        public DiffFunction<DenseVector<Object>> repr() {
            return DiffFunction.repr$((DiffFunction)this);
        }

        public DiffFunction<DenseVector<Object>> cached(CanCopy<DenseVector<Object>> copy) {
            return DiffFunction.cached$((DiffFunction)this, copy);
        }

        public <U> DiffFunction<U> throughLens(Isomorphism<DenseVector<Object>, U> l) {
            return DiffFunction.throughLens$((DiffFunction)this, l);
        }

        public Object gradientAt(Object x) {
            return StochasticDiffFunction.gradientAt$((StochasticDiffFunction)this, (Object)x);
        }

        public double valueAt(Object x) {
            return StochasticDiffFunction.valueAt$((StochasticDiffFunction)this, (Object)x);
        }

        public final double apply(Object x) {
            return StochasticDiffFunction.apply$((StochasticDiffFunction)this, (Object)x);
        }

        public final <TT, B, C, That> That $plus(B b, UFunc.UImpl2<OpAdd$, TT, B, That> op) {
            return (That)NumericOps.$plus$((NumericOps)this, b, op);
        }

        public final Object $colon$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$plus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$plus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$times$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$times$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $plus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$plus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $times$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$times$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$minus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$minus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$percent$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$percent$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $percent$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$percent$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $minus$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$minus$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$div$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$div$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$up$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $div$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$div$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final <TT, B, That> That $less$colon$less(B b, UFunc.UImpl2<OpLT$, TT, B, That> op) {
            return (That)NumericOps.$less$colon$less$((NumericOps)this, b, op);
        }

        public final <TT, B, That> That $less$colon$eq(B b, UFunc.UImpl2<OpLTE$, TT, B, That> op) {
            return (That)NumericOps.$less$colon$eq$((NumericOps)this, b, op);
        }

        public final <TT, B, That> That $greater$colon$greater(B b, UFunc.UImpl2<OpGT$, TT, B, That> op) {
            return (That)NumericOps.$greater$colon$greater$((NumericOps)this, b, op);
        }

        public final <TT, B, That> That $greater$colon$eq(B b, UFunc.UImpl2<OpGTE$, TT, B, That> op) {
            return (That)NumericOps.$greater$colon$eq$((NumericOps)this, b, op);
        }

        public final Object $colon$amp$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$amp$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$bar$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$bar$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $colon$up$up$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$colon$up$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $amp$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$amp$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $bar$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$bar$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final Object $up$up$eq(Object b, UFunc.InPlaceImpl2 op) {
            return NumericOps.$up$up$eq$((NumericOps)this, (Object)b, (UFunc.InPlaceImpl2)op);
        }

        public final <TT, B, That> That $plus$colon$plus(B b, UFunc.UImpl2<OpAdd$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$plus$colon$plus$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $times$colon$times(B b, UFunc.UImpl2<OpMulScalar$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$times$colon$times$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $colon$eq$eq(B b, UFunc.UImpl2<OpEq$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$colon$eq$eq$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $colon$bang$eq(B b, UFunc.UImpl2<OpNe$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$colon$bang$eq$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, That> That unary_$minus(UFunc.UImpl<OpNeg$, TT, That> op) {
            return (That)ImmutableNumericOps.unary_$minus$((ImmutableNumericOps)this, op);
        }

        public final <TT, B, That> That $minus$colon$minus(B b, UFunc.UImpl2<OpSub$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$minus$colon$minus$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $minus(B b, UFunc.UImpl2<OpSub$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$minus$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $percent$colon$percent(B b, UFunc.UImpl2<OpMod$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$percent$colon$percent$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $percent(B b, UFunc.UImpl2<OpMod$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$percent$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $div$colon$div(B b, UFunc.UImpl2<OpDiv$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$div$colon$div$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $div(B b, UFunc.UImpl2<OpDiv$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$div$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $up$colon$up(B b, UFunc.UImpl2<OpPow$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$up$colon$up$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, BB, That> That dot(B b, UFunc.UImpl2<OpMulInner$, TT, BB, That> op) {
            return (That)ImmutableNumericOps.dot$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, That> That unary_$bang(UFunc.UImpl<OpNot$, TT, That> op) {
            return (That)ImmutableNumericOps.unary_$bang$((ImmutableNumericOps)this, op);
        }

        public final <TT, B, That> That $amp$colon$amp(B b, UFunc.UImpl2<OpAnd$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$amp$colon$amp$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $bar$colon$bar(B b, UFunc.UImpl2<OpOr$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$bar$colon$bar$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $up$up$colon$up$up(B b, UFunc.UImpl2<OpXor$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$up$up$colon$up$up$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $amp(B b, UFunc.UImpl2<OpAnd$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$amp$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $bar(B b, UFunc.UImpl2<OpOr$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$bar$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $up$up(B b, UFunc.UImpl2<OpXor$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$up$up$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, B, That> That $times(B b, UFunc.UImpl2<OpMulMatrix$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$times$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, That> That t(CanTranspose<TT, That> op) {
            return (That)ImmutableNumericOps.t$((ImmutableNumericOps)this, op);
        }

        public <TT, B, That> That $bslash(B b, UFunc.UImpl2<OpSolveMatrixBy$, TT, B, That> op) {
            return (That)ImmutableNumericOps.$bslash$((ImmutableNumericOps)this, b, op);
        }

        public final <TT, That, Slice1, Slice2, Result> Result t(Slice1 a, Slice2 b, CanTranspose<TT, That> op, CanSlice2<That, Slice1, Slice2, Result> canSlice) {
            return (Result)ImmutableNumericOps.t$((ImmutableNumericOps)this, a, b, op, canSlice);
        }

        public final <TT, That, Slice1, Result> Result t(Slice1 a, CanTranspose<TT, That> op, CanSlice<That, Slice1, Result> canSlice) {
            return (Result)ImmutableNumericOps.t$((ImmutableNumericOps)this, a, op, canSlice);
        }

        public boolean apply$mcZD$sp(double v1) {
            return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
        }

        public double apply$mcDD$sp(double v1) {
            return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
        }

        public float apply$mcFD$sp(double v1) {
            return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
        }

        public int apply$mcID$sp(double v1) {
            return Function1.apply$mcID$sp$((Function1)this, (double)v1);
        }

        public long apply$mcJD$sp(double v1) {
            return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
        }

        public void apply$mcVD$sp(double v1) {
            Function1.apply$mcVD$sp$((Function1)this, (double)v1);
        }

        public boolean apply$mcZF$sp(float v1) {
            return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
        }

        public double apply$mcDF$sp(float v1) {
            return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
        }

        public float apply$mcFF$sp(float v1) {
            return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
        }

        public int apply$mcIF$sp(float v1) {
            return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
        }

        public long apply$mcJF$sp(float v1) {
            return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
        }

        public void apply$mcVF$sp(float v1) {
            Function1.apply$mcVF$sp$((Function1)this, (float)v1);
        }

        public boolean apply$mcZI$sp(int v1) {
            return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
        }

        public double apply$mcDI$sp(int v1) {
            return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
        }

        public float apply$mcFI$sp(int v1) {
            return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
        }

        public int apply$mcII$sp(int v1) {
            return Function1.apply$mcII$sp$((Function1)this, (int)v1);
        }

        public long apply$mcJI$sp(int v1) {
            return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
        }

        public void apply$mcVI$sp(int v1) {
            Function1.apply$mcVI$sp$((Function1)this, (int)v1);
        }

        public boolean apply$mcZJ$sp(long v1) {
            return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
        }

        public double apply$mcDJ$sp(long v1) {
            return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
        }

        public float apply$mcFJ$sp(long v1) {
            return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
        }

        public int apply$mcIJ$sp(long v1) {
            return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
        }

        public long apply$mcJJ$sp(long v1) {
            return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
        }

        public void apply$mcVJ$sp(long v1) {
            Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
        }

        public <A> Function1<A, Object> compose(Function1<A, DenseVector<Object>> g) {
            return Function1.compose$((Function1)this, g);
        }

        public <A> Function1<DenseVector<Object>, A> andThen(Function1<Object, A> g) {
            return Function1.andThen$((Function1)this, g);
        }

        public String toString() {
            return Function1.toString$((Function1)this);
        }

        private int numFeaturesPlusIntercept() {
            return this.numFeaturesPlusIntercept;
        }

        public Tuple2<Object, DenseVector<Object>> calculate(DenseVector<Object> coefficients) {
            org.apache.spark.ml.linalg.DenseVector coef = Vectors$.MODULE$.fromBreeze(coefficients).toDense();
            if (this.fitIntercept) {
                double dotProd = 0.0;
                double[] coefValues = coef.values();
                double[] aBarValues = this.aBar.values();
                for (int j = 0; j < this.numFeatures; ++j) {
                    dotProd += coefValues[j] * aBarValues[j];
                }
                coefValues[this.numFeatures] = this.bBar - dotProd;
            }
            org.apache.spark.ml.linalg.DenseVector aax = new org.apache.spark.ml.linalg.DenseVector(new double[this.numFeaturesPlusIntercept()]);
            BLAS$.MODULE$.dspmv(this.numFeaturesPlusIntercept(), 1.0, this.aa, coef, 1.0, aax);
            double loss = 0.5 * this.bbBar - BLAS$.MODULE$.dot((Vector)this.ab, (Vector)coef) + 0.5 * BLAS$.MODULE$.dot((Vector)coef, (Vector)aax);
            BLAS$.MODULE$.axpy(-1.0, (Vector)this.ab, (Vector)aax);
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)loss), (Object)aax.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
        }

        public /* synthetic */ QuasiNewtonSolver org$apache$spark$ml$optim$QuasiNewtonSolver$NormalEquationCostFun$$$outer() {
            return this.$outer;
        }

        public NormalEquationCostFun(QuasiNewtonSolver $outer, double bBar, double bbBar, org.apache.spark.ml.linalg.DenseVector ab, org.apache.spark.ml.linalg.DenseVector aa, org.apache.spark.ml.linalg.DenseVector aBar, boolean fitIntercept, int numFeatures) {
            this.bBar = bBar;
            this.bbBar = bbBar;
            this.ab = ab;
            this.aa = aa;
            this.aBar = aBar;
            this.fitIntercept = fitIntercept;
            this.numFeatures = numFeatures;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Function1.$init$((Function1)this);
            ImmutableNumericOps.$init$((ImmutableNumericOps)this);
            NumericOps.$init$((NumericOps)this);
            StochasticDiffFunction.$init$((StochasticDiffFunction)this);
            DiffFunction.$init$((DiffFunction)this);
            this.numFeaturesPlusIntercept = fitIntercept ? numFeatures + 1 : numFeatures;
        }
    }
}

