/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.clustering.KMeans$;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.clustering.KMeansParams;
import org.apache.spark.ml.clustering.KMeansSummary;
import org.apache.spark.ml.functions$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasDistanceMeasure;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\f\u0019\u0001\rB\u0001\"\u000e\u0001\u0003\u0006\u0004%\tE\u000e\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005o!)q\n\u0001C\u0001!\")Q\u000b\u0001C!-\")q\n\u0001C\u0001A\")!\r\u0001C\u0001G\")\u0001\u000e\u0001C\u0001S\")A\u000e\u0001C\u0001[\")A\u000f\u0001C\u0001k\")\u0001\u0010\u0001C\u0001s\")a\u0010\u0001C\u0001\u007f\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002h\u0001!\t%!\u001b\b\u000f\u0005}\u0004\u0004#\u0001\u0002\u0002\u001a1q\u0003\u0007E\u0001\u0003\u0007CaaT\n\u0005\u0002\u0005]\u0005bBAM'\u0011\u0005\u00131\u0014\u0005\n\u0003O\u001b\u0012\u0011!C\u0005\u0003S\u0013aaS'fC:\u001c(BA\r\u001b\u0003)\u0019G.^:uKJLgn\u001a\u0006\u00037q\t!!\u001c7\u000b\u0005uq\u0012!B:qCJ\\'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001I1z\u0003cA\u0013'Q5\t!$\u0003\u0002(5\tIQi\u001d;j[\u0006$xN\u001d\t\u0003S)j\u0011\u0001G\u0005\u0003Wa\u00111bS'fC:\u001cXj\u001c3fYB\u0011\u0011&L\u0005\u0003]a\u0011AbS'fC:\u001c\b+\u0019:b[N\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003iE\u0012Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW-A\u0002vS\u0012,\u0012a\u000e\t\u0003q\u0005s!!O \u0011\u0005ijT\"A\u001e\u000b\u0005q\u0012\u0013A\u0002\u001fs_>$hHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001U(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!>Q\r\tQi\u0013\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011r\t!\"\u00198o_R\fG/[8o\u0013\tQuIA\u0003TS:\u001cW-I\u0001M\u0003\u0015\td&\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t)5*\u0001\u0004=S:LGO\u0010\u000b\u0003#J\u0003\"!\u000b\u0001\t\u000bU\u001a\u0001\u0019A\u001c)\u0007I+5\nK\u0002\u0004\u000b.\u000bAaY8qsR\u0011\u0011k\u0016\u0005\u00061\u0012\u0001\r!W\u0001\u0006Kb$(/\u0019\t\u00035vk\u0011a\u0017\u0006\u00039j\tQ\u0001]1sC6L!AX.\u0003\u0011A\u000b'/Y7NCBD3\u0001B#L)\u0005\t\u0006fA\u0003F\u0017\u0006q1/\u001a;GK\u0006$XO]3t\u0007>dGC\u00013f\u001b\u0005\u0001\u0001\"\u00024\u0007\u0001\u00049\u0014!\u0002<bYV,\u0007f\u0001\u0004F\u0017\u0006\u00012/\u001a;Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0003I*DQAZ\u0004A\u0002]B3aB#L\u0003\u0011\u0019X\r^&\u0015\u0005\u0011t\u0007\"\u00024\t\u0001\u0004y\u0007C\u00019r\u001b\u0005i\u0014B\u0001:>\u0005\rIe\u000e\u001e\u0015\u0004\u0011\u0015[\u0015aC:fi&s\u0017\u000e^'pI\u0016$\"\u0001\u001a<\t\u000b\u0019L\u0001\u0019A\u001c)\u0007%)5*\u0001\ntKR$\u0015n\u001d;b]\u000e,W*Z1tkJ,GC\u00013{\u0011\u00151'\u00021\u00018Q\rQQ\t`\u0011\u0002{\u0006)!G\f\u001b/a\u0005a1/\u001a;J]&$8\u000b^3qgR\u0019A-!\u0001\t\u000b\u0019\\\u0001\u0019A8)\u0007-)5*\u0001\u0006tKRl\u0015\r_%uKJ$2\u0001ZA\u0005\u0011\u00151G\u00021\u0001pQ\raQiS\u0001\u0007g\u0016$Hk\u001c7\u0015\u0007\u0011\f\t\u0002\u0003\u0004g\u001b\u0001\u0007\u00111\u0003\t\u0004a\u0006U\u0011bAA\f{\t1Ai\\;cY\u0016D3!D#L\u0003\u001d\u0019X\r^*fK\u0012$2\u0001ZA\u0010\u0011\u00191g\u00021\u0001\u0002\"A\u0019\u0001/a\t\n\u0007\u0005\u0015RH\u0001\u0003M_:<\u0007f\u0001\bF\u0017\u0006a1/\u001a;XK&<\u0007\u000e^\"pYR\u0019A-!\f\t\u000b\u0019|\u0001\u0019A\u001c)\t=)\u0015\u0011G\u0011\u0003\u0003g\tQa\r\u00181]A\n1AZ5u)\rA\u0013\u0011\b\u0005\b\u0003w\u0001\u0002\u0019AA\u001f\u0003\u001d!\u0017\r^1tKR\u0004D!a\u0010\u0002PA1\u0011\u0011IA$\u0003\u0017j!!a\u0011\u000b\u0007\u0005\u0015C$A\u0002tc2LA!!\u0013\u0002D\t9A)\u0019;bg\u0016$\b\u0003BA'\u0003\u001fb\u0001\u0001\u0002\u0007\u0002R\u0005e\u0012\u0011!A\u0001\u0006\u0003\t\u0019FA\u0002`II\nB!!\u0016\u0002\\A\u0019\u0001/a\u0016\n\u0007\u0005eSHA\u0004O_RD\u0017N\\4\u0011\u0007A\fi&C\u0002\u0002`u\u00121!\u00118zQ\u0011\u0001R)a\u0019\"\u0005\u0005\u0015\u0014!\u0002\u001a/a9\u0002\u0014a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005-\u0014q\u000f\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)!\u0011\u0011OA\"\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t)(a\u001c\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002zE\u0001\r!a\u001b\u0002\rM\u001c\u0007.Z7bQ\r\tRi\u0013\u0015\u0004\u0001\u0015[\u0015AB&NK\u0006t7\u000f\u0005\u0002*'M91#!\"\u0002\f\u0006E\u0005c\u00019\u0002\b&\u0019\u0011\u0011R\u001f\u0003\r\u0005s\u0017PU3g!\u0011\u0001\u0014QR)\n\u0007\u0005=\u0015GA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn\u001d*fC\u0012\f'\r\\3\u0011\u0007A\f\u0019*C\u0002\u0002\u0016v\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\"!!!\u0002\t1|\u0017\r\u001a\u000b\u0004#\u0006u\u0005BBAP+\u0001\u0007q'\u0001\u0003qCRD\u0007\u0006B\u000bF\u0003G\u000b#!!*\u0002\u000bErcG\f\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003W\u0003B!!,\u000286\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b\u0019,\u0001\u0003mC:<'BAA[\u0003\u0011Q\u0017M^1\n\t\u0005e\u0016q\u0016\u0002\u0007\u001f\nTWm\u0019;)\tM)\u00151\u0015\u0015\u0005%\u0015\u000b\u0019\u000b")
public class KMeans
extends Estimator<KMeansModel>
implements KMeansParams,
DefaultParamsWritable {
    private final String uid;
    private final IntParam k;
    private final Param<String> initMode;
    private final IntParam initSteps;
    private final Param<String> weightCol;
    private final Param<String> distanceMeasure;
    private final DoubleParam tol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static KMeans load(String string) {
        return KMeans$.MODULE$.load(string);
    }

    public static MLReader<KMeans> read() {
        return KMeans$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return KMeansParams.getK$(this);
    }

    @Override
    public String getInitMode() {
        return KMeansParams.getInitMode$(this);
    }

    @Override
    public int getInitSteps() {
        return KMeansParams.getInitSteps$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return KMeansParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getDistanceMeasure() {
        return HasDistanceMeasure.getDistanceMeasure$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final Param<String> initMode() {
        return this.initMode;
    }

    @Override
    public final IntParam initSteps() {
        return this.initSteps;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initMode_$eq(Param<String> x$1) {
        this.initMode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initSteps_$eq(IntParam x$1) {
        this.initSteps = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasDistanceMeasure$_setter_$distanceMeasure_$eq(Param<String> x$1) {
        this.distanceMeasure = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public KMeans copy(ParamMap extra) {
        return (KMeans)this.defaultCopy(extra);
    }

    public KMeans setFeaturesCol(String value) {
        return (KMeans)this.set(this.featuresCol(), value);
    }

    public KMeans setPredictionCol(String value) {
        return (KMeans)this.set(this.predictionCol(), value);
    }

    public KMeans setK(int value) {
        return (KMeans)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setInitMode(String value) {
        return (KMeans)this.set(this.initMode(), value);
    }

    public KMeans setDistanceMeasure(String value) {
        return (KMeans)this.set(this.distanceMeasure(), value);
    }

    public KMeans setInitSteps(int value) {
        return (KMeans)this.set(this.initSteps(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setMaxIter(int value) {
        return (KMeans)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setTol(double value) {
        return (KMeans)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public KMeans setSeed(long value) {
        return (KMeans)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public KMeans setWeightCol(String value) {
        return (KMeans)this.set(this.weightCol(), value);
    }

    @Override
    public KMeansModel fit(Dataset<?> dataset) {
        return (KMeansModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            this.transformSchema(dataset.schema(), true);
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.k(), this.initMode(), this.initSteps(), this.distanceMeasure(), this.maxIter(), this.seed(), this.tol(), this.weightCol()}));
            org.apache.spark.mllib.clustering.KMeans algo = new org.apache.spark.mllib.clustering.KMeans().setK(BoxesRunTime.unboxToInt((Object)this.$(this.k()))).setInitializationMode(this.$(this.initMode())).setInitializationSteps(BoxesRunTime.unboxToInt((Object)this.$(this.initSteps()))).setMaxIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))).setSeed(BoxesRunTime.unboxToLong((Object)this.$(this.seed()))).setEpsilon(BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))).setDistanceMeasure(this.$(this.distanceMeasure()));
            Column w = this.isDefined(this.weightCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(this.weightCol()))).nonEmpty() ? functions$.MODULE$.checkNonNegativeWeight().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{org.apache.spark.sql.functions$.MODULE$.col(this.$(this.weightCol())).cast((DataType)DoubleType$.MODULE$)})) : org.apache.spark.sql.functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
            RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol()), w})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object point = ((SeqLike)some.get()).apply(0);
                    Object weight = ((SeqLike)some.get()).apply(1);
                    if (point instanceof org.apache.spark.ml.linalg.Vector) {
                        org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)point;
                        if (weight instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)weight);
                            return new Tuple2((Object)Vectors$.MODULE$.fromML(vector), (Object)BoxesRunTime.boxToDouble((double)d));
                        }
                    }
                }
                throw new MatchError((Object)row);
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            org.apache.spark.mllib.clustering.KMeansModel parentModel = algo.runWithWeight((RDD<Tuple2<Vector, Object>>)instances, handlePersistence, (Option<Instrumentation>)new Some(instr));
            KMeansModel model = this.copyValues(new KMeansModel(this.uid(), parentModel).setParent(this), this.copyValues$default$2());
            KMeansSummary summary = new KMeansSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), parentModel.numIter(), parentModel.trainingCost());
            model.setSummary((Option<KMeansSummary>)new Some((Object)summary));
            instr.logNamedValue("clusterSizes", summary.clusterSizes());
            return model;
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public KMeans(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasTol.$init$(this);
        HasDistanceMeasure.$init$(this);
        HasWeightCol.$init$(this);
        KMeansParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public KMeans() {
        this(Identifiable$.MODULE$.randomUID("kmeans"));
    }
}

