/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.LinearSVC$;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.apache.spark.ml.classification.LinearSVCParams;
import org.apache.spark.ml.classification.LinearSVCTrainingSummary;
import org.apache.spark.ml.classification.LinearSVCTrainingSummaryImpl;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.feature.StandardScalerModel$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.HingeBlockAggregator;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.MultiClassSummarizer;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t%b\u0001B\f\u0019\u0001\rB\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0005\u0010\u0005\t'\u0002\u0011\t\u0011)A\u0005{!)Q\u000b\u0001C\u0001-\")Q\u000b\u0001C\u00015\")A\f\u0001C\u0001;\")a\r\u0001C\u0001O\")Q\u000e\u0001C\u0001]\")A\u000f\u0001C\u0001k\")\u0001\u0010\u0001C\u0001s\")A\u0010\u0001C\u0001{\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!a\r\u0001\t#\n)\u0004C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\u001e9\u0011Q\u001e\r\t\u0002\u0005=hAB\f\u0019\u0011\u0003\t\t\u0010\u0003\u0004V'\u0011\u0005!Q\u0001\u0005\b\u0005\u000f\u0019B\u0011\tB\u0005\u0011%\u0011\tbEA\u0001\n\u0013\u0011\u0019BA\u0005MS:,\u0017M]*W\u0007*\u0011\u0011DG\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\tYB$\u0001\u0002nY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!#'\u000e\t\u0006K\u0019BcfL\u0007\u00021%\u0011q\u0005\u0007\u0002\u000b\u00072\f7o]5gS\u0016\u0014\bCA\u0015-\u001b\u0005Q#BA\u0016\u001b\u0003\u0019a\u0017N\\1mO&\u0011QF\u000b\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005\u0015\u0002\u0001CA\u00131\u0013\t\t\u0004D\u0001\bMS:,\u0017M]*W\u00076{G-\u001a7\u0011\u0005\u0015\u001a\u0014B\u0001\u001b\u0019\u0005=a\u0015N\\3beN36\tU1sC6\u001c\bC\u0001\u001c:\u001b\u00059$B\u0001\u001d\u001b\u0003\u0011)H/\u001b7\n\u0005i:$!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.Z\u0001\u0004k&$W#A\u001f\u0011\u0005y:eBA F!\t\u00015)D\u0001B\u0015\t\u0011%%\u0001\u0004=e>|GO\u0010\u0006\u0002\t\u0006)1oY1mC&\u0011aiQ\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002G\u0007\"\u001a\u0011aS)\u0011\u00051{U\"A'\u000b\u00059c\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001+\u0014\u0002\u0006'&t7-Z\u0011\u0002%\u0006)!G\f\u001a/a\u0005!Q/\u001b3!Q\r\u00111*U\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059:\u0006\"B\u001e\u0004\u0001\u0004i\u0004fA,L#\"\u001a1aS)\u0015\u00039B3\u0001B&R\u0003-\u0019X\r\u001e*fOB\u000b'/Y7\u0015\u0005y{V\"\u0001\u0001\t\u000b\u0001,\u0001\u0019A1\u0002\u000bY\fG.^3\u0011\u0005\t\u001cW\"A\"\n\u0005\u0011\u001c%A\u0002#pk\ndW\rK\u0002\u0006\u0017F\u000b!b]3u\u001b\u0006D\u0018\n^3s)\tq\u0006\u000eC\u0003a\r\u0001\u0007\u0011\u000e\u0005\u0002cU&\u00111n\u0011\u0002\u0004\u0013:$\bf\u0001\u0004L#\u0006y1/\u001a;GSRLe\u000e^3sG\u0016\u0004H\u000f\u0006\u0002__\")\u0001m\u0002a\u0001aB\u0011!-]\u0005\u0003e\u000e\u0013qAQ8pY\u0016\fg\u000eK\u0002\b\u0017F\u000baa]3u)>dGC\u00010w\u0011\u0015\u0001\u0007\u00021\u0001bQ\rA1*U\u0001\u0013g\u0016$8\u000b^1oI\u0006\u0014H-\u001b>bi&|g\u000e\u0006\u0002_u\")\u0001-\u0003a\u0001a\"\u001a\u0011bS)\u0002\u0019M,GoV3jO\"$8i\u001c7\u0015\u0005ys\b\"\u00021\u000b\u0001\u0004i\u0004f\u0001\u0006L#\u0006a1/\u001a;UQJ,7\u000f[8mIR\u0019a,!\u0002\t\u000b\u0001\\\u0001\u0019A1)\u0007-Y\u0015+A\ntKR\fum\u001a:fO\u0006$\u0018n\u001c8EKB$\b\u000eF\u0002_\u0003\u001bAQ\u0001\u0019\u0007A\u0002%D3\u0001D&R\u0003M\u0019X\r^'bq\ncwnY6TSj,\u0017J\\'C)\rq\u0016Q\u0003\u0005\u0006A6\u0001\r!\u0019\u0015\u0005\u001b-\u000bI\"\t\u0002\u0002\u001c\u0005)1GL\u0019/a\u0005!1m\u001c9z)\rq\u0013\u0011\u0005\u0005\b\u0003Gq\u0001\u0019AA\u0013\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u00165\u0005)\u0001/\u0019:b[&!\u0011qFA\u0015\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\bL#\u0006)AO]1j]R\u0019q&a\u000e\t\u000f\u0005er\u00021\u0001\u0002<\u00059A-\u0019;bg\u0016$\b\u0007BA\u001f\u0003\u001b\u0002b!a\u0010\u0002F\u0005%SBAA!\u0015\r\t\u0019\u0005H\u0001\u0004gFd\u0017\u0002BA$\u0003\u0003\u0012q\u0001R1uCN,G\u000f\u0005\u0003\u0002L\u00055C\u0002\u0001\u0003\r\u0003\u001f\n9$!A\u0001\u0002\u000b\u0005\u0011\u0011\u000b\u0002\u0004?\u0012\n\u0014\u0003BA*\u00033\u00022AYA+\u0013\r\t9f\u0011\u0002\b\u001d>$\b.\u001b8h!\r\u0011\u00171L\u0005\u0004\u0003;\u001a%aA!os\u0006Y1M]3bi\u0016lu\u000eZ3m)%y\u00131MA8\u0003g\n9\bC\u0004\u0002:A\u0001\r!!\u001a1\t\u0005\u001d\u00141\u000e\t\u0007\u0003\u007f\t)%!\u001b\u0011\t\u0005-\u00131\u000e\u0003\r\u0003[\n\u0019'!A\u0001\u0002\u000b\u0005\u0011\u0011\u000b\u0002\u0004?\u0012\u0012\u0004BBA9!\u0001\u0007\u0001&\u0001\u0007d_\u00164g-[2jK:$8\u000f\u0003\u0004\u0002vA\u0001\r!Y\u0001\nS:$XM]2faRDq!!\u001f\u0011\u0001\u0004\tY(\u0001\tpE*,7\r^5wK\"K7\u000f^8ssB!!-! b\u0013\r\tyh\u0011\u0002\u0006\u0003J\u0014\u0018-_\u0001\niJ\f\u0017N\\%na2$b\"!\"\u0002\f\u0006\u001d\u00161VAX\u0003g\u000bi\rE\u0004c\u0003\u000f\u000bY(a\u001f\n\u0007\u0005%5I\u0001\u0004UkBdWM\r\u0005\b\u0003\u001b\u000b\u0002\u0019AAH\u0003%Ign\u001d;b]\u000e,7\u000f\u0005\u0004\u0002\u0012\u0006]\u00151T\u0007\u0003\u0003'S1!!&\u001d\u0003\r\u0011H\rZ\u0005\u0005\u00033\u000b\u0019JA\u0002S\t\u0012\u0003B!!(\u0002$6\u0011\u0011q\u0014\u0006\u0004\u0003CS\u0012a\u00024fCR,(/Z\u0005\u0005\u0003K\u000byJ\u0001\u0005J]N$\u0018M\\2f\u0011\u0019\tI+\u0005a\u0001C\u0006\u0019\u0012m\u0019;vC2\u0014En\\2l'&TX-\u00138N\u0005\"9\u0011QV\tA\u0002\u0005m\u0014a\u00034fCR,(/Z:Ti\u0012Dq!!-\u0012\u0001\u0004\tY(\u0001\u0007gK\u0006$XO]3t\u001b\u0016\fg\u000eC\u0004\u00026F\u0001\r!a.\u0002\u001dI,w-\u001e7be&T\u0018\r^5p]B)!-!/\u0002>&\u0019\u00111X\"\u0003\r=\u0003H/[8o!\u0011\ty,!3\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\fA\u0001\\8tg*\u0019\u0011q\u0019\u000e\u0002\u000b=\u0004H/[7\n\t\u0005-\u0017\u0011\u0019\u0002\u0011\u0019J\u0012VmZ;mCJL'0\u0019;j_:Dq!a4\u0012\u0001\u0004\t\t.A\u0005paRLW.\u001b>feB9\u00111[AoS\u0006\u0005XBAAk\u0015\u0011\t9.!7\u0002\u0011=\u0004H/[7ju\u0016T!!a7\u0002\r\t\u0014X-\u001a>f\u0013\u0011\ty.!6\u0003\u000b=;F*\u0015(\u0011\u000b\u0005\r\u0018q]1\u000e\u0005\u0005\u0015(bA\u0016\u0002Z&!\u0011\u0011^As\u0005-!UM\\:f-\u0016\u001cGo\u001c:)\u0007\u0001Y\u0015+A\u0005MS:,\u0017M]*W\u0007B\u0011QeE\n\b'\u0005M\u0018\u0011`A\u0000!\r\u0011\u0017Q_\u0005\u0004\u0003o\u001c%AB!osJ+g\r\u0005\u00037\u0003wt\u0013bAA\u007fo\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007c\u00012\u0003\u0002%\u0019!1A\"\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005=\u0018\u0001\u00027pC\u0012$2A\fB\u0006\u0011\u0019\u0011i!\u0006a\u0001{\u0005!\u0001/\u0019;iQ\r)2*U\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0016A!!q\u0003B\u0011\u001b\t\u0011IB\u0003\u0003\u0003\u001c\tu\u0011\u0001\u00027b]\u001eT!Aa\b\u0002\t)\fg/Y\u0005\u0005\u0005G\u0011IB\u0001\u0004PE*,7\r\u001e\u0015\u0004'-\u000b\u0006f\u0001\nL#\u0002")
public class LinearSVC
extends Classifier<Vector, LinearSVC, LinearSVCModel>
implements LinearSVCParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam threshold;
    private final DoubleParam maxBlockSizeInMB;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam regParam;

    public static LinearSVC load(String string) {
        return LinearSVC$.MODULE$.load(string);
    }

    public static MLReader<LinearSVC> read() {
        return LinearSVC$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public double getThreshold() {
        return HasThreshold.getThreshold$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$classification$LinearSVCParams$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearSVC setRegParam(double value) {
        return (LinearSVC)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setMaxIter(int value) {
        return (LinearSVC)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearSVC setFitIntercept(boolean value) {
        return (LinearSVC)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setTol(double value) {
        return (LinearSVC)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setStandardization(boolean value) {
        return (LinearSVC)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setWeightCol(String value) {
        return (LinearSVC)this.set(this.weightCol(), value);
    }

    public LinearSVC setThreshold(double value) {
        return (LinearSVC)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setAggregationDepth(int value) {
        return (LinearSVC)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearSVC setMaxBlockSizeInMB(double value) {
        return (LinearSVC)this.set(this.maxBlockSizeInMB(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public LinearSVC copy(ParamMap extra) {
        return (LinearSVC)this.defaultCopy(extra);
    }

    @Override
    public LinearSVCModel train(Dataset<?> dataset) {
        return (LinearSVCModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            None$ none$;
            int n;
            Option<Object> option;
            RDD instances;
            Tuple2<SummarizerBuffer, MultiClassSummarizer> tuple2;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.weightCol(), this.featuresCol(), this.predictionCol(), this.rawPredictionCol(), this.regParam(), this.maxIter(), this.fitIntercept(), this.tol(), this.standardization(), this.threshold(), this.aggregationDepth(), this.maxBlockSizeInMB()}));
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("Input instances will be standardized, blockified to blocks, and ").append("then cached during training. Be careful of double caching!").toString());
            }
            if ((tuple2 = Summarizer$.MODULE$.getClassificationSummarizers((RDD<Instance>)(instances = this.extractInstances(dataset).setName("training instances")), BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), (Seq<String>)((Seq)new .colon.colon((Object)"mean", (List)new .colon.colon((Object)"std", (List)new .colon.colon((Object)"count", (List)Nil$.MODULE$)))))) == null) {
                throw new MatchError(tuple2);
            }
            SummarizerBuffer summarizer = (SummarizerBuffer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            SummarizerBuffer summarizer2 = (SummarizerBuffer)tuple22._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple22._2();
            double[] histogram = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numFeatures = summarizer2.mean().size();
            instr.logNumExamples(summarizer2.count());
            instr.logNamedValue("lowestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).min((Ordering)Ordering.Double$.MODULE$).toString());
            instr.logNamedValue("highestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).max((Ordering)Ordering.Double$.MODULE$).toString());
            instr.logSumOfWeights(summarizer2.weightSum());
            double actualBlockSizeInMB = BoxesRunTime.unboxToDouble((Object)this.$(this.maxBlockSizeInMB()));
            if (actualBlockSizeInMB == 0.0) {
                actualBlockSizeInMB = InstanceBlock$.MODULE$.DefaultBlockSizeInMB();
                Predef$.MODULE$.require(actualBlockSizeInMB > 0.0, (Function0 & Serializable & scala.Serializable)() -> "inferred actual BlockSizeInMB must > 0");
                instr.logNamedValue("actualBlockSizeInMB", Double.toString(actualBlockSizeInMB));
            }
            if ((option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())))) instanceof Some) {
                Some some = (Some)option;
                int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                int n3 = n2;
                Predef$.MODULE$.require(n3 >= histogram.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Specified number of classes ").append(n3).append(" was ").append("less than the number of unique labels ").append(histogram.length).append(".").toString());
                n = n3;
            } else if (None$.MODULE$.equals(option)) {
                n = histogram.length;
            } else {
                throw new MatchError(option);
            }
            int numClasses = n;
            Predef$.MODULE$.require(numClasses == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("LinearSVC only supports binary classification.").append(" ").append(numClasses).append(" classes detected in ").append(this.labelCol()).toString());
            instr.logNumClasses(numClasses);
            instr.logNumFeatures(numFeatures);
            if (numInvalid != 0L) {
                String msg = new StringBuilder(66).append("Classification labels should be in [0 to ").append(numClasses - 1).append("]. ").append("Found ").append(numInvalid).append(" invalid labels.").toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            double[] featuresStd = summarizer2.std().toArray();
            double[] featuresMean = summarizer2.mean().toArray();
            JFunction1.mcDI.sp & Serializable & scala.Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> featuresStd[j];
            if (BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) != 0.0) {
                JFunction1.mcZI.sp & Serializable & scala.Serializable shouldApply = (JFunction1.mcZI.sp & Serializable & scala.Serializable)idx -> idx >= 0 && idx < numFeatures;
                none$ = new Some((Object)new L2Regularization(BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())), (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
            } else {
                none$ = None$.MODULE$;
            }
            None$ regularization = none$;
            OWLQN optimizer = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, LinearSVC.regParamL1Fun$1(), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
            Tuple2<double[], double[]> tuple23 = this.trainImpl((RDD<Instance>)instances, actualBlockSizeInMB, featuresStd, featuresMean, (Option<L2Regularization>)regularization, (OWLQN<Object, DenseVector<Object>>)optimizer);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            double[] rawCoefficients = (double[])tuple23._1();
            double[] objectiveHistory = (double[])tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)rawCoefficients, (Object)objectiveHistory);
            double[] rawCoefficients2 = (double[])tuple24._1();
            double[] objectiveHistory2 = (double[])tuple24._2();
            if (rawCoefficients2 == null) {
                String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            double[] coefficientArray = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
                if (featuresStd[i] != 0.0) {
                    return rawCoefficients2[i] / featuresStd[i];
                }
                return 0.0;
            }, ClassTag$.MODULE$.Double());
            double intercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rawCoefficients2)).last()) : 0.0;
            return this.createModel(dataset, Vectors$.MODULE$.dense(coefficientArray), intercept, objectiveHistory2);
        });
    }

    private LinearSVCModel createModel(Dataset<?> dataset, Vector coefficients, double intercept, double[] objectiveHistory) {
        LinearSVCModel model = this.copyValues(new LinearSVCModel(this.uid(), coefficients, intercept), this.copyValues$default$2());
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = model.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ClassificationModel summaryModel = (ClassificationModel)tuple3._1();
        String rawPredictionColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)rawPredictionColName, (Object)predictionColName);
        ClassificationModel summaryModel2 = (ClassificationModel)tuple32._1();
        String rawPredictionColName2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        LinearSVCTrainingSummaryImpl summary = new LinearSVCTrainingSummaryImpl(summaryModel2.transform(dataset), rawPredictionColName2, predictionColName2, this.$(this.labelCol()), weightColName, objectiveHistory);
        return (LinearSVCModel)model.setSummary((Option<LinearSVCTrainingSummary>)new Some((Object)summary));
    }

    private Tuple2<double[], double[]> trainImpl(RDD<Instance> instances, double actualBlockSizeInMB, double[] featuresStd, double[] featuresMean, Option<L2Regularization> regularization, OWLQN<Object, DenseVector<Object>> optimizer) {
        double[] solution;
        int numFeatures = featuresStd.length;
        int numFeaturesPlusIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures;
        double[] inverseStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresStd)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)std -> {
            if (std != 0.0) {
                return 1.0 / std;
            }
            return 0.0;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] scaledMean = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> inverseStd[i] * featuresMean[i], ClassTag$.MODULE$.Double());
        Broadcast bcInverseStd = instances.context().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = instances.context().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD standardized = instances.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            Function1<Vector, Vector> func = StandardScalerModel$.MODULE$.getTransformFunc((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), (double[])bcInverseStd.value(), false, true);
            return iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance != null) {
                    double label = instance.label();
                    double weight = instance.weight();
                    Vector vec = instance.features();
                    return new Instance(label, weight, (Vector)func.apply((Object)vec));
                }
                throw new MatchError((Object)instance);
            });
        }, instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Instance.class));
        long maxMemUsage = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(actualBlockSizeInMB * (double)1024L * (double)1024L));
        RDD blocks = InstanceBlock$.MODULE$.blokifyWithMaxMemUsage((RDD<Instance>)standardized, maxMemUsage).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName(new StringBuilder(32).append("training blocks (blockSizeInMB=").append(actualBlockSizeInMB).append(")").toString());
        Function1 & Serializable & scala.Serializable getAggregatorFunc = (Function1 & Serializable & scala.Serializable)x$4 -> new HingeBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), (Broadcast<Vector>)x$4);
        RDDLossFunction costFun = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(HingeBlockAggregator.class));
        double[] initialSolution = (double[])Array$.MODULE$.ofDim(numFeaturesPlusIntercept, ClassTag$.MODULE$.Double());
        if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, initialSolution, 1, scaledMean, 1);
            initialSolution[numFeatures] = initialSolution[numFeatures] + adapt;
        }
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialSolution));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        blocks.unpersist(blocks.unpersist$default$1());
        bcInverseStd.destroy();
        bcScaledMean.destroy();
        double[] dArray = solution = state == null ? null : ((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double());
        if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && solution != null) {
            double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, solution, 1, scaledMean, 1);
            solution[numFeatures] = solution[numFeatures] - adapt;
        }
        return new Tuple2((Object)solution, arrayBuilder.result());
    }

    private static final Function1 regParamL1Fun$1() {
        return (JFunction1.mcDI.sp & Serializable & scala.Serializable)index -> 0.0;
    }

    public LinearSVC(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasAggregationDepth.$init$(this);
        HasThreshold.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LinearSVCParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public LinearSVC() {
        this(Identifiable$.MODULE$.randomUID("linearsvc"));
    }
}

