/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.EntropyAggregator;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.GiniAggregator;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t2A\u0001B\u0003\u0001!!)Q\u0003\u0001C\u0001-!9\u0011\u0004\u0001b\u0001\n\u0013Q\u0002BB\u0011\u0001A\u0003%1DA\u0007J[B,(/\u001b;z'VLG/\u001a\u0006\u0003\r\u001d\tA\u0001\u001e:fK*\u0011\u0001\"C\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u0015-\tQa\u001d9be.T!\u0001D\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0011aA8sO\u000e\u00011C\u0001\u0001\u0012!\t\u00112#D\u0001\n\u0013\t!\u0012BA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\u0015\tAa]3fIV\t1\u0004\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SDA\u0002J]R\fQa]3fI\u0002\u0002")
public class ImpuritySuite
extends SparkFunSuite {
    private final int seed;

    private int seed() {
        return this.seed;
    }

    private static final Tuple3 computeStats$1(Seq samples, Seq weights) {
        return (Tuple3)((TraversableOnce)samples.zip((GenIterable)weights, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple3 != null) {
                    double wn = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                    double wy = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    double wyy = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    if (tuple22 != null) {
                        double y = tuple22._1$mcD$sp();
                        double w = tuple22._2$mcD$sp();
                        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)(wn + w)), (Object)BoxesRunTime.boxToDouble((double)(wy + w * y)), (Object)BoxesRunTime.boxToDouble((double)(wyy + w * y * y)));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public ImpuritySuite() {
        this.seed = 42;
        this.test("Gini impurity does not support negative labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            GiniAggregator gini = new GiniAggregator(2);
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> gini.update(new double[]{0.0, 1.0, 2.0}, 0, -1.0, 3, 0.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ImpuritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        }, new Position("ImpuritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("Entropy does not support negative labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            EntropyAggregator entropy = new EntropyAggregator(2);
            return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> entropy.update(new double[]{0.0, 1.0, 2.0}, 0, -1.0, 3, 0.0), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ImpuritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        }, new Position("ImpuritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        this.test("Classification impurities are insensitive to scaling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Random rng = new Random(this.seed());
            double[] weightedCounts = (double[])Array$.MODULE$.fill(5, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double());
            double[] smallWeightedCounts = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weightedCounts)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$1 -> x$1 * 1.0E-4, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] largeWeightedCounts = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weightedCounts)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 * (double)10000, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            ((IterableLike)new .colon.colon((Object)Gini$.MODULE$, (List)new .colon.colon((Object)Entropy$.MODULE$, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)impurity -> {
                double impurity1 = impurity.calculate(weightedCounts, BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(weightedCounts)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(impurity.calculate(smallWeightedCounts, BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(smallWeightedCounts)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(impurity1).relTol(0.005)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(impurity.calculate(smallWeightedCounts, scala.Predef.doubleArrayOps(smallWeightedCounts).sum[Double](math.this.Numeric.DoubleIsFractional))).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(impurity1).relTol(0.005))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImpuritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(impurity.calculate(largeWeightedCounts, BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(largeWeightedCounts)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)))).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(impurity1).relTol(0.005)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(impurity.calculate(largeWeightedCounts, scala.Predef.doubleArrayOps(largeWeightedCounts).sum[Double](math.this.Numeric.DoubleIsFractional))).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(impurity1).relTol(0.005))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ImpuritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            });
        }, new Position("ImpuritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("Regression impurities are insensitive to scaling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Random rng = new Random(this.seed());
            double[] samples = (double[])Array$.MODULE$.fill(10, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double());
            double[] _weights = (double[])Array$.MODULE$.fill(10, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double());
            double[] smallWeights = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(_weights)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> x$3 * 1.0E-4, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double[] largeWeights = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(_weights)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 * (double)10000, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            Tuple3 tuple3 = ImpuritySuite.computeStats$1((Seq)Predef$.MODULE$.wrapDoubleArray(samples), (Seq)Predef$.MODULE$.wrapDoubleArray(_weights));
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            double count = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double sum = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double sumSquared = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)count), (Object)BoxesRunTime.boxToDouble((double)sum), (Object)BoxesRunTime.boxToDouble((double)sumSquared));
            double count2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            double sum2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            double sumSquared2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
            ((IterableLike)new .colon.colon((Object)Variance$.MODULE$, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)impurity -> {
                double impurity1 = impurity.calculate(count2, sum2, sumSquared2);
                Tuple3 tuple3 = ImpuritySuite.computeStats$1((Seq)Predef$.MODULE$.wrapDoubleArray(samples), (Seq)Predef$.MODULE$.wrapDoubleArray(smallWeights));
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                double smallCount = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                double smallSum = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double smallSumSquared = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)smallCount), (Object)BoxesRunTime.boxToDouble((double)smallSum), (Object)BoxesRunTime.boxToDouble((double)smallSumSquared));
                double smallCount2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                double smallSum2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                double smallSumSquared2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                Tuple3 tuple33 = ImpuritySuite.computeStats$1((Seq)Predef$.MODULE$.wrapDoubleArray(samples), (Seq)Predef$.MODULE$.wrapDoubleArray(largeWeights));
                if (tuple33 == null) {
                    throw new MatchError((Object)tuple33);
                }
                double largeCount = BoxesRunTime.unboxToDouble((Object)tuple33._1());
                double largeSum = BoxesRunTime.unboxToDouble((Object)tuple33._2());
                double largeSumSquared = BoxesRunTime.unboxToDouble((Object)tuple33._3());
                Tuple3 tuple34 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)largeCount), (Object)BoxesRunTime.boxToDouble((double)largeSum), (Object)BoxesRunTime.boxToDouble((double)largeSumSquared));
                double largeCount2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
                double largeSum2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                double largeSumSquared2 = BoxesRunTime.unboxToDouble((Object)tuple34._3());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(impurity.calculate(smallCount2, smallSum2, smallSumSquared2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(impurity1).relTol(0.005)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(impurity.calculate(smallCount, smallSum, smallSumSquared)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(impurity1).relTol(0.005))", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ImpuritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(impurity.calculate(largeCount2, largeSum2, largeSumSquared2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(impurity1).relTol(0.005)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(impurity.calculate(largeCount, largeSum, largeSumSquared)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(impurity1).relTol(0.005))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ImpuritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            });
        }, new Position("ImpuritySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
    }
}

