/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionModel$;
import org.apache.spark.mllib.regression.LinearRegressionSuite$;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u;Q!\u0003\u0006\t\nU1Qa\u0006\u0006\t\naAQAI\u0001\u0005\u0002\rBq\u0001J\u0001C\u0002\u0013\u0005Q\u0005\u0003\u0004*\u0003\u0001\u0006IA\n\u0005\bU\u0005\t\t\u0011\"\u0003,\r\u00119\"\u0002\u0001\u001b\t\u000b\t2A\u0011A \t\u000b\u00053A\u0011\u0001\"\u0002+1Kg.Z1s%\u0016<'/Z:tS>t7+^5uK*\u00111\u0002D\u0001\u000be\u0016<'/Z:tS>t'BA\u0007\u000f\u0003\u0015iG\u000e\\5c\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001\u0001\t\u0003-\u0005i\u0011A\u0003\u0002\u0016\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:\u001cV/\u001b;f'\r\t\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005i\u0001\u0013BA\u0011\u001c\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}Q\tQ#A\u0003n_\u0012,G.F\u0001'!\t1r%\u0003\u0002)\u0015\t)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0017AB7pI\u0016d\u0007%A\u0006sK\u0006$'+Z:pYZ,G#\u0001\u0017\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00027b]\u001eT\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\t1qJ\u00196fGR\u001c2AB\u001b:!\t1t'D\u0001\u000f\u0013\tAdBA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003y1\tA!\u001e;jY&\u0011ah\u000f\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u)\u0005\u0001\u0005C\u0001\f\u0007\u0003I1\u0018\r\\5eCR,\u0007K]3eS\u000e$\u0018n\u001c8\u0015\u0007\r3u\u000b\u0005\u0002\u001b\t&\u0011Qi\u0007\u0002\u0005+:LG\u000fC\u0003H\u0011\u0001\u0007\u0001*A\u0006qe\u0016$\u0017n\u0019;j_:\u001c\bcA%R):\u0011!j\u0014\b\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bR\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005A[\u0012a\u00029bG.\fw-Z\u0005\u0003%N\u00131aU3r\u0015\t\u00016\u0004\u0005\u0002\u001b+&\u0011ak\u0007\u0002\u0007\t>,(\r\\3\t\u000baC\u0001\u0019A-\u0002\u000b%t\u0007/\u001e;\u0011\u0007%\u000b&\f\u0005\u0002\u00177&\u0011AL\u0003\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e")
public class LinearRegressionSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static LinearRegressionModel model() {
        return LinearRegressionSuite$.MODULE$.model();
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public void validatePrediction(Seq<Object> predictions, Seq<LabeledPoint> input) {
        int numOffPredictions;
        int $org_scalatest_assert_macro_left = numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LinearRegressionSuite.$anonfun$validatePrediction$1(x0$1)));
        int $org_scalatest_assert_macro_right = input.length() / 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
    }

    private final void testImplicits$lzycompute$1() {
        LinearRegressionSuite linearRegressionSuite = this;
        synchronized (linearRegressionSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validatePrediction$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            LabeledPoint expected;
            double prediction = tuple2._1$mcD$sp();
            return package$.MODULE$.abs(prediction - (expected = (LabeledPoint)tuple2._2()).label()) > 0.5;
        }
        throw new MatchError((Object)tuple2);
    }

    public LinearRegressionSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("linear regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool bool2;
            Bool bool3;
            RDD testRDD = this.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(3.0, new double[]{10.0, 10.0}, 100, 42, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            LinearRegressionWithSGD linReg = (LinearRegressionWithSGD)new LinearRegressionWithSGD(1.0, 100, 0.0, 1.0).setIntercept(true);
            linReg.optimizer().setNumIterations(1000).setStepSize(1.0);
            LinearRegressionModel model = (LinearRegressionModel)linReg.run(testRDD);
            double $org_scalatest_assert_macro_left = model.intercept();
            double $org_scalatest_assert_macro_right = 2.5;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                double $org_scalatest_assert_macro_left3 = model.intercept();
                double $org_scalatest_assert_macro_right2 = 3.5;
                bool3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            } else {
                bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            Vector weights = model.weights();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)weights.size()));
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            double $org_scalatest_assert_macro_left5 = weights.apply(0);
            double $org_scalatest_assert_macro_right5 = 9.0;
            Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 >= $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left6.value()) {
                double $org_scalatest_assert_macro_left7 = weights.apply(0);
                double $org_scalatest_assert_macro_right6 = 11.0;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7 <= $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right7 = bool2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left6.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            double $org_scalatest_assert_macro_left8 = weights.apply(1);
            double $org_scalatest_assert_macro_right8 = 9.0;
            Bool $org_scalatest_assert_macro_left9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 >= $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left9.value()) {
                double $org_scalatest_assert_macro_left10 = weights.apply(1);
                double $org_scalatest_assert_macro_right9 = 11.0;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left10), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10 <= $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right10 = bool;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "&&", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left9.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            Seq validationData = LinearDataGenerator$.MODULE$.generateLinearInput(3.0, new double[]{10.0, 10.0}, 100, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)validationData);
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)validationData);
        }, new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("linear regression without intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool bool2;
            RDD testRDD = this.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 42, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            LinearRegressionWithSGD linReg = (LinearRegressionWithSGD)new LinearRegressionWithSGD(1.0, 100, 0.0, 1.0).setIntercept(false);
            linReg.optimizer().setNumIterations(1000).setStepSize(1.0);
            LinearRegressionModel model = (LinearRegressionModel)linReg.run(testRDD);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            Vector weights = model.weights();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)weights.size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            double $org_scalatest_assert_macro_left3 = weights.apply(0);
            double $org_scalatest_assert_macro_right3 = 9.0;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 >= $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                double $org_scalatest_assert_macro_left5 = weights.apply(0);
                double $org_scalatest_assert_macro_right4 = 11.0;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 <= $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right5 = bool2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            double $org_scalatest_assert_macro_left6 = weights.apply(1);
            double $org_scalatest_assert_macro_right6 = 9.0;
            Bool $org_scalatest_assert_macro_left7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 >= $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left7.value()) {
                double $org_scalatest_assert_macro_left8 = weights.apply(1);
                double $org_scalatest_assert_macro_right7 = 11.0;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 <= $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right8 = bool;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "&&", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left7.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Seq validationData = LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
            RDD validationRDD = this.sc().parallelize(validationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(validationRDD.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)validationData);
            this.validatePrediction((Seq<Object>)((Seq)validationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)validationData);
        }, new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("sparse linear regression without intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Bool bool;
            Bool bool2;
            RDD denseRDD = this.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 42, LinearDataGenerator$.MODULE$.generateLinearInput$default$5()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            RDD sparseRDD = denseRDD.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                LabeledPoint labeledPoint = x0$1;
                if (labeledPoint != null) {
                    double label = labeledPoint.label();
                    Vector v = labeledPoint.features();
                    Vector sv = Vectors$.MODULE$.sparse(10000, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, v.apply(0)), (List)new .colon.colon((Object)new Tuple2.mcID.sp(9999, v.apply(1)), (List)Nil$.MODULE$)));
                    return new LabeledPoint(label, sv);
                }
                throw new MatchError((Object)labeledPoint);
            }, ClassTag$.MODULE$.apply(LabeledPoint.class)).cache();
            LinearRegressionWithSGD linReg = (LinearRegressionWithSGD)new LinearRegressionWithSGD(1.0, 100, 0.0, 1.0).setIntercept(false);
            linReg.optimizer().setNumIterations(1000).setStepSize(1.0);
            LinearRegressionModel model = (LinearRegressionModel)linReg.run(sparseRDD);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
            double $org_scalatest_assert_macro_right = 0.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            Vector weights = model.weights();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)weights.size()));
            int $org_scalatest_assert_macro_right2 = 10000;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            double $org_scalatest_assert_macro_left3 = weights.apply(0);
            double $org_scalatest_assert_macro_right3 = 9.0;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 >= $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                double $org_scalatest_assert_macro_left5 = weights.apply(0);
                double $org_scalatest_assert_macro_right4 = 11.0;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 <= $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right5 = bool2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            double $org_scalatest_assert_macro_left6 = weights.apply(9999);
            double $org_scalatest_assert_macro_right6 = 9.0;
            Bool $org_scalatest_assert_macro_left7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 >= $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left7.value()) {
                double $org_scalatest_assert_macro_left8 = weights.apply(9999);
                double $org_scalatest_assert_macro_right7 = 11.0;
                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 <= $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right8 = bool;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "&&", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left7.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            Seq validationData = LinearDataGenerator$.MODULE$.generateLinearInput(0.0, new double[]{10.0, 10.0}, 100, 17, LinearDataGenerator$.MODULE$.generateLinearInput$default$5());
            Seq sparseValidationData = (Seq)validationData.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                LabeledPoint labeledPoint = x0$2;
                if (labeledPoint != null) {
                    double label = labeledPoint.label();
                    Vector v = labeledPoint.features();
                    Vector sv = Vectors$.MODULE$.sparse(10000, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, v.apply(0)), (List)new .colon.colon((Object)new Tuple2.mcID.sp(9999, v.apply(1)), (List)Nil$.MODULE$)));
                    return new LabeledPoint(label, sv);
                }
                throw new MatchError((Object)labeledPoint);
            }, Seq$.MODULE$.canBuildFrom());
            RDD sparseValidationRDD = this.sc().parallelize(sparseValidationData, 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
            this.validatePrediction((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])model.predict(sparseValidationRDD.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.features(), ClassTag$.MODULE$.apply(Vector.class))).collect()), (Seq<LabeledPoint>)sparseValidationData);
            this.validatePrediction((Seq<Object>)((Seq)sparseValidationData.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToDouble((double)model.predict(row.features())), Seq$.MODULE$.canBuildFrom())), (Seq<LabeledPoint>)sparseValidationData);
        }, new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            LinearRegressionModel model = LinearRegressionSuite$.MODULE$.model();
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                model.save(this.sc(), path);
                LinearRegressionModel sameModel = LinearRegressionModel$.MODULE$.load(this.sc(), path);
                Vector $org_scalatest_assert_macro_left = model.weights();
                Vector $org_scalatest_assert_macro_right = sameModel.weights();
                Vector vector = $org_scalatest_assert_macro_left;
                Vector vector2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(vector != null ? !vector.equals(vector2) : vector2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
                double $org_scalatest_assert_macro_left2 = model.intercept();
                double $org_scalatest_assert_macro_right2 = sameModel.intercept();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return assertion;
        }, new Position("LinearRegressionSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
    }
}

