/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.evaluation.RankingMetrics;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u1AAA\u0002\u0001\u001d!)\u0011\u0004\u0001C\u00015\t\u0019\"+\u00198lS:<W*\u001a;sS\u000e\u001c8+^5uK*\u0011A!B\u0001\u000bKZ\fG.^1uS>t'B\u0001\u0004\b\u0003\u0015iG\u000e\\5c\u0015\tA\u0011\"A\u0003ta\u0006\u00148N\u0003\u0002\u000b\u0017\u00051\u0011\r]1dQ\u0016T\u0011\u0001D\u0001\u0004_J<7\u0001A\n\u0004\u0001=\u0019\u0002C\u0001\t\u0012\u001b\u00059\u0011B\u0001\n\b\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011AcF\u0007\u0002+)\u0011a#B\u0001\u0005kRLG.\u0003\u0002\u0019+\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0004\u0001")
public class RankingMetricsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        RankingMetricsSuite rankingMetricsSuite = this;
        synchronized (rankingMetricsSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public RankingMetricsSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("Ranking metrics: MAP, NDCG, Recall", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD predictionAndLabels = this.sc().parallelize((Seq)new .colon.colon((Object)new Tuple2((Object)new int[]{1, 6, 2, 7, 8, 3, 9, 10, 4, 5}, (Object)new int[]{1, 2, 3, 4, 5}), (List)new .colon.colon((Object)new Tuple2((Object)new int[]{4, 1, 5, 6, 2, 7, 3, 8, 9, 10}, (Object)new int[]{1, 2, 3}), (List)new .colon.colon((Object)new Tuple2((Object)new int[]{1, 2, 3, 4, 5}, Array$.MODULE$.empty(ClassTag$.MODULE$.Int())), (List)Nil$.MODULE$))), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            double eps = 1.0E-5;
            RankingMetrics metrics = new RankingMetrics(predictionAndLabels, ClassTag$.MODULE$.Int());
            double map = metrics.meanAveragePrecision();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precisionAt(1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.3333333333333333).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precisionAt(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.3333333333333333).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precisionAt(2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.3333333333333333).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precisionAt(2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.3333333333333333).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precisionAt(3)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.3333333333333333).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precisionAt(3)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.3333333333333333).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precisionAt(4)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.25).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precisionAt(4)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.25).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precisionAt(5)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.26666666666666666).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precisionAt(5)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.26666666666666666).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precisionAt(10)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.26666666666666666).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precisionAt(10)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.26666666666666666).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precisionAt(15)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.17777777777777778).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precisionAt(15)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.17777777777777778).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(map).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.355026).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(map).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.355026).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAveragePrecisionAt(1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.333334).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAveragePrecisionAt(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.333334).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAveragePrecisionAt(2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.25).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAveragePrecisionAt(2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.25).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAveragePrecisionAt(3)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.24074).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAveragePrecisionAt(3)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.24074).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.ndcgAt(3)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.3333333333333333).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.ndcgAt(3)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.3333333333333333).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.ndcgAt(5)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.328788).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.ndcgAt(5)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.328788).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.ndcgAt(10)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.487913).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.ndcgAt(10)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.487913).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.ndcgAt(15)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.ndcgAt(10)).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.ndcgAt(15)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.ndcgAt(10)).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recallAt(1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.06666666666666667).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recallAt(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.06666666666666667).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recallAt(2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.17777777777777778).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recallAt(2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.17777777777777778).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recallAt(3)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.24444444444444444).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recallAt(3)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.24444444444444444).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recallAt(4)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.24444444444444444).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recallAt(4)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.24444444444444444).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recallAt(5)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.35555555555555557).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recallAt(5)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.35555555555555557).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recallAt(10)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6666666666666666).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recallAt(10)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.6666666666666666).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recallAt(15)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6666666666666666).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recallAt(15)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.6666666666666666).absTol(eps))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("MAP, NDCG, Recall with few predictions (SPARK-14886)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD predictionAndLabels = this.sc().parallelize((Seq)new .colon.colon((Object)new Tuple2((Object)new int[]{1, 6, 2}, (Object)new int[]{1, 2, 3, 4, 5}), (List)new .colon.colon((Object)new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (Object)new int[]{1, 2, 3}), (List)Nil$.MODULE$)), 2, ClassTag$.MODULE$.apply(Tuple2.class));
            double eps = 1.0E-5;
            RankingMetrics metrics = new RankingMetrics(predictionAndLabels, ClassTag$.MODULE$.Int());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precisionAt(1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.5).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precisionAt(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.5).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.precisionAt(2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.25).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.precisionAt(2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.25).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.ndcgAt(1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.5).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.ndcgAt(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.5).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.ndcgAt(2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.30657).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.ndcgAt(2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.30657).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recallAt(1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.1).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recallAt(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.1).absTol(eps))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.recallAt(2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.1).absTol(eps)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.recallAt(2)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.1).absTol(eps))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("RankingMetricsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
    }
}

