/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.Kryo$;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.EuclideanDistanceMeasure;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.KMeansModel$;
import org.apache.spark.mllib.clustering.KMeansSuite;
import org.apache.spark.mllib.clustering.KMeansSuite$;
import org.apache.spark.mllib.clustering.KMeansSuite$VectorWithCompare$2$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordered;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001M3AAC\u0006\u0001-!)\u0011\u0005\u0001C\u0001E!9Q\u0005\u0001b\u0001\n\u00131\u0003BB\u0017\u0001A\u0003%qeB\u0003/\u0017!\u0005qFB\u0003\u000b\u0017!\u0005\u0001\u0007C\u0003\"\u000b\u0011\u0005\u0011\u0007C\u00033\u000b\u0011\u00051\u0007C\u0003A\u000b\u0011\u0005\u0011\tC\u0004J\u000b\u0005\u0005I\u0011\u0002&\u0003\u0017-kU-\u00198t'VLG/\u001a\u0006\u0003\u00195\t!b\u00197vgR,'/\u001b8h\u0015\tqq\"A\u0003nY2L'M\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u00192\u0001A\f\u001c!\tA\u0012$D\u0001\u0010\u0013\tQrBA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u00039}i\u0011!\b\u0006\u0003=5\tA!\u001e;jY&\u0011\u0001%\b\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t1\"\u0001\u0003tK\u0016$W#A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\u0007%sG/A\u0003tK\u0016$\u0007%A\u0006L\u001b\u0016\fgn]*vSR,\u0007C\u0001\u0013\u0006'\t)q\u0003F\u00010\u0003-\u0019'/Z1uK6{G-\u001a7\u0015\tQ:\u0014h\u000f\t\u0003IUJ!AN\u0006\u0003\u0017-kU-\u00198t\u001b>$W\r\u001c\u0005\u0006q\u001d\u0001\raJ\u0001\u0004I&l\u0007\"\u0002\u001e\b\u0001\u00049\u0013!A6\t\u000bq:\u0001\u0019A\u001f\u0002\u0011%\u001c8\u000b]1sg\u0016\u0004\"\u0001\u000b \n\u0005}J#a\u0002\"p_2,\u0017M\\\u0001\u000bG\",7m[#rk\u0006dGc\u0001\"F\u000fB\u0011\u0001fQ\u0005\u0003\t&\u0012A!\u00168ji\")a\t\u0003a\u0001i\u0005\t\u0011\rC\u0003I\u0011\u0001\u0007A'A\u0001c\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003-\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\t1\fgn\u001a\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJ\u0001\u0004PE*,7\r\u001e")
public class KMeansSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int seed;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    public static void checkEqual(KMeansModel kMeansModel, KMeansModel kMeansModel2) {
        KMeansSuite$.MODULE$.checkEqual(kMeansModel, kMeansModel2);
    }

    public static KMeansModel createModel(int n, int n2, boolean bl) {
        return KMeansSuite$.MODULE$.createModel(n, n2, bl);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private int seed() {
        return this.seed;
    }

    private final void testImplicits$lzycompute$1() {
        KMeansSuite kMeansSuite = this;
        synchronized (kMeansSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$13(KMeansSuite $this, RDD rdd$1, String initMode) {
        KMeansModel model1 = KMeans$.MODULE$.train(rdd$1, 10, 2, initMode, (long)$this.seed());
        Vector[] centers1 = model1.clusterCenters();
        KMeansModel model2 = KMeans$.MODULE$.train(rdd$1, 10, 2, initMode, (long)$this.seed());
        Vector[] centers2 = model2.clusterCenters();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])centers1)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])centers2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Vector c1 = (Vector)tuple2._1();
                Vector c2 = (Vector)tuple2._2();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(c1).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(c2).absTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(c1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(c2).absTol(1.0E-14))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ Object[] $anonfun$new$18(int n$1, int i) {
        double x = (double)i / 1000.0;
        return Predef$.MODULE$.refArrayOps((Object[])new Vector[]{Vectors$.MODULE$.sparse(n$1, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0 + x), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 6.0), (List)Nil$.MODULE$)))), Vectors$.MODULE$.sparse(n$1, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0 - x), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 2.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 6.0), (List)Nil$.MODULE$)))), Vectors$.MODULE$.sparse(n$1, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 3.0 + x), (List)Nil$.MODULE$))), Vectors$.MODULE$.sparse(n$1, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 3.0 - x), (List)Nil$.MODULE$))), Vectors$.MODULE$.sparse(n$1, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 4.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 6.0 + x), (List)Nil$.MODULE$)))), Vectors$.MODULE$.sparse(n$1, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 4.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 6.0 - x), (List)Nil$.MODULE$))))});
    }

    private final /* synthetic */ KMeansSuite$VectorWithCompare$2$ VectorWithCompare$lzycompute$1(LazyRef VectorWithCompare$module$1) {
        KMeansSuite$VectorWithCompare$2$ kMeansSuite$VectorWithCompare$2$;
        LazyRef lazyRef = VectorWithCompare$module$1;
        synchronized (lazyRef) {
            kMeansSuite$VectorWithCompare$2$ = VectorWithCompare$module$1.initialized() ? (KMeansSuite$VectorWithCompare$2$)((Object)VectorWithCompare$module$1.value()) : (KMeansSuite$VectorWithCompare$2$)((Object)VectorWithCompare$module$1.initialize((Object)new KMeansSuite$VectorWithCompare$2$(this)));
        }
        return kMeansSuite$VectorWithCompare$2$;
    }

    private final KMeansSuite$VectorWithCompare$2$ VectorWithCompare$3(LazyRef VectorWithCompare$module$1) {
        if (VectorWithCompare$module$1.initialized()) {
            return (KMeansSuite$VectorWithCompare$2$)((Object)VectorWithCompare$module$1.value());
        }
        return this.VectorWithCompare$lzycompute$1(VectorWithCompare$module$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$22(Tuple2 x) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._1()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._2()).absTol(1.0E-5));
    }

    public static final /* synthetic */ boolean $anonfun$new$25(Tuple2 x) {
        return TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._1()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)x._2()).absTol(1.0E-5));
    }

    public static final /* synthetic */ void $anonfun$new$29(KMeansSuite $this, String path$1, File tempDir$1, boolean x0$2) {
        boolean bl = x0$2;
        KMeansModel model = KMeansSuite$.MODULE$.createModel(10, 3, bl);
        try {
            model.save($this.sc(), path$1);
            KMeansModel sameModel = KMeansModel$.MODULE$.load($this.sc(), path$1);
            KMeansSuite$.MODULE$.checkEqual(model, sameModel);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(tempDir$1);
        }
    }

    public KMeansSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.seed = 42;
        this.test("single cluster", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$1 = this.sc();
            Seq x$1 = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 0.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 6.0})), (List)Nil$.MODULE$)));
            int x$2 = qual$1.parallelize$default$2();
            RDD data = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Vector.class));
            Vector center = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}));
            KMeansModel model = KMeans$.MODULE$.train(data, 1, 1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            model = KMeans$.MODULE$.train(data, 1, 2);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            model = KMeans$.MODULE$.train(data, 1, 5);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            model = KMeans$.MODULE$.train(data, 1, 1, KMeans$.MODULE$.RANDOM());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            model = KMeans$.MODULE$.train(data, 1, 1, KMeans$.MODULE$.K_MEANS_PARALLEL());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("fewer distinct points than clusters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD data = this.sc().parallelize((Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 3.0})), (List)Nil$.MODULE$))), 2, ClassTag$.MODULE$.apply(Vector.class));
            KMeansModel model = KMeans$.MODULE$.train(data, 2, 1, "random");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.clusterCenters().length));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            model = KMeans$.MODULE$.train(data, 2, 1, "k-means||");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.clusterCenters().length));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("unique cluster centers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = new Random(this.seed());
            int numDistinctPoints = 10;
            IndexedSeq points = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDistinctPoints).map((Function1 & Serializable & scala.Serializable)i -> Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng$1.nextDouble(), ClassTag$.MODULE$.Double())), IndexedSeq$.MODULE$.canBuildFrom());
            RDD data = this.sc().parallelize((Seq)points.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.fill(1 + rng.nextInt(3), (Function0 & Serializable & scala.Serializable)() -> x$1, ClassTag$.MODULE$.apply(Vector.class)))), IndexedSeq$.MODULE$.canBuildFrom()), 2, ClassTag$.MODULE$.apply(Vector.class));
            RDD normedData = data.map((Function1 & Serializable & scala.Serializable)x$2 -> new VectorWithNorm(x$2), ClassTag$.MODULE$.apply(VectorWithNorm.class));
            KMeans km = new KMeans().setK(50).setMaxIterations(5).setInitializationMode("k-means||").setInitializationSteps(10).setSeed((long)this.seed());
            EuclideanDistanceMeasure distanceMeasureInstance = new EuclideanDistanceMeasure();
            Vector[] initialCenters = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])km.initKMeansParallel(normedData, (DistanceMeasure)distanceMeasureInstance))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)initialCenters.length));
            int $org_scalatest_assert_macro_right = ((Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])initialCenters)).distinct()).length;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            int $org_scalatest_assert_macro_left2 = initialCenters.length;
            int $org_scalatest_assert_macro_right2 = numDistinctPoints;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            KMeansModel model = km.run(data);
            Vector[] finalCenters = model.clusterCenters();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)finalCenters.length));
            int $org_scalatest_assert_macro_right3 = ((Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])finalCenters)).distinct()).length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            int k = 10;
            KMeans km2 = new KMeans().setK(k).setMaxIterations(5).setInitializationMode("k-means||").setInitializationSteps(10).setSeed((long)this.seed());
            Vector[] initialCenters2 = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])km2.initKMeansParallel(normedData, (DistanceMeasure)distanceMeasureInstance))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.vector(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)initialCenters2.length));
            int $org_scalatest_assert_macro_right4 = ((Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])initialCenters2)).distinct()).length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)initialCenters2.length));
            int $org_scalatest_assert_macro_right5 = k;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            KMeansModel model2 = km2.run(data);
            Vector[] finalCenters2 = model2.clusterCenters();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)finalCenters2.length));
            int $org_scalatest_assert_macro_right6 = ((Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])finalCenters2)).distinct()).length;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            KMeans km3 = new KMeans().setK(k).setMaxIterations(5).setInitializationMode("random").setSeed((long)this.seed());
            KMeansModel model3 = km3.run(data);
            Vector[] finalCenters3 = model3.clusterCenters();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)finalCenters3.length));
            int $org_scalatest_assert_macro_right7 = ((Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])finalCenters3)).distinct()).length;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("deterministic initialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            List points = (List)List$.MODULE$.tabulate(1000, (Function1 & Serializable & scala.Serializable)n -> Vectors$.MODULE$.dense((double)BoxesRunTime.unboxToInt((Object)n), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToInt((Object)n)})));
            RDD rdd = this.sc().parallelize((Seq)points, 3, ClassTag$.MODULE$.apply(Vector.class));
            ((IterableLike)new .colon.colon((Object)KMeans$.MODULE$.RANDOM(), (List)new .colon.colon((Object)KMeans$.MODULE$.K_MEANS_PARALLEL(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)initMode -> {
                KMeansSuite.$anonfun$new$13(this, rdd, initMode);
                return BoxedUnit.UNIT;
            });
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("single cluster with big dataset", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Vector[] smallData = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 0.0})), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 6.0}))});
            RDD data = this.sc().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])smallData)), IndexedSeq$.MODULE$.canBuildFrom()), 4, ClassTag$.MODULE$.apply(Vector.class));
            Vector center = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 4.0}));
            KMeansModel model = KMeans$.MODULE$.train(data, 1, 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            model = KMeans$.MODULE$.train(data, 1, 2);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            model = KMeans$.MODULE$.train(data, 1, 5);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            model = KMeans$.MODULE$.train(data, 1, 1, KMeans$.MODULE$.RANDOM());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
            model = KMeans$.MODULE$.train(data, 1, 1, KMeans$.MODULE$.K_MEANS_PARALLEL());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.test("single cluster with sparse data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int n = 10000;
            RDD data = this.sc().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).flatMap((Function1 & Serializable & scala.Serializable)i -> new ArrayOps.ofRef(KMeansSuite.$anonfun$new$18(n, BoxesRunTime.unboxToInt((Object)i))), IndexedSeq$.MODULE$.canBuildFrom()), 4, ClassTag$.MODULE$.apply(Vector.class));
            data.persist();
            Vector center = Vectors$.MODULE$.sparse(n, (Seq)new .colon.colon((Object)new Tuple2.mcID.sp(0, 1.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(1, 3.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(2, 4.0), (List)Nil$.MODULE$))));
            KMeansModel model = KMeans$.MODULE$.train(data, 1, 1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            model = KMeans$.MODULE$.train(data, 1, 2);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
            model = KMeans$.MODULE$.train(data, 1, 5);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            model = KMeans$.MODULE$.train(data, 1, 1, KMeans$.MODULE$.RANDOM());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            model = KMeans$.MODULE$.train(data, 1, 1, KMeans$.MODULE$.K_MEANS_PARALLEL());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(center).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).head).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(center).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            return data.unpersist(data.unpersist$default$1());
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        this.test("k-means|| initialization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LazyRef VectorWithCompare$module = new LazyRef();
            Seq points = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 6.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 0.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 6.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0})), (List)Nil$.MODULE$)))));
            SparkContext qual$2 = this.sc();
            Seq x$3 = points;
            int x$4 = qual$2.parallelize$default$2();
            RDD rdd = qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Vector.class));
            KMeansModel model = KMeans$.MODULE$.train(rdd, 5, 1);
            public class Org_apache_spark_mllib_clustering_KMeansSuite$VectorWithCompare$1
            implements Ordered<Org_apache_spark_mllib_clustering_KMeansSuite$VectorWithCompare$1>,
            Product,
            scala.Serializable {
                private final Vector x;
                private final /* synthetic */ KMeansSuite $outer;

                public boolean $less(Object that) {
                    return Ordered.$less$((Ordered)this, (Object)that);
                }

                public boolean $greater(Object that) {
                    return Ordered.$greater$((Ordered)this, (Object)that);
                }

                public boolean $less$eq(Object that) {
                    return Ordered.$less$eq$((Ordered)this, (Object)that);
                }

                public boolean $greater$eq(Object that) {
                    return Ordered.$greater$eq$((Ordered)this, (Object)that);
                }

                public int compareTo(Object that) {
                    return Ordered.compareTo$((Ordered)this, (Object)that);
                }

                public Vector x() {
                    return this.x;
                }

                public int compare(Org_apache_spark_mllib_clustering_KMeansSuite$VectorWithCompare$1 that) {
                    ArrayOps.ofDouble ofDouble2 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.x().toArray()));
                    ArrayOps.ofDouble ofDouble3 = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(that.x().toArray()));
                    if (BoxesRunTime.unboxToDouble((Object)ofDouble2.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(acc, x) -> acc + x * x)) > BoxesRunTime.unboxToDouble((Object)ofDouble3.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(acc, x) -> acc + x * x))) {
                        return -1;
                    }
                    return 1;
                }

                public Org_apache_spark_mllib_clustering_KMeansSuite$VectorWithCompare$1 copy(Vector x) {
                    return new Org_apache_spark_mllib_clustering_KMeansSuite$VectorWithCompare$1(this.$outer, x);
                }

                public Vector copy$default$1() {
                    return this.x();
                }

                public String productPrefix() {
                    return "VectorWithCompare";
                }

                public int productArity() {
                    return 1;
                }

                public Object productElement(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return this.x();
                        }
                    }
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Org_apache_spark_mllib_clustering_KMeansSuite$VectorWithCompare$1;
                }

                public int hashCode() {
                    return ScalaRunTime$.MODULE$._hashCode((Product)this);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Org_apache_spark_mllib_clustering_KMeansSuite$VectorWithCompare$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Org_apache_spark_mllib_clustering_KMeansSuite$VectorWithCompare$1 var4_3 = (Org_apache_spark_mllib_clustering_KMeansSuite$VectorWithCompare$1)x$1;
                    Vector vector = this.x();
                    Vector vector2 = var4_3.x();
                    if (vector == null) {
                        if (vector2 != null) {
                            return false;
                        }
                    } else if (!vector.equals(vector2)) return false;
                    if (!var4_3.canEqual(this)) return false;
                    return true;
                }

                public Org_apache_spark_mllib_clustering_KMeansSuite$VectorWithCompare$1(KMeansSuite $outer, Vector x) {
                    this.x = x;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    Ordered.$init$((Ordered)this);
                    Product.$init$((Product)this);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$compare$1(double double ), $anonfun$compare$2(double double )}, serializedLambda);
                }
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> this.VectorWithCompare$3(VectorWithCompare$module).apply((Vector)x$6), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())))).zip((GenIterable)points.sortBy((Function1 & Serializable & scala.Serializable)x$7 -> this.VectorWithCompare$3(VectorWithCompare$module).apply((Vector)x$7), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)KMeansSuite.$anonfun$new$22(x))), "scala.Predef.refArrayOps[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).sortBy[VectorWithCompare](((x$6: org.apache.spark.mllib.linalg.Vector) => VectorWithCompare.apply(x$6)))(math.this.Ordering.ordered[VectorWithCompare](scala.Predef.$conforms[VectorWithCompare]))).zip[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, Array[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)]](points.sortBy[VectorWithCompare](((x$7: org.apache.spark.mllib.linalg.Vector) => VectorWithCompare.apply(x$7)))(math.this.Ordering.ordered[VectorWithCompare](scala.Predef.$conforms[VectorWithCompare])))(scala.this.Array.canBuildFrom[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)]((ClassTag.apply[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](classOf[scala.Tuple2]): scala.reflect.ClassTag[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)])))).forall(((x: (org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            model = KMeans$.MODULE$.train(rdd, 5, 10);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).sortBy((Function1 & Serializable & scala.Serializable)x$8 -> this.VectorWithCompare$3(VectorWithCompare$module).apply((Vector)x$8), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())))).zip((GenIterable)points.sortBy((Function1 & Serializable & scala.Serializable)x$9 -> this.VectorWithCompare$3(VectorWithCompare$module).apply((Vector)x$9), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)KMeansSuite.$anonfun$new$25(x))), "scala.Predef.refArrayOps[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](scala.Predef.refArrayOps[org.apache.spark.mllib.linalg.Vector](model.clusterCenters).sortBy[VectorWithCompare](((x$8: org.apache.spark.mllib.linalg.Vector) => VectorWithCompare.apply(x$8)))(math.this.Ordering.ordered[VectorWithCompare](scala.Predef.$conforms[VectorWithCompare]))).zip[org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector, Array[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)]](points.sortBy[VectorWithCompare](((x$9: org.apache.spark.mllib.linalg.Vector) => VectorWithCompare.apply(x$9)))(math.this.Ordering.ordered[VectorWithCompare](scala.Predef.$conforms[VectorWithCompare])))(scala.this.Array.canBuildFrom[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)]((ClassTag.apply[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)](classOf[scala.Tuple2]): scala.reflect.ClassTag[(org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)])))).forall(((x: (org.apache.spark.mllib.linalg.Vector, org.apache.spark.mllib.linalg.Vector)) => org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(x._2).absTol(1.0E-5))))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("two clusters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq points = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(9.2, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (List)Nil$.MODULE$))))));
            RDD rdd = this.sc().parallelize(points, 3, ClassTag$.MODULE$.apply(Vector.class));
            ((IterableLike)new .colon.colon((Object)KMeans$.MODULE$.RANDOM(), (List)new .colon.colon((Object)KMeans$.MODULE$.K_MEANS_PARALLEL(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)initMode -> {
                KMeansModel model = KMeans$.MODULE$.train(rdd, 2, 2, initMode);
                int[] predicts = (int[])model.predict(rdd).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)predicts[0]));
                int $org_scalatest_assert_macro_right = predicts[1];
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)predicts[0]));
                int $org_scalatest_assert_macro_right2 = predicts[2];
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)predicts[3]));
                int $org_scalatest_assert_macro_right3 = predicts[4];
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)predicts[3]));
                int $org_scalatest_assert_macro_right4 = predicts[5];
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
                int $org_scalatest_assert_macro_left5 = predicts[0];
                int $org_scalatest_assert_macro_right5 = predicts[3];
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "!=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 != $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            });
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(new boolean[]{true, false})).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                KMeansSuite.$anonfun$new$29(this, path, tempDir, BoxesRunTime.unboxToBoolean((Object)x0$2));
                return BoxedUnit.UNIT;
            });
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        this.test("Initialize using given cluster centers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Seq points = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0})), (List)Nil$.MODULE$))));
            RDD rdd = this.sc().parallelize(points, 3, ClassTag$.MODULE$.apply(Vector.class));
            KMeansModel initialModel = new KMeansModel((Vector[])((Object[])new Vector[]{(Vector)points.apply(0), (Vector)points.apply(2)}));
            KMeansModel returnModel = new KMeans().setK(2).setMaxIterations(0).setInitialModel(initialModel).run(rdd);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(returnModel.clusterCenters()[0]);
            Vector $org_scalatest_assert_macro_right = initialModel.clusterCenters()[0];
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(returnModel.clusterCenters()[1]);
            Vector $org_scalatest_assert_macro_right2 = initialModel.clusterCenters()[1];
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("Kryo class register", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf(false);
            conf.set(Kryo$.MODULE$.KRYO_REGISTRATION_REQUIRED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            SerializerInstance ser = new KryoSerializer(conf).newInstance();
            VectorWithNorm vec1 = new VectorWithNorm(Vectors$.MODULE$.dense(new double[]{1.0, 2.0}));
            VectorWithNorm vec2 = new VectorWithNorm(Vectors$.MODULE$.sparse(10, new int[]{5, 8}, new double[]{1.0, 2.0}));
            ((IterableLike)new .colon.colon((Object)vec1, (List)new .colon.colon((Object)vec2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)v -> {
                VectorWithNorm v2 = (VectorWithNorm)ser.deserialize(ser.serialize(v, ClassTag$.MODULE$.apply(VectorWithNorm.class)), ClassTag$.MODULE$.apply(VectorWithNorm.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)v2.norm()));
                double $org_scalatest_assert_macro_right = v.norm();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(v2.vector());
                Vector $org_scalatest_assert_macro_right2 = v.vector();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
            });
        }, new Position("KMeansSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
    }
}

