/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.clustering.GaussianMixture;
import org.apache.spark.mllib.clustering.GaussianMixture$;
import org.apache.spark.mllib.clustering.GaussianMixtureModel;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$;
import org.apache.spark.mllib.clustering.GaussianMixtureSuite$GaussianTestData$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0003\u0006\u0001+!)\u0001\u0005\u0001C\u0001C\u001d)A\u0005\u0001E\u0001K\u0019)q\u0005\u0001E\u0001Q!)\u0001e\u0001C\u0001_!9\u0001g\u0001b\u0001\n\u0003\t\u0004BB\u001e\u0004A\u0003%!\u0007C\u0004=\u0007\t\u0007I\u0011A\u0019\t\ru\u001a\u0001\u0015!\u00033\u0005Q9\u0015-^:tS\u0006tW*\u001b=ukJ,7+^5uK*\u00111\u0002D\u0001\u000bG2,8\u000f^3sS:<'BA\u0007\u000f\u0003\u0015iG\u000e\\5c\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0004\u0001YQ\u0002CA\f\u0019\u001b\u0005q\u0011BA\r\u000f\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111DH\u0007\u00029)\u0011Q\u0004D\u0001\u0005kRLG.\u0003\u0002 9\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u000b\u0003A9\u0015-^:tS\u0006tG+Z:u\t\u0006$\u0018\r\u0005\u0002'\u00075\t\u0001A\u0001\tHCV\u001c8/[1o)\u0016\u001cH\u000fR1uCN\u00111!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\u0015\nA\u0001Z1uCV\t!\u0007E\u0002+gUJ!\u0001N\u0016\u0003\u000b\u0005\u0013(/Y=\u0011\u0005YJT\"A\u001c\u000b\u0005ab\u0011A\u00027j]\u0006dw-\u0003\u0002;o\t1a+Z2u_J\fQ\u0001Z1uC\u0002\nQ\u0001Z1uCJ\na\u0001Z1uCJ\u0002\u0003")
public class GaussianMixtureSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private volatile GaussianMixtureSuite$GaussianTestData$ GaussianTestData$module;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    public GaussianMixtureSuite$GaussianTestData$ GaussianTestData() {
        if (this.GaussianTestData$module == null) {
            this.GaussianTestData$lzycompute$1();
        }
        return this.GaussianTestData$module;
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void GaussianTestData$lzycompute$1() {
        GaussianMixtureSuite gaussianMixtureSuite = this;
        synchronized (gaussianMixtureSuite) {
            if (this.GaussianTestData$module == null) {
                this.GaussianTestData$module = new GaussianMixtureSuite$GaussianTestData$(this);
            }
        }
    }

    private final void testImplicits$lzycompute$1() {
        GaussianMixtureSuite gaussianMixtureSuite = this;
        synchronized (gaussianMixtureSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$5(RDD data$1, double Ew$1, Vector Emu$1, Matrix Esigma$1, int seed) {
        GaussianMixtureModel gmm = new GaussianMixture().setK(1).setSeed((long)seed).run(data$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gmm.weights()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Ew$1).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(gmm.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew).absTol(1.0E-5))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gmm.gaussians()[0].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Emu$1).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(gmm.gaussians.apply(0).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu).absTol(1.0E-5))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(gmm.gaussians()[0].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(Esigma$1).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(gmm.gaussians.apply(0).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma).absTol(1.0E-5))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
    }

    public static final /* synthetic */ Assertion $anonfun$new$9(RDD data$2, double Ew$2, Vector Emu$2, Matrix Esigma$2, int seed) {
        GaussianMixtureModel gmm = new GaussianMixture().setK(1).setSeed((long)seed).run(data$2);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gmm.weights()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Ew$2).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(gmm.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew).absTol(1.0E-5))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gmm.gaussians()[0].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Emu$2).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(gmm.gaussians.apply(0).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu).absTol(1.0E-5))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(gmm.gaussians()[0].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(Esigma$2).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(gmm.gaussians.apply(0).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma).absTol(1.0E-5))", Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
    }

    public static final /* synthetic */ Assertion $anonfun$new$13(GaussianMixtureSuite $this, GaussianMixtureModel sameModel$1, GaussianMixtureModel gmm$1, int i) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(sameModel$1.gaussians()[i].mu());
        Vector $org_scalatest_assert_macro_right = gmm$1.gaussians()[i].mu();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(sameModel$1.gaussians()[i].sigma());
        Matrix $org_scalatest_assert_macro_right2 = gmm$1.gaussians()[i].sigma();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
    }

    public GaussianMixtureSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("gmm fails on high dimensional data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$1 = this.sc();
            Seq x$1 = (Seq)new .colon.colon((Object)Vectors$.MODULE$.sparse(GaussianMixture$.MODULE$.MAX_NUM_FEATURES() + 1, new int[]{0, 4}, new double[]{3.0, 8.0}), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(GaussianMixture$.MODULE$.MAX_NUM_FEATURES() + 1, new int[]{1, 5}, new double[]{4.0, 9.0}), (List)Nil$.MODULE$));
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Vector.class));
            GaussianMixture gm = new GaussianMixture();
            return (IllegalArgumentException)this.withClue(new StringBuilder(59).append("GMM should restrict the maximum number of features to be < ").append(GaussianMixture$.MODULE$.MAX_NUM_FEATURES()).toString(), (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> gm.run(rdd), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36)));
        }, new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("single cluster", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkContext qual$2 = this.sc();
            Seq x$3 = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{9.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(5.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0})), (List)Nil$.MODULE$)));
            int x$4 = qual$2.parallelize$default$2();
            RDD data = qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(Vector.class));
            double Ew = 1.0;
            Vector Emu = Vectors$.MODULE$.dense(5.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.0}));
            Matrix Esigma = Matrices$.MODULE$.dense(2, 2, new double[]{0.6666666666666666, -0.6666666666666666, -0.6666666666666666, 0.6666666666666666});
            int[] seeds = new int[]{314589, 29032897, 50181, 494821, 4660};
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(seeds)).foreach((Function1 & Serializable & scala.Serializable)seed -> GaussianMixtureSuite.$anonfun$new$5(data, Ew, Emu, Esigma, BoxesRunTime.unboxToInt((Object)seed)));
        }, new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.test("two clusters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$3 = this.sc();
            WrappedArray x$5 = Predef$.MODULE$.wrapRefArray((Object[])this.GaussianTestData().data());
            int x$6 = qual$3.parallelize$default$2();
            RDD data = qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.apply(Vector.class));
            GaussianMixtureModel initialGmm = new GaussianMixtureModel(new double[]{0.5, 0.5}, (MultivariateGaussian[])((Object[])new MultivariateGaussian[]{new MultivariateGaussian(Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Matrices$.MODULE$.dense(1, 1, new double[]{1.0})), new MultivariateGaussian(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Matrices$.MODULE$.dense(1, 1, new double[]{1.0}))}));
            double[] Ew = new double[]{0.3333333333333333, 0.6666666666666666};
            Vector[] Emu = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(-4.3673, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(5.1604, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))});
            Matrix[] Esigma = (Matrix[])((Object[])new Matrix[]{Matrices$.MODULE$.dense(1, 1, new double[]{1.1098}), Matrices$.MODULE$.dense(1, 1, new double[]{0.86644})});
            GaussianMixtureModel gmm = new GaussianMixture().setK(2).setInitialModel(initialGmm).run(data);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gmm.weights()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Ew[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(gmm.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew.apply(0)).absTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gmm.weights()[1]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Ew[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(gmm.weights.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew.apply(1)).absTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gmm.gaussians()[0].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Emu[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(gmm.gaussians.apply(0).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu.apply(0)).absTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(gmm.gaussians()[1].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Emu[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(gmm.gaussians.apply(1).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu.apply(1)).absTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(gmm.gaussians()[0].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(Esigma[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(gmm.gaussians.apply(0).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma.apply(0)).absTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(gmm.gaussians()[1].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(Esigma[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(gmm.gaussians.apply(1).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma.apply(1)).absTol(0.001))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("two clusters with distributed decompositions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            RDD data = this.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.GaussianTestData().data2()), 2, ClassTag$.MODULE$.apply(Vector.class));
            int k = 5;
            int d = ((Vector)data.first()).size();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(GaussianMixture$.MODULE$.shouldDistributeGaussians(k, d), "GaussianMixture.shouldDistributeGaussians(k, d)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            GaussianMixtureModel gmm = new GaussianMixture().setK(k).run(data);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)gmm.k()));
            int $org_scalatest_assert_macro_right = k;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("single cluster with sparse data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkContext qual$4 = this.sc();
            Seq x$7 = (Seq)new .colon.colon((Object)Vectors$.MODULE$.sparse(3, new int[]{0, 2}, new double[]{4.0, 2.0}), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(3, new int[]{0, 2}, new double[]{2.0, 4.0}), (List)new .colon.colon((Object)Vectors$.MODULE$.sparse(3, new int[]{1}, new double[]{6.0}), (List)Nil$.MODULE$)));
            int x$8 = qual$4.parallelize$default$2();
            RDD data = qual$4.parallelize(x$7, x$8, ClassTag$.MODULE$.apply(Vector.class));
            double Ew = 1.0;
            Vector Emu = Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 2.0}));
            Matrix Esigma = Matrices$.MODULE$.dense(3, 3, new double[]{2.6666666666666665, -4.0, 1.3333333333333333, -4.0, 8.0, -4.0, 1.3333333333333333, -4.0, 2.6666666666666665});
            int[] seeds = new int[]{42, 1994, 27, 11, 0};
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(seeds)).foreach((Function1 & Serializable & scala.Serializable)seed -> GaussianMixtureSuite.$anonfun$new$9(data, Ew, Emu, Esigma, BoxesRunTime.unboxToInt((Object)seed)));
        }, new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("two clusters with sparse data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkContext qual$5 = this.sc();
            WrappedArray x$9 = Predef$.MODULE$.wrapRefArray((Object[])this.GaussianTestData().data());
            int x$10 = qual$5.parallelize$default$2();
            RDD data = qual$5.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.apply(Vector.class));
            RDD sparseData = data.map((Function1 & Serializable & scala.Serializable)point -> Vectors$.MODULE$.sparse(1, new int[]{0}, point.toArray()), ClassTag$.MODULE$.apply(Vector.class));
            GaussianMixtureModel initialGmm = new GaussianMixtureModel(new double[]{0.5, 0.5}, (MultivariateGaussian[])((Object[])new MultivariateGaussian[]{new MultivariateGaussian(Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Matrices$.MODULE$.dense(1, 1, new double[]{1.0})), new MultivariateGaussian(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Matrices$.MODULE$.dense(1, 1, new double[]{1.0}))}));
            double[] Ew = new double[]{0.3333333333333333, 0.6666666666666666};
            Vector[] Emu = (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(-4.3673, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(5.1604, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))});
            Matrix[] Esigma = (Matrix[])((Object[])new Matrix[]{Matrices$.MODULE$.dense(1, 1, new double[]{1.1098}), Matrices$.MODULE$.dense(1, 1, new double[]{0.86644})});
            GaussianMixtureModel sparseGMM = new GaussianMixture().setK(2).setInitialModel(initialGmm).run(sparseData);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(sparseGMM.weights()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Ew[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(sparseGMM.weights.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew.apply(0)).absTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(sparseGMM.weights()[1]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(Ew[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(sparseGMM.weights.apply(1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(Ew.apply(1)).absTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(sparseGMM.gaussians()[0].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Emu[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(sparseGMM.gaussians.apply(0).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu.apply(0)).absTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(sparseGMM.gaussians()[1].mu()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Emu[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(sparseGMM.gaussians.apply(1).mu).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(Emu.apply(1)).absTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(sparseGMM.gaussians()[0].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(Esigma[0]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(sparseGMM.gaussians.apply(0).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma.apply(0)).absTol(0.001))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(sparseGMM.gaussians()[1].sigma()).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(Esigma[1]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(sparseGMM.gaussians.apply(1).sigma).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(Esigma.apply(1)).absTol(0.001))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }, new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        this.test("model save / load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            SparkContext qual$6 = this.sc();
            WrappedArray x$11 = Predef$.MODULE$.wrapRefArray((Object[])this.GaussianTestData().data());
            int x$12 = qual$6.parallelize$default$2();
            RDD data = qual$6.parallelize((Seq)x$11, x$12, ClassTag$.MODULE$.apply(Vector.class));
            GaussianMixtureModel gmm = new GaussianMixture().setK(2).setSeed(0L).run(data);
            File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            String path = tempDir.toURI().toString();
            try {
                gmm.save(this.sc(), path);
                GaussianMixtureModel sameModel = GaussianMixtureModel$.MODULE$.load(this.sc(), path);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sameModel.k()));
                int $org_scalatest_assert_macro_right = gmm.k();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), sameModel.k()).foreach((Function1 & Serializable & scala.Serializable)i -> GaussianMixtureSuite.$anonfun$new$13(this, sameModel, gmm, BoxesRunTime.unboxToInt((Object)i)));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            return boxedUnit;
        }, new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.test("model prediction, parallel and local", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkContext qual$7 = this.sc();
            WrappedArray x$13 = Predef$.MODULE$.wrapRefArray((Object[])this.GaussianTestData().data());
            int x$14 = qual$7.parallelize$default$2();
            RDD data = qual$7.parallelize((Seq)x$13, x$14, ClassTag$.MODULE$.apply(Vector.class));
            GaussianMixtureModel gmm = new GaussianMixture().setK(2).setSeed(0L).run(data);
            RDD batchPredictions = gmm.predict(data);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])batchPredictions.zip(data, ClassTag$.MODULE$.apply(Vector.class)).collect())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    int batchPred = tuple2._1$mcI$sp();
                    Vector datum = (Vector)tuple2._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)batchPred));
                    int $org_scalatest_assert_macro_right = gmm.predict(datum);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("GaussianMixtureSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
    }
}

