/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.stat.inference.KolmogorovSmirnovTest;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.stat.KolmogorovSmirnovTest$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Y3Aa\u0001\u0003\u0001\u001f!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C\u0001M\tQ2j\u001c7n_\u001e|'o\u001c<T[&\u0014hn\u001c<UKN$8+^5uK*\u0011QAB\u0001\u0005gR\fGO\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011)q\u0001\"!\u0005\n\u000e\u0003!I!a\u0005\u0005\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t)\"$D\u0001\u0017\u0015\t9\u0002$\u0001\u0003vi&d'BA\r\t\u0003\u0015iG\u000e\\5c\u0013\tYbCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\u0005uyR\"\u0001\u0010\u000b\u0005]1\u0011B\u0001\u0011\u001f\u0005Q!UMZ1vYR\u0014V-\u00193Xe&$X\rV3ti\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011\u0001B\u0001!CB\f7\r[3D_6lwN\\'bi\"\u001cT)];jm\u0006dWM\\2f)\u0016\u001cH\u000fF\u0003([eZ\u0014\u000b\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0003V]&$\b\"\u0002\u0018\u0003\u0001\u0004y\u0013AC:b[BdW\rR5tiB\u0011\u0001gN\u0007\u0002c)\u0011!gM\u0001\rI&\u001cHO]5ckRLwN\u001c\u0006\u0003iU\nQ!\\1uQNR!A\u000e\u0006\u0002\u000f\r|W.\\8og&\u0011\u0001(\r\u0002\u0011%\u0016\fG\u000eR5tiJL'-\u001e;j_:DQA\u000f\u0002A\u0002=\nq\u0002\u001e5f_J,G/[2bY\u0012K7\u000f\u001e\u0005\u0006y\t\u0001\r!P\u0001\u0016i\",wN]3uS\u000e\fG\u000eR5ti\nKh*Y7f!\u0011Ac\bQ&\n\u0005}J#A\u0002+va2,'\u0007\u0005\u0002B\u0011:\u0011!I\u0012\t\u0003\u0007&j\u0011\u0001\u0012\u0006\u0003\u000b:\ta\u0001\u0010:p_Rt\u0014BA$*\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001dK\u0003c\u0001\u0015M\u001d&\u0011Q*\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003Q=K!\u0001U\u0015\u0003\r\u0011{WO\u00197f\u0011\u0015\u0011&\u00011\u0001T\u0003Q\u0011XM[3di:+H\u000e\u001c%za>$\b.Z:jgB\u0011\u0001\u0006V\u0005\u0003+&\u0012qAQ8pY\u0016\fg\u000e")
public class KolmogorovSmirnovTestSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public void apacheCommonMath3EquivalenceTest(RealDistribution sampleDist, RealDistribution theoreticalDist, Tuple2<String, double[]> theoreticalDistByName, boolean rejectNullHypothesis) {
        RealDistribution realDistribution;
        double d;
        Object statistic1;
        double pThreshold;
        KolmogorovSmirnovTest ksTest;
        double[] sampledArray;
        int n;
        block10: {
            Row row;
            block9: {
                Row row2;
                long seed = 10L;
                sampleDist.reseedRandomGenerator(seed);
                if (theoreticalDist != null) {
                    theoreticalDist.reseedRandomGenerator(seed);
                }
                n = 100000;
                sampledArray = sampleDist.sample(n);
                Dataset sampledDF = this.testImplicits().rddToDatasetHolder(this.sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(sampledArray), 10, ClassTag$.MODULE$.Double()), this.testImplicits().newDoubleEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sample"}));
                ksTest = new KolmogorovSmirnovTest();
                pThreshold = 0.05;
                if (theoreticalDist != null) {
                    JFunction1.mcDD.sp & Serializable & scala.Serializable cdf = (JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> theoreticalDist.cumulativeProbability(x);
                    row2 = (Row)KolmogorovSmirnovTest$.MODULE$.test(sampledDF, "sample", (Function1)cdf).head();
                } else {
                    row2 = (Row)KolmogorovSmirnovTest$.MODULE$.test(sampledDF, "sample", (String)theoreticalDistByName._1(), (Seq)Predef$.MODULE$.wrapDoubleArray((double[])theoreticalDistByName._2())).head();
                }
                row = row2;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block9;
                Object pValue1 = ((SeqLike)some.get()).apply(0);
                statistic1 = ((SeqLike)some.get()).apply(1);
                if (!(pValue1 instanceof Double)) break block9;
                d = BoxesRunTime.unboxToDouble((Object)pValue1);
                if (statistic1 instanceof Double) break block10;
            }
            throw new MatchError((Object)row);
        }
        double d2 = BoxesRunTime.unboxToDouble((Object)statistic1);
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
        double pValue1 = sp2._1$mcD$sp();
        double statistic12 = sp2._2$mcD$sp();
        if (theoreticalDist == null) {
            String $org_scalatest_assert_macro_left = (String)theoreticalDistByName._1();
            String $org_scalatest_assert_macro_right = "norm";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KolmogorovSmirnovTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            double[] params = (double[])theoreticalDistByName._2();
            realDistribution = new NormalDistribution(params[0], params[1]);
        } else {
            realDistribution = theoreticalDist;
        }
        RealDistribution theoreticalDistMath3 = realDistribution;
        double referenceStat1 = ksTest.kolmogorovSmirnovStatistic(theoreticalDistMath3, sampledArray);
        double referencePVal1 = 1.0 - ksTest.cdf(referenceStat1, n);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(statistic12).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referenceStat1).relTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(statistic1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(referenceStat1).relTol(1.0E-4))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KolmogorovSmirnovTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(pValue1).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(referencePVal1).relTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(pValue1).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(referencePVal1).relTol(1.0E-4))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KolmogorovSmirnovTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        if (rejectNullHypothesis) {
            double $org_scalatest_assert_macro_left = pValue1;
            double $org_scalatest_assert_macro_right = pThreshold;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("KolmogorovSmirnovTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            return;
        }
        double $org_scalatest_assert_macro_left = pValue1;
        double $org_scalatest_assert_macro_right = pThreshold;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("KolmogorovSmirnovTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    private final void testImplicits$lzycompute$1() {
        KolmogorovSmirnovTestSuite kolmogorovSmirnovTestSuite = this;
        synchronized (kolmogorovSmirnovTestSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public KolmogorovSmirnovTestSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("1 sample Kolmogorov-Smirnov test: apache commons math3 implementation equivalence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            NormalDistribution stdNormalDist = new NormalDistribution(0.0, 1.0);
            ExponentialDistribution expDist = new ExponentialDistribution(0.6);
            UniformRealDistribution uniformDist = new UniformRealDistribution(0.0, 1.0);
            ExponentialDistribution expDist2 = new ExponentialDistribution(0.2);
            Tuple2 stdNormByName = new Tuple2((Object)"norm", (Object)new double[]{0.0, 1.0});
            this.apacheCommonMath3EquivalenceTest((RealDistribution)stdNormalDist, null, (Tuple2<String, double[]>)stdNormByName, false);
            this.apacheCommonMath3EquivalenceTest((RealDistribution)expDist, null, (Tuple2<String, double[]>)stdNormByName, true);
            this.apacheCommonMath3EquivalenceTest((RealDistribution)uniformDist, null, (Tuple2<String, double[]>)stdNormByName, true);
            this.apacheCommonMath3EquivalenceTest((RealDistribution)expDist, (RealDistribution)expDist2, null, true);
        }, new Position("KolmogorovSmirnovTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("1 sample Kolmogorov-Smirnov test: R implementation equivalence", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double d;
            Object statistic;
            double rKSPVal;
            double rKSStat;
            block3: {
                Row row;
                block2: {
                    rKSStat = 0.18874;
                    rKSPVal = 0.4223;
                    SparkContext qual$1 = this.sc();
                    WrappedArray x$1 = Predef$.MODULE$.wrapDoubleArray(new double[]{1.1626852897838, -0.585924465893051, 1.78546500331661, -1.33259371048501, -0.446566766553219, 0.569606122374976, -2.88971761441412, -0.869018343326555, -0.461702683149641, -0.555540910137444, -0.0201353678515895, -0.150382224136063, -0.628126755843964, 1.32322085193283, -1.52135057001199, -0.437427868856691, 0.970577579543399, 0.0282226444247749, -0.0857821886527593, 0.389214404984942});
                    int x$2 = qual$1.parallelize$default$2();
                    Dataset rData = this.testImplicits().rddToDatasetHolder(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.Double()), this.testImplicits().newDoubleEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sample"}));
                    row = (Row)KolmogorovSmirnovTest$.MODULE$.test(rData, "sample", "norm", (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0})).head();
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object pValue = ((SeqLike)some.get()).apply(0);
                    statistic = ((SeqLike)some.get()).apply(1);
                    if (!(pValue instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)pValue);
                    if (statistic instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)statistic);
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
            double pValue = sp2._1$mcD$sp();
            double statistic2 = sp2._2$mcD$sp();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(statistic2).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(rKSStat).relTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(statistic).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(rKSStat).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KolmogorovSmirnovTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(pValue).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(rKSPVal).relTol(1.0E-4)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(pValue).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(rKSPVal).relTol(1.0E-4))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("KolmogorovSmirnovTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("KolmogorovSmirnovTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }
}

