/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.BinaryLogisticBlockAggregator;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.ml.util.TestingUtils$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001I4A\u0001E\t\u0001=!)1\u0006\u0001C\u0001Y!Iq\u0006\u0001a\u0001\u0002\u0004%\t\u0001\r\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002yB\u0011\u0002\u0012\u0001A\u0002\u0003\u0005\u000b\u0015B\u0019\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0003\u0001\u0004\"\u0003&\u0001\u0001\u0004\u0005\r\u0011\"\u0001L\u0011%i\u0005\u00011A\u0001B\u0003&\u0011\u0007C\u0005P\u0001\u0001\u0007\t\u0019!C\u0001a!I\u0001\u000b\u0001a\u0001\u0002\u0004%\t!\u0015\u0005\n'\u0002\u0001\r\u0011!Q!\nEB\u0011\"\u0016\u0001A\u0002\u0003\u0007I\u0011\u0001\u0019\t\u0013Y\u0003\u0001\u0019!a\u0001\n\u00039\u0006\"C-\u0001\u0001\u0004\u0005\t\u0015)\u00032\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015i\u0006\u0001\"\u0003_\u0005\t\u0012\u0015N\\1ss2{w-[:uS\u000e\u0014En\\2l\u0003\u001e<'/Z4bi>\u00148+^5uK*\u0011!cE\u0001\u000bC\u001e<'/Z4bi>\u0014(B\u0001\u000b\u0016\u0003\u0015y\u0007\u000f^5n\u0015\t1r#\u0001\u0002nY*\u0011\u0001$G\u0001\u0006gB\f'o\u001b\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001y2\u0005\u0005\u0002!C5\tq#\u0003\u0002#/\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0003Q]\tQ!\u001c7mS\nL!AK\u0013\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\u0012!\f\t\u0003]\u0001i\u0011!E\u0001\nS:\u001cH/\u00198dKN,\u0012!\r\t\u0004eU:T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\u000b\u0005\u0013(/Y=\u0011\u0005aZT\"A\u001d\u000b\u0005i*\u0012a\u00024fCR,(/Z\u0005\u0003ye\u0012\u0001\"\u00138ti\u0006t7-Z\u0001\u000eS:\u001cH/\u00198dKN|F%Z9\u0015\u0005}\u0012\u0005C\u0001\u001aA\u0013\t\t5G\u0001\u0003V]&$\bbB\"\u0004\u0003\u0003\u0005\r!M\u0001\u0004q\u0012\n\u0014AC5ogR\fgnY3tA!\u0012AA\u0012\t\u0003e\u001dK!\u0001S\u001a\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001G5ogR\fgnY3t\u0007>t7\u000f^1oi\u001a+\u0017\r^;sK\u0006a\u0012N\\:uC:\u001cWm]\"p]N$\u0018M\u001c;GK\u0006$XO]3`I\u0015\fHCA M\u0011\u001d\u0019e!!AA\u0002E\n\u0011$\u001b8ti\u0006t7-Z:D_:\u001cH/\u00198u\r\u0016\fG/\u001e:fA!\u0012qAR\u0001!S:\u001cH/\u00198dKN\u001cuN\\:uC:$h)Z1ukJ,g)\u001b7uKJ,G-\u0001\u0013j]N$\u0018M\\2fg\u000e{gn\u001d;b]R4U-\u0019;ve\u00164\u0015\u000e\u001c;fe\u0016$w\fJ3r)\ty$\u000bC\u0004D\u0013\u0005\u0005\t\u0019A\u0019\u0002C%t7\u000f^1oG\u0016\u001c8i\u001c8ti\u0006tGOR3biV\u0014XMR5mi\u0016\u0014X\r\u001a\u0011)\u0005)1\u0015aD:dC2,G-\u00138ti\u0006t7-Z:\u0002'M\u001c\u0017\r\\3e\u0013:\u001cH/\u00198dKN|F%Z9\u0015\u0005}B\u0006bB\"\r\u0003\u0003\u0005\r!M\u0001\u0011g\u000e\fG.\u001a3J]N$\u0018M\\2fg\u0002B#!\u0004$\u0002\u0013\t,gm\u001c:f\u00032dG#A \u0002!\u001d,GOT3x\u0003\u001e<'/Z4bi>\u0014H#B0cG.\u0004\bC\u0001\u0018a\u0013\t\t\u0017CA\u000fCS:\f'/\u001f'pO&\u001cH/[2CY>\u001c7.Q4he\u0016<\u0017\r^8s\u0011\u0015ys\u00021\u00012\u0011\u0015!w\u00021\u0001f\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t!\t1\u0017.D\u0001h\u0015\tAW#\u0001\u0004mS:\fGnZ\u0005\u0003U\u001e\u0014aAV3di>\u0014\b\"\u00027\u0010\u0001\u0004i\u0017\u0001\u00044ji&sG/\u001a:dKB$\bC\u0001\u001ao\u0013\ty7GA\u0004C_>dW-\u00198\t\u000bE|\u0001\u0019A7\u0002\u0017\u0019LGoV5uQ6+\u0017M\u001c")
public class BinaryLogisticBlockAggregatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient Instance[] instances;
    private transient Instance[] instancesConstantFeature;
    private transient Instance[] instancesConstantFeatureFiltered;
    private transient Instance[] scaledInstances;
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    public Instance[] instances() {
        return this.instances;
    }

    public void instances_$eq(Instance[] x$1) {
        this.instances = x$1;
    }

    public Instance[] instancesConstantFeature() {
        return this.instancesConstantFeature;
    }

    public void instancesConstantFeature_$eq(Instance[] x$1) {
        this.instancesConstantFeature = x$1;
    }

    public Instance[] instancesConstantFeatureFiltered() {
        return this.instancesConstantFeatureFiltered;
    }

    public void instancesConstantFeatureFiltered_$eq(Instance[] x$1) {
        this.instancesConstantFeatureFiltered = x$1;
    }

    public Instance[] scaledInstances() {
        return this.scaledInstances;
    }

    public void scaledInstances_$eq(Instance[] x$1) {
        this.scaledInstances = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
        this.instances_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(0.0, 0.3, Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeature_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new Instance(0.0, 0.3, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5})))}));
        this.instancesConstantFeatureFiltered_$eq((Instance[])((Object[])new Instance[]{new Instance(0.0, 0.1, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(1.0, 0.5, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new Instance(0.0, 0.3, Vectors$.MODULE$.dense(0.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))}));
        this.scaledInstances_$eq(this.standardize(this.instances()));
    }

    private BinaryLogisticBlockAggregator getNewAggregator(Instance[] instances, Vector coefficients, boolean fitIntercept, boolean fitWithMean) {
        int x$2;
        WrappedArray x$1;
        SparkContext qual$1 = this.sc();
        Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$1.parallelize((Seq)(x$1 = Predef$.MODULE$.wrapRefArray((Object[])instances)), x$2 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
        SummarizerBuffer featuresSummarizer2 = featuresSummarizer;
        double[] featuresStd = featuresSummarizer2.std().toArray();
        double[] featuresMean = featuresSummarizer2.mean().toArray();
        double[] inverseStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(featuresStd)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)std -> {
            if (std != 0.0) {
                return 1.0 / std;
            }
            return 0.0;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] scaledMean = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(inverseStd)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(featuresMean), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToDouble((double)BinaryLogisticBlockAggregatorSuite.$anonfun$getNewAggregator$2(t)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Broadcast bcInverseStd = this.sc().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = this.sc().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcCoefficients = this.sc().broadcast((Object)coefficients, ClassTag$.MODULE$.apply(Vector.class));
        return new BinaryLogisticBlockAggregator(bcInverseStd, bcScaledMean, fitIntercept, fitWithMean, bcCoefficients);
    }

    private final void testImplicits$lzycompute$1() {
        BinaryLogisticBlockAggregatorSuite binaryLogisticBlockAggregatorSuite = this;
        synchronized (binaryLogisticBlockAggregatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public static final /* synthetic */ double $anonfun$getNewAggregator$2(Tuple2 t) {
        return t._1$mcD$sp() * t._2$mcD$sp();
    }

    public static final /* synthetic */ void $anonfun$new$16(Vector stdCoefVec$1, DoubleRef lossSum$1, double[] gradientCoef$1, Vector featuresStd$1, Instance x0$1) {
        Instance instance = x0$1;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            double margin = BLAS$.MODULE$.dot(stdCoefVec$1, f);
            double prob = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
            lossSum$1.elem += -w * l * package$.MODULE$.log(prob) - w * (1.0 - l) * package$.MODULE$.log1p(-prob);
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$1)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                gradientCoef$1[i] = gradientCoef$1[i] + w * (prob - l) * f.apply(i) / featuresStd$1.apply(i);
            });
            return;
        }
        throw new MatchError((Object)instance);
    }

    public static final /* synthetic */ void $anonfun$new$27(Vector stdCoefVec$2, double interceptValue$1, DoubleRef lossSum$2, double[] gradientCoef$2, Vector featuresStd$2, DoubleRef gradientIntercept$1, Instance x0$2) {
        Instance instance = x0$2;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            double margin = BLAS$.MODULE$.dot(stdCoefVec$2, f) + interceptValue$1;
            double prob = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
            lossSum$2.elem += -w * l * package$.MODULE$.log(prob) - w * (1.0 - l) * package$.MODULE$.log1p(-prob);
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$2)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                gradientCoef$2[i] = gradientCoef$2[i] + w * (prob - l) * f.apply(i) / featuresStd$2.apply(i);
            });
            gradientIntercept$1.elem += w * (prob - l);
            return;
        }
        throw new MatchError((Object)instance);
    }

    public static final /* synthetic */ void $anonfun$new$38(Vector featuresMean$1, Vector stdCoefVec$3, double interceptValue$2, DoubleRef lossSum$3, double[] gradientCoef$3, Vector featuresStd$3, DoubleRef gradientIntercept$2, Instance x0$3) {
        Instance instance = x0$3;
        if (instance != null) {
            double l = instance.label();
            double w = instance.weight();
            Vector f = instance.features();
            DenseVector centered = f.toDense().copy();
            BLAS$.MODULE$.axpy(-1.0, featuresMean$1, (Vector)centered);
            double margin = BLAS$.MODULE$.dot(stdCoefVec$3, (Vector)centered) + interceptValue$2;
            double prob = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
            lossSum$3.elem += -w * l * package$.MODULE$.log(prob) - w * (1.0 - l) * package$.MODULE$.log1p(-prob);
            new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef$3)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                gradientCoef$3[i] = gradientCoef$3[i] + w * (prob - l) * (f.apply(i) - featuresMean$1.apply(i)) / featuresStd$3.apply(i);
            });
            gradientIntercept$2.elem += w * (prob - l);
            return;
        }
        throw new MatchError((Object)instance);
    }

    public BinaryLogisticBlockAggregatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        this.test("sparse coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Broadcast bcInverseStd = this.sc().broadcast((Object)new double[]{1.0}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Broadcast bcScaledMean = this.sc().broadcast((Object)new double[]{2.0}, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Broadcast bcCoefficients = this.sc().broadcast((Object)Vectors$.MODULE$.sparse(2, new int[]{0}, new double[]{1.0}), ClassTag$.MODULE$.apply(Vector.class));
            BinaryLogisticBlockAggregator binaryAgg = new BinaryLogisticBlockAggregator(bcInverseStd, bcScaledMean, true, false, bcCoefficients);
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, 1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (List)Nil$.MODULE$));
            IllegalArgumentException thrownBinary = (IllegalArgumentException)this.withClue("aggregator cannot handle sparse coefficients", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> binaryAgg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80)));
            String $org_scalatest_assert_macro_left = thrownBinary.getMessage();
            String $org_scalatest_assert_macro_right = "coefficients only supports dense";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        }, new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        this.test("aggregator add method input size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0};
            double interceptValue = 4.0;
            BinaryLogisticBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue), ClassTag$.MODULE$.Double())), true, true);
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, 1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), (List)Nil$.MODULE$));
            return (IllegalArgumentException)this.withClue("BinaryLogisticBlockAggregator features dimension must match coefficients dimension", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94)));
        }, new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("negative weight", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0};
            double interceptValue = 4.0;
            BinaryLogisticBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue), ClassTag$.MODULE$.Double())), true, true);
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)new .colon.colon((Object)new Instance(1.0, -1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), (List)Nil$.MODULE$));
            return (IllegalArgumentException)this.withClue("BinaryLogisticBlockAggregator does not support negative instance weights", (Function0 & Serializable & scala.Serializable)() -> (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> agg.add(block), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107)));
        }, new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("check sizes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = new Random();
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            Vector coefWithIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures + 1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            Vector coefWithoutIntercept = Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rng.nextDouble(), ClassTag$.MODULE$.Double()));
            InstanceBlock block = InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.instances()));
            BinaryLogisticBlockAggregator aggIntercept = this.getNewAggregator(this.instances(), coefWithIntercept, true, false);
            aggIntercept.add(block);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right = numFeatures + 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            BinaryLogisticBlockAggregator aggNoIntercept = this.getNewAggregator(this.instances(), coefWithoutIntercept, false, false);
            aggNoIntercept.add(block);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)aggNoIntercept.gradient().size()));
            int $org_scalatest_assert_macro_right2 = numFeatures;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }, new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("check correctness: fitIntercept = false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$22;
            WrappedArray x$12;
            Vector coefVec = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            SparkContext qual$1 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$1.parallelize((Seq)(x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$22 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = featuresSummarizer;
            Vector featuresStd = featuresSummarizer2.std();
            Vector stdCoefVec = Vectors$.MODULE$.dense((double[])Array$.MODULE$.tabulate(coefVec.size(), (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefVec.apply(i) / featuresStd.apply(i), ClassTag$.MODULE$.Double()));
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DoubleRef lossSum = DoubleRef.create((double)0.0);
            double[] gradientCoef = (double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double());
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BinaryLogisticBlockAggregatorSuite.$anonfun$new$16(stdCoefVec, lossSum, gradientCoef, featuresStd, x0$1);
                return BoxedUnit.UNIT;
            });
            double loss = lossSum.elem / weightSum;
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scaledInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)new .colon.colon((Object)blocks1, (List)new .colon.colon((Object)blocks2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    BinaryLogisticBlockAggregator agg = this.getNewAggregator(this.instances(), coefVec, false, false);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> agg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
                });
            });
        }, new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("check correctness: fitIntercept = true, fitWithMean = false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$42;
            WrappedArray x$32;
            Vector coefVec = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            double interceptValue = 1.0;
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            SparkContext qual$2 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$2.parallelize((Seq)(x$32 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$42 = qual$2.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = featuresSummarizer;
            Vector featuresStd = featuresSummarizer2.std();
            Vector stdCoefVec = Vectors$.MODULE$.dense((double[])Array$.MODULE$.tabulate(coefVec.size(), (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefVec.apply(i) / featuresStd.apply(i), ClassTag$.MODULE$.Double()));
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DoubleRef lossSum = DoubleRef.create((double)0.0);
            double[] gradientCoef = (double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double());
            DoubleRef gradientIntercept = DoubleRef.create((double)0.0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                BinaryLogisticBlockAggregatorSuite.$anonfun$new$27(stdCoefVec, interceptValue, lossSum, gradientCoef, featuresStd, gradientIntercept, x0$2);
                return BoxedUnit.UNIT;
            });
            double loss = lossSum.elem / weightSum;
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)gradientIntercept.elem), ClassTag$.MODULE$.Double()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scaledInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)new .colon.colon((Object)blocks1, (List)new .colon.colon((Object)blocks2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    BinaryLogisticBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefVec.toArray())).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue), ClassTag$.MODULE$.Double())), true, false);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> agg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
                });
            });
        }, new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("check correctness: fitIntercept = true, fitWithMean = true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$62;
            WrappedArray x$52;
            Vector coefVec = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}));
            double interceptValue = 1.0;
            int numFeatures = ((Instance)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).head()).features().size();
            SparkContext qual$3 = this.sc();
            Tuple2 tuple2 = Summarizer$.MODULE$.getClassificationSummarizers(qual$3.parallelize((Seq)(x$52 = Predef$.MODULE$.wrapRefArray((Object[])this.instances())), x$62 = qual$3.parallelize$default$2(), ClassTag$.MODULE$.apply(Instance.class)), Summarizer$.MODULE$.getClassificationSummarizers$default$2(), Summarizer$.MODULE$.getClassificationSummarizers$default$3());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SummarizerBuffer featuresSummarizer = (SummarizerBuffer)tuple2._1();
            SummarizerBuffer featuresSummarizer2 = featuresSummarizer;
            Vector featuresStd = featuresSummarizer2.std();
            Vector featuresMean = featuresSummarizer2.mean();
            Vector stdCoefVec = Vectors$.MODULE$.dense((double[])Array$.MODULE$.tabulate(coefVec.size(), (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> coefVec.apply(i) / featuresStd.apply(i), ClassTag$.MODULE$.Double()));
            double weightSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.weight()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            DoubleRef lossSum = DoubleRef.create((double)0.0);
            double[] gradientCoef = (double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double());
            DoubleRef gradientIntercept = DoubleRef.create((double)0.0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instances())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                BinaryLogisticBlockAggregatorSuite.$anonfun$new$38(featuresMean, stdCoefVec, interceptValue, lossSum, gradientCoef, featuresStd, gradientIntercept, x0$3);
                return BoxedUnit.UNIT;
            });
            double loss = lossSum.elem / weightSum;
            Vector gradient = Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradientCoef)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)gradientIntercept.elem), ClassTag$.MODULE$.Double()))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$6 -> x$6 / weightSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)blockSize -> {
                InstanceBlock[] blocks1 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.scaledInstances())).grouped(blockSize).map((Function1 & Serializable & scala.Serializable)seq -> InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])seq))).toArray(ClassTag$.MODULE$.apply(InstanceBlock.class));
                InstanceBlock[] blocks2 = (InstanceBlock[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks1)).map((Function1 & Serializable & scala.Serializable)block -> new InstanceBlock(block.labels(), block.weights(), (Matrix)block.matrix().toSparseRowMajor()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InstanceBlock.class)));
                ((IterableLike)new .colon.colon((Object)blocks1, (List)new .colon.colon((Object)blocks2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)blocks -> {
                    BinaryLogisticBlockAggregator agg = this.getNewAggregator(this.instances(), Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefVec.toArray())).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue), ClassTag$.MODULE$.Double())), true, true);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)block -> agg.add(block));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(agg.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(loss).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(agg.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(agg.gradient()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(gradient).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(agg.gradient).~==(org.apache.spark.ml.util.TestingUtils.VectorWithAlmostEquals(gradient).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
                });
            });
        }, new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("check with zero standard deviation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            double[] coefArray = new double[]{1.0, 2.0};
            double[] coefArrayFiltered = new double[]{2.0};
            double interceptValue = 1.0;
            ((IterableLike)new .colon.colon((Object)new Tuple2.mcZZ.sp(false, false), (List)new .colon.colon((Object)new Tuple2.mcZZ.sp(true, false), (List)new .colon.colon((Object)new Tuple2.mcZZ.sp(true, true), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    boolean fitIntercept = tuple2._1$mcZ$sp();
                    boolean fitWithMean = tuple2._2$mcZ$sp();
                    Vector coefVec = fitIntercept ? Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArray)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue), ClassTag$.MODULE$.Double())) : Vectors$.MODULE$.dense(coefArray);
                    BinaryLogisticBlockAggregator aggConstantFeature = this.getNewAggregator(this.instancesConstantFeature(), coefVec, fitIntercept, fitWithMean);
                    aggConstantFeature.add(InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.standardize(this.instancesConstantFeature()))));
                    Vector grad = aggConstantFeature.gradient();
                    Vector coefVecFiltered = fitIntercept ? Vectors$.MODULE$.dense((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(coefArrayFiltered)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)interceptValue), ClassTag$.MODULE$.Double())) : Vectors$.MODULE$.dense(coefArrayFiltered);
                    BinaryLogisticBlockAggregator aggConstantFeatureFiltered = this.getNewAggregator(this.instancesConstantFeatureFiltered(), coefVecFiltered, fitIntercept, fitWithMean);
                    aggConstantFeatureFiltered.add(InstanceBlock$.MODULE$.fromInstances((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.standardize(this.instancesConstantFeatureFiltered()))));
                    Vector gradFiltered = aggConstantFeatureFiltered.gradient();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(aggConstantFeature.loss()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(aggConstantFeatureFiltered.loss()).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(aggConstantFeature.loss).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(aggConstantFeatureFiltered.loss).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)grad.apply(0)));
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(grad.apply(1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(gradFiltered.apply(0)).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(grad.apply(1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(gradFiltered.apply(0)).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
                    if (fitIntercept) {
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(grad.toArray())).last())).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(gradFiltered.toArray())).last())).relTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(grad.toArray).last).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(scala.Predef.doubleArrayOps(gradFiltered.toArray).last).relTol(1.0E-9))", Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("BinaryLogisticBlockAggregatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
    }
}

