/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.LSH;
import org.apache.spark.ml.feature.LSHModel;
import org.apache.spark.ml.feature.LSHTest$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LSHTest$ {
    public static LSHTest$ MODULE$;

    static {
        new LSHTest$();
    }

    public <T extends LSHModel<T>> Tuple2<Object, Object> calculateLSHProperty(Dataset<?> dataset, LSH<T> lsh, double distFP, double distFN) {
        Seq headHashValue;
        LSHModel model = lsh.fit(dataset);
        String inputCol = model.getInputCol();
        String outputCol = model.getOutputCol();
        Dataset transformedData = model.transform(dataset);
        MLTestingUtils$.MODULE$.checkCopyAndUids(lsh, (Model<?>)model);
        SchemaUtils$.MODULE$.checkColumnType(transformedData.schema(), model.getOutputCol(), (DataType)DataTypes.createArrayType((DataType)new VectorUDT()), SchemaUtils$.MODULE$.checkColumnType$default$4());
        Seq $org_scalatest_assert_macro_left = headHashValue = (Seq)((Row)transformedData.select(outputCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).head()).get(0);
        int $org_scalatest_assert_macro_right = model.getNumHashTables();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LSHTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        Dataset pairs = transformedData.as("a").crossJoin(transformedData.as("b"));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_feature_LSHTest$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_LSHTest$$typecreator1$1() {
            }
        }
        public final class Org_apache_spark_ml_feature_LSHTest$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_LSHTest$$typecreator2$1() {
            }
        }
        UserDefinedFunction distUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToDouble((double)model.keyDistance(x, y)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_LSHTest$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_LSHTest$$typecreator2$1()));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_feature_LSHTest$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_feature_LSHTest$$typecreator3$1() {
            }
        }
        public final class Org_apache_spark_ml_feature_LSHTest$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_feature_LSHTest$$typecreator4$1() {
            }
        }
        UserDefinedFunction sameBucket = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)LSHTest$.$anonfun$calculateLSHProperty$2(model, x, y)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_feature_LSHTest$$typecreator3$1()), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_ml_feature_LSHTest$$typecreator4$1()));
        Dataset result = pairs.withColumn("same_bucket", sameBucket.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(2).append("a.").append(outputCol).toString()), functions$.MODULE$.col(new StringBuilder(2).append("b.").append(outputCol).toString())}))).withColumn("distance", distUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(2).append("a.").append(inputCol).toString()), functions$.MODULE$.col(new StringBuilder(2).append("b.").append(inputCol).toString())})));
        Dataset positive = result.filter(functions$.MODULE$.col("same_bucket"));
        Dataset negative = result.filter(functions$.MODULE$.col("same_bucket").unary_$bang());
        double falsePositiveCount = positive.filter(functions$.MODULE$.col("distance").$greater((Object)BoxesRunTime.boxToDouble((double)distFP))).count();
        double falseNegativeCount = negative.filter(functions$.MODULE$.col("distance").$less((Object)BoxesRunTime.boxToDouble((double)distFN))).count();
        return new Tuple2.mcDD.sp(falsePositiveCount / (double)positive.count(), falseNegativeCount / (double)negative.count());
    }

    public <T extends LSHModel<T>> Tuple2<Object, Object> calculateApproxNearestNeighbors(LSH<T> lsh, Dataset<?> dataset, Vector key, int k, boolean singleProbe) {
        BoxedUnit boxedUnit;
        LSHModel model = lsh.fit(dataset);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_feature_LSHTest$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_LSHTest$$typecreator1$2() {
            }
        }
        UserDefinedFunction distUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)model.keyDistance(x, key)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_LSHTest$$typecreator1$2()));
        Dataset expected = dataset.sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{distUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(model.getInputCol())}))})).limit(k);
        Dataset actual = model.approxNearestNeighbors(dataset, key, k, singleProbe, "distCol");
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actual.schema().sameType((DataType)model.transformSchema(dataset.schema()).add("distCol", DataTypes.DoubleType)), "actual.schema.sameType(model.transformSchema(dataset.schema).add(\"distCol\", org.apache.spark.sql.types.DataTypes.DoubleType))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LSHTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        if (!singleProbe) {
            long $org_scalatest_assert_macro_left = actual.count();
            int $org_scalatest_assert_macro_right = k;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LSHTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        double correctCount = expected.join(actual, model.getInputCol()).count();
        return new Tuple2.mcDD.sp(correctCount / (double)actual.count(), correctCount / (double)expected.count());
    }

    public <T extends LSHModel<T>> Tuple2<Object, Object> calculateApproxSimilarityJoin(LSH<T> lsh, Dataset<?> datasetA, Dataset<?> datasetB, double threshold) {
        LSHModel model = lsh.fit(datasetA);
        String inputCol = model.getInputCol();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_feature_LSHTest$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_LSHTest$$typecreator1$3() {
            }
        }
        public final class Org_apache_spark_ml_feature_LSHTest$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_LSHTest$$typecreator2$2() {
            }
        }
        UserDefinedFunction distUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToDouble((double)model.keyDistance(x, y)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_LSHTest$$typecreator1$3()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_LSHTest$$typecreator2$2()));
        Dataset expected = datasetA.as("a").crossJoin(datasetB.as("b")).filter(distUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(2).append("a.").append(inputCol).toString()), functions$.MODULE$.col(new StringBuilder(2).append("b.").append(inputCol).toString())})).$less((Object)BoxesRunTime.boxToDouble((double)threshold)));
        Dataset actual = model.approxSimilarityJoin(datasetA, datasetB, threshold);
        SchemaUtils$.MODULE$.checkColumnType(actual.schema(), "distCol", DataTypes.DoubleType, SchemaUtils$.MODULE$.checkColumnType$default$4());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(actual.schema().apply("datasetA").dataType().sameType((DataType)model.transformSchema(datasetA.schema())), "actual.schema.apply(\"datasetA\").dataType.sameType(model.transformSchema(datasetA.schema))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LSHTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(actual.schema().apply("datasetB").dataType().sameType((DataType)model.transformSchema(datasetB.schema())), "actual.schema.apply(\"datasetB\").dataType.sameType(model.transformSchema(datasetB.schema))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LSHTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        double correctCount = actual.filter(functions$.MODULE$.col("distCol").$less((Object)BoxesRunTime.boxToDouble((double)threshold))).count();
        return new Tuple2.mcDD.sp(correctCount / (double)actual.count(), correctCount / (double)expected.count());
    }

    public static final /* synthetic */ boolean $anonfun$calculateLSHProperty$2(LSHModel model$1, Vector[] x, Vector[] y) {
        return model$1.hashDistance(x, y) == 0.0;
    }

    private LSHTest$() {
        MODULE$ = this;
    }
}

