/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluatorSuite$;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$testImplicits$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00112AAA\u0002\u0001\u001d!)\u0001\u0005\u0001C\u0001C\t1S*\u001e7uS\u000ed\u0017m]:DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8Fm\u0006dW/\u0019;peN+\u0018\u000e^3\u000b\u0005\u0011)\u0011AC3wC2,\u0018\r^5p]*\u0011aaB\u0001\u0003[2T!\u0001C\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Y\u0011AB1qC\u000eDWMC\u0001\r\u0003\ry'oZ\u0002\u0001'\u0011\u0001qbE\u000e\u0011\u0005A\tR\"A\u0004\n\u0005I9!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001535\tQC\u0003\u0002\u0017/\u0005!Q\u000f^5m\u0015\tAr!A\u0003nY2L'-\u0003\u0002\u001b+\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\bC\u0001\u000f\u001f\u001b\u0005i\"B\u0001\f\u0006\u0013\tyRD\u0001\u000bEK\u001a\fW\u000f\u001c;SK\u0006$wK]5uKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003\r\u0001")
public class MulticlassClassificationEvaluatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient SparkSession spark;
    private transient SparkContext sc;
    private transient String checkpointDir;
    private volatile MLlibTestSparkContext$testImplicits$ testImplicits$module;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest.testDefaultReadWrite$(this, instance, testParams);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest.testDefaultReadWrite$default$2$(this);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, Dataset<?> dataset, Map<String, Object> testEstimatorParams, Map<String, Object> testModelParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest.testEstimatorAndModelReadWrite$(this, estimator, dataset, testEstimatorParams, testModelParams, checkModelData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        TempDirectory.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        TempDirectory.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext.afterAll$(this);
    }

    @Override
    public Instance[] standardize(Instance[] instances) {
        return MLlibTestSparkContext.standardize$(this, instances);
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public File tempDir() {
        return TempDirectory.tempDir$(this);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public String checkpointDir() {
        return this.checkpointDir;
    }

    @Override
    public void checkpointDir_$eq(String x$1) {
        this.checkpointDir = x$1;
    }

    @Override
    public MLlibTestSparkContext$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    private final void testImplicits$lzycompute$1() {
        MulticlassClassificationEvaluatorSuite multiclassClassificationEvaluatorSuite = this;
        synchronized (multiclassClassificationEvaluatorSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new MLlibTestSparkContext$testImplicits$(this);
            }
        }
    }

    public MulticlassClassificationEvaluatorSuite() {
        TempDirectory.$init$(this);
        MLlibTestSparkContext.$init$(this);
        DefaultReadWriteTest.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParamsSuite$.MODULE$.checkParams((Params)new MulticlassClassificationEvaluator()), new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setPredictionCol("myPrediction").setLabelCol("myLabel").setMetricName("accuracy").setMetricLabel(1.0).setBeta(2.0);
            return this.testDefaultReadWrite(evaluator, this.testDefaultReadWrite$default$2());
        }, new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("should support all NumericType labels and not support other types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MLTestingUtils$.MODULE$.checkNumericTypes(new MulticlassClassificationEvaluator(), this.spark()), new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("evaluation metrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MulticlassClassificationEvaluatorSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_evaluation_MulticlassClassificationEvaluatorSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_evaluation_MulticlassClassificationEvaluatorSuite$$typecreator6$1(MulticlassClassificationEvaluatorSuite $outer) {
                }
            }
            Dataset predictionAndLabels = this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(0.0, 1.0), new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(1.0, 0.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(2.0, 2.0), new Tuple2.mcDD.sp(2.0, 0.0)})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_MulticlassClassificationEvaluatorSuite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "label"}));
            MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setMetricName("precisionByLabel").setMetricLabel(0.0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(predictionAndLabels)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.6666666666666666).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(predictionAndLabels)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.6666666666666666).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            evaluator.setMetricName("truePositiveRateByLabel").setMetricLabel(1.0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(predictionAndLabels)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.75).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(predictionAndLabels)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.75).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("MulticlassClassificationEvaluator support logloss", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            public final class Org_apache_spark_ml_evaluation_MulticlassClassificationEvaluatorSuite$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                }

                public Org_apache_spark_ml_evaluation_MulticlassClassificationEvaluatorSuite$$typecreator16$1(MulticlassClassificationEvaluatorSuite $outer) {
                }
            }
            Seq labels = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 0.0, 1.0}));
            Seq probabilities = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8, 0.1})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(0.9, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.05, 0.05})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(0.8, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.2, 0.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(0.3, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.65, 0.05})), (List)Nil$.MODULE$))));
            SparkContext qual$1 = this.sc();
            Seq x$1 = (Seq)labels.zip((GenIterable)probabilities, Seq$.MODULE$.canBuildFrom());
            int x$2 = qual$1.parallelize$default$2();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MulticlassClassificationEvaluatorSuite.class.getClassLoader());
            Dataset df = this.testImplicits().rddToDatasetHolder(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    double label = tuple2._1$mcD$sp();
                    Vector probability = (Vector)tuple2._2();
                    double prediction = probability.argmax();
                    return new Tuple3((Object)BoxesRunTime.boxToDouble((double)prediction), (Object)BoxesRunTime.boxToDouble((double)label), (Object)probability);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Tuple3.class)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_MulticlassClassificationEvaluatorSuite$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "label", "probability"}));
            MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator().setMetricName("logLoss");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(evaluator.evaluate(df)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.9682005730687164).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(evaluator.evaluate(df)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.9682005730687164).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }, new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("getMetrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MulticlassClassificationEvaluatorSuite.class.getClassLoader());
            public final class Org_apache_spark_ml_evaluation_MulticlassClassificationEvaluatorSuite$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_evaluation_MulticlassClassificationEvaluatorSuite$$typecreator26$1(MulticlassClassificationEvaluatorSuite $outer) {
                }
            }
            Dataset predictionAndLabels = this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(0.0, 1.0), new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(1.0, 0.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(2.0, 2.0), new Tuple2.mcDD.sp(2.0, 0.0)})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_MulticlassClassificationEvaluatorSuite$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "label"}));
            MulticlassClassificationEvaluator evaluator = new MulticlassClassificationEvaluator();
            MulticlassMetrics metrics = evaluator.getMetrics(predictionAndLabels);
            double f1 = metrics.weightedFMeasure();
            double accuracy = metrics.accuracy();
            double precisionByLabel = metrics.precision(evaluator.getMetricLabel());
            double $org_scalatest_assert_macro_left = evaluator.evaluate(predictionAndLabels);
            double $org_scalatest_assert_macro_right = f1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            evaluator.setMetricName("accuracy");
            double $org_scalatest_assert_macro_left2 = evaluator.evaluate(predictionAndLabels);
            double $org_scalatest_assert_macro_right2 = accuracy;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            evaluator.setMetricName("precisionByLabel");
            double $org_scalatest_assert_macro_left3 = evaluator.evaluate(predictionAndLabels);
            double $org_scalatest_assert_macro_right3 = precisionByLabel;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            evaluator.setMetricName("truePositiveRateByLabel").setMetricLabel(1.0);
            double $org_scalatest_assert_macro_left4 = evaluator.evaluate(predictionAndLabels);
            double $org_scalatest_assert_macro_right4 = metrics.truePositiveRate(evaluator.getMetricLabel());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        }, new Position("MulticlassClassificationEvaluatorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }
}

